/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.AnnotationUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.BarAnnotation;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002JV\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\u0019\u0010#\u001a\u00020!*\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b%\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation;", "", "()V", "build", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "rectanglesHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/RectanglesHelper;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "createLabelRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "hPlacement", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation$PlacementInsideBar;", "vPlacement", "barRect", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "padding", "", "linearAnnotations", "nonLinearAnnotations", "placeLabel", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "index", "", "barsCount", "viewPort", "isHorizontallyOriented", "", "isUpsideDown", "contains", "other", "contains$plot_base", "PlacementInsideBar", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBarAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,295:1\n1#2:296\n1477#3:297\n1502#3,3:298\n1505#3,3:308\n1045#3:312\n1864#3,2:313\n1549#3:315\n1620#3,3:316\n1855#3,2:319\n1866#3:321\n372#4,7:301\n215#5:311\n216#5:322\n*S KotlinDebug\n*F\n+ 1 BarAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation\n*L\n104#1:297\n104#1:298,3\n104#1:308,3\n110#1:312\n113#1:313,2\n151#1:315\n151#1:316,3\n168#1:319,2\n113#1:321\n104#1:301,7\n107#1:311\n107#1:322\n*E\n"})
public final class BarAnnotation {
    @NotNull
    public static final BarAnnotation INSTANCE = new BarAnnotation();

    private BarAnnotation() {
    }

    public final void build(@NotNull SvgRoot root, @NotNull RectanglesHelper rectanglesHelper, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)rectanglesHelper, (String)"rectanglesHelper");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        if (coord.isLinear()) {
            this.linearAnnotations(root, rectanglesHelper, coord, ctx2);
        } else {
            this.nonLinearAnnotations(root, rectanglesHelper, ctx2);
        }
    }

    private final void nonLinearAnnotations(SvgRoot root, RectanglesHelper rectanglesHelper, GeomContext ctx2) {
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        rectanglesHelper.iterateRectangleGeometry((Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit>)((Function2)new Function2<DataPointAesthetics, DoubleRectangle, Unit>(rectanglesHelper, ctx2, annotation2, root){
            final /* synthetic */ RectanglesHelper $rectanglesHelper;
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ Annotation $annotation;
            final /* synthetic */ SvgRoot $root;
            {
                this.$rectanglesHelper = $rectanglesHelper;
                this.$ctx = $ctx;
                this.$annotation = $annotation;
                this.$root = $root;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DataPointAesthetics p, @NotNull DoubleRectangle rect2) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                DoubleVector doubleVector = this.$rectanglesHelper.toClient(rect2.getCenter(), p);
                if (doubleVector == null) {
                    return;
                }
                DoubleVector clientBarCenter = doubleVector;
                Object $this$invoke_u24lambda_u240 = rect2.flipIf(this.$ctx.getFlipped());
                boolean bl = false;
                Object[] objectArray = new DoubleVector[]{new DoubleVector(((DoubleRectangle)$this$invoke_u24lambda_u240).getLeft(), ((DoubleRectangle)$this$invoke_u24lambda_u240).getBottom()), new DoubleVector(((DoubleRectangle)$this$invoke_u24lambda_u240).getRight(), ((DoubleRectangle)$this$invoke_u24lambda_u240).getBottom())};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                $this$invoke_u24lambda_u240 = this.$rectanglesHelper;
                GeomContext geomContext = this.$ctx;
                boolean $i$f$mapNotNull = false;
                void var9_12 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv22 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv22.iterator();
                while (iterator2.hasNext()) {
                    DoubleVector it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    DoubleVector it = (DoubleVector)element$iv$iv;
                    boolean bl3 = false;
                    if (((GeomHelper)$this$invoke_u24lambda_u240).toClient(it.flipIf(geomContext.getFlipped()), p) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List barBorder = (List)destination$iv$iv;
                if (barBorder.size() != 2) {
                    return;
                }
                DoubleVector v = ((DoubleVector)barBorder.get(1)).subtract((DoubleVector)barBorder.get(0));
                double it = Math.atan2(v.getY(), v.getX());
                boolean $i$a$-let-BarAnnotation$nonLinearAnnotations$1$angle$22 = false;
                double $this$forEach$iv$iv$iv22 = Math.abs(it);
                double angle = (1.5707963267948966 <= $this$forEach$iv$iv$iv22 ? $this$forEach$iv$iv$iv22 <= 4.71238898038469 : false) ? Math.PI - it : Math.PI * 2 - it;
                String text = this.$annotation.getAnnotationText(p.index(), this.$ctx.getPlotContext());
                Object object = this.$annotation.getTextStyle();
                Object object2 = this.$annotation.getTextColor(p.fill());
                double $i$a$-let-BarAnnotation$nonLinearAnnotations$1$angle$22 = MathKt.toDegrees(angle);
                object = AnnotationUtil.INSTANCE.createLabelElement(text, clientBarCenter, new AnnotationUtil.TextParams((TextStyle)object, (Color)object2, "middle", "center", $i$a$-let-BarAnnotation$nonLinearAnnotations$1$angle$22, null, 0.0, 32, null), this.$ctx);
                object2 = this.$root;
                SvgNode p0 = (SvgNode)object;
                boolean bl5 = false;
                object2.add(p0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void linearAnnotations(SvgRoot root, RectanglesHelper rectanglesHelper, CoordinateSystem coord, GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        DoubleRectangle p0 = GeomBase.Companion.overallAesBounds(ctx2);
        boolean bl = false;
        DoubleRectangle doubleRectangle = coord.toClient(p0);
        if (doubleRectangle == null) {
            return;
        }
        DoubleRectangle viewPort = doubleRectangle;
        double padding = annotation2.getTextStyle().getSize() / (double)2;
        boolean isHorizontallyOriented = ctx2.getFlipped();
        List rectangles = new ArrayList();
        rectanglesHelper.iterateRectangleGeometry((Function2<? super DataPointAesthetics, ? super DoubleRectangle, Unit>)((Function2)new Function2<DataPointAesthetics, DoubleRectangle, Unit>(rectanglesHelper, viewPort, (List<Triple<DataPointAesthetics, DoubleRectangle, Boolean>>)rectangles){
            final /* synthetic */ RectanglesHelper $rectanglesHelper;
            final /* synthetic */ DoubleRectangle $viewPort;
            final /* synthetic */ List<Triple<DataPointAesthetics, DoubleRectangle, Boolean>> $rectangles;
            {
                this.$rectanglesHelper = $rectanglesHelper;
                this.$viewPort = $viewPort;
                this.$rectangles = $rectangles;
                super(2);
            }

            public final void invoke(@NotNull DataPointAesthetics p, @NotNull DoubleRectangle rect2) {
                DoubleRectangle doubleRectangle;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                DoubleRectangle doubleRectangle2 = this.$rectanglesHelper.toClient(rect2, p);
                if (doubleRectangle2 == null || (doubleRectangle = doubleRectangle2.intersect(this.$viewPort)) == null) {
                    return;
                }
                DoubleRectangle clientRect = doubleRectangle;
                DoubleRectangle $this$invoke_u24lambda_u240 = rect2;
                boolean bl = false;
                boolean isUpsideDown = $this$invoke_u24lambda_u240.getDimension().getY() < 0.0 || $this$invoke_u24lambda_u240.getTop() < 0.0;
                this.$rectangles.add((Triple<DataPointAesthetics, DoubleRectangle, Boolean>)new Triple((Object)p, (Object)clientRect, (Object)isUpsideDown));
            }
        }));
        Iterable iterable = rectangles;
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Triple triple = (Triple)element$iv$iv;
            boolean bl2 = false;
            DoubleRectangle rect2 = (DoubleRectangle)triple.component2();
            Double key$iv$iv = isHorizontallyOriented ? rect2.getCenter().getY() : rect2.getCenter().getX();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEachIndexed$iv;
            Iterable $this$sortedBy$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl4 = false;
            List bars = (List)entry.getValue();
            int barsCount = bars.size();
            Iterable bl2 = bars;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(isHorizontallyOriented){
                final /* synthetic */ boolean $isHorizontallyOriented$inlined;
                {
                    this.$isHorizontallyOriented$inlined = bl;
                }

                public final int compare(T a2, T b2) {
                    Triple triple = (Triple)a2;
                    boolean bl = false;
                    DoubleRectangle rect2 = (DoubleRectangle)triple.component2();
                    triple = (Triple)b2;
                    Comparable comparable = Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY());
                    bl = false;
                    rect2 = (DoubleRectangle)triple.component2();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(this.$isHorizontallyOriented$inlined ? rect2.getCenter().getX() : rect2.getCenter().getY()));
                }
            });
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $this$mapTo$iv$iv;
                double d;
                Color color;
                Pair<Text.HorizontalAnchor, DoubleRectangle> pair2;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Triple triple = (Triple)item$iv;
                int index = n;
                boolean bl5 = false;
                DataPointAesthetics p = (DataPointAesthetics)triple.component1();
                DoubleRectangle barRect = (DoubleRectangle)triple.component2();
                boolean isUpsideDown = (Boolean)triple.component3();
                String text = annotation2.getAnnotationText(p.index(), ctx2.getPlotContext());
                DoubleVector textSize = (DoubleVector)AnnotationUtil.INSTANCE.textSizeGetter(annotation2.getTextStyle(), ctx2).invoke((Object)text, (Object)p);
                if (INSTANCE.placeLabel(barRect, index, barsCount, textSize, padding, viewPort, isHorizontallyOriented, isUpsideDown) == null) continue;
                Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair2.component1());
                DoubleRectangle textRect = (DoubleRectangle)pair2.component2();
                double alpha = 0.0;
                if (INSTANCE.contains$plot_base(barRect, textRect)) {
                    alpha = 0.0;
                    color = annotation2.getTextColor(p.fill());
                } else {
                    alpha = 0.75;
                    color = Annotation.getTextColor$default(annotation2, null, 1, null);
                }
                Color labelColor = color;
                DoubleVector location2 = null;
                switch (WhenMappings.$EnumSwitchMapping$0[hAlignment.ordinal()]) {
                    case 1: {
                        d = textRect.getLeft();
                        break;
                    }
                    case 2: {
                        d = textRect.getRight();
                        break;
                    }
                    case 3: {
                        d = textRect.getCenter().getX();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                location2 = new DoubleVector(d, textRect.getTop());
                Iterable $this$map$iv = MultilineLabel.Companion.splitLines(text);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void line2;
                    SvgGElement svgGElement;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl6 = false;
                    TextStyle textStyle = annotation2.getTextStyle();
                    String string2 = hAlignment.toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    SvgGElement it = svgGElement = AnnotationUtil.INSTANCE.createLabelElement((String)line2, location2, new AnnotationUtil.TextParams(textStyle, labelColor, string2, "top", null, ctx2.getBackgroundColor(), alpha, 16, null), ctx2);
                    boolean bl7 = false;
                    location2 = location2.add(new DoubleVector(0.0, annotation2.getTextStyle().getSize()));
                    collection.add(svgGElement);
                }
                List labels = (List)destination$iv$iv2;
                Iterable $this$forEach$iv2 = labels;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SvgNode p02 = (SvgNode)element$iv2;
                    boolean bl8 = false;
                    root.add(p02);
                }
            }
        }
    }

    public final boolean contains$plot_base(@NotNull DoubleRectangle $this$contains, @NotNull DoubleRectangle other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.xRange().contains(other.xRange()) && $this$contains.yRange().contains(other.yRange());
    }

    private final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel(DoubleRectangle barRect, int index, int barsCount, DoubleVector textSize, double padding, DoubleRectangle viewPort, boolean isHorizontallyOriented, boolean isUpsideDown) {
        DoubleRectangle doubleRectangle;
        double pos;
        PlacementInsideBar placementInsideBar;
        Function1 coordSelector2 = isHorizontallyOriented ? (Function1)placeLabel.coordSelector.1.INSTANCE : (Function1)placeLabel.coordSelector.2.INSTANCE;
        if (barsCount == 1) {
            PlacementInsideBar it = isHorizontallyOriented ? PlacementInsideBar.MIN : PlacementInsideBar.MAX;
            boolean bl = false;
            placementInsideBar = isUpsideDown ? it.flip() : it;
        } else {
            placementInsideBar = index == 0 ? PlacementInsideBar.MIN : (index == barsCount - 1 ? PlacementInsideBar.MAX : PlacementInsideBar.MIDDLE);
        }
        PlacementInsideBar insideBar = placementInsideBar;
        Pair<Text.HorizontalAnchor, DoubleRectangle> pair2 = BarAnnotation.placeLabel$place(isHorizontallyOriented, barRect, textSize, padding, insideBar);
        Text.HorizontalAnchor hAlignment = (Text.HorizontalAnchor)((Object)pair2.component1());
        DoubleRectangle textRect = (DoubleRectangle)pair2.component2();
        if (this.contains$plot_base(barRect, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (index != 0 && index != barsCount - 1) {
            return null;
        }
        if (barsCount == 1) {
            PlacementInsideBar placementInsideBar2 = insideBar = isHorizontallyOriented ? PlacementInsideBar.MAX : PlacementInsideBar.MIN;
            if (isUpsideDown) {
                insideBar = insideBar.flip();
            }
        }
        if (insideBar == PlacementInsideBar.MAX) {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.LEFT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue() + padding / (double)2;
            doubleRectangle = BarAnnotation.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        } else {
            if (isHorizontallyOriented) {
                hAlignment = Text.HorizontalAnchor.RIGHT;
            }
            pos = ((Number)coordSelector2.invoke((Object)barRect.getOrigin())).doubleValue() - ((Number)coordSelector2.invoke((Object)textSize)).doubleValue() - padding / (double)2;
            doubleRectangle = textRect = BarAnnotation.placeLabel$moveTo(textRect, isHorizontallyOriented, pos);
        }
        if (this.contains$plot_base(viewPort, textRect)) {
            return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
        }
        if (((Number)coordSelector2.invoke((Object)textSize)).doubleValue() + padding > ((Number)coordSelector2.invoke((Object)barRect.getDimension())).doubleValue()) {
            return null;
        }
        return BarAnnotation.placeLabel$place(isHorizontallyOriented, barRect, textSize, padding, insideBar);
    }

    private final DoubleRectangle createLabelRect(PlacementInsideBar hPlacement, PlacementInsideBar vPlacement, DoubleRectangle barRect, DoubleVector textSize, double padding) {
        double originX2 = BarAnnotation.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originX.1.INSTANCE), hPlacement);
        double originY2 = BarAnnotation.createLabelRect$getCoord(barRect, padding, textSize, (Function1<? super DoubleVector, Double>)((Function1)createLabelRect.originY.1.INSTANCE), vPlacement);
        return new DoubleRectangle(originX2, originY2, textSize.getX(), textSize.getY());
    }

    private static final Pair<Text.HorizontalAnchor, DoubleRectangle> placeLabel$place(boolean $isHorizontallyOriented, DoubleRectangle $barRect, DoubleVector $textSize, double $padding, PlacementInsideBar placement) {
        Text.HorizontalAnchor horizontalAnchor;
        DoubleRectangle textRect;
        block6: {
            block5: {
                textRect = INSTANCE.createLabelRect($isHorizontallyOriented ? placement : PlacementInsideBar.MIDDLE, $isHorizontallyOriented ? PlacementInsideBar.MIDDLE : placement, $barRect, $textSize, $padding);
                if (!$isHorizontallyOriented) break block5;
                switch (WhenMappings.$EnumSwitchMapping$1[placement.ordinal()]) {
                    case 1: {
                        horizontalAnchor = Text.HorizontalAnchor.LEFT;
                        break block6;
                    }
                    case 2: {
                        horizontalAnchor = Text.HorizontalAnchor.RIGHT;
                        break block6;
                    }
                    case 3: {
                        horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
        }
        Text.HorizontalAnchor hAlignment = horizontalAnchor;
        return TuplesKt.to((Object)((Object)hAlignment), (Object)textRect);
    }

    private static final DoubleRectangle placeLabel$moveTo(DoubleRectangle $this$placeLabel_u24moveTo, boolean $isHorizontallyOriented, double value) {
        DoubleVector newOrigin = $isHorizontallyOriented ? new DoubleVector(value, $this$placeLabel_u24moveTo.getOrigin().getY()) : new DoubleVector($this$placeLabel_u24moveTo.getOrigin().getX(), value);
        return new DoubleRectangle(newOrigin, $this$placeLabel_u24moveTo.getDimension());
    }

    private static final double createLabelRect$getCoord(DoubleRectangle $barRect, double $padding, DoubleVector $textSize, Function1<? super DoubleVector, Double> coordSelector2, PlacementInsideBar align) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$1[align.ordinal()]) {
            case 1: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + $padding;
                break;
            }
            case 2: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getOrigin())).doubleValue() + ((Number)coordSelector2.invoke((Object)$barRect.getDimension())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() - $padding;
                break;
            }
            case 3: {
                d = ((Number)coordSelector2.invoke((Object)$barRect.getCenter())).doubleValue() - ((Number)coordSelector2.invoke((Object)$textSize)).doubleValue() / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/BarAnnotation$PlacementInsideBar;", "", "(Ljava/lang/String;I)V", "flip", "MIN", "MAX", "MIDDLE", "plot-base"})
    private static final class PlacementInsideBar
    extends Enum<PlacementInsideBar> {
        public static final /* enum */ PlacementInsideBar MIN = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MAX = new PlacementInsideBar();
        public static final /* enum */ PlacementInsideBar MIDDLE = new PlacementInsideBar();
        private static final /* synthetic */ PlacementInsideBar[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final PlacementInsideBar flip() {
            PlacementInsideBar placementInsideBar;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    placementInsideBar = MAX;
                    break;
                }
                case 2: {
                    placementInsideBar = MIN;
                    break;
                }
                case 3: {
                    placementInsideBar = MIDDLE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return placementInsideBar;
        }

        public static PlacementInsideBar[] values() {
            return (PlacementInsideBar[])$VALUES.clone();
        }

        public static PlacementInsideBar valueOf(String value) {
            return Enum.valueOf(PlacementInsideBar.class, value);
        }

        @NotNull
        public static EnumEntries<PlacementInsideBar> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = placementInsideBarArray = new PlacementInsideBar[]{PlacementInsideBar.MIN, PlacementInsideBar.MAX, PlacementInsideBar.MIDDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PlacementInsideBar.values().length];
                try {
                    nArray[PlacementInsideBar.MIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MAX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlacementInsideBar.values().length];
            try {
                nArray[PlacementInsideBar.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlacementInsideBar.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

