/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.DotplotGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.FilledCircleLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.PointDimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000212B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J>\u0010$\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J8\u0010'\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001a0.2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020*H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u00063"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "yStackDir", "Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;", "getYStackDir", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;", "setYStackDir", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;)V", "buildHint", "", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "dotId", "", "stackSize", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "binWidthPx", "", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "buildStack", "dataPoints", "", "getDotCenter", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flip", "", "heightSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "resolution", "isDiscrete", "Companion", "YStackdir", "plot-base"})
@SourceDebugExtension(value={"SMAP\nYDotplotGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YDotplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1477#2:179\n1502#2,3:180\n1505#2,3:190\n1477#2:194\n1502#2,3:195\n1505#2,3:205\n372#3,7:183\n372#3,7:198\n215#4:193\n215#4,2:208\n216#4:210\n1#5:211\n*S KotlinDebug\n*F\n+ 1 YDotplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom\n*L\n53#1:179\n53#1:180,3\n53#1:190,3\n56#1:194\n56#1:195,3\n56#1:205,3\n53#1:183,7\n56#1:198,7\n54#1:193\n57#1:208,2\n54#1:210\n*E\n"})
public final class YDotplotGeom
extends DotplotGeom
implements WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private YStackdir yStackDir = DEF_YSTACKDIR;
    @NotNull
    private static final YStackdir DEF_YSTACKDIR = YStackdir.CENTER;
    public static final boolean HANDLES_GROUPS = true;

    @NotNull
    public final YStackdir getYStackDir() {
        return this.yStackDir;
    }

    public final void setYStackDir(@NotNull YStackdir yStackdir) {
        Intrinsics.checkNotNullParameter((Object)((Object)yStackdir), (String)"<set-?>");
        this.yStackDir = yStackdir;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledCircleLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        Double key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        double d;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable<DataPointAesthetics> pointsWithBinWidth = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getBINWIDTH(), Aes.Companion.getX(), Aes.Companion.getY());
        if (!CollectionsKt.any(pointsWithBinWidth)) {
            return;
        }
        DataPointAesthetics it = (DataPointAesthetics)CollectionsKt.first(pointsWithBinWidth);
        boolean $i$a$-let-YDotplotGeom$buildIntern$binWidthPx$22 = false;
        Double d2 = it.x();
        Intrinsics.checkNotNull((Object)d2);
        double x2 = d2;
        Double d3 = it.y();
        Intrinsics.checkNotNull((Object)d3);
        double y2 = d3;
        Double d4 = it.binwidth();
        Intrinsics.checkNotNull((Object)d4);
        double bw = d4;
        DoubleVector doubleVector = coord.toClient(new DoubleVector(x2, y2));
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector p0 = doubleVector;
        DoubleVector doubleVector2 = coord.toClient(new DoubleVector(x2, y2 + bw));
        Intrinsics.checkNotNull((Object)doubleVector2);
        DoubleVector p1 = doubleVector2;
        boolean bl = ctx2.getFlipped();
        if (!bl) {
            d = Math.abs(p0.getY() - p1.getY());
        } else if (bl) {
            d = Math.abs(p0.getX() - p1.getX());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double binWidthPx = d;
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(pointsWithBinWidth, Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSTACKSIZE());
        boolean $i$f$groupBy = false;
        void $i$a$-let-YDotplotGeom$buildIntern$binWidthPx$22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p02 = (DataPointAesthetics)element$iv$iv;
            boolean bl2 = false;
            key$iv$iv = p02.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$forEach$iv2;
            void $this$groupByTo$iv$iv2;
            Map $this$groupBy$iv2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl4 = false;
            List dataPointGroup = (List)entry.getValue();
            Iterable list$iv$iv = dataPointGroup;
            boolean $i$f$groupBy2 = false;
            key$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                DataPointAesthetics p03 = (DataPointAesthetics)element$iv$iv;
                boolean bl5 = false;
                Double key$iv$iv2 = p03.y();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object;
                list$iv$iv2.add(element$iv$iv);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry2 = element$iv2 = iterator3.next();
                boolean bl7 = false;
                List dataPointStack = (List)entry2.getValue();
                this.buildStack(root, dataPointStack, pos, coord, ctx2, binWidthPx);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildStack(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2, double binWidthPx) {
        DotplotGeom.DotHelper dotHelper = new DotplotGeom.DotHelper(pos, coord, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        Iterable<? extends DataPointAesthetics> iterable = dataPoints2;
        double d = 0.0;
        Iterator<? extends DataPointAesthetics> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            DataPointAesthetics dataPointAesthetics;
            DataPointAesthetics dataPointAesthetics2 = dataPointAesthetics = iterator2.next();
            double d2 = d;
            boolean bl = false;
            Double d3 = it.stacksize();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = d3;
            d = d2 + d4;
        }
        int fullStackSize = (int)d;
        int stackSize = this.boundedStackSize(fullStackSize, coord, ctx2, binWidthPx, !ctx2.getFlipped());
        int builtStackSize = 0;
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d5 = dataPointAesthetics.stacksize();
            Intrinsics.checkNotNull((Object)d5);
            int groupStackSize = this.boundedStackSize(builtStackSize + (int)d5.doubleValue(), coord, ctx2, binWidthPx, !ctx2.getFlipped()) - builtStackSize;
            int currentStackSize = this.stackDotsAcrossGroups() ? stackSize : groupStackSize;
            int dotId = -1;
            for (int i = 0; i < groupStackSize; ++i) {
                dotId = this.stackDotsAcrossGroups() ? builtStackSize + i : i;
                DoubleVector center = this.getDotCenter(dataPointAesthetics, dotId, currentStackSize, binWidthPx, ctx2.getFlipped(), geomHelper);
                LinePath path = dotHelper.createDot(dataPointAesthetics, center, this.getDotSize() * binWidthPx / (double)2);
                root.add(path.getRootGroup());
            }
            this.buildHint(dataPointAesthetics, dotId, currentStackSize, ctx2, geomHelper, binWidthPx);
            builtStackSize += groupStackSize;
        }
    }

    private final void buildHint(DataPointAesthetics p, int dotId, int stackSize, GeomContext ctx2, GeomHelper geomHelper, double binWidthPx) {
        Double d = p.stacksize();
        Intrinsics.checkNotNull((Object)d);
        int currentStackSize = (int)d.doubleValue();
        if (currentStackSize == 0) {
            return;
        }
        DoubleVector center = this.getDotCenter(p, dotId, stackSize, binWidthPx, ctx2.getFlipped(), geomHelper);
        double radius = this.getDotSize() * binWidthPx / 2.0;
        double width2 = 2.0 * radius;
        double height = 2.0 * radius * ((double)currentStackSize * this.getStackRatio() - (this.getStackRatio() - 1.0));
        double stackShift = this.yStackDir == YStackdir.LEFT ? -radius : -height + radius;
        DoubleRectangle rect2 = ctx2.getFlipped() ? new DoubleRectangle(new DoubleVector(center.getX() - radius, center.getY() + stackShift), new DoubleVector(width2, height)) : new DoubleRectangle(new DoubleVector(center.getX() + stackShift, center.getY() - radius), new DoubleVector(height, width2));
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.Y_DOT_PLOT, ctx2);
        ctx2.getTargetCollector().addRectangle(p.index(), rect2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)p), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
    }

    private final DoubleVector getDotCenter(DataPointAesthetics p, int dotId, int stackSize, double binWidthPx, boolean flip, GeomHelper geomHelper) {
        double d;
        Double d2 = p.x();
        Intrinsics.checkNotNull((Object)d2);
        double x2 = d2;
        Double d3 = p.y();
        Intrinsics.checkNotNull((Object)d3);
        double y2 = d3;
        switch (WhenMappings.$EnumSwitchMapping$0[this.yStackDir.ordinal()]) {
            case 1: {
                d = (double)(-dotId) - 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            case 2: {
                d = (double)dotId + 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            case 3: {
                d = (double)dotId + 0.5 - (double)stackSize / 2.0;
                break;
            }
            case 4: {
                double parityShift = stackSize % 2 == 0 ? 0.0 : 0.5;
                d = (double)dotId + parityShift - (double)stackSize / 2.0 + 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double shiftedDotId = d;
        DoubleVector shift = new DoubleVector(shiftedDotId * this.getDotSize() * this.getStackRatio() * binWidthPx, 0.0);
        DoubleVector doubleVector = geomHelper.toClient(x2, y2, p);
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector.add(flip ? shift.flip() : shift);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return PointDimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getBINWIDTH(), resolution);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$Companion;", "", "()V", "DEF_YSTACKDIR", "Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;", "getDEF_YSTACKDIR", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YStackdir getDEF_YSTACKDIR() {
            return DEF_YSTACKDIR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[YStackdir.values().length];
            try {
                nArray[YStackdir.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YStackdir.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YStackdir.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YStackdir.CENTERWHOLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/YDotplotGeom$YStackdir;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "CENTER", "CENTERWHOLE", "plot-base"})
    public static final class YStackdir
    extends Enum<YStackdir> {
        public static final /* enum */ YStackdir LEFT = new YStackdir();
        public static final /* enum */ YStackdir RIGHT = new YStackdir();
        public static final /* enum */ YStackdir CENTER = new YStackdir();
        public static final /* enum */ YStackdir CENTERWHOLE = new YStackdir();
        private static final /* synthetic */ YStackdir[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static YStackdir[] values() {
            return (YStackdir[])$VALUES.clone();
        }

        public static YStackdir valueOf(String value) {
            return Enum.valueOf(YStackdir.class, value);
        }

        @NotNull
        public static EnumEntries<YStackdir> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = yStackdirArray = new YStackdir[]{YStackdir.LEFT, YStackdir.RIGHT, YStackdir.CENTER, YStackdir.CENTERWHOLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

