/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.outputs.error;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.error.PythonStacktraceUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.py.editor.outputs.error.JupyterCellHyperlinkInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/py/editor/outputs/error/PythonLinkFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.jupyter.py"})
public final class PythonLinkFilter
implements Filter,
DumbAware {
    @NotNull
    private final EditorImpl editor;

    public PythonLinkFilter(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final JupyterNotebookBase getNotebook() {
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)((Editor)this.editor)).getNotebook();
        Intrinsics.checkNotNull((Object)jupyterNotebook, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase");
        return (JupyterNotebookBase)jupyterNotebook;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        PythonStacktraceUtils.CellHighlightInfo cellHighlightInfo = PythonStacktraceUtils.INSTANCE.linkifyStackLine(line, entireLength);
        if (cellHighlightInfo == null) {
            return null;
        }
        PythonStacktraceUtils.CellHighlightInfo stackLineInfo = cellHighlightInfo;
        JupyterCellHyperlinkInfo hyperlinkInfo = new JupyterCellHyperlinkInfo(stackLineInfo.getRunCount(), stackLineInfo.getCellLine(), this);
        return new Filter.Result(stackLineInfo.getHighlightRange().getFirst(), stackLineInfo.getHighlightRange().getLast(), (HyperlinkInfo)hyperlinkInfo);
    }
}

