/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.Platform;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.remote.MultiLoaderObjectInputStream;
import com.intellij.openapi.externalSystem.util.wsl.WSLUtilKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.io.BaseOutputReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.SocketInetAddress;
import org.gradle.internal.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.DaemonMessageSerializer;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.internal.provider.action.BuildActionSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetup;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetupImpl;
import org.jetbrains.plugins.gradle.execution.target.GradleServerProgressIndicator;
import org.jetbrains.plugins.gradle.execution.target.GradleServerRunnerKt;
import org.jetbrains.plugins.gradle.execution.target.GradleToolingProxyClassloaderHolder;
import org.jetbrains.plugins.gradle.execution.target.TargetProjectConnection;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.tooling.proxy.IntermediateResult;
import org.jetbrains.plugins.gradle.tooling.proxy.Output;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardError;
import org.jetbrains.plugins.gradle.tooling.proxy.StandardOutput;
import org.jetbrains.plugins.gradle.tooling.proxy.TargetBuildParameters;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 '2\u00020\u0001:\u0003%&'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J8\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0002J*\u0010!\u001a\u00020\u001a2\b\b\u0001\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner;", "", "connection", "Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;", "consumerOperationParameters", "Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;", "prepareTaskState", "", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/TargetProjectConnection;Lorg/gradle/tooling/internal/consumer/parameters/ConsumerOperationParameters;Z)V", "run", "", "classloaderHolder", "Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;", "targetBuildParametersBuilder", "Lorg/jetbrains/plugins/gradle/tooling/proxy/TargetBuildParameters$Builder;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "runTargetProcess", "targetedCommandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;", "targetProgressIndicator", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProgressIndicator;", "useLocalLineSeparators", "", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "useLocalFileSeparators", "platform", "Lcom/intellij/execution/Platform;", "uriMode", "resolveFistPath", "text", "targetProjectBasePath", "localProjectBasePath", "GradleServerEventsListener", "GradleServerProcessListener", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleServerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleServerRunner.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerRunner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,334:1\n15#2:335\n*S KotlinDebug\n*F\n+ 1 GradleServerRunner.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerRunner\n*L\n327#1:335\n*E\n"})
public final class GradleServerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetProjectConnection connection;
    @NotNull
    private final ConsumerOperationParameters consumerOperationParameters;
    private final boolean prepareTaskState;
    @NotNull
    private static final Logger log;

    public GradleServerRunner(@NotNull TargetProjectConnection connection, @NotNull ConsumerOperationParameters consumerOperationParameters, boolean prepareTaskState) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Intrinsics.checkNotNullParameter((Object)consumerOperationParameters, (String)"consumerOperationParameters");
        this.connection = connection;
        this.consumerOperationParameters = consumerOperationParameters;
        this.prepareTaskState = prepareTaskState;
    }

    public final void run(@NotNull GradleToolingProxyClassloaderHolder classloaderHolder, @NotNull TargetBuildParameters.Builder<?> targetBuildParametersBuilder, @NotNull ResultHandler<Object> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)classloaderHolder, (String)"classloaderHolder");
        Intrinsics.checkNotNullParameter(targetBuildParametersBuilder, (String)"targetBuildParametersBuilder");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        ExternalSystemTaskId externalSystemTaskId = this.connection.getTaskId();
        if (externalSystemTaskId == null || (externalSystemTaskId = externalSystemTaskId.findProject()) == null) {
            return;
        }
        ExternalSystemTaskId project2 = externalSystemTaskId;
        GradleServerProgressIndicator progressIndicator = new GradleServerProgressIndicator(this.connection.getTaskId(), this.connection.getTaskListener());
        this.consumerOperationParameters.getCancellationToken().addCallback(progressIndicator::cancel);
        GradleServerEnvironmentSetupImpl serverEnvironmentSetup = new GradleServerEnvironmentSetupImpl((Project)project2, this.connection, this.prepareTaskState);
        TargetedCommandLine commandLine = serverEnvironmentSetup.prepareEnvironment(targetBuildParametersBuilder, this.consumerOperationParameters, progressIndicator);
        this.runTargetProcess(commandLine, serverEnvironmentSetup, progressIndicator, resultHandler, classloaderHolder);
    }

    private final void runTargetProcess(TargetedCommandLine targetedCommandLine, GradleServerEnvironmentSetup serverEnvironmentSetup, GradleServerProgressIndicator targetProgressIndicator, ResultHandler<Object> resultHandler, GradleToolingProxyClassloaderHolder classloaderHolder) {
        targetProgressIndicator.checkCanceled();
        TargetEnvironment remoteEnvironment = serverEnvironmentSetup.getTargetEnvironment();
        Process process = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        Charset charset = targetedCommandLine.getCharset();
        String string = targetedCommandLine.getCommandPresentation(remoteEnvironment);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(process, charset, string){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        TargetEnvironment.UploadRoot projectUploadRoot = serverEnvironmentSetup.getProjectUploadRoot();
        Object r = TargetEnvironmentFunctions.getTargetUploadPath((TargetEnvironment.UploadRoot)projectUploadRoot).apply(remoteEnvironment);
        Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
        String targetProjectBasePath = (String)r;
        String localProjectBasePath = ((Object)projectUploadRoot.getLocalRootPath()).toString();
        TargetPlatform targetPlatform = remoteEnvironment.getTargetPlatform();
        TargetEnvironmentConfigurationProvider targetEnvironmentConfigurationProvider = this.connection.getEnvironmentConfigurationProvider();
        GradleServerConfigurationProvider serverConfigurationProvider = targetEnvironmentConfigurationProvider instanceof GradleServerConfigurationProvider ? (GradleServerConfigurationProvider)targetEnvironmentConfigurationProvider : null;
        Function1 connectionAddressResolver = arg_0 -> GradleServerRunner.runTargetProcess$lambda$0(serverEnvironmentSetup, serverConfigurationProvider, arg_0);
        GradleServerEventsListener gradleServerEventsListener = new GradleServerEventsListener(serverEnvironmentSetup, (Function1<? super HostPort, HostPort>)connectionAddressResolver, classloaderHolder, arg_0 -> GradleServerRunner.runTargetProcess$lambda$2(this, targetProgressIndicator, targetPlatform, targetProjectBasePath, localProjectBasePath, arg_0));
        GradleServerProcessListener listener2 = new GradleServerProcessListener(targetProgressIndicator, resultHandler, gradleServerEventsListener);
        processHandler2.addProcessListener((ProcessListener)listener2);
        processHandler2.runProcessWithProgressIndicator((ProgressIndicator)targetProgressIndicator.getProgressIndicator(), -1, true);
    }

    private final String useLocalLineSeparators(String $this$useLocalLineSeparators, TargetPlatform targetPlatform) {
        String string;
        if (targetPlatform.getPlatform() == Platform.current()) {
            string = $this$useLocalLineSeparators;
        } else {
            String string2 = targetPlatform.getPlatform().lineSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator");
            String string3 = Platform.current().lineSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator");
            string = StringsKt.replace$default((String)$this$useLocalLineSeparators, (String)string2, (String)string3, (boolean)false, (int)4, null);
        }
        return string;
    }

    private final String useLocalFileSeparators(String $this$useLocalFileSeparators, Platform platform, boolean uriMode) {
        char separator = uriMode ? (char)'/' : (char)Platform.current().fileSeparator;
        return platform.fileSeparator == separator ? $this$useLocalFileSeparators : StringsKt.replace$default((String)$this$useLocalFileSeparators, (char)platform.fileSeparator, (char)separator, (boolean)false, (int)4, null);
    }

    @NlsSafe
    private final String resolveFistPath(@NlsSafe String text, String targetProjectBasePath, String localProjectBasePath, TargetPlatform targetPlatform) {
        char c;
        int pathIndexStart = StringsKt.indexOf$default((CharSequence)text, (String)targetProjectBasePath, (int)0, (boolean)false, (int)6, null);
        if (pathIndexStart == -1) {
            return text;
        }
        int delimiter = pathIndexStart == 0 ? 32 : ((c = text.charAt(pathIndexStart - 1)) != '\'' && c != '\"' ? 32 : (int)c);
        int pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)delimiter, (int)pathIndexStart, (boolean)false, (int)4, null);
        if (pathIndexEnd == -1) {
            pathIndexEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)pathIndexStart, (boolean)false, (int)4, null);
        }
        if (pathIndexEnd == -1) {
            pathIndexEnd = text.length();
        }
        String string = text.substring(Math.max(0, pathIndexStart - 7), Math.max(0, pathIndexStart - 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        boolean isUri = StringsKt.endsWith$default((String)string, (String)"file:/", (boolean)false, (int)2, null);
        String string2 = text.substring(pathIndexStart + targetProjectBasePath.length(), pathIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Platform platform = targetPlatform.getPlatform();
        Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
        String path = this.useLocalFileSeparators(string2, platform, isUri);
        StringBuilder buf = new StringBuilder();
        buf.append(text.subSequence(0, pathIndexStart));
        Platform platform2 = Platform.current();
        Intrinsics.checkNotNullExpressionValue((Object)platform2, (String)"current(...)");
        buf.append(this.useLocalFileSeparators(localProjectBasePath, platform2, isUri));
        buf.append(path);
        String string3 = text.substring(pathIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        buf.append(string3);
        String string4 = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    private static final HostPort runTargetProcess$lambda$0(GradleServerEnvironmentSetup $serverEnvironmentSetup, GradleServerConfigurationProvider $serverConfigurationProvider, HostPort it) {
        Integer targetPort;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Promise serverBindingPort = $serverEnvironmentSetup.getServerBindingPort();
        Promise promise = serverBindingPort;
        Integer localPort = promise != null && (promise = promise.getLocalValue()) != null ? (Integer)promise.blockingGet(0) : null;
        Promise promise2 = serverBindingPort;
        Integer n = targetPort = promise2 != null && (promise2 = promise2.getTargetValue()) != null ? (Integer)promise2.blockingGet(0) : null;
        int n2 = it.getPort();
        HostPort hostPort = n != null && n == n2 && localPort != null ? new HostPort(it.getHost(), localPort.intValue()) : it;
        GradleServerConfigurationProvider gradleServerConfigurationProvider = $serverConfigurationProvider;
        if (gradleServerConfigurationProvider == null || (gradleServerConfigurationProvider = gradleServerConfigurationProvider.getClientCommunicationAddress($serverEnvironmentSetup.getEnvironmentConfiguration(), hostPort)) == null) {
            gradleServerConfigurationProvider = hostPort;
        }
        return gradleServerConfigurationProvider;
    }

    private static final void runTargetProcess$lambda$2(GradleServerRunner this$0, GradleServerProgressIndicator $targetProgressIndicator, TargetPlatform $targetPlatform, String $targetProjectBasePath, String $localProjectBasePath, Object it) {
        Object object = it;
        if (object instanceof String) {
            ProgressListenerVersion1 $this$runTargetProcess_u24lambda_u242_u24lambda_u241 = this$0.consumerOperationParameters.getProgressListener();
            boolean bl = false;
            $this$runTargetProcess_u24lambda_u242_u24lambda_u241.onOperationStart((String)it);
            $this$runTargetProcess_u24lambda_u242_u24lambda_u241.onOperationEnd();
        } else if (object instanceof StandardError) {
            String string = this$0.resolveFistPath(this$0.useLocalLineSeparators(((StandardError)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $targetPlatform);
            ProcessOutputType processOutputType = ProcessOutputType.STDERR;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDERR");
            $targetProgressIndicator.addText(string, (Key)processOutputType);
        } else if (object instanceof StandardOutput) {
            String string = this$0.resolveFistPath(this$0.useLocalLineSeparators(((StandardOutput)it).getText(), $targetPlatform), $targetProjectBasePath, $localProjectBasePath, $targetPlatform);
            ProcessOutputType processOutputType = ProcessOutputType.STDOUT;
            Intrinsics.checkNotNullExpressionValue((Object)processOutputType, (String)"STDOUT");
            $targetProgressIndicator.addText(string, (Key)processOutputType);
        } else {
            this$0.consumerOperationParameters.getBuildProgressListener().onEvent(it);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleServerRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u001d\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0006\u0010\u001e\u001a\u00020\u0010J\u0014\u0010\u001f\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;", "", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;", "connectionAddressResolver", "Lkotlin/Function1;", "Lcom/intellij/execution/target/HostPort;", "classloaderHolder", "Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;", "buildEventConsumer", "Lorg/gradle/initialization/BuildEventConsumer;", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/gradle/execution/target/GradleToolingProxyClassloaderHolder;Lorg/gradle/initialization/BuildEventConsumer;)V", "listenerTask", "Ljava/util/concurrent/Future;", "start", "", "hostName", "", "port", "", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "createConnection", "Lorg/gradle/internal/remote/internal/RemoteConnection;", "Lorg/gradle/launcher/daemon/protocol/Message;", "doRun", "deserializeIfNeeded", "value", "sendResultAck", "stop", "waitForResult", "handler", "Lkotlin/Function0;", "", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleServerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleServerRunner.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
    private static final class GradleServerEventsListener {
        @NotNull
        private final GradleServerEnvironmentSetup serverEnvironmentSetup;
        @NotNull
        private final Function1<HostPort, HostPort> connectionAddressResolver;
        @NotNull
        private final GradleToolingProxyClassloaderHolder classloaderHolder;
        @NotNull
        private final BuildEventConsumer buildEventConsumer;
        private Future<?> listenerTask;

        public GradleServerEventsListener(@NotNull GradleServerEnvironmentSetup serverEnvironmentSetup, @NotNull Function1<? super HostPort, HostPort> connectionAddressResolver, @NotNull GradleToolingProxyClassloaderHolder classloaderHolder, @NotNull BuildEventConsumer buildEventConsumer) {
            Intrinsics.checkNotNullParameter((Object)serverEnvironmentSetup, (String)"serverEnvironmentSetup");
            Intrinsics.checkNotNullParameter(connectionAddressResolver, (String)"connectionAddressResolver");
            Intrinsics.checkNotNullParameter((Object)classloaderHolder, (String)"classloaderHolder");
            Intrinsics.checkNotNullParameter((Object)buildEventConsumer, (String)"buildEventConsumer");
            this.serverEnvironmentSetup = serverEnvironmentSetup;
            this.connectionAddressResolver = connectionAddressResolver;
            this.classloaderHolder = classloaderHolder;
            this.buildEventConsumer = buildEventConsumer;
        }

        public final void start(@NotNull String hostName, int port, @NotNull ResultHandler<Object> resultHandler) {
            Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
            Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
            if (!(this.listenerTask == null)) {
                boolean bl = false;
                String string = "Gradle server events listener has already been started";
                throw new IllegalStateException(string.toString());
            }
            this.listenerTask = ApplicationManager.getApplication().executeOnPooledThread(() -> GradleServerEventsListener.start$lambda$1(this, hostName, port, resultHandler));
        }

        private final RemoteConnection<Message> createConnection(String hostName, int port) {
            HostPort hostPort = (HostPort)this.connectionAddressResolver.invoke((Object)new HostPort(hostName, port));
            InetAddress inetAddress = InetAddress.getByName(hostPort.getHost());
            ConnectCompletion connectCompletion = (ConnectCompletion)WSLUtilKt.connectRetrying$default((long)5000L, (long)0L, () -> GradleServerEventsListener.createConnection$lambda$2(inetAddress, hostPort), (int)2, null);
            Serializer serializer = DaemonMessageSerializer.create((Serializer)BuildActionSerializer.create());
            RemoteConnection remoteConnection = connectCompletion.create(Serializers.stateful((Serializer)serializer));
            Intrinsics.checkNotNullExpressionValue((Object)remoteConnection, (String)"create(...)");
            return remoteConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doRun(String hostName, int port, ResultHandler<Object> resultHandler) {
            RemoteConnection<Message> connection = this.createConnection(hostName, port);
            connection.dispatch((Object)new BuildEvent((Object)this.serverEnvironmentSetup.getTargetBuildParameters()));
            connection.flush();
            try {
                while (true) {
                    if ((Message)connection.receive() == null) {
                    } else {
                        Message message;
                        Message message2 = message;
                        if (message2 instanceof Success) {
                            value = this.deserializeIfNeeded(((Success)message).getValue());
                            resultHandler.onComplete(value);
                        } else if (message2 instanceof Failure) {
                            Object object = ((Failure)message).getValue();
                            GradleConnectionException gradleConnectionException = object instanceof GradleConnectionException ? (GradleConnectionException)object : null;
                            if (gradleConnectionException == null) {
                                gradleConnectionException = new GradleConnectionException(((Throwable)((Failure)message).getValue()).getMessage());
                            }
                            resultHandler.onFailure(gradleConnectionException);
                        } else {
                            if (message2 instanceof BuildEvent) {
                                this.buildEventConsumer.dispatch(((BuildEvent)message).getPayload());
                                continue;
                            }
                            if (message2 instanceof Output) {
                                this.buildEventConsumer.dispatch((Object)message);
                                continue;
                            }
                            if (message2 instanceof IntermediateResult) {
                                value = this.deserializeIfNeeded(((IntermediateResult)message).getValue());
                                this.serverEnvironmentSetup.getTargetIntermediateResultHandler().onResult(((IntermediateResult)message).getType(), value);
                                continue;
                            }
                        }
                    }
                    break;
                }
            }
            finally {
                this.sendResultAck(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object deserializeIfNeeded(Object value) {
            Object object;
            byte[] byArray = value instanceof byte[] ? (byte[])value : null;
            if (byArray == null) {
                return value;
            }
            byte[] bytes = byArray;
            Closeable closeable = (Closeable)new MultiLoaderObjectInputStream((InputStream)new ByteArrayInputStream(bytes), this.classloaderHolder.getClassloaders());
            Throwable throwable = null;
            try {
                MultiLoaderObjectInputStream it = (MultiLoaderObjectInputStream)closeable;
                boolean bl = false;
                object = it.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object deserialized = object;
            return deserialized;
        }

        private final void sendResultAck(RemoteConnection<Message> $this$sendResultAck) {
            $this$sendResultAck.dispatch((Object)new BuildEvent((Object)"ack"));
            $this$sendResultAck.flush();
            $this$sendResultAck.stop();
        }

        public final void stop() {
            if (this.listenerTask != null) {
                Future<?> future = this.listenerTask;
                if (future == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                    future = null;
                }
                if (!future.isDone()) {
                    Future<?> future2 = this.listenerTask;
                    if (future2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                        future2 = null;
                    }
                    future2.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitForResult(@NotNull Function0<Boolean> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            long startTime = System.currentTimeMillis();
            while (!((Boolean)handler.invoke()).booleanValue()) {
                Object lock;
                if (this.listenerTask != null) {
                    Future<?> future = this.listenerTask;
                    if (future == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"listenerTask");
                        future = null;
                    }
                    if (future.isDone()) break;
                }
                if (System.currentTimeMillis() - startTime >= 10000L) break;
                Object object = lock = new Object();
                synchronized (object) {
                    boolean bl = false;
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        private static final void start$lambda$1(GradleServerEventsListener this$0, String $hostName, int $port, ResultHandler $resultHandler) {
            try {
                this$0.doRun($hostName, $port, (ResultHandler<Object>)$resultHandler);
            }
            catch (Throwable t) {
                $resultHandler.onFailure(new GradleConnectionException(t.getMessage(), t));
            }
        }

        private static final ConnectCompletion createConnection$lambda$2(InetAddress $inetAddress, HostPort $hostPort) {
            return new TcpOutgoingConnector().connect((Address)new SocketInetAddress($inetAddress, $hostPort.getPort()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "", "gradleServerEventsListener", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;", "<init>", "(Lcom/intellij/execution/target/TargetProgressIndicator;Lorg/gradle/tooling/ResultHandler;Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerEventsListener;)V", "connectionAddressReceived", "", "resultReceived", "getResultReceived", "()Z", "setResultReceived", "(Z)V", "resultHandlerWrapper", "getResultHandlerWrapper", "()Lorg/gradle/tooling/ResultHandler;", "processTerminated", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleServerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleServerRunner.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProcessListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
    private static final class GradleServerProcessListener
    implements ProcessListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final TargetProgressIndicator targetProgressIndicator;
        @NotNull
        private final ResultHandler<Object> resultHandler;
        @NotNull
        private final GradleServerEventsListener gradleServerEventsListener;
        private volatile boolean connectionAddressReceived;
        private volatile boolean resultReceived;
        @NotNull
        private final ResultHandler<Object> resultHandlerWrapper;
        @NotNull
        private static final String connectionConfLinePrefix = "Gradle target server hostAddress: ";

        public GradleServerProcessListener(@NotNull TargetProgressIndicator targetProgressIndicator, @NotNull ResultHandler<Object> resultHandler, @NotNull GradleServerEventsListener gradleServerEventsListener) {
            Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
            Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
            Intrinsics.checkNotNullParameter((Object)gradleServerEventsListener, (String)"gradleServerEventsListener");
            this.targetProgressIndicator = targetProgressIndicator;
            this.resultHandler = resultHandler;
            this.gradleServerEventsListener = gradleServerEventsListener;
            this.resultHandlerWrapper = (ResultHandler)new ResultHandler<Object>(this){
                final /* synthetic */ GradleServerProcessListener this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onComplete(Object result) {
                    this.this$0.setResultReceived(true);
                    GradleServerProcessListener.access$getResultHandler$p(this.this$0).onComplete(result);
                }

                public void onFailure(GradleConnectionException gradleConnectionException) {
                    Intrinsics.checkNotNullParameter((Object)gradleConnectionException, (String)"gradleConnectionException");
                    this.this$0.setResultReceived(true);
                    GradleServerProcessListener.access$getResultHandler$p(this.this$0).onFailure(gradleConnectionException);
                }
            };
        }

        public final boolean getResultReceived() {
            return this.resultReceived;
        }

        public final void setResultReceived(boolean bl) {
            this.resultReceived = bl;
        }

        @NotNull
        public final ResultHandler<Object> getResultHandlerWrapper() {
            return this.resultHandlerWrapper;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.resultReceived) {
                this.gradleServerEventsListener.waitForResult((Function0<Boolean>)((Function0)() -> GradleServerProcessListener.processTerminated$lambda$0(this)));
            }
            if (!this.resultReceived) {
                ProcessOutputType outputType = event.getExitCode() == 0 ? ProcessOutputType.STDOUT : ProcessOutputType.STDERR;
                String string = event.getText();
                if (string != null) {
                    String string2;
                    String it = string2 = string;
                    boolean bl = false;
                    this.targetProgressIndicator.addText(it, (Key)outputType);
                }
                GradleConnectionException gradleConnectionException = this.targetProgressIndicator.isCanceled() ? (GradleConnectionException)new BuildCancelledException("Build cancelled.") : new GradleConnectionException("Operation result has not been received.");
                this.resultHandler.onFailure(gradleConnectionException);
            }
            this.gradleServerEventsListener.stop();
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            GradleServerRunnerKt.access$traceIfNotEmpty(log, event.getText());
            if (this.connectionAddressReceived) {
                return;
            }
            if (outputType == ProcessOutputTypes.STDERR) {
                this.targetProgressIndicator.addText(event.getText(), outputType);
            }
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string, (String)connectionConfLinePrefix, (boolean)false, (int)2, null)) {
                this.connectionAddressReceived = true;
                String string2 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String hostName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string2, (String)connectionConfLinePrefix, null, (int)2, null), (String)" port: ", null, (int)2, null);
                String string3 = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                int port = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)string3, (String)" port: ", null, (int)2, null))).toString());
                this.gradleServerEventsListener.start(hostName, port, this.resultHandlerWrapper);
            }
        }

        private static final boolean processTerminated$lambda$0(GradleServerProcessListener this$0) {
            return this$0.resultReceived || this$0.targetProgressIndicator.isCanceled();
        }

        public static final /* synthetic */ ResultHandler access$getResultHandler$p(GradleServerProcessListener $this) {
            return $this.resultHandler;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerRunner$GradleServerProcessListener$Companion;", "", "<init>", "()V", "connectionConfLinePrefix", "", "intellij.gradle"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

