/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;
import org.assertj.core.description.Description;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicJListCellReader;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JListContentQuery;
import org.assertj.swing.driver.JListItemCountQuery;
import org.assertj.swing.driver.JListItemPreconditions;
import org.assertj.swing.driver.JListItemValueQuery;
import org.assertj.swing.driver.JListMatchingItemQuery;
import org.assertj.swing.driver.JListScrollToItemTask;
import org.assertj.swing.driver.JListSelectedIndexQuery;
import org.assertj.swing.driver.JListSelectionIndicesQuery;
import org.assertj.swing.driver.JListSelectionValueQuery;
import org.assertj.swing.driver.JListSelectionValuesQuery;
import org.assertj.swing.driver.MultipleSelectionTemplate;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.util.ArrayPreconditions;
import org.assertj.swing.util.Arrays;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.PatternTextMatcher;
import org.assertj.swing.util.Range;
import org.assertj.swing.util.StringTextMatcher;
import org.assertj.swing.util.TextMatcher;

@InternalApi
public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private JListCellReader cellReader;

    public JListDriver(@Nonnull Robot robot) {
        super(robot);
        this.replaceCellReader(new BasicJListCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JList<?> list) {
        return JListContentQuery.contents(list, this.cellReader());
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList<?> list, @Nonnull String[] values) {
        this.selectItems(list, new StringTextMatcher(values));
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList<?> list, @Nonnull Pattern[] patterns) {
        this.selectItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void selectItems(final @Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        final List<Integer> indices = JListMatchingItemQuery.matchingItemIndices(list, matcher2, this.cellReader());
        if (indices.isEmpty()) {
            throw this.failMatchingNotFound(list, matcher2);
        }
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.size();
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, (Integer)indices.get(index));
            }
        }.multiSelect();
    }

    @RunsInEDT
    private void unselectItems(final @Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        final List<Integer> indices = JListMatchingItemQuery.matchingItemIndices(list, matcher2, this.cellReader());
        if (indices.isEmpty()) {
            throw this.failMatchingNotFound(list, matcher2);
        }
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.size();
            }

            @Override
            void unselectElement(int index) {
                JListDriver.this.unselectItem(list, (Integer)indices.get(index));
            }
        }.multiUnselect();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList<?> list, @Nullable String value) {
        this.selectItem(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        this.selectItem(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, matcher2, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher2);
        if (scrollInfo.second == null) {
            return;
        }
        this.robot.click(list, this.cellCenterIn(scrollInfo));
    }

    public void clickItem(@Nonnull JList<?> list, @Nullable String value, @Nonnull MouseButton button2, int times) {
        this.clickItem(list, new StringTextMatcher(value), button2, times);
    }

    public void clickItem(@Nonnull JList<?> list, @Nonnull Pattern pattern, @Nonnull MouseButton button2, int times) {
        this.clickItem(list, new PatternTextMatcher(pattern), button2, times);
    }

    private void clickItem(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2, @Nonnull MouseButton button2, int times) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher2, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher2);
        this.robot.click(list, this.cellCenterIn(scrollInfo), button2, times);
    }

    public void selectItems(final @Nonnull JList<?> list, final @Nonnull int[] indices) {
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.length;
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    public void unselectItems(final @Nonnull JList<?> list, final @Nonnull int[] indices) {
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.length;
            }

            @Override
            void unselectElement(int index) {
                JListDriver.this.unselectItem(list, indices[index]);
            }
        }.multiUnselect();
    }

    public void clearSelection(@Nonnull JList<?> list) {
        JListDriver.clearSelectionOf(list);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void clearSelectionOf(@Nonnull JList<?> list) {
        GuiActionRunner.execute(() -> list.clearSelection());
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList<?> list, @Nonnull Range.From from, @Nonnull Range.To to) {
        this.selectItems(list, from.value, to.value);
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList<?> list, int start, int end) {
        JListDriver.validateIndicesAndClearSelection(list, start, end);
        this.selectItem(list, start);
        this.robot.pressKeyWhileRunning(16, () -> this.clickItem(list, end, MouseButton.LEFT_BUTTON, 1));
    }

    @RunsInEDT
    private static void validateIndicesAndClearSelection(@Nonnull JList<?> list, int ... indices) {
        GuiActionRunner.execute(() -> {
            JListItemPreconditions.checkIndicesInBounds(list, indices);
            list.clearSelection();
        });
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList<?> list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, index);
        this.robot.waitForIdle();
        if (cellCenter == null) {
            return;
        }
        this.robot.click(list, cellCenter);
    }

    @RunsInEDT
    public void unselectItem(@Nonnull JList<?> list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        if (list.isSelectedIndex(index)) {
            this.robot.click(list, cellCenter);
        }
    }

    @RunsInEDT
    public void clickItem(@Nonnull JList<?> list, int index, @Nonnull MouseButton button2, int times) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        this.robot.click(list, cellCenter, button2, times);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList<?> list, @Nullable String value) {
        String selection = this.requiredSelection(list);
        ((TextAssert)TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list))).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        String selection = this.requiredSelection(list);
        ((TextAssert)TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list))).matches(pattern);
    }

    @Nullable
    private String requiredSelection(@Nonnull JList<?> list) {
        Object selection = JListSelectionValueQuery.singleSelectionValue(list, this.cellReader());
        if (JListSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            this.failNoSelection(list);
        }
        return (String)selection;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList<?> list, int index) {
        int selectedIndex = JListSelectedIndexQuery.selectedIndexOf(list);
        if (selectedIndex == -1) {
            this.failNoSelection(list);
        }
        ((AbstractIntegerAssert)Assertions.assertThat(selectedIndex).as(this.selectedIndexProperty(list))).isEqualTo(index);
    }

    @Nonnull
    @RunsInEDT
    public String[] selectionOf(@Nonnull JList<?> list) {
        List<String> selection = JListSelectionValuesQuery.selectionValues(list, this.cellReader());
        return selection.toArray(new String[selection.size()]);
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList<?> list, String ... items) {
        this.requireSelectedItems(list, new StringTextMatcher(items));
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList<?> list, Pattern ... patterns) {
        this.requireSelectedItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void requireSelectedItems(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        List<String> matchingValues = JListMatchingItemQuery.matchingItemValues(list, matcher2, this.cellReader());
        ((ListAssert)((AbstractListAssert)((Object)Assertions.assertThat(JListSelectionValuesQuery.selectionValues(list, this.cellReader())))).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(matchingValues);
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList<?> list, int ... indices) {
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        java.util.Arrays.sort(indices);
        ((AbstractIntArrayAssert)Assertions.assertThat(JListSelectionIndicesQuery.selectedIndices(list)).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(indices);
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JList<?> list) {
        ((AbstractIntegerAssert)Assertions.assertThat(JListSelectedIndexQuery.selectedIndexOf(list)).as(this.selectedIndexProperty(list))).isEqualTo(-1);
    }

    @RunsInEDT
    private void failNoSelection(@Nonnull JList<?> list) {
        Fail.fail(String.format("[%s] No selection", this.selectedIndexProperty(list).value()));
    }

    @RunsInEDT
    private Description selectedIndexProperty(@Nonnull JList<?> list) {
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void drag(@Nonnull JList<?> list, @Nullable String value) {
        this.drag(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void drag(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        this.drag(list, new PatternTextMatcher(pattern));
    }

    private void drag(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher2, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher2);
        super.drag(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drop(@Nonnull JList<?> list, @Nullable String value) {
        this.drop(list, new StringTextMatcher(value));
    }

    public void drop(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        this.drop(list, new PatternTextMatcher(pattern));
    }

    private void drop(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher2, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher2);
        super.drop(list, this.cellCenterIn(scrollInfo));
    }

    private void checkItemFound(@Nonnull JList<?> list, @Nonnull Pair<Integer, Point> scrollInfo, @Nonnull TextMatcher matcher2) {
        if (JListScrollToItemTask.ITEM_NOT_FOUND == scrollInfo) {
            throw this.failMatchingNotFound(list, matcher2);
        }
    }

    @RunsInEDT
    public void drag(@Nonnull JList<?> list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drag(list, cellCenter);
    }

    @RunsInEDT
    public void drop(@Nonnull JList<?> list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drop(list, cellCenter);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList<?> list, @Nullable String value) {
        return this.showPopupMenu(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        return this.showPopupMenu(list, new PatternTextMatcher(pattern));
    }

    @Nonnull
    @RunsInEDT
    private JPopupMenu showPopupMenu(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher2, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher2);
        return this.robot.showPopupMenu(list, this.cellCenterIn(scrollInfo));
    }

    @Nonnull
    private Point cellCenterIn(@Nonnull Pair<Integer, Point> scrollInfo) {
        return (Point)Preconditions.checkNotNull(scrollInfo.second);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList<?> list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        return this.robot.showPopupMenu(list, cellCenter);
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JList<?> list, @Nullable String value) {
        return JListMatchingItemQuery.centerOfMatchingItemCell(list, value, this.cellReader());
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList<?> list, @Nullable String value) {
        return this.indexOf(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList<?> list, @Nonnull Pattern pattern) {
        return this.indexOf(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private int indexOf(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        int index = JListDriver.itemIndex(list, matcher2, this.cellReader());
        if (index >= 0) {
            return index;
        }
        throw this.failMatchingNotFound(list, matcher2);
    }

    @RunsInEDT
    private static int itemIndex(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2, @Nonnull JListCellReader cellReader) {
        Integer result = GuiActionRunner.execute(() -> JListMatchingItemQuery.matchingItemIndex(list, matcher2, cellReader));
        return Preconditions.checkNotNull(result);
    }

    @Nonnull
    private LocationUnavailableException failMatchingNotFound(@Nonnull JList<?> list, @Nonnull TextMatcher matcher2) {
        String format = "Unable to find item matching the %s %s among the JList contents %s";
        String msg = String.format(format, matcher2.description(), matcher2.formattedValues(), Arrays.format(JListContentQuery.contents(list, this.cellReader())));
        return new LocationUnavailableException(msg);
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JList<?> list, int index) {
        return JListItemValueQuery.itemValue(list, index, this.cellReader());
    }

    public void replaceCellReader(@Nonnull JListCellReader newCellReader) {
        this.cellReader = Preconditions.checkNotNull(newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JList<?> list, int expected) {
        int actual = JListItemCountQuery.itemCountIn(list);
        ((AbstractIntegerAssert)Assertions.assertThat(actual).as(JListDriver.propertyName(list, "itemCount"))).isEqualTo(expected);
    }

    @Nonnull
    private JListCellReader cellReader() {
        return this.cellReader;
    }
}

