/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.uast.testFramework.common;

import com.intellij.testFramework.EqualsToFile;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.evaluation.MapBasedEvaluationContext;
import org.jetbrains.uast.evaluation.UEvaluationContext;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0001\u0012J\b\u0010\u0002\u001a\u00020\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u0003*\u00020\b2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/uast/testFramework/common/ValuesTestBase;", "", "getTestDataPath", "", "getEvaluatorExtension", "Lorg/jetbrains/uast/evaluation/UEvaluatorExtension;", "analyzeAll", "Lorg/jetbrains/uast/evaluation/UEvaluationContext;", "Lorg/jetbrains/uast/UFile;", "asLogValues", "evaluationContext", "cachedOnly", "", "check", "", "testName", "file", "createCopyToCheck", "ValueLogger", "intellij.platform.uast.testFramework"})
@SourceDebugExtension(value={"SMAP\nValuesTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValuesTestBase.kt\ncom/intellij/platform/uast/testFramework/common/ValuesTestBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public interface ValuesTestBase {
    @NotNull
    public String getTestDataPath();

    @Nullable
    default public UEvaluatorExtension getEvaluatorExtension() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private UEvaluationContext analyzeAll(UFile $this$analyzeAll) {
        Object object;
        UastLanguagePlugin uastLanguagePlugin;
        UFile uFile;
        block3: {
            block2: {
                void it;
                uFile = $this$analyzeAll;
                uastLanguagePlugin = null;
                object = this.getEvaluatorExtension();
                if (object == null) break block2;
                UEvaluatorExtension uEvaluatorExtension = object;
                UastLanguagePlugin uastLanguagePlugin2 = uastLanguagePlugin;
                UFile uFile2 = uFile;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                uFile = uFile2;
                uastLanguagePlugin = uastLanguagePlugin2;
                List list2 = list;
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return UEvaluationContextKt.analyzeAll$default((UFile)uFile, uastLanguagePlugin, (List)object, (int)1, null);
    }

    private String asLogValues(UFile $this$asLogValues, UEvaluationContext evaluationContext, boolean cachedOnly) {
        ValueLogger valueLogger;
        ValueLogger $this$asLogValues_u24lambda_u241 = valueLogger = new ValueLogger(evaluationContext, cachedOnly);
        boolean bl = false;
        $this$asLogValues.accept((UastVisitor)$this$asLogValues_u24lambda_u241);
        return valueLogger.toString();
    }

    default public void check(@NotNull String testName, @NotNull UFile file) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File valuesFile = new File(this.getTestDataPath(), StringsKt.substringBeforeLast$default((String)testName, (char)'.', null, (int)2, null) + ".values.txt");
        UEvaluationContext evaluationContext = this.analyzeAll(file);
        EqualsToFile.assertEqualsToFile("Log values", valuesFile, this.asLogValues(file, evaluationContext, false));
        UFile copyFile = this.createCopyToCheck(file);
        if (copyFile != null) {
            EqualsToFile.assertEqualsToFile("Log cached values", valuesFile, this.asLogValues(copyFile, evaluationContext, true));
        }
    }

    @Nullable
    default public UFile createCopyToCheck(@NotNull UFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/uast/testFramework/common/ValuesTestBase$ValueLogger;", "Lorg/jetbrains/uast/visitor/UastVisitor;", "evaluationContext", "Lorg/jetbrains/uast/evaluation/UEvaluationContext;", "cachedOnly", "", "<init>", "(Lorg/jetbrains/uast/evaluation/UEvaluationContext;Z)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "", "visitElement", "node", "Lorg/jetbrains/uast/UElement;", "afterVisitElement", "", "toString", "", "intellij.platform.uast.testFramework"})
    @SourceDebugExtension(value={"SMAP\nValuesTestBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValuesTestBase.kt\ncom/intellij/platform/uast/testFramework/common/ValuesTestBase$ValueLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1863#2,2:79\n*S KotlinDebug\n*F\n+ 1 ValuesTestBase.kt\ncom/intellij/platform/uast/testFramework/common/ValuesTestBase$ValueLogger\n*L\n55#1:79,2\n*E\n"})
    public static final class ValueLogger
    implements UastVisitor {
        @NotNull
        private final UEvaluationContext evaluationContext;
        private final boolean cachedOnly;
        @NotNull
        private final StringBuilder builder;
        private int level;

        public ValueLogger(@NotNull UEvaluationContext evaluationContext, boolean cachedOnly) {
            Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
            this.evaluationContext = evaluationContext;
            this.cachedOnly = cachedOnly;
            this.builder = new StringBuilder();
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ValueLogger valueLogger = this;
            String string = node.asLogString();
            boolean bl = false;
            List renderString = StringsKt.lines((CharSequence)node.asRenderString());
            String initialLine = string + " [" + (renderString.size() == 1 ? (String)CollectionsKt.single((List)renderString) : CollectionsKt.first((List)renderString) + "..." + CollectionsKt.last((List)renderString)) + "]";
            Iterable $this$forEach$iv = (Iterable)new IntRange(1, this.level);
            boolean $i$f$forEach = false;
            UEvaluationContext uEvaluationContext = $this$forEach$iv.iterator();
            while (uEvaluationContext.hasNext()) {
                int element$iv = ((IntIterator)uEvaluationContext).nextInt();
                boolean bl2 = false;
                this.builder.append("    ");
            }
            this.builder.append(initialLine);
            if (node instanceof UExpression) {
                Object object;
                if (this.cachedOnly) {
                    uEvaluationContext = this.evaluationContext;
                    MapBasedEvaluationContext mapBasedEvaluationContext = uEvaluationContext instanceof MapBasedEvaluationContext ? (MapBasedEvaluationContext)uEvaluationContext : null;
                    object = mapBasedEvaluationContext != null ? mapBasedEvaluationContext.cachedValueOf((UExpression)node) : null;
                } else {
                    object = this.evaluationContext.valueOfIfAny((UExpression)node);
                }
                UValue value2 = object;
                StringBuilder stringBuilder = this.builder.append(" = ");
                Object object2 = value2;
                if (object2 == null) {
                    object2 = "NON-EVALUATED";
                }
                stringBuilder.append(object2);
            }
            this.builder.append('\n');
            int n = this.level;
            this.level = n + 1;
            return false;
        }

        public void afterVisitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            int n = this.level;
            this.level = n + -1;
        }

        @NotNull
        public String toString() {
            String string = this.builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

