/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.api.CallSignature;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.util.FunctionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u001c0\u000fj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\t\u0010\u000bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/FunctionalSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallSignature;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/CallParameter;", "functionalExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "skippedOptionalParameterCount", "", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;I)V", "isVararg", "", "()Z", "isVararg$delegate", "Lkotlin/Lazy;", "parameters", "", "getParameters", "()Ljava/util/List;", "parameters$delegate", "skipOptionalParams", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "returnType", "Lcom/intellij/psi/PsiType;", "getReturnType", "()Lcom/intellij/psi/PsiType;", "applyTo", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "ClosureParameter", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nFunctionalSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionalSignature.kt\norg/jetbrains/plugins/groovy/lang/typing/FunctionalSignature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1557#2:60\n1628#2,3:61\n*S KotlinDebug\n*F\n+ 1 FunctionalSignature.kt\norg/jetbrains/plugins/groovy/lang/typing/FunctionalSignature\n*L\n22#1:60\n22#1:61,3\n*E\n"})
public final class FunctionalSignature
implements CallSignature<CallParameter> {
    @NotNull
    private final GrFunctionalExpression functionalExpression;
    private final int skippedOptionalParameterCount;
    @NotNull
    private final Lazy isVararg$delegate;
    @NotNull
    private final Lazy parameters$delegate;

    public FunctionalSignature(@NotNull GrFunctionalExpression functionalExpression, int skippedOptionalParameterCount) {
        Intrinsics.checkNotNullParameter((Object)functionalExpression, (String)"functionalExpression");
        this.functionalExpression = functionalExpression;
        this.skippedOptionalParameterCount = skippedOptionalParameterCount;
        this.isVararg$delegate = FunctionsKt.recursionAwareLazy(() -> FunctionalSignature.isVararg_delegate$lambda$0(this));
        this.parameters$delegate = FunctionsKt.recursionAwareLazy(() -> FunctionalSignature.parameters_delegate$lambda$1(this));
    }

    @Override
    public boolean isVararg() {
        Lazy lazy = this.isVararg$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public List<CallParameter> getParameters() {
        Lazy lazy = this.parameters$delegate;
        return (List)lazy.getValue();
    }

    private final List<GrParameter> skipOptionalParams() {
        Object[] objectArray = this.functionalExpression.getAllParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllParameters(...)");
        Object[] parameters = objectArray;
        if (this.skippedOptionalParameterCount == 0) {
            return ArraysKt.asList((Object[])parameters);
        }
        int resultSize = parameters.length - this.skippedOptionalParameterCount;
        ArrayList result2 = new ArrayList(resultSize);
        int optionalParametersToSkip = this.skippedOptionalParameterCount;
        for (GrParameter parameter : CollectionsKt.asReversed((List)ArraysKt.asList((Object[])parameters))) {
            if (optionalParametersToSkip > 0 && parameter.isOptional()) {
                --optionalParametersToSkip;
                continue;
            }
            ((Collection)result2).add(parameter);
        }
        if (!(result2.size() == resultSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.asReversedMutable((List)result2);
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.functionalExpression.getReturnType();
    }

    @Override
    @NotNull
    public ArgumentMapping<CallParameter> applyTo(@NotNull List<? extends Argument> arguments2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ArgumentsKt.argumentMapping(this, arguments2, context);
    }

    private static final boolean isVararg_delegate$lambda$0(FunctionalSignature this$0) {
        return this$0.functionalExpression.isVarArgs();
    }

    /*
     * WARNING - void declaration
     */
    private static final List parameters_delegate$lambda$1(FunctionalSignature this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.skipOptionalParams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GrParameter grParameter = (GrParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClosureParameter((GrParameter)p0));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/FunctionalSignature$ClosureParameter;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "psi", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;)V", "getPsi", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/params/GrParameter;", "type", "Lcom/intellij/psi/PsiType;", "getType", "()Lcom/intellij/psi/PsiType;", "parameterName", "", "getParameterName", "()Ljava/lang/String;", "isOptional", "", "()Z", "intellij.groovy.psi"})
    private static final class ClosureParameter
    implements PsiCallParameter {
        @NotNull
        private final GrParameter psi;

        public ClosureParameter(@NotNull GrParameter psi) {
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            this.psi = psi;
        }

        @Override
        @NotNull
        public GrParameter getPsi() {
            return this.psi;
        }

        @Override
        @NotNull
        public PsiType getType() {
            PsiType psiType = this.getPsi().getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            return psiType;
        }

        @Override
        @NotNull
        public String getParameterName() {
            String string = this.getPsi().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        public boolean isOptional() {
            return false;
        }
    }
}

