/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.logback;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrMethodWrapper;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/ext/logback/LogbackDelegateMemberContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "<init>", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "getComponentClass", "Lcom/intellij/psi/PsiClass;", "ComponentProcessor", "intellij.groovy"})
public final class LogbackDelegateMemberContributor
extends NonCodeMembersContributor {
    @Override
    @NotNull
    protected String getParentClassName() {
        return "ch.qos.logback.classic.gaffer.ComponentDelegate";
    }

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ResolveUtilKt.shouldProcessMethods(processor)) {
            return;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint != null ? nameHint.getName(state) : null;
        PsiClass psiClass = this.getComponentClass(place);
        if (psiClass == null) {
            return;
        }
        PsiClass componentClass = psiClass;
        ComponentProcessor componentProcessor = new ComponentProcessor(processor, place, name);
        if (name == null) {
            componentClass.processDeclarations((PsiScopeProcessor)componentProcessor, state, null, place);
        } else {
            String[] stringArray = new String[]{"add", "set"};
            for (String prefix : stringArray) {
                for (PsiMethod method : componentClass.findMethodsByName(prefix + StringsKt.capitalize((String)name), true)) {
                    Intrinsics.checkNotNull((Object)method);
                    if (componentProcessor.execute((PsiElement)method, state)) continue;
                    return;
                }
            }
        }
    }

    private final PsiClass getComponentClass(PsiElement place) {
        PsiClassType componentType;
        GrExpression componentArgument;
        GrReferenceExpression grReferenceExpression = place instanceof GrReferenceExpression ? (GrReferenceExpression)place : null;
        if (grReferenceExpression == null) {
            return null;
        }
        GrReferenceExpression reference = grReferenceExpression;
        if (reference.isQualified()) {
            return null;
        }
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)reference, GrClosableBlock.class);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock closure = grClosableBlock;
        GrCall grCall = GrDelegatesToUtilKt.getContainingCall(closure);
        if (grCall == null) {
            return null;
        }
        GrCall call = grCall;
        Object[] arguments2 = PsiUtil.getAllArguments(call);
        Intrinsics.checkNotNull((Object)arguments2);
        if (arguments2.length == 0) {
            return null;
        }
        PsiType psiType = ((GrExpression)ArraysKt.last((Object[])arguments2)).getType();
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        boolean lastIsClosure = Intrinsics.areEqual((Object)(psiClassType != null && (psiClassType = psiClassType.resolve()) != null ? psiClassType.getQualifiedName() : null), (Object)"groovy.lang.Closure");
        int componentArgumentIndex = (lastIsClosure ? arguments2.length - 1 : arguments2.length) - 1;
        GrExpression grExpression = componentArgument = (GrExpression)ArraysKt.getOrNull((Object[])arguments2, (int)componentArgumentIndex);
        PsiType psiType2 = ResolveUtil.unwrapClassType((PsiType)(grExpression != null ? grExpression.getType() : null));
        PsiClassType psiClassType2 = componentType = psiType2 instanceof PsiClassType ? (PsiClassType)psiType2 : null;
        return psiClassType2 != null ? psiClassType2.resolve() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J)\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\n\b\u0000\u0010\u0015*\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/ext/logback/LogbackDelegateMemberContributor$ComponentProcessor;", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "delegate", "place", "Lcom/intellij/psi/PsiElement;", "name", "", "<init>", "(Lcom/intellij/psi/scope/PsiScopeProcessor;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getDelegate", "()Lcom/intellij/psi/scope/PsiScopeProcessor;", "getPlace", "()Lcom/intellij/psi/PsiElement;", "getName", "()Ljava/lang/String;", "execute", "", "method", "state", "Lcom/intellij/psi/ResolveState;", "getHint", "T", "", "hintKey", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "intellij.groovy"})
    public static final class ComponentProcessor
    implements PsiScopeProcessor {
        @NotNull
        private final PsiScopeProcessor delegate;
        @NotNull
        private final PsiElement place;
        @Nullable
        private final String name;

        public ComponentProcessor(@NotNull PsiScopeProcessor delegate, @NotNull PsiElement place, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            this.delegate = delegate;
            this.place = place;
            this.name = name;
        }

        @NotNull
        public final PsiScopeProcessor getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final PsiElement getPlace() {
            return this.place;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public boolean execute(@NotNull PsiElement method, @NotNull ResolveState state) {
            GrLightParameter grLightParameter;
            GrLightMethodBuilder grLightMethodBuilder;
            String string;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (!(method instanceof PsiMethod)) {
                return true;
            }
            if (GroovyPropertyUtils.isSetterLike((PsiMethod)method, "set")) {
                if (!this.delegate.execute(method, state)) {
                    return false;
                }
                string = "set";
            } else if (GroovyPropertyUtils.isSetterLike((PsiMethod)method, "add")) {
                String string2 = ((PsiMethod)method).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String newName = StringsKt.replaceFirst$default((String)string2, (String)"add", (String)"set", (boolean)false, (int)4, null);
                GrMethodWrapper wrapper = GrMethodWrapper.wrap((PsiMethod)method, newName);
                if (!this.delegate.execute((PsiElement)wrapper, state)) {
                    return false;
                }
                string = "add";
            } else {
                return true;
            }
            String prefix = string;
            String string3 = ((PsiMethod)method).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String propertyName = StringsKt.decapitalize((String)StringsKt.removePrefix((String)string3, (CharSequence)prefix));
            if (this.name != null && !Intrinsics.areEqual((Object)this.name, (Object)propertyName)) {
                return true;
            }
            PsiParameter[] psiParameterArray = ((PsiMethod)method).getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            PsiParameter psiParameter = (PsiParameter)ArraysKt.singleOrNull((Object[])psiParameterArray);
            if (psiParameter == null) {
                return true;
            }
            PsiParameter parameter = psiParameter;
            PsiType psiType = TypesUtil.createJavaLangClassType(parameter.getType(), this.place);
            if (psiType == null) {
                return true;
            }
            PsiType classType = psiType;
            GrLightMethodBuilder $this$execute_u24lambda_u240 = grLightMethodBuilder = new GrLightMethodBuilder(this.place.getManager(), propertyName);
            boolean bl = false;
            $this$execute_u24lambda_u240.setReturnType((PsiType)PsiTypes.voidType());
            $this$execute_u24lambda_u240.setNavigationElement(method);
            $this$execute_u24lambda_u240.setContainingClass(((PsiMethod)method).getContainingClass());
            GrLightMethodBuilder wrappedBase = grLightMethodBuilder;
            GrLightMethodBuilder $this$execute_u24lambda_u241 = grLightMethodBuilder = wrappedBase.copy();
            boolean bl2 = false;
            $this$execute_u24lambda_u241.addParameter("name", "java.lang.String");
            $this$execute_u24lambda_u241.addParameter("clazz", classType);
            $this$execute_u24lambda_u241.addOptionalParameter("configuration", "groovy.lang.Closure");
            GrLightMethodBuilder it = grLightMethodBuilder;
            boolean bl3 = false;
            if (!this.delegate.execute((PsiElement)it, state)) {
                return false;
            }
            GrLightMethodBuilder $this$execute_u24lambda_u244 = grLightMethodBuilder = wrappedBase.copy();
            boolean bl4 = false;
            $this$execute_u24lambda_u244.addParameter("clazz", classType);
            GrLightParameter $this$execute_u24lambda_u244_u24lambda_u243 = grLightParameter = $this$execute_u24lambda_u244.addAndGetOptionalParameter("configuration", "groovy.lang.Closure");
            boolean bl5 = false;
            $this$execute_u24lambda_u244_u24lambda_u243.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_TYPE_KEY, "ch.qos.logback.classic.gaffer.ComponentDelegate");
            $this$execute_u24lambda_u244_u24lambda_u243.putUserData(GrDelegatesToUtilKt.DELEGATES_TO_STRATEGY_KEY, 1);
            it = grLightMethodBuilder;
            boolean bl6 = false;
            return this.delegate.execute((PsiElement)it, state);
        }

        @Nullable
        public <T> T getHint(@NotNull Key<T> hintKey) {
            Intrinsics.checkNotNullParameter(hintKey, (String)"hintKey");
            return (T)(Intrinsics.areEqual(hintKey, (Object)ElementClassHint.KEY) ? ComponentProcessor::getHint$lambda$6 : null);
        }

        private static final boolean getHint$lambda$6(ElementClassHint.DeclarationKind it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it == ElementClassHint.DeclarationKind.METHOD;
        }
    }
}

