/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacroContributor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectWidePathMacroContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.idea.maven.utils.MavenSerializedRepositoryManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

final class MavenPathMacroContributor
implements ProjectWidePathMacroContributor,
PathMacroContributor {
    MavenPathMacroContributor() {
    }

    public void registerPathMacros(@NotNull Map<String, String> macros, @NotNull Map<String, String> legacyMacros) {
        if (macros == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(0);
        }
        if (legacyMacros == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(1);
        }
        String repository = MavenUtil.resolveDefaultLocalRepository(null).toAbsolutePath().toString();
        macros.put("MAVEN_REPOSITORY", repository);
    }

    public void forceRegisterPathMacros(@NotNull Map<String, String> macros) {
        if (macros == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(2);
        }
        if (System.getProperty("maven.repo.local") != null) {
            macros.put("MAVEN_REPOSITORY", System.getProperty("maven.repo.local"));
        }
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull String> getProjectPathMacros(@NotNull @SystemIndependent String projectFilePath) {
        if (projectFilePath == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(3);
        }
        Map<String, String> map = Map.of("MAVEN_REPOSITORY", MavenPathMacroContributor.getPathToMavenHome(projectFilePath));
        if (map == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    static String getPathToMavenHome(@NotNull @SystemIndependent String projectFilePath) {
        Path projectFile2;
        EelDescriptor descriptor2;
        String serializedPath;
        if (projectFilePath == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(5);
        }
        if ((serializedPath = MavenPathMacroContributor.getBySerializedProjectPath(descriptor2 = EelProviderUtil.getEelDescriptor((Path)(projectFile2 = Path.of(projectFilePath, new String[0]))), projectFilePath, projectFile2)) != null) {
            String string = serializedPath;
            if (string == null) {
                MavenPathMacroContributor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = MavenUtil.resolveDefaultLocalRepository(projectFile2).toAbsolutePath().toString();
        if (string == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String getBySerializedProjectPath(@NotNull EelDescriptor descriptor2, @NotNull String projectFilePath, Path projectFile2) {
        Project[] projects;
        if (descriptor2 == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(8);
        }
        if (projectFilePath == null) {
            MavenPathMacroContributor.$$$reportNull$$$0(9);
        }
        if (descriptor2.equals(LocalEelDescriptor.INSTANCE) && !Files.exists(projectFile2.getParent().resolve("mavenHomeManager.xml"), new LinkOption[0])) {
            return PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath("$MAVEN_REPOSITORY$");
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (!projectFilePath.equals(project.getProjectFilePath())) continue;
            return ((MavenSerializedRepositoryManager)project.getService(MavenSerializedRepositoryManager.class)).getMavenHomePath().toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macros";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legacyMacros";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePath";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenPathMacroContributor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenPathMacroContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPathMacros";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToMavenHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerPathMacros";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forceRegisterPathMacros";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathMacros";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathToMavenHome";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBySerializedProjectPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

