/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0087@\u00a2\u0006\u0002\u0010\nJ*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0087@\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J(\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0007J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0007J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u0013H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil;", "", "<init>", "()V", "read", "Lorg/jdom/Element;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "handler", "Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/nio/file/Path;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/file/Path;Ljava/nio/charset/Charset;Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bytes", "", "doRead", "text", "", "findChildByPath", "element", "path", "findChildValueByPath", "defaultValue", "hasChildByPath", "", "findChildrenByPath", "", "subPath", "findChildrenValuesByPath", "childrenName", "collectChildren", "container", "ErrorHandler", "intellij.maven"})
public final class MavenJDOMUtil {
    @NotNull
    public static final MavenJDOMUtil INSTANCE = new MavenJDOMUtil();

    private MavenJDOMUtil() {
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final Object read(@NotNull VirtualFile var0, @Nullable ErrorHandler var1_1, @NotNull Continuation<? super Element> $completion) {
        if (!($completion instanceof read.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenJDOMUtil.read(null, null, (Continuation<? super Element>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = file;
                $continuation.L$1 = handler;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, read$lambda$0(com.intellij.openapi.vfs.VirtualFile ), ()Ljava/nio/charset/Charset;)((VirtualFile)file), (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                handler = (ErrorHandler)$continuation.L$1;
                file = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = (Charset)v0;
                if (v1 == null) {
                    return null;
                }
                charset = v1;
                path = Path.of(file.getPath(), new String[0]);
                Intrinsics.checkNotNull((Object)path);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v2 = MavenJDOMUtil.read(path, charset, handler, (Continuation<? super Element>)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    @Nullable
    public static final Object read(@NotNull Path file2, @NotNull Charset charset, @Nullable ErrorHandler handler2, @NotNull Continuation<? super Element> $completion) {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isDisposed()) {
            MavenLog.LOG.warn("MavenJDOMUtil.read: app is null or disposed");
            return null;
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Element>, Object>(file2, handler2, charset, null){
            int label;
            final /* synthetic */ Path $file;
            final /* synthetic */ ErrorHandler $handler;
            final /* synthetic */ Charset $charset;
            {
                this.$file = $file;
                this.$handler = $handler;
                this.$charset = $charset;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Closeable closeable;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Element element;
                            closeable = Files.newInputStream(this.$file, new OpenOption[0]);
                            Charset charset = this.$charset;
                            ErrorHandler errorHandler = this.$handler;
                            Path path = this.$file;
                            Throwable throwable = null;
                            try {
                                InputStream inputStream = (InputStream)closeable;
                                boolean bl = false;
                                Intrinsics.checkNotNull((Object)inputStream);
                                Reader reader = new InputStreamReader(inputStream, charset);
                                int n = 8192;
                                String text = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                                Element element2 = MavenJDOMUtil.access$doRead(MavenJDOMUtil.INSTANCE, text, errorHandler);
                                if (element2 == null) {
                                    MavenLog.LOG.warn("MavenJDOMUtil.read: reading result is null for file " + path + ", text '" + text + "'");
                                }
                                element = element2;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            closeable = element;
                        }
                        catch (IOException e) {
                            MavenLog.LOG.warn("MavenJDOMUtil.read: file " + this.$file + " text is not loaded", (Throwable)e);
                            ErrorHandler errorHandler = this.$handler;
                            if (errorHandler != null) {
                                errorHandler.onReadError(e);
                            }
                            closeable = null;
                        }
                        return closeable;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Element> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @JvmStatic
    @Nullable
    public static final Element read(@NotNull byte[] bytes, @Nullable ErrorHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bytesToString(...)");
        return INSTANCE.doRead(string, handler2);
    }

    private final Element doRead(String text, ErrorHandler handler2) {
        LinkedList<Element> stack = new LinkedList<Element>();
        Element[] elementArray = new Element[]{null};
        Element[] result2 = elementArray;
        XmlBuilderDriver driver = new XmlBuilderDriver((CharSequence)text);
        XmlBuilder builder2 = new XmlBuilder(stack, result2, handler2){
            final /* synthetic */ LinkedList<Element> $stack;
            final /* synthetic */ Element[] $result;
            final /* synthetic */ ErrorHandler $handler;
            {
                this.$stack = $stack;
                this.$result = $result;
                this.$handler = $handler;
            }

            public void doctype(CharSequence publicId, CharSequence systemId, int startOffset, int endOffset) {
            }

            public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                Element parent;
                Element element;
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                String name = ((Object)localName).toString();
                if (StringsKt.isBlank((CharSequence)name)) {
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                try {
                    element = new Element(name);
                }
                catch (IllegalNameException e) {
                    element = new Element("invalidName");
                }
                Element newElement = element;
                Element element2 = parent = this.$stack.isEmpty() ? null : this.$stack.getLast();
                if (parent == null) {
                    this.$result[0] = newElement;
                } else {
                    parent.addContent(newElement);
                }
                this.$stack.addLast(newElement);
                return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
            }

            public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                String name = ((Object)localName).toString();
                if (StringsKt.isBlank((CharSequence)name)) {
                    return;
                }
                Iterator<Element> itr = this.$stack.descendingIterator();
                while (itr.hasNext()) {
                    Element element = itr.next();
                    if (!Intrinsics.areEqual((Object)element.getName(), (Object)name)) continue;
                    while (this.$stack.removeLast() != element) {
                    }
                    break;
                }
            }

            public void textElement(CharSequence text, CharSequence physical, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)physical, (String)"physical");
                this.$stack.getLast().addContent(JDOMUtil.legalizeText((String)((Object)text).toString()));
            }

            public void attribute(CharSequence name, CharSequence value, int startoffset, int endoffset) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            }

            public void error(String message, int startOffset, int endOffset) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    ErrorHandler errorHandler = this.$handler;
                    if (errorHandler == null) break block0;
                    errorHandler.onSyntaxError(message, startOffset, endOffset);
                }
            }
        };
        driver.build(builder2);
        return result2[0];
    }

    @JvmStatic
    @Nullable
    public static final Element findChildByPath(@Nullable Element element, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int i2 = 0;
        for (Element el = element; el != null; el = el.getChild(string)) {
            int dot = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)i2, (boolean)false, (int)4, null);
            if (dot == -1) {
                String string2 = path.substring(i2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return el.getChild(string2);
            }
            string = path.substring(i2, dot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            i2 = dot + 1;
        }
        return null;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String findChildValueByPath(@Nullable Element element, @NotNull String path, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Element child = MavenJDOMUtil.findChildByPath(element, path);
        if (child == null) {
            return defaultValue;
        }
        String childValue = child.getTextTrim();
        Intrinsics.checkNotNull((Object)childValue);
        return ((CharSequence)childValue).length() == 0 ? defaultValue : childValue;
    }

    public static /* synthetic */ String findChildValueByPath$default(Element element, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return MavenJDOMUtil.findChildValueByPath(element, string, string2);
    }

    @JvmStatic
    public static final boolean hasChildByPath(@Nullable Element element, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MavenJDOMUtil.findChildByPath(element, path) != null;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> findChildrenByPath(@Nullable Element element, @NotNull String path, @NotNull String subPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)subPath, (String)"subPath");
        return INSTANCE.collectChildren(MavenJDOMUtil.findChildByPath(element, path), subPath);
    }

    @JvmStatic
    @NotNull
    public static final List<String> findChildrenValuesByPath(@Nullable Element element, @NotNull String path, @NotNull String childrenName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)childrenName, (String)"childrenName");
        List result2 = new ArrayList();
        for (Element each : MavenJDOMUtil.findChildrenByPath(element, path, childrenName)) {
            String value = each.getTextTrim();
            Intrinsics.checkNotNull((Object)value);
            if (((CharSequence)value).length() == 0) continue;
            result2.add(value);
        }
        return result2;
    }

    private final List<Element> collectChildren(Element container, String subPath) {
        if (container == null) {
            return CollectionsKt.emptyList();
        }
        int firstDot = StringsKt.indexOf$default((CharSequence)subPath, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstDot == -1) {
            List list = container.getChildren(subPath);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            return list;
        }
        String string = subPath.substring(0, firstDot);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String childName = string;
        String string2 = subPath.substring(firstDot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String pathInChild = string2;
        List result2 = new ArrayList();
        for (Element each : container.getChildren(childName)) {
            Element child = MavenJDOMUtil.findChildByPath(each, pathInChild);
            if (child == null) continue;
            result2.add(child);
        }
        return result2;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String findChildValueByPath(@Nullable Element element, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return MavenJDOMUtil.findChildValueByPath$default(element, path, null, 4, null);
    }

    private static final Charset read$lambda$0(VirtualFile $file) {
        if (!$file.isValid()) {
            MavenLog.LOG.warn("MavenJDOMUtil.read: file " + $file.getName() + " is invalid");
            return null;
        }
        return $file.getCharset();
    }

    public static final /* synthetic */ Element access$doRead(MavenJDOMUtil $this, String text, ErrorHandler handler2) {
        return $this.doRead(text, handler2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenJDOMUtil$ErrorHandler;", "", "onReadError", "", "e", "Ljava/io/IOException;", "onSyntaxError", "message", "", "startOffset", "", "endOffset", "intellij.maven"})
    public static interface ErrorHandler {
        public void onReadError(@Nullable IOException var1);

        public void onSyntaxError(@NotNull String var1, int var2, int var3);
    }
}

