/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.project.ProjectKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenIgnoreFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "<init>", "()V", "isIgnoredFile", "", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "getIgnoredGroupDescription", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "intellij.maven"})
public final class MavenIgnoreFileProvider
implements IgnoredFileProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!Intrinsics.areEqual((Object)filePath.getName(), (Object)"mavenHomeManager.xml")) return false;
        FilePath filePath2 = filePath.getParentPath();
        if (!Intrinsics.areEqual((Object)(filePath2 != null ? filePath2.getPath() : null), (Object)project.getBasePath())) return false;
        return true;
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SetsKt.setOf((Object)IgnoredBeanFactory.ignoreFile((String)FileUtil.toSystemIndependentName((String)((Object)ProjectKt.getStateStore((Project)project).getProjectFilePath().getParent().resolve("mavenHomeManager.xml")).toString()), (Project)project));
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        String string = MavenProjectBundle.message("maven.ignored.projects.settings", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

