/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.CollectionFactory;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.BundledMaven4;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

@Service(value={Service.Level.PROJECT})
public final class MavenDistributionsCache {
    private static final ClearableLazyValue<Path> mySourcePath = ClearableLazyValue.create(MavenDistributionsCache::getSourceMavenPath);
    private final ConcurrentMap<String, String> myWorkingDirToMultiModuleMap = CollectionFactory.createConcurrentWeakMap();
    private final ConcurrentMap<String, String> myVmSettingsMap = CollectionFactory.createConcurrentWeakMap();
    private final ConcurrentMap<String, MavenDistribution> myMultimoduleDirToWrapperedMavenDistributionsMap = new ConcurrentHashMap<String, MavenDistribution>();
    private final Project myProject;
    private final ClearableLazyValue<MavenDistribution> mySettingsDistribution = ClearableLazyValue.create(this::getSettingsDistribution);

    public MavenDistributionsCache(Project project) {
        this.myProject = project;
    }

    public static MavenDistributionsCache getInstance(Project project) {
        return (MavenDistributionsCache)project.getService(MavenDistributionsCache.class);
    }

    public void cleanCaches() {
        this.mySettingsDistribution.drop();
        this.myWorkingDirToMultiModuleMap.clear();
        this.myMultimoduleDirToWrapperedMavenDistributionsMap.clear();
        this.myVmSettingsMap.clear();
    }

    @NotNull
    public MavenDistribution getSettingsDistribution() {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        MavenHomeType type = settings.getGeneralSettings().getMavenHomeType();
        if (type instanceof MavenWrapper) {
            String baseDir = this.myProject.getBasePath();
            List<MavenProject> projects = projectsManager.getProjects();
            if (!projects.isEmpty()) {
                baseDir = projects.get(0).getDirectory();
            }
            if (baseDir != null) {
                String multiModuleDir = this.myWorkingDirToMultiModuleMap.computeIfAbsent(baseDir, this::resolveMultiModuleDirectory);
                MavenDistribution mavenDistribution = this.myMultimoduleDirToWrapperedMavenDistributionsMap.computeIfAbsent(multiModuleDir, this::getWrapperDistribution);
                if (mavenDistribution == null) {
                    MavenDistributionsCache.$$$reportNull$$$0(0);
                }
                return mavenDistribution;
            }
        } else if (type instanceof MavenInSpecificPath) {
            MavenInSpecificPath sp = (MavenInSpecificPath)type;
            MavenDistribution mavenDistribution = MavenDistributionsCache.fromPath(sp.getMavenHome(), sp.getTitle());
            if (mavenDistribution != null) {
                MavenDistribution mavenDistribution2 = mavenDistribution;
                if (mavenDistribution2 == null) {
                    MavenDistributionsCache.$$$reportNull$$$0(1);
                }
                return mavenDistribution2;
            }
        } else if (type instanceof BundledMaven3 || type instanceof BundledMaven4) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        projectsManager.getSyncConsole().addWarning(SyncBundle.message("cannot.resolve.maven.home", new Object[0]), SyncBundle.message("is.not.correct.maven.home.reverting.to.embedded", settings.getGeneralSettings().getMavenHomeType().getTitle()));
        return MavenDistributionsCache.resolveEmbeddedMavenHome();
    }

    @Nullable
    private static MavenDistribution fromPath(@NotNull String path, @NotNull String label) {
        Path file2;
        if (path == null) {
            MavenDistributionsCache.$$$reportNull$$$0(2);
        }
        if (label == null) {
            MavenDistributionsCache.$$$reportNull$$$0(3);
        }
        if (!MavenUtil.isValidMavenHome(file2 = Path.of(path, new String[0]))) {
            return null;
        }
        return new LocalMavenDistribution(file2, label);
    }

    @NotNull
    public String getVmOptions(@Nullable String workingDirectory) {
        String vmOptions = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getImportingSettings().getVmOptionsForImporter();
        if (workingDirectory == null || !StringUtil.isEmptyOrSpaces((String)vmOptions)) {
            String string = vmOptions;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(4);
            }
            return string;
        }
        String multiModuleDir = this.myWorkingDirToMultiModuleMap.computeIfAbsent(workingDirectory, this::resolveMultiModuleDirectory);
        String string = this.myVmSettingsMap.computeIfAbsent(multiModuleDir, MavenExternalParameters::readJvmConfigOptions);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public MavenDistribution getMavenDistribution(@Nullable String workingDirectory) {
        if (!this.useWrapper() || workingDirectory == null) {
            MavenDistribution mavenDistribution = (MavenDistribution)this.mySettingsDistribution.getValue();
            if (mavenDistribution == null) {
                MavenDistributionsCache.$$$reportNull$$$0(6);
            }
            return mavenDistribution;
        }
        String multiModuleDir = this.myWorkingDirToMultiModuleMap.computeIfAbsent(workingDirectory, this::resolveMultiModuleDirectory);
        MavenDistribution mavenDistribution = this.myMultimoduleDirToWrapperedMavenDistributionsMap.computeIfAbsent(multiModuleDir, this::getWrapperDistribution);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(7);
        }
        return mavenDistribution;
    }

    void addWrapper(@NotNull String workingDirectory, @NotNull MavenDistribution distribution) {
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(8);
        }
        if (distribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(9);
        }
        this.myMultimoduleDirToWrapperedMavenDistributionsMap.put(workingDirectory, distribution);
    }

    @NotNull
    private MavenDistribution getWrapperDistribution(@NotNull String multiModuleDir) {
        String distributionUrl;
        if (multiModuleDir == null) {
            MavenDistributionsCache.$$$reportNull$$$0(10);
        }
        MavenDistribution mavenDistribution = (distributionUrl = this.getWrapperDistributionUrl(multiModuleDir)) == null ? MavenDistributionsCache.resolveEmbeddedMavenHome() : MavenDistributionsCache.getMavenWrapper(this.myProject, distributionUrl);
        if (mavenDistribution == null) {
            MavenDistributionsCache.$$$reportNull$$$0(11);
        }
        return mavenDistribution;
    }

    @Nullable
    public MavenDistribution getWrapper(@NotNull String workingDirectory) {
        String multiModuleDir;
        String distributionUrl;
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(12);
        }
        return (distributionUrl = this.getWrapperDistributionUrl(multiModuleDir = this.myWorkingDirToMultiModuleMap.computeIfAbsent(workingDirectory, this::resolveMultiModuleDirectory))) != null ? MavenWrapperSupport.getCurrentDistribution(this.myProject, distributionUrl) : null;
    }

    private static MavenDistribution getMavenWrapper(Project project, String distributionUrl) {
        MavenDistribution distribution = MavenWrapperSupport.getCurrentDistribution(project, distributionUrl);
        if (distribution == null) {
            distribution = MavenDistributionsCache.resolveEmbeddedMavenHome();
        }
        return distribution;
    }

    @NotNull
    public static LocalMavenDistribution resolveEmbeddedMavenHome() {
        PluginDescriptor mavenPlugin = PluginManager.getPluginByClass(MavenDistributionsCache.class);
        if (PluginManagerCore.isRunningFromSources()) {
            Path mavenPath = (Path)mySourcePath.getValue();
            return new LocalMavenDistribution(mavenPath, BundledMaven3.INSTANCE.getTitle());
        }
        if (mavenPlugin != null) {
            Path pathToBundledMaven = mavenPlugin.getPluginPath().resolve("lib").resolve("maven3");
            return new LocalMavenDistribution(pathToBundledMaven, BundledMaven3.INSTANCE.getTitle());
        }
        Path pluginFileOrDir = Path.of(PathUtil.getJarPathForClass(MavenServerManager.class), new String[0]);
        Path pathToBundledMaven = pluginFileOrDir.getParent().resolve("maven3");
        return new LocalMavenDistribution(pathToBundledMaven, BundledMaven3.INSTANCE.getTitle());
    }

    private static Path getSourceMavenPath() {
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        return BundledMavenDownloader.INSTANCE.downloadMavenDistributionSync(communityRoot);
    }

    @Nullable
    String getWrapperDistributionUrl(String multimoduleDirectory) {
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByPath(multimoduleDirectory);
        if (baseDir == null) {
            return null;
        }
        return MavenWrapperSupport.getWrapperDistributionUrl(baseDir);
    }

    @NotNull
    private String resolveMultiModuleDirectory(@NotNull String workingDirectory) {
        MavenProjectsManager manager;
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(13);
        }
        if (!(manager = MavenProjectsManager.getInstance(this.myProject)).isMavenizedProject()) {
            String string = FileUtilRt.toSystemIndependentName((String)this.calculateMultimoduleDirUpToFileTree(workingDirectory));
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = FileUtilRt.toSystemIndependentName((String)manager.getRootProjects().stream().map(MavenProject::getDirectory).filter(rpDirectory -> FileUtil.isAncestor((String)rpDirectory, (String)workingDirectory, (boolean)false)).findFirst().orElseGet(() -> this.calculateMultimoduleDirUpToFileTree(workingDirectory)));
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private String calculateMultimoduleDirUpToFileTree(String directory) {
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(directory);
        if (path == null) {
            String string = directory;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(16);
            }
            return string;
        }
        Collection knownWorkingDirs = this.myWorkingDirToMultiModuleMap.values();
        for (String known : knownWorkingDirs) {
            if (!FileUtil.isAncestor((String)known, (String)directory, (boolean)false)) continue;
            String string = known;
            if (string == null) {
                MavenDistributionsCache.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = MavenUtil.getVFileBaseDir(path).getPath();
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getMultimoduleDirectory(@NotNull String workingDirectory) {
        if (workingDirectory == null) {
            MavenDistributionsCache.$$$reportNull$$$0(19);
        }
        String string = this.myWorkingDirToMultiModuleMap.computeIfAbsent(workingDirectory, this::resolveMultiModuleDirectory);
        if (string == null) {
            MavenDistributionsCache.$$$reportNull$$$0(20);
        }
        return string;
    }

    private boolean useWrapper() {
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        return MavenUtil.isWrapper(settings.getGeneralSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8, 9, 10, 12, 13, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsDistribution";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenDistributionsCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenDistribution";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperDistribution";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMultiModuleDirectory";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMultimoduleDirUpToFileTree";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultimoduleDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperDistribution";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWrapper";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveMultiModuleDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMultimoduleDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8, 9, 10, 12, 13, 19 -> new IllegalArgumentException(string);
        };
    }
}

