/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.progress.RawProgressReporter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.extension.kotlin.ContextExtensionsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectTimestamp;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateContext;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdater;
import org.jetbrains.idea.maven.telemetry.TelemetryKt;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u00019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u001e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u001fJ,\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J\u001e\u0010%\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100#H\u0002J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010*\u001a\u00020\u000bH\u0002J$\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120-H\u0002J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0010H\u0002J\u001e\u00100\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u00101J\u001c\u00102\u001a\u00020!2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040#H\u0086@\u00a2\u0006\u0002\u00105J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0016\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater;", "", "tree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "updateContext", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;", "reader", "Lorg/jetbrains/idea/maven/project/MavenProjectReader;", "process", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "updateModules", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;Lorg/jetbrains/idea/maven/project/MavenProjectReader;Lcom/intellij/platform/util/progress/RawProgressReporter;Z)V", "updated", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createdMavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "userSettingsFile", "Ljava/nio/file/Path;", "Lorg/jetbrains/annotations/Nullable;", "globalSettingsFile", "startUpdate", "mavenProjectFile", "forceRead", "readPomIfNeeded", "mavenProject", "(Lorg/jetbrains/idea/maven/project/MavenProject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateTimestamp", "Lorg/jetbrains/idea/maven/project/MavenProjectTimestamp;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRemovedModules", "", "prevModules", "", "existingModuleFiles", "reconnectModuleFiles", "modulesFilesToReconnect", "collectModuleFilesToReconnect", "collectModuleFilesToUpdate", "moduleFilesToReconnect", "updateExistingModules", "collectChildFilesToUpdate", "prevChildren", "", "findOrCreateProject", "f", "update", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProjects", "specs", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFileTimestamp", "", "file", "UpdateSpec", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectsTreeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n48#2,6:278\n86#2,2:284\n55#2,3:286\n97#2:289\n89#2,6:290\n774#3:296\n865#3,2:297\n774#3:299\n865#3,2:300\n1557#3:302\n1628#3,3:303\n1557#3:306\n1628#3,3:307\n1557#3:310\n1628#3,3:311\n*S KotlinDebug\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n*L\n70#1:278,6\n70#1:284,2\n70#1:286,3\n70#1:289\n70#1:290,6\n121#1:296\n121#1:297,2\n171#1:299\n171#1:300,2\n178#1:302\n178#1:303,3\n226#1:306\n226#1:307,3\n237#1:310\n237#1:311,3\n*E\n"})
public final class MavenProjectsTreeUpdater {
    @NotNull
    private final MavenProjectsTree tree;
    @NotNull
    private final MavenProjectsTreeUpdateContext updateContext;
    @NotNull
    private final MavenProjectReader reader;
    @Nullable
    private final RawProgressReporter process;
    private final boolean updateModules;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Boolean> updated;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, MavenProject> createdMavenProjects;
    @Nullable
    private final Path userSettingsFile;
    @Nullable
    private final Path globalSettingsFile;

    public MavenProjectsTreeUpdater(@NotNull MavenProjectsTree tree, @NotNull MavenProjectsTreeUpdateContext updateContext, @NotNull MavenProjectReader reader, @Nullable RawProgressReporter process2, boolean updateModules) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.tree = tree;
        this.updateContext = updateContext;
        this.reader = reader;
        this.process = process2;
        this.updateModules = updateModules;
        this.updated = new ConcurrentHashMap();
        this.createdMavenProjects = new ConcurrentHashMap();
        this.userSettingsFile = this.reader.getGeneralSettings().getEffectiveUserSettingsIoFile();
        this.globalSettingsFile = this.reader.getGeneralSettings().getEffectiveGlobalSettingsIoFile();
    }

    private final boolean startUpdate(VirtualFile mavenProjectFile, boolean forceRead) {
        block2: {
            String string = mavenProjectFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String projectPath = string;
            if (this.tree.isIgnored(projectPath)) {
                MavenLog.LOG.trace("Won't update ignored file " + mavenProjectFile);
                return false;
            }
            Ref previousUpdateRef = new Ref();
            this.updated.compute(mavenProjectFile, (arg_0, arg_1) -> MavenProjectsTreeUpdater.startUpdate$lambda$1((arg_0, arg_1) -> MavenProjectsTreeUpdater.startUpdate$lambda$0(previousUpdateRef, forceRead, arg_0, arg_1), arg_0, arg_1));
            Boolean previousUpdate = (Boolean)previousUpdateRef.get();
            if (previousUpdate != null && !forceRead || Intrinsics.areEqual((Object)true, (Object)previousUpdate)) {
                MavenLog.LOG.trace("Has already been updated (" + previousUpdate + "): " + mavenProjectFile + "; forceRead: " + forceRead);
                return false;
            }
            RawProgressReporter rawProgressReporter = this.process;
            if (rawProgressReporter == null) break block2;
            Object[] objectArray = new Object[]{projectPath};
            rawProgressReporter.text(MavenProjectBundle.message("maven.reading.pom", objectArray));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object readPomIfNeeded(MavenProject var1_1, boolean var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof readPomIfNeeded.1)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$readPomIfNeeded(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                forceRead = $continuation.Z$0;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                timeStampChanged = Intrinsics.areEqual((Object)(timestamp = (MavenProjectTimestamp)v0), (Object)this.tree.getTimeStamp$intellij_maven(mavenProject)) == false;
                v1 = readPom = forceRead != false || timeStampChanged != false ? 1 : 0;
                if (readPom == 0) ** GOTO lbl124
                oldProjectId = mavenProject.isNew() != false ? null : mavenProject.getMavenId();
                oldParentId = mavenProject.getParentId();
                v2 = TelemetryKt.getTracer().spanBuilder("readPom");
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"spanBuilder(...)");
                $this$useWithScope_u24default$iv = v2;
                context$iv /* !! */  = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                $i$f$useWithScope = false;
                v3 = $this$useWithScope_u24default$iv.startSpan();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"startSpan(...)");
                $this$useWithoutActiveScope$iv$iv = v3;
                $i$f$useWithoutActiveScope = false;
                span$iv = $this$useWithoutActiveScope$iv$iv;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                v4 = Context.current().with((ImplicitContextKeyed)span$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"with(...)");
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = timestamp;
                $continuation.L$3 = oldProjectId;
                $continuation.L$4 = oldParentId;
                $continuation.L$5 = $this$useWithoutActiveScope$iv$iv;
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = readPom;
                $continuation.label = 2;
                v5 = BuildersKt.withContext((CoroutineContext)context$iv /* !! */ .plus(ContextExtensionsKt.asContextElement((Context)v4)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MavenProjectReaderResult>, Object>(span$iv, null, this, mavenProject){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Span $span;
                    final /* synthetic */ MavenProjectsTreeUpdater this$0;
                    final /* synthetic */ MavenProject $mavenProject$inlined;
                    {
                        this.$span = $span;
                        this.this$0 = mavenProjectsTreeUpdater;
                        this.$mavenProject$inlined = mavenProject;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $completion) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$completion);
                                CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                Continuation cfr_ignored_0 = (Continuation)this;
                                boolean bl = false;
                                this.label = 1;
                                Object object2 = MavenProjectsTreeUpdater.access$getReader$p(this.this$0).readProjectAsync(this.$mavenProject$inlined.getFile(), (Continuation<? super MavenProjectReaderResult>)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                void $result;
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super MavenProjectReaderResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v5 != var21_6) goto lbl58
lbl57:
                // 1 sources

                return var21_6;
lbl58:
                // 1 sources

                ** GOTO lbl76
            }
            case 2: {
                $i$f$useWithScope = false;
                $i$f$useWithoutActiveScope = false;
                $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                readPom = $continuation.I$0;
                forceRead = $continuation.Z$0;
                $this$useWithoutActiveScope$iv$iv = (Span)$continuation.L$5;
                oldParentId = (MavenId)$continuation.L$4;
                oldProjectId = (MavenId)$continuation.L$3;
                timestamp = (MavenProjectTimestamp)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl76:
                    // 2 sources

                    var17_22 = v5;
                    ** GOTO lbl89
                }
                catch (CancellationException e$iv$iv) {
                    throw e$iv$iv;
                }
                catch (Throwable e$iv$iv) {
                    $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                    throw e$iv$iv;
                }
            }
            catch (Throwable var18_25) {
                throw var18_25;
            }
            {
                finally {
                    $this$useWithoutActiveScope$iv$iv.end();
                }
lbl89:
                // 1 sources

                readerResult = (MavenProjectReaderResult)var17_22;
                context$iv /* !! */  = this.reader.getGeneralSettings().getEffectiveRepositoryPath();
                Intrinsics.checkNotNullExpressionValue((Object)context$iv /* !! */ , (String)"getEffectiveRepositoryPath(...)");
                readChanges = mavenProject.updateFromReaderResult(readerResult, (Path)context$iv /* !! */ , true);
                this.tree.putVirtualFileToProjectMapping(mavenProject, oldProjectId);
                if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) ** GOTO lbl97
                this.tree.putTimestamp$intellij_maven(mavenProject, timestamp);
                ** GOTO lbl120
lbl97:
                // 1 sources

                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = readChanges;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = readPom;
                $continuation.label = 3;
                v6 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v6 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl118
            }
            case 3: {
                readPom = $continuation.I$0;
                forceRead = $continuation.Z$0;
                readChanges = (MavenProjectChanges)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl118:
                // 2 sources

                newTimestamp = (MavenProjectTimestamp)v6;
                this.tree.putTimestamp$intellij_maven(mavenProject, newTimestamp);
lbl120:
                // 2 sources

                forcedChanges = forceRead != false ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
                Intrinsics.checkNotNull((Object)forcedChanges);
                changes = MavenProjectChangesBuilder.Companion.merged(forcedChanges, readChanges);
                this.updateContext.updated(mavenProject, changes);
lbl124:
                // 2 sources

                return Boxing.boxBoolean((boolean)(readPom != 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object calculateTimestamp(MavenProject mavenProject, Continuation<? super MavenProjectTimestamp> $completion) {
        return CoroutinesKt.readAction(() -> MavenProjectsTreeUpdater.calculateTimestamp$lambda$3(this, mavenProject), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRemovedModules(MavenProject mavenProject, List<MavenProject> prevModules, List<? extends VirtualFile> existingModuleFiles) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = prevModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            if (!(!existingModuleFiles.contains(it.getFile()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedModules = (List)destination$iv$iv;
        for (MavenProject module : removedModules) {
            VirtualFile moduleFile = module.getFile();
            if (this.tree.isManagedFile(moduleFile)) {
                if (!this.tree.reconnectRoot(module)) continue;
                this.updateContext.updated(module, MavenProjectChanges.NONE);
                continue;
            }
            this.tree.removeModule(mavenProject, module);
            this.tree.doDelete$intellij_maven(mavenProject, module, this.updateContext);
        }
    }

    private final void reconnectModuleFiles(MavenProject mavenProject, List<? extends VirtualFile> modulesFilesToReconnect) {
        for (VirtualFile virtualFile : modulesFilesToReconnect) {
            MavenProject module = this.tree.findProject(virtualFile);
            if (module == null || !this.tree.reconnect(mavenProject, module)) continue;
            this.updateContext.updated(module, MavenProjectChanges.NONE);
        }
    }

    private final List<VirtualFile> collectModuleFilesToReconnect(MavenProject mavenProject, List<? extends VirtualFile> existingModuleFiles) {
        ArrayList<VirtualFile> modulesFilesToReconnect = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject foundModule = this.tree.findProject(virtualFile);
            boolean bl = isNewModule = foundModule == null;
            if (!isNewModule) {
                MavenProject mavenProject2 = foundModule;
                Intrinsics.checkNotNull((Object)mavenProject2);
                MavenProject currentAggregator = this.tree.findAggregator(mavenProject2);
                if (currentAggregator != null && currentAggregator != mavenProject) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject.getFile());
                    continue;
                }
            }
            modulesFilesToReconnect.add(virtualFile);
        }
        return modulesFilesToReconnect;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectModuleFilesToUpdate(List<? extends VirtualFile> moduleFilesToReconnect, boolean updateExistingModules) {
        void $this$filterTo$iv$iv;
        if (updateExistingModules) {
            return moduleFilesToReconnect;
        }
        Iterable $this$filter$iv = moduleFilesToReconnect;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(this.tree.findProject(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectChildFilesToUpdate(MavenProject mavenProject, Collection<MavenProject> prevChildren) {
        void $this$mapTo$iv$iv;
        HashSet<MavenProject> children = new HashSet<MavenProject>(prevChildren);
        Collection<MavenProject> collection = this.updateContext.getDeletedProjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getDeletedProjects(...)");
        children.removeAll(CollectionsKt.toSet((Iterable)collection));
        children.addAll(this.tree.findInheritors(mavenProject));
        Iterable $this$map$iv = children;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject2 = (MavenProject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    private final MavenProject findOrCreateProject(VirtualFile f) {
        MavenProject mavenProject = this.tree.findProject(f);
        if (mavenProject != null) {
            return mavenProject;
        }
        MavenProject mavenProject2 = this.createdMavenProjects.compute(f, (arg_0, arg_1) -> MavenProjectsTreeUpdater.findOrCreateProject$lambda$8((arg_0, arg_1) -> MavenProjectsTreeUpdater.findOrCreateProject$lambda$7(f, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)mavenProject2);
        MavenProject createdMavenProject = mavenProject2;
        return createdMavenProject;
    }

    /*
     * Unable to fully structure code
     */
    private final Object update(VirtualFile var1_1, boolean var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof update.1)) ** GOTO lbl-1000
        var27_4 = $completion;
        if ((var27_4.label & -2147483648) != 0) {
            var27_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                boolean Z$1;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$update(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.startUpdate(mavenProjectFile, forceRead != false)) {
                    return Unit.INSTANCE;
                }
                MavenLog.LOG.trace("Maven tree updater: start update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                mavenProject = this.findOrCreateProject(mavenProjectFile);
                prevModules = this.tree.getModules(mavenProject);
                prevChildren = this.tree.findInheritors(mavenProject);
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProjectFile;
                $continuation.L$2 = mavenProject;
                $continuation.L$3 = prevModules;
                $continuation.L$4 = prevChildren;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.readPomIfNeeded(mavenProject, forceRead != false, (Continuation<? super Boolean>)$continuation);
                if (v0 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                forceRead = $continuation.Z$0;
                prevChildren = (Collection<MavenProject>)$continuation.L$4;
                prevModules = (List<MavenProject>)$continuation.L$3;
                mavenProject = (MavenProject)$continuation.L$2;
                mavenProjectFile = (VirtualFile)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                readPom = (Boolean)v0;
                existingModuleFiles = mavenProject.getExistingModuleFiles();
                this.handleRemovedModules(mavenProject, prevModules, existingModuleFiles);
                modulesFilesToReconnect = this.collectModuleFilesToReconnect(mavenProject, existingModuleFiles);
                updateExistingModules = readPom != false || this.updateModules != false;
                modulesFilesToUpdate = this.collectModuleFilesToUpdate(modulesFilesToReconnect, updateExistingModules != false);
                forceReadModules = this.updateModules != false && forceRead != false;
                $this$map$iv = modulesFilesToUpdate;
                $i$f$map = false;
                var16_19 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_27 = (VirtualFile)item$iv$iv;
                    var25_30 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$moduleUpdates$1 = false;
                    var25_30.add(new UpdateSpec((VirtualFile)it, forceReadModules != false));
                }
                moduleUpdates = (List)destination$iv$iv;
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProjectFile;
                $continuation.L$2 = mavenProject;
                $continuation.L$3 = prevChildren;
                $continuation.L$4 = modulesFilesToReconnect;
                $continuation.Z$0 = forceRead;
                $continuation.Z$1 = readPom;
                $continuation.label = 2;
                v1 = this.updateProjects(moduleUpdates, (Continuation<? super Unit>)$continuation);
                if (v1 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl81
            }
            case 2: {
                readPom = $continuation.Z$1;
                forceRead = $continuation.Z$0;
                modulesFilesToReconnect = (List<VirtualFile>)$continuation.L$4;
                prevChildren = (Collection)$continuation.L$3;
                mavenProject = (MavenProject)$continuation.L$2;
                mavenProjectFile = (VirtualFile)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl81:
                // 2 sources

                this.reconnectModuleFiles(mavenProject, (List<? extends VirtualFile>)modulesFilesToReconnect);
                childFilesToUpdate = this.collectChildFilesToUpdate(mavenProject, prevChildren);
                $this$map$iv = childFilesToUpdate;
                $i$f$map = false;
                $i$f$mapTo = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var23_32 = (VirtualFile)item$iv$iv;
                    var25_30 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$childUpdates$1 = false;
                    var25_30.add(new UpdateSpec((VirtualFile)it, readPom != false));
                }
                childUpdates = (List)destination$iv$iv;
                $continuation.L$0 = mavenProjectFile;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.Z$0 = forceRead;
                $continuation.label = 3;
                v2 = this.updateProjects(childUpdates, (Continuation<? super Unit>)$continuation);
                if (v2 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl113
            }
            case 3: {
                forceRead = $continuation.Z$0;
                mavenProjectFile = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl113:
                // 2 sources

                MavenLog.LOG.trace("Maven tree updater: finish update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object updateProjects(@NotNull List<UpdateSpec> specs, @NotNull Continuation<? super Unit> $completion) {
        if (specs.isEmpty()) {
            return Unit.INSTANCE;
        }
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(specs, this, null){
            int label;
            final /* synthetic */ List<UpdateSpec> $specs;
            final /* synthetic */ MavenProjectsTreeUpdater this$0;
            {
                this.$specs = $specs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$specs, this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ List<UpdateSpec> $specs;
                            final /* synthetic */ MavenProjectsTreeUpdater this$0;
                            {
                                this.$specs = $specs;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                        Iterable iterable = this.$specs;
                                        MavenProjectsTreeUpdater mavenProjectsTreeUpdater = this.this$0;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            UpdateSpec spec = (UpdateSpec)element$iv;
                                            boolean bl = false;
                                            BuildersKt.launch$default((CoroutineScope)$this$withContext, (CoroutineContext)((CoroutineContext)new CoroutineName("reading " + spec.mavenProjectFile())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mavenProjectsTreeUpdater, spec, null){
                                                Object L$0;
                                                int label;
                                                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                                                final /* synthetic */ UpdateSpec $spec;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$spec = $spec;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * Unable to fully structure code
                                                 */
                                                public final Object invokeSuspend(Object var1_1) {
                                                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            v0 = TelemetryKt.getTracer().spanBuilder("updateProjectSpec");
                                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"spanBuilder(...)");
                                                            var2_3 = v0;
                                                            var4_4 = this.this$0;
                                                            var5_5 = this.$spec;
                                                            context$iv = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
                                                            $i$f$useWithScope = false;
                                                            v1 = $this$useWithScope_u24default$iv.startSpan();
                                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"startSpan(...)");
                                                            $this$useWithoutActiveScope$iv$iv = v1;
                                                            $i$f$useWithoutActiveScope = false;
                                                            span$iv = $this$useWithoutActiveScope$iv$iv;
                                                            $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                                                            v2 = Context.current().with((ImplicitContextKeyed)span$iv);
                                                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"with(...)");
                                                            this.L$0 = $this$useWithoutActiveScope$iv$iv;
                                                            this.label = 1;
                                                            v3 = BuildersKt.withContext((CoroutineContext)context$iv.plus(ContextExtensionsKt.asContextElement((Context)v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(span$iv, null, var4_4, var5_5){
                                                                int label;
                                                                private /* synthetic */ Object L$0;
                                                                final /* synthetic */ Span $span;
                                                                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                                                                final /* synthetic */ UpdateSpec $spec$inlined;
                                                                {
                                                                    this.$span = $span;
                                                                    this.this$0 = mavenProjectsTreeUpdater;
                                                                    this.$spec$inlined = updateSpec;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * WARNING - void declaration
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                public final Object invokeSuspend(Object $completion) {
                                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$completion);
                                                                            CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                                                            Continuation cfr_ignored_0 = (Continuation)this;
                                                                            boolean bl = false;
                                                                            this.label = 1;
                                                                            Object object2 = MavenProjectsTreeUpdater.access$update(this.this$0, this.$spec$inlined.mavenProjectFile(), this.$spec$inlined.forceRead(), (Continuation)this);
                                                                            if (object2 != object) return Unit.INSTANCE;
                                                                            return object;
                                                                        }
                                                                        case 1: {
                                                                            void $result;
                                                                            boolean bl = false;
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            Object object2 = $result;
                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                                    var3_3.L$0 = value;
                                                                    return (Continuation)var3_3;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)this);
                                                            ** if (v3 != var13_2) goto lbl27
lbl26:
                                                            // 1 sources

                                                            return var13_2;
lbl27:
                                                            // 1 sources

                                                            ** GOTO lbl38
                                                        }
                                                        case 1: {
                                                            $i$f$useWithScope = false;
                                                            $i$f$useWithoutActiveScope = false;
                                                            $i$a$-useWithoutActiveScope-TraceKt$useWithScope$2$iv = false;
                                                            $this$useWithoutActiveScope$iv$iv = (Span)this.L$0;
                                                            try {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v3 = $result;
lbl38:
                                                                // 2 sources

                                                                var11_15 = v3;
                                                                ** GOTO lbl51
                                                            }
                                                            catch (CancellationException e$iv$iv) {
                                                                throw e$iv$iv;
                                                            }
                                                            catch (Throwable e$iv$iv) {
                                                                $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
                                                                throw e$iv$iv;
                                                            }
                                                        }
                                                        catch (Throwable var12_18) {
                                                            throw var12_18;
                                                        }
                                                        {
                                                            finally {
                                                                $this$useWithoutActiveScope$iv$iv.end();
                                                            }
lbl51:
                                                            // 1 sources

                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final long getFileTimestamp(VirtualFile file2) {
        if (file2 == null || !file2.isValid()) {
            return -1L;
        }
        return file2.getTimeStamp();
    }

    private final long getFileTimestamp(Path file2) {
        return this.getFileTimestamp(file2 == null ? null : LocalFileSystem.getInstance().findFileByNioFile(file2));
    }

    private static final Boolean startUpdate$lambda$0(Ref $previousUpdateRef, boolean $forceRead, VirtualFile virtualFile, Boolean value) {
        $previousUpdateRef.set((Object)value);
        return Intrinsics.areEqual((Object)true, (Object)value) || $forceRead;
    }

    private static final Boolean startUpdate$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final MavenProjectTimestamp calculateTimestamp$lambda$3(MavenProjectsTreeUpdater this$0, MavenProject $mavenProject) {
        MavenProject parent;
        long pomTimestamp = this$0.getFileTimestamp($mavenProject.getFile());
        MavenProject mavenProject = parent = this$0.tree.findParent($mavenProject);
        long parentTimestamp = this$0.getFileTimestamp((VirtualFile)(mavenProject != null ? mavenProject.getFile() : null));
        VirtualFile profilesXmlFile = $mavenProject.getProfilesXmlFile();
        long profilesTimestamp = this$0.getFileTimestamp(profilesXmlFile);
        VirtualFile jvmConfigFile = MavenUtil.INSTANCE.getConfigFile($mavenProject, ".mvn/jvm.config");
        long jvmConfigTimestamp = this$0.getFileTimestamp(jvmConfigFile);
        VirtualFile mavenConfigFile = MavenUtil.INSTANCE.getConfigFile($mavenProject, ".mvn/maven.config");
        long mavenConfigTimestamp = this$0.getFileTimestamp(mavenConfigFile);
        long userSettingsTimestamp = this$0.getFileTimestamp(this$0.userSettingsFile);
        long globalSettingsTimestamp = this$0.getFileTimestamp(this$0.globalSettingsFile);
        int profilesHashCode = this$0.reader.getExplicitProfiles().hashCode();
        return new MavenProjectTimestamp(pomTimestamp, parentTimestamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
    }

    private static final MavenProject findOrCreateProject$lambda$7(VirtualFile $f, VirtualFile file2, MavenProject value) {
        if (value != null) {
            return value;
        }
        MavenLog.LOG.debug("Maven tree updater: created new maven project " + file2);
        return new MavenProject($f);
    }

    private static final MavenProject findOrCreateProject$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        return (MavenProject)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Object access$readPomIfNeeded(MavenProjectsTreeUpdater $this, MavenProject mavenProject, boolean forceRead, Continuation $completion) {
        return $this.readPomIfNeeded(mavenProject, forceRead, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$calculateTimestamp(MavenProjectsTreeUpdater $this, MavenProject mavenProject, Continuation $completion) {
        return $this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$completion);
    }

    public static final /* synthetic */ Object access$update(MavenProjectsTreeUpdater $this, VirtualFile mavenProjectFile, boolean forceRead, Continuation $completion) {
        return $this.update(mavenProjectFile, forceRead, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MavenProjectReader access$getReader$p(MavenProjectsTreeUpdater $this) {
        return $this.reader;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "Ljava/lang/Record;", "mavenProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceRead", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.maven"})
    @ApiStatus.Internal
    public static final class UpdateSpec
    extends Record {
        @NotNull
        private final VirtualFile mavenProjectFile;
        private final boolean forceRead;

        public UpdateSpec(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            this.mavenProjectFile = mavenProjectFile;
            this.forceRead = forceRead;
        }

        @NotNull
        public final VirtualFile mavenProjectFile() {
            return this.mavenProjectFile;
        }

        public final boolean forceRead() {
            return this.forceRead;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.mavenProjectFile;
        }

        public final boolean component2() {
            return this.forceRead;
        }

        @NotNull
        public final UpdateSpec copy(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            return new UpdateSpec(mavenProjectFile, forceRead);
        }

        public static /* synthetic */ UpdateSpec copy$default(UpdateSpec updateSpec, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = updateSpec.mavenProjectFile;
            }
            if ((n & 2) != 0) {
                bl = updateSpec.forceRead;
            }
            return updateSpec.copy(virtualFile, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "UpdateSpec(mavenProjectFile=" + this.mavenProjectFile + ", forceRead=" + this.forceRead + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.mavenProjectFile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.forceRead);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateSpec)) {
                return false;
            }
            UpdateSpec updateSpec = (UpdateSpec)other;
            if (!Intrinsics.areEqual((Object)this.mavenProjectFile, (Object)updateSpec.mavenProjectFile)) {
                return false;
            }
            return this.forceRead == updateSpec.forceRead;
        }
    }
}

