/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.AttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;

public class PlexusIoVirtualFileResource
extends AbstractPlexusIoResource
implements ResourceAttributeSupplier {
    private final File file;

    protected PlexusIoVirtualFileResource(File file2, String name) {
        super(name, file2.lastModified(), file2.length(), file2.isFile(), file2.isDirectory(), file2.exists());
        this.file = file2;
    }

    protected static String getName(File file2) {
        return file2.getPath().replace('\\', '/');
    }

    public File getFile() {
        return this.file;
    }

    @Nonnull
    public InputStream getContents() throws IOException {
        throw new UnsupportedOperationException("We're not really sure we can do this");
    }

    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    public long getSize() {
        return this.getFile().length();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isExisting() {
        return this.getFile().exists();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public PlexusIoResourceAttributes getAttributes() {
        return null;
    }

    public long getLastModified() {
        if (this.file.exists()) {
            return AttributeUtils.getLastModified((File)this.getFile());
        }
        return System.currentTimeMillis();
    }

    public boolean isSymbolicLink() {
        return this.getAttributes().isSymbolicLink();
    }
}

