/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.backwardRefs.JavaBackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.impl.TargetOutputIndexImpl;
import org.jetbrains.jps.builders.java.JavaBuilderExtension;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompilerEncodingConfiguration;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.CustomOutputDataListener;
import org.jetbrains.jps.incremental.java.ExternalJavacOptionsProvider;
import org.jetbrains.jps.incremental.java.ModulePathSplitter;
import org.jetbrains.jps.incremental.java.OutputFilesSink;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.javac.CompilationPaths;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.ExternalJavacManagerKey;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.jps.javac.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.JavacMain;
import org.jetbrains.jps.javac.JpsInfoDiagnostic;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;

@ApiStatus.Internal
public final class JavaBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance(JavaBuilder.class);
    private static final String JAVA_EXTENSION = "java";
    private static final String USE_MODULE_PATH_ONLY_OPTION = "compiler.force.module.path";
    private static final String PROC_FULL_REQUIRED_OPTION = "compiler.proc.full.required";
    public static final String BUILDER_ID = "java";
    public static final Key<Boolean> IS_ENABLED = Key.create((String)"_java_compiler_enabled_");
    public static final FileFilter JAVA_SOURCES_FILTER = FileFilters.withExtension((String)"java");
    private static final Key<Boolean> PREFER_TARGET_JDK_COMPILER = GlobalContextKey.create("_prefer_target_jdk_javac_");
    private static final Key<Set<String>> SHOWN_NOTIFICATIONS = GlobalContextKey.create("_shown_notifications_");
    private static final Key<JavaCompilingTool> COMPILING_TOOL = Key.create((String)"_java_compiling_tool_");
    private static final Key<ConcurrentMap<String, Collection<String>>> COMPILER_USAGE_STATISTICS = Key.create((String)"_java_compiler_usage_stats_");
    private static final Key<ModulePathSplitter> MODULE_PATH_SPLITTER = GlobalContextKey.create("_module_path_splitter_");
    private static final List<String> COMPILABLE_EXTENSIONS = Collections.singletonList("java");
    private static final String PROC_ONLY_OPTION = "-proc:only";
    private static final String PROC_FULL_OPTION = "-proc:full";
    private static final String PROC_NONE_OPTION = "-proc:none";
    private static final String RELEASE_OPTION = "--release";
    private static final String TARGET_OPTION = "-target";
    private static final String PROCESSORPATH_OPTION = "-processorpath";
    private static final String ENCODING_OPTION = "-encoding";
    private static final String ENABLE_PREVIEW_OPTION = "--enable-preview";
    private static final String PROCESSOR_MODULE_PATH_OPTION = "--processor-module-path";
    private static final String SOURCE_OPTION = "-source";
    private static final String SYSTEM_OPTION = "--system";
    private static final String PATCH_MODULE_OPTION = "--patch-module";
    private static final Set<String> FILTERED_OPTIONS = Set.of("-target", "--release", "-d");
    private static final Set<String> FILTERED_SINGLE_OPTIONS = Set.of("-g", "-deprecation", "-nowarn", "-verbose", "-proc:none", "-proc:only", "-proc:full", "-proceedOnError");
    private static final Set<String> POSSIBLY_CONFLICTING_OPTIONS = Set.of("-source", "--system", "--boot-class-path", "-bootclasspath", "--class-path", "-classpath", "-cp", "-processorpath", "-sourcepath", "--module-path", "-p", "--module-source-path");
    private static final List<ClassPostProcessor> ourClassProcessors = new ArrayList<ClassPostProcessor>();
    @Nullable
    private static final File ourDefaultRtJar;
    private static final int ourProcFullRequiredFrom;
    private final Executor myTaskRunner;
    private final Collection<JavacFileReferencesRegistrar> myRefRegistrars = new ArrayList<JavacFileReferencesRegistrar>();
    private static final Key<String> USER_DEFINED_BYTECODE_TARGET;
    private static final Key<Semaphore> COUNTER_KEY;

    public static void registerClassPostProcessor(ClassPostProcessor processor) {
        ourClassProcessors.add(processor);
    }

    public JavaBuilder() {
        super(BuilderCategory.TRANSLATOR);
        this.myTaskRunner = SharedThreadPool.getInstance().createBoundedExecutor("JavaBuilder Pool", 1);
    }

    @NotNull
    @NlsSafe
    public static String getBuilderName() {
        return "java";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = Strings.capitalize((String)JavaBuilder.getBuilderName());
        if (string == null) {
            JavaBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void buildStarted(CompileContext context) {
        String compilerId = JavaBuilder.getUsedCompilerId(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Java compiler ID: " + compilerId);
        }
        MODULE_PATH_SPLITTER.set((UserDataHolder)context, (Object)new ModulePathSplitter(new ExplodedModuleNameFinder(context)));
        JavaCompilingTool compilingTool = JavaBuilderUtil.findCompilingTool(compilerId);
        COMPILING_TOOL.set((UserDataHolder)context, (Object)compilingTool);
        SHOWN_NOTIFICATIONS.set((UserDataHolder)context, Collections.synchronizedSet(new HashSet()));
        COMPILER_USAGE_STATISTICS.set((UserDataHolder)context, new ConcurrentHashMap());
        BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        if (!JavaBuilder.isJavac(compilingTool)) {
            dataManager.setProcessConstantsIncrementally(false);
        }
        JavaBackwardReferenceIndexWriter.initialize(context);
        for (JavacFileReferencesRegistrar registrar : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
            if (!registrar.isEnabled()) continue;
            registrar.initialize();
            this.myRefRegistrars.add(registrar);
        }
    }

    @Override
    public void chunkBuildStarted(final CompileContext context, final ModuleChunk chunk) {
        try {
            JavaBuilderUtil.markDirtyDependenciesForInitialRound(context, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                    if (processor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FSOperations.processFilesToRecompile(context, chunk, processor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/jps/incremental/java/JavaBuilder$1", "processDirtyFiles"));
                }
            }, chunk);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildFinished(CompileContext context) {
        this.myRefRegistrars.clear();
        ConcurrentMap stats = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        if (stats.size() == 1) {
            Map.Entry entry = stats.entrySet().iterator().next();
            String compilerName = (String)entry.getKey();
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, JpsBuildBundle.message("build.message.0.was.used.to.compile.java.sources", compilerName)));
            LOG.info(compilerName + " was used to compile " + String.valueOf(entry.getValue()));
        } else {
            for (Map.Entry entry : stats.entrySet()) {
                String compilerName = (String)entry.getKey();
                Collection moduleNames = (Collection)entry.getValue();
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.JPS_INFO, moduleNames.size() == 1 ? JpsBuildBundle.message("build.message.0.was.used.to.compile.1", compilerName, moduleNames.iterator().next()) : JpsBuildBundle.message("build.message.0.was.used.to.compile.1.modules", compilerName, moduleNames.size())));
                LOG.info(compilerName + " was used to compile " + String.valueOf(moduleNames));
            }
        }
    }

    @Override
    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = COMPILABLE_EXTENSIONS;
        if (list == null) {
            JavaBuilder.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(2);
        }
        if (chunk == null) {
            JavaBuilder.$$$reportNull$$$0(3);
        }
        if (dirtyFilesHolder == null) {
            JavaBuilder.$$$reportNull$$$0(4);
        }
        if (outputConsumer == null) {
            JavaBuilder.$$$reportNull$$$0(5);
        }
        JavaCompilingTool compilingTool = (JavaCompilingTool)COMPILING_TOOL.get((UserDataHolder)context);
        if (!((Boolean)IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue() || compilingTool == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        return this.doBuild(context, chunk, dirtyFilesHolder, outputConsumer, compilingTool);
    }

    public ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull JavaCompilingTool compilingTool) throws ProjectBuildException, IOException {
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(6);
        }
        if (chunk == null) {
            JavaBuilder.$$$reportNull$$$0(7);
        }
        if (dirtyFilesHolder == null) {
            JavaBuilder.$$$reportNull$$$0(8);
        }
        if (outputConsumer == null) {
            JavaBuilder.$$$reportNull$$$0(9);
        }
        if (compilingTool == null) {
            JavaBuilder.$$$reportNull$$$0(10);
        }
        try {
            ProjectBuilderLogger logger;
            Set filesToCompile = FileCollectionFactory.createCanonicalFileLinkedSet();
            dirtyFilesHolder.processDirtyFiles((target, file, descriptor) -> {
                if (JAVA_SOURCES_FILTER.accept(file) && CompilableModuleTypesHolder.ourCompilableModuleTypes.contains(target.getModule().getModuleType())) {
                    filesToCompile.add(file);
                }
                return true;
            });
            File moduleInfoFile = null;
            int javaModulesCount = 0;
            if ((!filesToCompile.isEmpty() || dirtyFilesHolder.hasRemovedFiles()) && JavaBuilder.getTargetPlatformLanguageVersion(chunk.representativeTarget().getModule()) >= 9) {
                for (ModuleBuildTarget target2 : chunk.getTargets()) {
                    File moduleInfo = JavaBuilderUtil.findModuleInfoFile(context, target2);
                    if (moduleInfo == null) continue;
                    ++javaModulesCount;
                    if (moduleInfoFile != null) continue;
                    moduleInfoFile = moduleInfo;
                }
            }
            if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled() && !filesToCompile.isEmpty()) {
                logger.logCompiledFiles(filesToCompile, "java", "Compiling files:");
            }
            if (javaModulesCount > 1) {
                @NlsSafe String modules = chunk.getModules().stream().map(JpsNamedElement::getName).collect(Collectors.joining(", "));
                context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.compile.a.module.cycle.with.multiple.module.info.files", modules)));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            return this.compile(context, chunk, dirtyFilesHolder, filesToCompile, outputConsumer, compilingTool, moduleInfoFile);
        }
        catch (CorruptedException | BuildDataCorruptedException | ProjectBuildException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            if (message == null || message.trim().isEmpty()) {
                message = JpsBuildBundle.message("build.message.internal.error.0", ExceptionUtil.getThrowableText((Throwable)e));
            }
            context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.ERROR, message));
            throw new StopBuildException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleLevelBuilder.ExitCode compile(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, Collection<? extends File> files, ModuleLevelBuilder.OutputConsumer outputConsumer, JavaCompilingTool compilingTool, File moduleInfoFile) throws Exception {
        ModuleLevelBuilder.ExitCode exitCode;
        block17: {
            boolean hasSourcesToCompile;
            exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            boolean bl = hasSourcesToCompile = !files.isEmpty();
            if (!hasSourcesToCompile && !dirtyFilesHolder.hasRemovedFiles()) {
                return exitCode;
            }
            ProjectDescriptor pd = context.getProjectDescriptor();
            JavaBuilderUtil.ensureModuleHasJdk(chunk.representativeTarget().getModule(), context, JavaBuilder.getBuilderName());
            Collection<File> classpath = ProjectPaths.getCompilationClasspath(chunk, false);
            Collection<File> platformCp = ProjectPaths.getPlatformCompilationClasspath(chunk, false);
            OutputFilesSink outputSink = new OutputFilesSink(context, outputConsumer, JavaBuilderUtil.getDependenciesRegistrar(context), chunk.getPresentableShortName());
            Collection<File> filesWithErrors = null;
            try {
                if (!hasSourcesToCompile) break block17;
                exitCode = ModuleLevelBuilder.ExitCode.OK;
                HashSet<File> srcPath = new HashSet<File>();
                BuildRootIndex index = pd.getBuildRootIndex();
                for (ModuleBuildTarget target : chunk.getTargets()) {
                    for (JavaSourceRootDescriptor rd : index.getTempTargetRoots(target, context)) {
                        srcPath.add(rd.root);
                    }
                }
                DiagnosticSink diagnosticSink = new DiagnosticSink(context, Collections.unmodifiableCollection(this.myRefRegistrars));
                String chunkName = chunk.getName();
                context.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.parsing.java.0", chunk.getPresentableShortName())));
                int filesCount = files.size();
                boolean compiledOk = true;
                if (filesCount > 0) {
                    LOG.info("Compiling " + filesCount + " java files; module: " + chunkName + (chunk.containsTests() ? " (tests)" : ""));
                    if (LOG.isDebugEnabled()) {
                        for (File file : files) {
                            LOG.debug("Compiling " + file.getPath());
                        }
                        LOG.debug(" classpath for " + chunkName + ":");
                        for (File file : classpath) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                        LOG.debug(" platform classpath for " + chunkName + ":");
                        for (File file : platformCp) {
                            LOG.debug("  " + file.getAbsolutePath());
                        }
                    }
                    try {
                        compiledOk = this.compileJava(context, chunk, files, classpath, platformCp, srcPath, diagnosticSink, outputSink, compilingTool, moduleInfoFile);
                    }
                    finally {
                        filesWithErrors = diagnosticSink.getFilesWithErrors();
                    }
                }
                context.checkCanceled();
                if (!compiledOk && diagnosticSink.getErrorCount() == 0) {
                    diagnosticSink.report((Diagnostic<? extends JavaFileObject>)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, JpsBuildBundle.message("build.message.compilation.failed.internal.java.compiler.error", new Object[0])));
                }
                if (!((Boolean)Utils.PROCEED_ON_ERROR_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE)).booleanValue() && diagnosticSink.getErrorCount() > 0) {
                    throw new StopBuildException(JpsBuildBundle.message("build.message.compilation.failed.errors.0.warnings.1", diagnosticSink.getErrorCount(), diagnosticSink.getWarningCount()));
                }
            }
            finally {
                JavaBuilderUtil.registerFilesToCompile(context, files);
                if (filesWithErrors != null) {
                    JavaBuilderUtil.registerFilesWithErrors(context, filesWithErrors);
                }
                JavaBuilderUtil.registerSuccessfullyCompiled(context, outputSink.getSuccessfullyCompiled());
            }
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileJava(CompileContext context, ModuleChunk chunk, Collection<? extends File> files, Collection<? extends File> originalClassPath, Collection<? extends File> originalPlatformCp, Collection<? extends File> sourcePath, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, File moduleInfoFile) throws IOException {
        Semaphore counter = new Semaphore();
        COUNTER_KEY.set((UserDataHolder)context, (Object)counter);
        Set<JpsModule> modules = chunk.getModules();
        ProcessorConfigProfile profile = null;
        JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
        if (modules.size() == 1) {
            profile = compilerConfig.getAnnotationProcessingProfile(modules.iterator().next());
        } else {
            String message = JavaBuilder.validateCycle(context, chunk);
            if (message != null) {
                diagnosticSink.report((Diagnostic)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, message));
                return false;
            }
        }
        Map<File, Set<File>> outs = JavaBuilder.buildOutputDirectoriesMap(context, chunk);
        try {
            Iterable<? extends File> platformCp;
            Iterable<Object> upgradeModulePath;
            Iterable<File> classPath;
            ModulePath modulePath;
            Pair<String, Integer> forkSdk;
            int targetLanguageLevel = JavaBuilder.getTargetPlatformLanguageVersion(chunk.representativeTarget().getModule());
            if (JavaBuilder.shouldForkCompilerProcess(context, chunk, targetLanguageLevel, compilingTool)) {
                forkSdk = JavaBuilder.getForkedJavacSdk((DiagnosticListener<? super JavaFileObject>)diagnosticSink, chunk, targetLanguageLevel);
                if (forkSdk == null) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                forkSdk = null;
            }
            int compilerSdkVersion = forkSdk == null ? JavaVersion.current().feature : (Integer)forkSdk.getSecond();
            Pair<Iterable<String>, Iterable<String>> vm_compilerOptions = JavaBuilder.getCompilationOptions(compilerSdkVersion, context, chunk, profile, compilingTool);
            Iterable vmOptions = (Iterable)vm_compilerOptions.first;
            Iterable options = (Iterable)vm_compilerOptions.second;
            Iterable<? extends File> effectivePlatformCp = JavaBuilder.calcEffectivePlatformCp(originalPlatformCp, options, compilingTool);
            if (effectivePlatformCp == null) {
                String text = JpsBuildBundle.message("build.message.unsupported.compact.compilation.profile.was.requested", chunk.getName(), System.getProperty("java.version"));
                context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.ERROR, text));
                boolean bl = false;
                return bl;
            }
            if (moduleInfoFile != null || Iterators.contains((Iterable)options, (Object)PATCH_MODULE_OPTION)) {
                boolean useModulePathOnly;
                ModulePathSplitter splitter = (ModulePathSplitter)MODULE_PATH_SPLITTER.get((UserDataHolder)context);
                Pair<ModulePath, Collection<File>> pair = splitter.splitPath(moduleInfoFile, outs.keySet(), ProjectPaths.getCompilationModulePath(chunk, false), JavaBuilder.collectAdditionalRequires(options));
                boolean bl = useModulePathOnly = moduleInfoFile == null || Boolean.parseBoolean(System.getProperty(USE_MODULE_PATH_ONLY_OPTION));
                if (useModulePathOnly) {
                    ModulePath.Builder mpBuilder = ModulePath.newBuilder();
                    for (File file : ProjectPaths.getCompilationModulePath(chunk, false)) {
                        mpBuilder.add(((ModulePath)pair.first).getModuleName(file), file);
                    }
                    modulePath = mpBuilder.create();
                    classPath = Collections.emptyList();
                } else {
                    modulePath = (ModulePath)pair.first;
                    classPath = (Iterable)pair.second;
                }
                upgradeModulePath = effectivePlatformCp;
                platformCp = Collections.emptyList();
            } else {
                modulePath = ModulePath.EMPTY;
                upgradeModulePath = Collections.emptyList();
                if (!Iterators.isEmpty(effectivePlatformCp) && JavaBuilder.getChunkSdkVersion(chunk) >= 9) {
                    platformCp = Collections.emptyList();
                    classPath = Iterators.flat(effectivePlatformCp, originalClassPath);
                } else {
                    platformCp = effectivePlatformCp;
                    classPath = originalClassPath;
                }
            }
            ClassProcessingConsumer classesConsumer = new ClassProcessingConsumer(context, outputSink);
            if (forkSdk != null) {
                JavaBuilder.updateCompilerUsageStatistics(context, "javac " + String.valueOf(forkSdk.getSecond()), chunk);
                ExternalJavacManager server = JavaBuilder.ensureJavacServerStarted(context);
                CompilationPaths paths = CompilationPaths.create(platformCp, classPath, upgradeModulePath, modulePath, sourcePath);
                int heapSize = Utils.suggestForkedCompilerHeapSize();
                boolean bl = JavaBuilder.invokeJavac(compilerSdkVersion, context, chunk, compilingTool, options, files, classesConsumer, (_options, _files, _outSink) -> {
                    JavaBuilder.logJavacCall(chunk, _options, "fork");
                    return server.forkJavac((String)forkSdk.getFirst(), heapSize, vmOptions, _options, paths, _files, outs, diagnosticSink, _outSink, compilingTool, context.getCancelStatus(), true).get();
                });
                return bl;
            }
            JavaBuilder.updateCompilerUsageStatistics(context, compilingTool.getDescription(), chunk);
            boolean bl = JavaBuilder.invokeJavac(compilerSdkVersion, context, chunk, compilingTool, options, files, classesConsumer, (_options, _files, _outSink) -> {
                JavaBuilder.logJavacCall(chunk, _options, "in-process");
                return JavacMain.compile((Iterable)_options, (Iterable)_files, (Iterable)classPath, (Iterable)platformCp, (ModulePath)modulePath, (Iterable)upgradeModulePath, (Iterable)sourcePath, (Map)outs, (DiagnosticOutputConsumer)diagnosticSink, (OutputFileConsumer)_outSink, (CanceledStatus)context.getCancelStatus(), (JavaCompilingTool)compilingTool, null);
            });
            return bl;
        }
        finally {
            counter.waitFor();
        }
    }

    @NotNull
    private static Collection<String> collectAdditionalRequires(Iterable<String> options) {
        SmartHashSet result = new SmartHashSet();
        Iterator<String> it = options.iterator();
        while (it.hasNext()) {
            String moduleNames;
            String option = it.next();
            if (!"--add-reads".equalsIgnoreCase(option) || !it.hasNext() || (moduleNames = StringUtil.substringAfter((String)it.next(), (String)"=")) == null) continue;
            result.addAll(StringUtil.split((String)moduleNames, (String)","));
        }
        SmartHashSet smartHashSet = result;
        if (smartHashSet == null) {
            JavaBuilder.$$$reportNull$$$0(11);
        }
        return smartHashSet;
    }

    private static void logJavacCall(ModuleChunk chunk, Iterable<String> options, String mode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Iterators.contains(options, (Object)PROC_ONLY_OPTION) ? "Running processors for chunk" : "Compiling chunk") + " [" + chunk.getName() + "] with options: \"" + StringUtil.join(options, (String)" ") + "\", mode=" + mode);
        }
    }

    private static boolean invokeJavac(int compilerSdkVersion, CompileContext context, ModuleChunk chunk, @NotNull JavaCompilingTool compilingTool, Iterable<String> options, Iterable<? extends File> files, OutputFileConsumer outSink, JavacCaller javacCall) {
        if (compilingTool == null) {
            JavaBuilder.$$$reportNull$$$0(12);
        }
        if (Iterators.contains(options, (Object)PROC_ONLY_OPTION)) {
            ArrayList generated = new ArrayList();
            boolean processingSuccess = javacCall.invoke(options, files, fileObject -> {
                if (fileObject.getKind() == JavaFileObject.Kind.SOURCE) {
                    generated.add(fileObject.getFile());
                }
                outSink.save(fileObject);
            });
            if (!processingSuccess) {
                return false;
            }
            Iterable compileOnlyOptions = (Iterable)JavaBuilder.getCompilationOptions((int)compilerSdkVersion, (CompileContext)context, (ModuleChunk)chunk, null, (JavaCompilingTool)compilingTool).second;
            return javacCall.invoke(compileOnlyOptions, Iterators.flat(files, generated), outSink);
        }
        return javacCall.invoke(options, files, outSink);
    }

    private static void updateCompilerUsageStatistics(CompileContext context, String compilerName, ModuleChunk chunk) {
        Collection prev;
        ConcurrentMap map = (ConcurrentMap)COMPILER_USAGE_STATISTICS.get((UserDataHolder)context);
        Collection<String> names = (Set<String>)map.get(compilerName);
        if (names == null && (prev = (Collection)map.putIfAbsent(compilerName, names = Collections.synchronizedSet(new HashSet()))) != null) {
            names = prev;
        }
        for (JpsModule module : chunk.getModules()) {
            names.add(module.getName());
        }
    }

    @Nullable
    @Nls
    public static String validateCycle(CompileContext context, ModuleChunk chunk) {
        JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
        JpsJavaCompilerConfiguration compilerConfig = javaExt.getCompilerConfiguration(context.getProjectDescriptor().getProject());
        Set<JpsModule> modules = chunk.getModules();
        Pair pair = null;
        for (JpsModule module : modules) {
            LanguageLevel moduleLevel = javaExt.getLanguageLevel(module);
            if (pair == null) {
                pair = Pair.create((Object)module.getName(), (Object)moduleLevel);
                continue;
            }
            if (Comparing.equal((Object)((LanguageLevel)pair.getSecond()), (Object)moduleLevel)) continue;
            return JpsBuildBundle.message("build.message.modules.0.and.1.must.have.the.same.language.level", pair.getFirst(), module.getName());
        }
        JpsJavaCompilerOptions compilerOptions = compilerConfig.getCurrentCompilerOptions();
        Map overrideMap = compilerOptions.ADDITIONAL_OPTIONS_OVERRIDE;
        if (!overrideMap.isEmpty()) {
            Pair overridden = null;
            for (JpsModule module : modules) {
                String opts = (String)overrideMap.get(module.getName());
                if (!StringUtil.isEmptyOrSpaces((String)opts)) {
                    Set<String> parsed = JavaBuilder.parseOptions(opts);
                    if (overridden == null) {
                        overridden = Pair.create((Object)module.getName(), parsed);
                        continue;
                    }
                    if (((Set)overridden.second).equals(parsed)) continue;
                    return JpsBuildBundle.message("build.message.modules.0.and.1.must.have.the.same.additional.command.line.parameters", overridden.first, module.getName());
                }
                context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.some.modules.with.cyclic.dependencies.0.have.additional.command.line.parameters", chunk.getName())));
            }
        }
        for (JpsModule module : modules) {
            ProcessorConfigProfile prof = compilerConfig.getAnnotationProcessingProfile(module);
            if (!prof.isEnabled()) continue;
            return JpsBuildBundle.message("build.message.annotation.processing.is.not.supported.for.module.cycles", chunk.getName());
        }
        return null;
    }

    private static Set<String> parseOptions(String str) {
        SmartHashSet result = new SmartHashSet();
        StringTokenizer t = new StringTokenizer(str, " \n\t", false);
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    private static boolean shouldUseReleaseOption(JpsJavaCompilerConfiguration config, int compilerVersion, int chunkSdkVersion, int targetPlatformVersion) {
        if (!config.useReleaseOption()) {
            return false;
        }
        if (compilerVersion >= 9 && chunkSdkVersion > 0 && targetPlatformVersion > 0) {
            if (chunkSdkVersion < 9) {
                return false;
            }
            return compilerVersion != targetPlatformVersion;
        }
        return false;
    }

    private static boolean shouldForkCompilerProcess(CompileContext context, ModuleChunk chunk, int chunkLanguageLevel, JavaCompilingTool compilingTool) {
        Integer chunkSdkVersion;
        Pair<JpsSdk<JpsDummyElement>, Integer> sdkVersionPair;
        if (!JavaBuilder.isJavac(compilingTool)) {
            return false;
        }
        int compilerSdkVersion = JavaVersion.current().feature;
        if (JavaBuilder.preferTargetJdkCompiler(context) && (sdkVersionPair = JavaBuilder.getAssociatedSdk(chunk)) != null && (chunkSdkVersion = (Integer)sdkVersionPair.second) != compilerSdkVersion && chunkSdkVersion >= 7) {
            return true;
        }
        if (chunkLanguageLevel <= 0) {
            return false;
        }
        return !JavaBuilder.isTargetReleaseSupported(compilerSdkVersion, chunkLanguageLevel);
    }

    private static boolean isTargetReleaseSupported(int compilerVersion, int targetPlatformVersion) {
        if (targetPlatformVersion > compilerVersion) {
            return false;
        }
        if (compilerVersion < 9) {
            return true;
        }
        if (compilerVersion <= 11) {
            return targetPlatformVersion >= 6;
        }
        if (compilerVersion <= 19) {
            return targetPlatformVersion >= 7;
        }
        return targetPlatformVersion >= 8;
    }

    private static boolean isJavac(JavaCompilingTool compilingTool) {
        return compilingTool != null && (compilingTool.getId().equals("Javac") || compilingTool.getId().equals("compAPI"));
    }

    private static boolean preferTargetJdkCompiler(CompileContext context) {
        Boolean val = (Boolean)PREFER_TARGET_JDK_COMPILER.get((UserDataHolder)context);
        if (val == null) {
            JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
            val = config.getCompilerOptions((String)"Javac").PREFER_TARGET_JDK_COMPILER;
            PREFER_TARGET_JDK_COMPILER.set((UserDataHolder)context, (Object)val);
        }
        return val;
    }

    @Nullable
    private static Iterable<? extends File> calcEffectivePlatformCp(Collection<? extends File> platformCp, Iterable<String> options, JavaCompilingTool compilingTool) {
        if (ourDefaultRtJar == null || !JavaBuilder.isJavac(compilingTool)) {
            return platformCp;
        }
        boolean profileFeatureRequested = false;
        for (String option : options) {
            if (!"-profile".equalsIgnoreCase(option)) continue;
            profileFeatureRequested = true;
            break;
        }
        if (!profileFeatureRequested) {
            return platformCp;
        }
        boolean isTargetPlatformSameAsBuildRuntime = false;
        for (File file : platformCp) {
            if (!FileUtil.filesEqual((File)file, (File)ourDefaultRtJar)) continue;
            isTargetPlatformSameAsBuildRuntime = true;
            break;
        }
        if (!isTargetPlatformSameAsBuildRuntime) {
            return null;
        }
        return Collections.emptyList();
    }

    private void submitAsyncTask(CompileContext context, Runnable taskRunnable) {
        Semaphore counter = (Semaphore)COUNTER_KEY.get((UserDataHolder)context);
        assert (counter != null);
        counter.down();
        this.myTaskRunner.execute(() -> {
            try {
                taskRunnable.run();
            }
            catch (Throwable e) {
                context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), e));
            }
            finally {
                counter.up();
            }
        });
    }

    @NotNull
    private static synchronized ExternalJavacManager ensureJavacServerStarted(@NotNull CompileContext context) throws IOException {
        ExternalJavacManager server;
        if (context == null) {
            JavaBuilder.$$$reportNull$$$0(13);
        }
        if ((server = (ExternalJavacManager)((Object)ExternalJavacManagerKey.KEY.get(context))) != null) {
            ExternalJavacManager externalJavacManager = server;
            if (externalJavacManager == null) {
                JavaBuilder.$$$reportNull$$$0(14);
            }
            return externalJavacManager;
        }
        int listenPort = JavaBuilder.findFreePort();
        server = new ExternalJavacManager(Utils.getSystemRoot(), (Executor)SharedThreadPool.getInstance(), 120000L){

            @Override
            protected ExternalJavacManager.ExternalJavacProcessHandler createProcessHandler(UUID processId, @NotNull Process process, @NotNull String commandLine, boolean keepProcessAlive) {
                if (process == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (commandLine == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new ExternalJavacManager.ExternalJavacProcessHandler(processId, process, commandLine, keepProcessAlive){

                    @NotNull
                    public Future<?> executeTask(@NotNull Runnable task) {
                        if (task == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Future future = SharedThreadPool.getInstance().submit(task);
                        if (future == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return future;
                    }

                    @Override
                    @NotNull
                    protected BaseOutputReader.Options readerOptions() {
                        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
                        if (options == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return options;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "task";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder$2$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$2$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "executeTask";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "readerOptions";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "executeTask";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "process";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commandLine";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$2";
                objectArray[2] = "createProcessHandler";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        server.start(listenPort);
        ExternalJavacManagerKey.KEY.set(context, (Object)server);
        ExternalJavacManager externalJavacManager = server;
        if (externalJavacManager == null) {
            JavaBuilder.$$$reportNull$$$0(15);
        }
        return externalJavacManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket serverSocket;
        int n;
        ServerSocket serverSocket2 = new ServerSocket(0);
        try {
            n = serverSocket2.getLocalPort();
            serverSocket = serverSocket2;
        }
        catch (Throwable throwable) {
            try {
                ServerSocket serverSocket3 = serverSocket2;
                synchronized (serverSocket3) {
                    try {
                        serverSocket2.wait(1L);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                serverSocket2.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return 7878;
            }
        }
        synchronized (serverSocket) {
            try {
                serverSocket2.wait(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        serverSocket2.close();
        return n;
    }

    private static Pair<Iterable<String>, Iterable<String>> getCompilationOptions(int compilerSdkVersion, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile, @NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            JavaBuilder.$$$reportNull$$$0(16);
        }
        ArrayList<String> compilationOptions = new ArrayList<String>();
        ArrayList<Object> vmOptions = new ArrayList<Object>();
        if (!JavacMain.TRACK_AP_GENERATED_DEPENDENCIES) {
            vmOptions.add("-Djps.track.ap.dependencies=" + JavacMain.TRACK_AP_GENERATED_DEPENDENCIES);
            JavaBuilder.notifyMessage(context, BuildMessage.Kind.WARNING, "build.message.incremental.annotation.processing.disabled.0", true, "jps.track.ap.dependencies");
        }
        if (compilerSdkVersion > 15) {
            ClasspathBootstrap.configureReflectionOpenPackages(p -> vmOptions.add(p));
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerOptions compilerOptions = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getCurrentCompilerOptions();
        if (compilerOptions.DEBUGGING_INFO) {
            compilationOptions.add("-g");
        }
        if (compilerOptions.DEPRECATION) {
            compilationOptions.add("-deprecation");
        }
        if (compilerOptions.GENERATE_NO_WARNINGS) {
            compilationOptions.add("-nowarn");
        }
        if (compilerOptions instanceof EclipseCompilerOptions) {
            EclipseCompilerOptions eclipseOptions = (EclipseCompilerOptions)compilerOptions;
            if (eclipseOptions.PROCEED_ON_ERROR) {
                Utils.PROCEED_ON_ERROR_KEY.set((UserDataHolder)context, (Object)Boolean.TRUE);
                compilationOptions.add("-proceedOnError");
            }
        }
        String customArgs = compilerOptions.ADDITIONAL_OPTIONS_STRING;
        Map overrideMap = compilerOptions.ADDITIONAL_OPTIONS_OVERRIDE;
        if (!overrideMap.isEmpty()) {
            for (JpsModule m : chunk.getModules()) {
                String overridden = (String)overrideMap.get(m.getName());
                if (overridden == null) continue;
                customArgs = overridden;
                break;
            }
        }
        if (customArgs != null && !customArgs.isEmpty()) {
            BiConsumer<List, String> appender = List::add;
            JpsModule module = chunk.representativeTarget().getModule();
            File baseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
            if (baseDirectory != null) {
                String moduleDirPath = FileUtil.toCanonicalPath((String)baseDirectory.getAbsolutePath());
                appender = (strings, option) -> strings.add(StringUtil.replace((String)option, (String)"$MODULE_DIR$", (String)moduleDirPath));
            }
            boolean skip = false;
            boolean targetOptionFound = false;
            for (String userOption : ParametersListUtil.parse((String)customArgs)) {
                if (FILTERED_OPTIONS.contains(userOption)) {
                    skip = true;
                    targetOptionFound = TARGET_OPTION.equals(userOption);
                    JavaBuilder.notifyOptionIgnored(context, userOption, chunk);
                    continue;
                }
                if (skip) {
                    skip = false;
                    if (!targetOptionFound) continue;
                    targetOptionFound = false;
                    USER_DEFINED_BYTECODE_TARGET.set((UserDataHolder)context, (Object)userOption);
                    continue;
                }
                if (!FILTERED_SINGLE_OPTIONS.contains(userOption)) {
                    if (POSSIBLY_CONFLICTING_OPTIONS.contains(userOption)) {
                        JavaBuilder.notifyOptionPossibleConflicts(context, userOption, chunk);
                    }
                    if (userOption.startsWith("-J-")) {
                        vmOptions.add(userOption.substring("-J".length()));
                        continue;
                    }
                    appender.accept(compilationOptions, userOption);
                    continue;
                }
                JavaBuilder.notifyOptionIgnored(context, userOption, chunk);
            }
        }
        for (ExternalJavacOptionsProvider extension : JpsServiceManager.getInstance().getExtensions(ExternalJavacOptionsProvider.class)) {
            vmOptions.addAll(extension.getOptions(compilingTool, compilerSdkVersion));
        }
        JavaBuilder.addCompilationOptions(compilerSdkVersion, compilingTool, compilationOptions, context, chunk, profile, true);
        return Pair.create(vmOptions, compilationOptions);
    }

    private static void notifyOptionPossibleConflicts(CompileContext context, String option, ModuleChunk chunk) {
        JavaBuilder.notifyMessage(context, BuildMessage.Kind.JPS_INFO, "build.message.user.specified.option.0.for.1.may.conflict.with.calculated.option", false, option, chunk.getPresentableShortName());
    }

    private static void notifyOptionIgnored(CompileContext context, String option, ModuleChunk chunk) {
        JavaBuilder.notifyMessage(context, BuildMessage.Kind.JPS_INFO, "build.message.user.specified.option.0.is.ignored.for.1", false, option, chunk.getPresentableShortName());
    }

    private static void notifyMessage(CompileContext context, BuildMessage.Kind kind, String messageKey, boolean notifyOnce, Object ... params) {
        if (!notifyOnce || ((Set)SHOWN_NOTIFICATIONS.get((UserDataHolder)context)).add(messageKey)) {
            context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), kind, JpsBuildBundle.message(messageKey, params)));
        }
    }

    public static void addCompilationOptions(List<? super String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile) {
        JavaBuilder.addCompilationOptions(JavaVersion.current().feature, JavaBuilderUtil.findCompilingTool("Javac"), options, context, chunk, profile, false);
    }

    private static void addCompilationOptions(int compilerSdkVersion, JavaCompilingTool compilingTool, List<? super String> options, CompileContext context, ModuleChunk chunk, @Nullable ProcessorConfigProfile profile, boolean procOnlySupported) {
        LanguageLevel level;
        if (!options.contains(ENCODING_OPTION)) {
            CompilerEncodingConfiguration config = context.getProjectDescriptor().getEncodingConfiguration();
            String encoding = config.getPreferredModuleChunkEncoding(chunk);
            if (config.getAllModuleChunkEncodings(chunk).size() > 1) {
                String message = JpsBuildBundle.message("build.message.multiple.encodings.set.for.module.chunk", chunk.getName(), encoding, encoding != null ? 0 : 1);
                context.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.INFO, message));
            }
            if (!StringUtil.isEmpty((String)encoding)) {
                options.add(ENCODING_OPTION);
                options.add(encoding);
            }
        }
        JavaBuilder.addCrossCompilationOptions(compilerSdkVersion, options, context, chunk);
        if (!options.contains(ENABLE_PREVIEW_OPTION) && (level = JpsJavaExtensionService.getInstance().getLanguageLevel(chunk.representativeTarget().getModule())) != null && level.isPreview()) {
            options.add(ENABLE_PREVIEW_OPTION);
        }
        if (JavaBuilder.addAnnotationProcessingOptions(options, (AnnotationProcessingConfiguration)profile)) {
            assert (profile != null);
            if (procOnlySupported && profile.isProcOnly()) {
                options.add(PROC_ONLY_OPTION);
            } else if (ourProcFullRequiredFrom > 0) {
                if (compilerSdkVersion >= ourProcFullRequiredFrom) {
                    options.add(PROC_FULL_OPTION);
                }
            } else if (compilerSdkVersion > 22 && JavaBuilder.isJavac(compilingTool)) {
                options.add(PROC_FULL_OPTION);
            }
            File srcOutput = ProjectPaths.getAnnotationProcessorGeneratedSourcesOutputDir(chunk.getModules().iterator().next(), chunk.containsTests(), profile);
            if (srcOutput != null) {
                FileUtil.createDirectory((File)srcOutput);
                options.add("-s");
                options.add(srcOutput.getPath());
            }
        }
    }

    public static boolean addAnnotationProcessingOptions(List<? super String> options, @Nullable AnnotationProcessingConfiguration profile) {
        Set processors;
        if (profile == null || !profile.isEnabled()) {
            options.add(PROC_NONE_OPTION);
            return false;
        }
        if (!profile.isObtainProcessorsFromClasspath()) {
            String processorsPath = profile.getProcessorPath();
            options.add(profile.isUseProcessorModulePath() ? PROCESSOR_MODULE_PATH_OPTION : PROCESSORPATH_OPTION);
            options.add(FileUtil.toSystemDependentName((String)processorsPath.trim()));
        }
        if (!(processors = profile.getProcessors()).isEmpty()) {
            options.add("-processor");
            options.add(StringUtil.join((Collection)processors, (String)","));
        }
        for (Map.Entry optionEntry : profile.getProcessorOptions().entrySet()) {
            options.add("-A" + (String)optionEntry.getKey() + "=" + (String)optionEntry.getValue());
        }
        return true;
    }

    @NotNull
    public static String getUsedCompilerId(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        String string = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getJavaCompilerId();
        if (string == null) {
            JavaBuilder.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void addCrossCompilationOptions(int compilerSdkVersion, List<? super String> options, CompileContext context, ModuleChunk chunk) {
        String homePath;
        Pair<JpsSdk<JpsDummyElement>, Integer> associatedSdk;
        int bytecodeTarget;
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject());
        @NotNull JpsModule module = chunk.representativeTarget().getModule();
        LanguageLevel level = JpsJavaExtensionService.getInstance().getLanguageLevel(module);
        int chunkSdkVersion = JavaBuilder.getChunkSdkVersion(chunk);
        int languageLevel = level == null ? 0 : (level == LanguageLevel.JDK_X ? chunkSdkVersion : level.feature());
        int n = bytecodeTarget = level == LanguageLevel.JDK_X ? chunkSdkVersion : JavaBuilder.getModuleBytecodeTarget(context, chunk, compilerConfiguration, languageLevel);
        if (JavaBuilder.shouldUseReleaseOption(compilerConfiguration, compilerSdkVersion, chunkSdkVersion, bytecodeTarget)) {
            options.add(RELEASE_OPTION);
            options.add(JavaBuilder.complianceOption(bytecodeTarget));
            return;
        }
        if (languageLevel > 0 && !options.contains(SOURCE_OPTION)) {
            options.add(SOURCE_OPTION);
            options.add(JavaBuilder.complianceOption(languageLevel));
        }
        if (bytecodeTarget > 0) {
            if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion && compilerSdkVersion >= bytecodeTarget && bytecodeTarget > chunkSdkVersion) {
                bytecodeTarget = chunkSdkVersion;
            }
        } else if (chunkSdkVersion > 0 && compilerSdkVersion > chunkSdkVersion) {
            bytecodeTarget = chunkSdkVersion;
        }
        if (bytecodeTarget > 0) {
            options.add(TARGET_OPTION);
            options.add(JavaBuilder.complianceOption(bytecodeTarget));
        }
        if (compilerSdkVersion >= 9 && (associatedSdk = JavaBuilder.getAssociatedSdk(chunk)) != null && (Integer)associatedSdk.getSecond() >= 9 && (Integer)associatedSdk.getSecond() != compilerSdkVersion && (homePath = ((JpsSdk)associatedSdk.getFirst()).getHomePath()) != null) {
            options.add(SYSTEM_OPTION);
            options.add(FileUtil.toSystemIndependentName((String)homePath));
        }
    }

    public static int getModuleBytecodeTarget(CompileContext context, ModuleChunk chunk, JpsJavaCompilerConfiguration compilerConfiguration) {
        return JavaBuilder.getModuleBytecodeTarget(context, chunk, compilerConfiguration, JavaBuilder.getLanguageLevel(chunk.representativeTarget().getModule()));
    }

    private static int getModuleBytecodeTarget(CompileContext context, ModuleChunk chunk, JpsJavaCompilerConfiguration compilerConfiguration, int languageLevel) {
        int bytecodeTarget = 0;
        for (JpsModule module : chunk.getModules()) {
            int moduleTarget = JpsJavaSdkType.parseVersion((String)compilerConfiguration.getByteCodeTargetLevel(module.getName()));
            if (moduleTarget <= 0 || bytecodeTarget != 0 && moduleTarget >= bytecodeTarget) continue;
            bytecodeTarget = moduleTarget;
        }
        if (bytecodeTarget == 0) {
            if (languageLevel > 0) {
                bytecodeTarget = languageLevel;
            } else {
                String value = (String)USER_DEFINED_BYTECODE_TARGET.get((UserDataHolder)context);
                if (value != null) {
                    bytecodeTarget = JpsJavaSdkType.parseVersion((String)value);
                }
            }
        }
        return bytecodeTarget;
    }

    private static String complianceOption(int major) {
        return JpsJavaSdkType.complianceOption((JavaVersion)JavaVersion.compose((int)major));
    }

    private static int getLanguageLevel(@NotNull JpsModule module) {
        LanguageLevel level;
        if (module == null) {
            JavaBuilder.$$$reportNull$$$0(18);
        }
        return (level = JpsJavaExtensionService.getInstance().getLanguageLevel(module)) != null ? level.feature() : 0;
    }

    private static int getTargetPlatformLanguageVersion(@NotNull JpsModule module) {
        int level;
        if (module == null) {
            JavaBuilder.$$$reportNull$$$0(19);
        }
        if ((level = JavaBuilder.getLanguageLevel(module)) > 0) {
            return level;
        }
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (sdk != null) {
            return JpsJavaSdkType.getJavaVersion((JpsSdk)sdk);
        }
        return 0;
    }

    private static int getChunkSdkVersion(ModuleChunk chunk) {
        int chunkSdkVersion = -1;
        for (JpsModule module : chunk.getModules()) {
            int moduleSdkVersion;
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            if (sdk == null || (moduleSdkVersion = JpsJavaSdkType.getJavaVersion((JpsSdk)sdk)) == 0 || chunkSdkVersion >= 0 && chunkSdkVersion <= moduleSdkVersion) continue;
            chunkSdkVersion = moduleSdkVersion;
        }
        return chunkSdkVersion;
    }

    @Nullable
    private static Pair<String, Integer> getForkedJavacSdk(DiagnosticListener<? super JavaFileObject> diagnostic, ModuleChunk chunk, int targetLanguageLevel) {
        int fallbackVersion;
        String fallbackJdkVersion;
        String fallbackJdkHome;
        Pair<JpsSdk<JpsDummyElement>, Integer> associatedSdk = JavaBuilder.getAssociatedSdk(chunk);
        boolean canRunAssociatedJavac = false;
        if (associatedSdk != null) {
            int sdkVersion = (Integer)associatedSdk.second;
            boolean bl = canRunAssociatedJavac = sdkVersion >= 7;
            if (JavaBuilder.isTargetReleaseSupported(sdkVersion, targetLanguageLevel)) {
                if (canRunAssociatedJavac) {
                    return Pair.create((Object)((JpsSdk)associatedSdk.first).getHomePath(), (Object)sdkVersion);
                }
            } else {
                LOG.warn("Target bytecode version " + targetLanguageLevel + " is not supported by SDK " + sdkVersion + " associated with module " + chunk.getName());
            }
        }
        if ((fallbackJdkHome = System.getProperty("jps.fallback.jdk.home", null)) == null) {
            LOG.info("Fallback JDK is not specified. (See jps.fallback.jdk.home option)");
        }
        if ((fallbackJdkVersion = System.getProperty("jps.fallback.jdk.version", null)) == null) {
            LOG.info("Fallback JDK version is not specified. (See jps.fallback.jdk.version option)");
        }
        if (associatedSdk == null && (fallbackJdkHome == null || fallbackJdkVersion == null)) {
            diagnostic.report((Diagnostic<? super JavaFileObject>)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, JpsBuildBundle.message("build.message.cannot.start.javac.process.for.0.unknown.jdk.home", chunk.getName())));
            return null;
        }
        if (fallbackJdkHome != null && JavaBuilder.isTargetReleaseSupported(fallbackVersion = JpsJavaSdkType.parseVersion((String)fallbackJdkVersion), targetLanguageLevel)) {
            if (fallbackVersion >= 7) {
                return Pair.create((Object)fallbackJdkHome, (Object)fallbackVersion);
            }
            LOG.info("Version string for fallback JDK is '" + fallbackJdkVersion + "' (recognized as version '" + fallbackVersion + "'). At least version 7 is required to launch javac process.");
        }
        if (associatedSdk != null) {
            if (canRunAssociatedJavac) {
                return Pair.create((Object)((JpsSdk)associatedSdk.first).getHomePath(), (Object)((Integer)associatedSdk.second));
            }
            diagnostic.report((Diagnostic<? super JavaFileObject>)new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, JpsBuildBundle.message("build.message.unsupported.javac.version", chunk.getName(), associatedSdk.second, 7, targetLanguageLevel)));
        }
        return null;
    }

    private static @Nullable Pair<@NotNull JpsSdk<JpsDummyElement>, @NotNull Integer> getAssociatedSdk(ModuleChunk chunk) {
        JpsSdk sdk = chunk.representativeTarget().getModule().getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
        return sdk != null ? Pair.create((Object)sdk, (Object)JpsJavaSdkType.getJavaVersion((JpsSdk)sdk)) : null;
    }

    @Override
    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources(context);
        ExternalJavacManager extJavacManager = (ExternalJavacManager)((Object)ExternalJavacManagerKey.KEY.get(context));
        if (extJavacManager != null) {
            extJavacManager.shutdownIdleProcesses();
        }
    }

    private static Map<File, Set<File>> buildOutputDirectoriesMap(CompileContext context, ModuleChunk chunk) {
        Map map = FileCollectionFactory.createCanonicalFileMap();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File outputDir = target.getOutputDir();
            if (outputDir == null) continue;
            Set roots = FileCollectionFactory.createCanonicalFileSet();
            for (JavaSourceRootDescriptor descriptor : context.getProjectDescriptor().getBuildRootIndex().getTargetRoots(target, context)) {
                roots.add(descriptor.root);
            }
            map.put(outputDir, roots);
        }
        return map;
    }

    @Override
    public long getExpectedBuildTime() {
        return 100L;
    }

    static {
        File rtJar = null;
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty("sun.boot.class.path", ""), File.pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (!"rt.jar".equals(file.getName())) continue;
            rtJar = file;
            break;
        }
        ourDefaultRtJar = rtJar;
        int procFullRequired = 0;
        try {
            procFullRequired = Math.max(Integer.parseInt(System.getProperty(PROC_FULL_REQUIRED_OPTION, "0")), 0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ourProcFullRequiredFrom = procFullRequired;
        USER_DEFINED_BYTECODE_TARGET = Key.create((String)"_user_defined_bytecode_target_");
        COUNTER_KEY = Key.create((String)"_async_task_counter_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder";
                break;
            }
            case 2: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFilesHolder";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilingTool";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAdditionalRequires";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureJavacServerStarted";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedCompilerId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeJavac";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureJavacServerStarted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPlatformLanguageVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExplodedModuleNameFinder
    implements Function<File, String> {
        private final TargetOutputIndex myOutsIndex;

        ExplodedModuleNameFinder(CompileContext context) {
            BuildTargetIndex targetIndex = context.getProjectDescriptor().getBuildTargetIndex();
            ArrayList<ModuleBuildTarget> javaModuleTargets = new ArrayList<ModuleBuildTarget>();
            for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
                javaModuleTargets.addAll(targetIndex.getAllTargets(type));
            }
            this.myOutsIndex = new TargetOutputIndexImpl(javaModuleTargets, context);
        }

        @Override
        public String apply(File outputDir) {
            for (BuildTarget<?> target : this.myOutsIndex.getTargetsByOutputFile(outputDir)) {
                if (!(target instanceof ModuleBasedTarget)) continue;
                return ((ModuleBasedTarget)target).getModule().getName().trim();
            }
            return ModulePathSplitter.DEFAULT_MODULE_NAME_SEARCH.apply(outputDir);
        }
    }

    private static final class DiagnosticSink
    implements DiagnosticOutputConsumer {
        private final CompileContext myContext;
        private final AtomicInteger myErrorCount;
        private final AtomicInteger myWarningCount;
        private final Set<File> myFilesWithErrors;
        @NotNull
        private final Collection<? extends JavacFileReferencesRegistrar> myRegistrars;

        private DiagnosticSink(CompileContext context, @NotNull Collection<? extends JavacFileReferencesRegistrar> refRegistrars) {
            if (refRegistrars == null) {
                DiagnosticSink.$$$reportNull$$$0(0);
            }
            this.myErrorCount = new AtomicInteger(0);
            this.myWarningCount = new AtomicInteger(0);
            this.myFilesWithErrors = FileCollectionFactory.createCanonicalFileSet();
            this.myContext = context;
            this.myRegistrars = refRegistrars;
        }

        public void javaFileLoaded(File file) {
        }

        public void registerJavacFileData(JavacFileData data) {
            for (JavacFileReferencesRegistrar javacFileReferencesRegistrar : this.myRegistrars) {
                javacFileReferencesRegistrar.registerFile(this.myContext, data.getFilePath(), Iterators.map(data.getRefs().entrySet(), entry -> entry), data.getDefs(), data.getCasts(), data.getImplicitToStringRefs());
            }
        }

        public void customOutputData(String pluginId, String dataName, byte[] data) {
            if ("ast.reference.collector".equals(pluginId) && "JavacFileData".equals(dataName)) {
                this.registerJavacFileData(JavacFileData.fromBytes((byte[])data));
            } else {
                for (CustomOutputDataListener listener : JpsServiceManager.getInstance().getExtensions(CustomOutputDataListener.class)) {
                    if (!pluginId.equals(listener.getId())) continue;
                    listener.processData(this.myContext, dataName, data);
                    return;
                }
            }
        }

        public void outputLineAvailable(@NlsSafe String line) {
            if (!StringUtil.isEmpty((String)line)) {
                if (line.startsWith("JAVAC_PROCESS[STDOUT]")) {
                    System.out.println(line);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(line);
                    }
                } else if (line.startsWith("JAVAC_PROCESS[STDERR]")) {
                    System.err.println(line);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(line);
                    }
                } else if (line.contains("java.lang.OutOfMemoryError")) {
                    this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.ERROR, JpsBuildBundle.message("build.message.insufficient.memory", new Object[0])));
                    this.myErrorCount.incrementAndGet();
                } else {
                    this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.INFO, line));
                }
            }
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            String srcPath;
            BuildMessage.Kind kind;
            switch (diagnostic.getKind()) {
                case ERROR: {
                    kind = BuildMessage.Kind.ERROR;
                    this.myErrorCount.incrementAndGet();
                    break;
                }
                case MANDATORY_WARNING: 
                case WARNING: {
                    kind = BuildMessage.Kind.WARNING;
                    this.myWarningCount.incrementAndGet();
                    break;
                }
                case NOTE: {
                    kind = BuildMessage.Kind.INFO;
                    break;
                }
                case OTHER: {
                    kind = diagnostic instanceof JpsInfoDiagnostic ? BuildMessage.Kind.JPS_INFO : BuildMessage.Kind.OTHER;
                    break;
                }
                default: {
                    kind = BuildMessage.Kind.OTHER;
                }
            }
            File sourceFile = null;
            try {
                JavaFileObject source = diagnostic.getSource();
                sourceFile = source != null ? new File(source.toUri()) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
            if (sourceFile != null) {
                if (kind == BuildMessage.Kind.ERROR) {
                    this.myFilesWithErrors.add(sourceFile);
                }
                srcPath = FileUtil.toSystemIndependentName((String)sourceFile.getPath());
            } else {
                srcPath = null;
            }
            String message = diagnostic.getMessage(Locale.US);
            if (Utils.IS_TEST_MODE) {
                LOG.info(message);
            }
            CompilerMessage compilerMsg = new CompilerMessage(JavaBuilder.getBuilderName(), kind, message, srcPath, diagnostic.getStartPosition(), diagnostic.getEndPosition(), diagnostic.getPosition(), diagnostic.getLineNumber(), diagnostic.getColumnNumber());
            if (LOG.isDebugEnabled()) {
                LOG.debug(compilerMsg.toString());
            }
            this.myContext.processMessage(compilerMsg);
        }

        int getErrorCount() {
            return this.myErrorCount.get();
        }

        int getWarningCount() {
            return this.myWarningCount.get();
        }

        @NotNull
        Collection<File> getFilesWithErrors() {
            Set<File> set = this.myFilesWithErrors;
            if (set == null) {
                DiagnosticSink.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refRegistrars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/java/JavaBuilder$DiagnosticSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/java/JavaBuilder$DiagnosticSink";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesWithErrors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ClassProcessingConsumer
    implements OutputFileConsumer {
        private final CompileContext myContext;
        private final OutputFileConsumer myDelegateOutputFileSink;

        private ClassProcessingConsumer(CompileContext context, OutputFileConsumer sink) {
            this.myContext = context;
            this.myDelegateOutputFileSink = sink != null ? sink : fileObject -> {
                throw new RuntimeException("Output sink for compiler was not specified");
            };
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                ClassProcessingConsumer.$$$reportNull$$$0(0);
            }
            try {
                BinaryContent content = fileObject.getContent();
                File file = fileObject.getFile();
                if (content != null) {
                    content.saveToFile(file);
                } else {
                    this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.WARNING, JpsBuildBundle.message("build.message.missing.content.for.file.0", file.getPath())));
                }
            }
            catch (IOException e) {
                this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.ERROR, e.getMessage()));
            }
            JavaBuilder.this.submitAsyncTask(this.myContext, () -> {
                try {
                    for (ClassPostProcessor processor : ourClassProcessors) {
                        processor.process(this.myContext, fileObject);
                    }
                }
                finally {
                    this.myDelegateOutputFileSink.save(fileObject);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "org/jetbrains/jps/incremental/java/JavaBuilder$ClassProcessingConsumer", "save"));
        }
    }

    private static interface JavacCaller {
        public boolean invoke(Iterable<String> var1, Iterable<? extends File> var2, OutputFileConsumer var3);
    }

    private static final class CompilableModuleTypesHolder {
        static final Set<JpsModuleType<?>> ourCompilableModuleTypes = new HashSet();

        private CompilableModuleTypesHolder() {
        }

        static {
            for (JavaBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(JavaBuilderExtension.class)) {
                ourCompilableModuleTypes.addAll(extension.getCompilableModuleTypes());
            }
        }
    }
}

