/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ImportStaticMemberUsage;
import org.jetbrains.jps.dependency.java.ImportStaticOnDemandUsage;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategy;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.javac.Iterators;

public abstract class JvmDifferentiateStrategyImpl
implements JvmDifferentiateStrategy {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl");

    protected void affectMemberUsages(DifferentiateContext context, JvmNodeReferenceID clsId, ProtoMember member, Iterable<JvmNodeReferenceID> propagated) {
        this.affectMemberUsages(context, clsId, member, propagated, null);
    }

    protected void affectMemberUsages(DifferentiateContext context, JvmNodeReferenceID clsId, ProtoMember member, Iterable<JvmNodeReferenceID> propagated, @Nullable Predicate<Node<?, ?>> constraint) {
        this.affectUsages(context, (member instanceof JvmMethod ? "method " : (member instanceof JvmField ? "field " : "member ")) + String.valueOf(member), Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> member.createUsage((JvmNodeReferenceID)id), constraint);
    }

    protected void affectStaticMemberOnDemandUsages(DifferentiateContext context, JvmNodeReferenceID clsId, Iterable<JvmNodeReferenceID> propagated) {
        this.affectUsages(context, "static member on-demand import usage", Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> new ImportStaticOnDemandUsage((JvmNodeReferenceID)id), null);
    }

    protected void affectStaticMemberImportUsages(DifferentiateContext context, JvmNodeReferenceID clsId, String memberName, Iterable<JvmNodeReferenceID> propagated) {
        this.affectUsages(context, "static member import", Iterators.flat((Iterable)Iterators.asIterable((Object)clsId), propagated), id -> new ImportStaticMemberUsage(id.getNodeName(), memberName), null);
    }

    protected void affectUsages(DifferentiateContext context, String usageKind, Iterable<JvmNodeReferenceID> usageOwners, Function<? super JvmNodeReferenceID, ? extends Usage> usageFactory, @Nullable Predicate<Node<?, ?>> constraint) {
        for (JvmNodeReferenceID id : usageOwners) {
            if (constraint != null) {
                context.affectUsage(usageFactory.apply(id), constraint);
            } else {
                context.affectUsage(usageFactory.apply(id));
            }
            this.debug("Affect ", usageKind, " usage owned by node '", id.getNodeName(), "'");
        }
    }

    protected boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    protected void debug(String message, Object ... details) {
        if (this.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder(message);
            for (Object detail : details) {
                msg.append(detail);
            }
            this.debug(msg.toString());
        }
    }

    protected void debug(String message) {
        LOG.debug(message);
    }

    protected void affectSubclasses(DifferentiateContext context, Utils utils, ReferenceID fromClass, boolean affectUsages) {
        this.debug("Affecting subclasses of class: ", fromClass, "; with usages affection: ", affectUsages);
        for (ReferenceID cl : utils.withAllSubclasses(fromClass)) {
            String nodeName;
            this.affectNodeSources(context, cl, "Affecting source file: ", utils);
            if (!affectUsages || (nodeName = utils.getNodeName(cl)) == null) continue;
            context.affectUsage(new ClassUsage(nodeName));
            this.debug("Affect usage of class ", nodeName);
        }
    }

    protected void affectNodeSources(DifferentiateContext context, ReferenceID clsId, String affectReason, Utils utils) {
        this.affectSources(context, utils.getNodeSources(clsId), affectReason, false);
    }

    protected void affectSources(DifferentiateContext context, Iterable<NodeSource> sources, String affectReason, boolean forceAffect) {
        Set<NodeSource> deletedSources = context.getDelta().getDeletedSources();
        Predicate<? super NodeSource> affectionFilter = context.getParams().affectionFilter();
        for (NodeSource source : Iterators.filter(sources, affectionFilter::test)) {
            if (!forceAffect && context.isCompiled(source) || deletedSources.contains(source)) continue;
            context.affectNodeSource(source);
            this.debug(affectReason, source);
        }
    }
}

