/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.configurationStore.Property;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsUtils;
import com.intellij.psi.codeStyle.ImportsLayoutSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class JavaCodeStyleSettings
extends CustomCodeStyleSettings
implements ImportsLayoutSettings {
    private static final int CURRENT_VERSION = 1;
    private int myVersion;
    private int myOldVersion;
    private boolean myIsInitialized;
    private static final String REPEAT_ANNOTATIONS = "REPEAT_ANNOTATIONS";
    private static final String REPEAT_ANNOTATIONS_ITEM = "ANNO";
    private static final String DO_NOT_IMPORT_INNER = "DO_NOT_IMPORT_INNER";
    private static final String DO_NOT_IMPORT_INNER_ITEM = "CLASS";
    private static final String COLLECTION_ITEM_ATTRIBUTE = "name";
    public String FIELD_NAME_PREFIX;
    public String STATIC_FIELD_NAME_PREFIX;
    public String PARAMETER_NAME_PREFIX;
    public String LOCAL_VARIABLE_NAME_PREFIX;
    public String TEST_NAME_PREFIX;
    public String SUBCLASS_NAME_PREFIX;
    public String FIELD_NAME_SUFFIX;
    public String STATIC_FIELD_NAME_SUFFIX;
    public String PARAMETER_NAME_SUFFIX;
    public String LOCAL_VARIABLE_NAME_SUFFIX;
    public String TEST_NAME_SUFFIX;
    public String SUBCLASS_NAME_SUFFIX;
    public boolean PREFER_LONGER_NAMES;
    public boolean GENERATE_FINAL_LOCALS;
    public boolean GENERATE_FINAL_PARAMETERS;
    @PsiModifier.ModifierConstant
    public String VISIBILITY;
    public boolean USE_EXTERNAL_ANNOTATIONS;
    public boolean GENERATE_USE_TYPE_ANNOTATION_BEFORE_TYPE;
    public boolean INSERT_OVERRIDE_ANNOTATION;
    public boolean REPEAT_SYNCHRONIZED;
    private List<String> myRepeatAnnotations;
    private List<String> myDoNotImportInner;
    @Deprecated(forRemoval=true)
    public boolean REPLACE_INSTANCEOF;
    @Deprecated(forRemoval=true)
    public boolean REPLACE_CAST;
    public boolean REPLACE_INSTANCEOF_AND_CAST;
    public boolean REPLACE_NULL_CHECK;
    @Property(externalName="replace_sum_lambda_with_method_ref")
    public boolean REPLACE_SUM;
    public boolean SPACES_WITHIN_ANGLE_BRACKETS;
    public boolean SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT;
    public boolean SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER;
    public boolean SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS;
    public boolean DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION;
    public boolean DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION_IN_PARAMETER;
    public boolean ANNOTATION_NEW_LINE_IN_RECORD_COMPONENT;
    @CommonCodeStyleSettings.WrapConstant
    public int ANNOTATION_PARAMETER_WRAP;
    @CommonCodeStyleSettings.WrapConstant
    public int ENUM_FIELD_ANNOTATION_WRAP;
    public boolean ALIGN_MULTILINE_ANNOTATION_PARAMETERS;
    public boolean NEW_LINE_AFTER_LPAREN_IN_ANNOTATION;
    public boolean RPAREN_ON_NEW_LINE_IN_ANNOTATION;
    public boolean SPACE_AROUND_ANNOTATION_EQ;
    public boolean ALIGN_MULTILINE_TEXT_BLOCKS;
    public int BLANK_LINES_AROUND_INITIALIZER;
    public int BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS;
    public int BLANK_LINES_BETWEEN_RECORD_COMPONENTS;
    public static final int FULLY_QUALIFY_NAMES_IF_NOT_IMPORTED = 1;
    public static final int FULLY_QUALIFY_NAMES_ALWAYS = 2;
    public static final int SHORTEN_NAMES_ALWAYS_AND_ADD_IMPORT = 3;
    public int CLASS_NAMES_IN_JAVADOC;
    public boolean SPACE_BEFORE_COLON_IN_FOREACH;
    public boolean SPACE_INSIDE_ONE_LINE_ENUM_BRACES;
    public boolean SPACES_INSIDE_BLOCK_BRACES_WHEN_BODY_IS_PRESENT;
    public boolean NEW_LINE_WHEN_BODY_IS_PRESENTED;
    public boolean LAYOUT_STATIC_IMPORTS_SEPARATELY;
    public boolean LAYOUT_ON_DEMAND_IMPORT_FROM_SAME_PACKAGE_FIRST;
    public boolean PRESERVE_MODULE_IMPORTS;
    public boolean USE_FQ_CLASS_NAMES;
    public boolean USE_SINGLE_CLASS_IMPORTS;
    public boolean INSERT_INNER_CLASS_IMPORTS;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    public PackageEntryTable PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    @Property(externalName="imports_layout")
    public PackageEntryTable IMPORT_LAYOUT_TABLE;
    public boolean WRAP_SEMICOLON_AFTER_CALL_CHAIN;
    @CommonCodeStyleSettings.WrapConstant
    public int RECORD_COMPONENTS_WRAP;
    public boolean ALIGN_MULTILINE_RECORDS;
    public boolean NEW_LINE_AFTER_LPAREN_IN_RECORD_HEADER;
    public boolean RPAREN_ON_NEW_LINE_IN_RECORD_HEADER;
    public boolean SPACE_WITHIN_RECORD_HEADER;
    @CommonCodeStyleSettings.WrapConstant
    public int DECONSTRUCTION_LIST_WRAP;
    public boolean ALIGN_MULTILINE_DECONSTRUCTION_LIST_COMPONENTS;
    public boolean NEW_LINE_AFTER_LPAREN_IN_DECONSTRUCTION_PATTERN;
    public boolean RPAREN_ON_NEW_LINE_IN_DECONSTRUCTION_PATTERN;
    public boolean SPACE_WITHIN_DECONSTRUCTION_LIST;
    public boolean SPACE_BEFORE_DECONSTRUCTION_LIST;
    @CommonCodeStyleSettings.WrapConstant
    public int MULTI_CATCH_TYPES_WRAP;
    public boolean ALIGN_TYPES_IN_MULTI_CATCH;
    @Property(externalName="doc_enable_formatting")
    public boolean ENABLE_JAVADOC_FORMATTING;
    @Property(externalName="doc_align_param_comments")
    public boolean JD_ALIGN_PARAM_COMMENTS;
    @Property(externalName="doc_align_exception_comments")
    public boolean JD_ALIGN_EXCEPTION_COMMENTS;
    @Property(externalName="doc_add_blank_line_after_param_comments")
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS;
    @Property(externalName="doc_add_blank_line_after_return")
    public boolean JD_ADD_BLANK_AFTER_RETURN;
    @Property(externalName="doc_add_blank_line_after_description")
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION;
    @Property(externalName="doc_add_p_tag_on_empty_lines")
    public boolean JD_P_AT_EMPTY_LINES;
    @Property(externalName="doc_keep_invalid_tags")
    public boolean JD_KEEP_INVALID_TAGS;
    @Property(externalName="doc_keep_empty_lines")
    public boolean JD_KEEP_EMPTY_LINES;
    @Property(externalName="doc_do_not_wrap_if_one_line")
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS;
    @Property(externalName="doc_use_throws_not_exception_tag")
    public boolean JD_USE_THROWS_NOT_EXCEPTION;
    @Property(externalName="doc_keep_empty_parameter_tag")
    public boolean JD_KEEP_EMPTY_PARAMETER;
    @Property(externalName="doc_keep_empty_throws_tag")
    public boolean JD_KEEP_EMPTY_EXCEPTION;
    @Property(externalName="doc_keep_empty_return_tag")
    public boolean JD_KEEP_EMPTY_RETURN;
    @Property(externalName="doc_enable_leading_asterisks")
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED;
    @Property(externalName="doc_preserve_line_breaks")
    public boolean JD_PRESERVE_LINE_FEEDS;
    @Property(externalName="doc_param_description_on_new_line")
    public boolean JD_PARAM_DESCRIPTION_ON_NEW_LINE;
    @Property(externalName="doc_indent_on_continuation")
    public boolean JD_INDENT_ON_CONTINUATION;

    public JavaCodeStyleSettings(@NotNull CodeStyleSettings container) {
        if (container == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(0);
        }
        super("JavaCodeStyleSettings", container);
        this.myVersion = 1;
        this.myOldVersion = 0;
        this.myIsInitialized = false;
        this.FIELD_NAME_PREFIX = "";
        this.STATIC_FIELD_NAME_PREFIX = "";
        this.PARAMETER_NAME_PREFIX = "";
        this.LOCAL_VARIABLE_NAME_PREFIX = "";
        this.TEST_NAME_PREFIX = "";
        this.SUBCLASS_NAME_PREFIX = "";
        this.FIELD_NAME_SUFFIX = "";
        this.STATIC_FIELD_NAME_SUFFIX = "";
        this.PARAMETER_NAME_SUFFIX = "";
        this.LOCAL_VARIABLE_NAME_SUFFIX = "";
        this.TEST_NAME_SUFFIX = "Test";
        this.SUBCLASS_NAME_SUFFIX = "Impl";
        this.PREFER_LONGER_NAMES = true;
        this.VISIBILITY = "public";
        this.GENERATE_USE_TYPE_ANNOTATION_BEFORE_TYPE = true;
        this.INSERT_OVERRIDE_ANNOTATION = true;
        this.REPEAT_SYNCHRONIZED = true;
        this.myRepeatAnnotations = new ArrayList<String>();
        this.myDoNotImportInner = new ArrayList<String>();
        this.REPLACE_INSTANCEOF = false;
        this.REPLACE_CAST = false;
        this.REPLACE_INSTANCEOF_AND_CAST = false;
        this.REPLACE_NULL_CHECK = true;
        this.REPLACE_SUM = true;
        this.SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS = true;
        this.DO_NOT_WRAP_AFTER_SINGLE_ANNOTATION_IN_PARAMETER = false;
        this.ANNOTATION_NEW_LINE_IN_RECORD_COMPONENT = false;
        this.ANNOTATION_PARAMETER_WRAP = 0;
        this.ENUM_FIELD_ANNOTATION_WRAP = 0;
        this.NEW_LINE_AFTER_LPAREN_IN_ANNOTATION = false;
        this.RPAREN_ON_NEW_LINE_IN_ANNOTATION = false;
        this.SPACE_AROUND_ANNOTATION_EQ = true;
        this.ALIGN_MULTILINE_TEXT_BLOCKS = false;
        this.BLANK_LINES_AROUND_INITIALIZER = 1;
        this.BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS = 0;
        this.BLANK_LINES_BETWEEN_RECORD_COMPONENTS = 0;
        this.CLASS_NAMES_IN_JAVADOC = 1;
        this.SPACE_BEFORE_COLON_IN_FOREACH = true;
        this.SPACE_INSIDE_ONE_LINE_ENUM_BRACES = false;
        this.SPACES_INSIDE_BLOCK_BRACES_WHEN_BODY_IS_PRESENT = false;
        this.NEW_LINE_WHEN_BODY_IS_PRESENTED = false;
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
        this.LAYOUT_ON_DEMAND_IMPORT_FROM_SAME_PACKAGE_FIRST = true;
        this.PRESERVE_MODULE_IMPORTS = true;
        this.USE_SINGLE_CLASS_IMPORTS = true;
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
        this.IMPORT_LAYOUT_TABLE = new PackageEntryTable();
        this.WRAP_SEMICOLON_AFTER_CALL_CHAIN = false;
        this.RECORD_COMPONENTS_WRAP = 1;
        this.ALIGN_MULTILINE_RECORDS = true;
        this.NEW_LINE_AFTER_LPAREN_IN_RECORD_HEADER = false;
        this.RPAREN_ON_NEW_LINE_IN_RECORD_HEADER = false;
        this.SPACE_WITHIN_RECORD_HEADER = false;
        this.DECONSTRUCTION_LIST_WRAP = 1;
        this.ALIGN_MULTILINE_DECONSTRUCTION_LIST_COMPONENTS = true;
        this.NEW_LINE_AFTER_LPAREN_IN_DECONSTRUCTION_PATTERN = true;
        this.RPAREN_ON_NEW_LINE_IN_DECONSTRUCTION_PATTERN = true;
        this.SPACE_WITHIN_DECONSTRUCTION_LIST = false;
        this.SPACE_BEFORE_DECONSTRUCTION_LIST = false;
        this.MULTI_CATCH_TYPES_WRAP = 1;
        this.ALIGN_TYPES_IN_MULTI_CATCH = true;
        this.ENABLE_JAVADOC_FORMATTING = true;
        this.JD_ALIGN_PARAM_COMMENTS = true;
        this.JD_ALIGN_EXCEPTION_COMMENTS = true;
        this.JD_ADD_BLANK_AFTER_DESCRIPTION = true;
        this.JD_P_AT_EMPTY_LINES = true;
        this.JD_KEEP_INVALID_TAGS = true;
        this.JD_KEEP_EMPTY_LINES = true;
        this.JD_USE_THROWS_NOT_EXCEPTION = true;
        this.JD_KEEP_EMPTY_PARAMETER = true;
        this.JD_KEEP_EMPTY_EXCEPTION = true;
        this.JD_KEEP_EMPTY_RETURN = true;
        this.JD_LEADING_ASTERISKS_ARE_ENABLED = true;
        this.JD_INDENT_ON_CONTINUATION = false;
        this.initImportsByDefault();
    }

    public List<String> getRepeatAnnotations() {
        return this.myRepeatAnnotations;
    }

    public void setRepeatAnnotations(List<String> repeatAnnotations) {
        this.myRepeatAnnotations.clear();
        this.myRepeatAnnotations.addAll(repeatAnnotations);
    }

    public List<String> getDoNotImportInner() {
        return this.myDoNotImportInner;
    }

    public void setDoNotImportInner(List<String> doNotImportInner) {
        this.myDoNotImportInner = doNotImportInner;
    }

    public boolean useFqNamesInJavadocAlways() {
        return this.CLASS_NAMES_IN_JAVADOC == 2;
    }

    public boolean isLayoutStaticImportsSeparately() {
        return this.LAYOUT_STATIC_IMPORTS_SEPARATELY;
    }

    public void setLayoutStaticImportsSeparately(boolean value) {
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = value;
    }

    public boolean isLayoutOnDemandImportFromSamePackageFirst() {
        return this.LAYOUT_ON_DEMAND_IMPORT_FROM_SAME_PACKAGE_FIRST;
    }

    public void setLayoutOnDemandImportFromSamePackageFirst(boolean value) {
        this.LAYOUT_ON_DEMAND_IMPORT_FROM_SAME_PACKAGE_FIRST = value;
    }

    public int getNamesCountToUseImportOnDemand() {
        return this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setNamesCountToUseImportOnDemand(int value) {
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public int getClassCountToUseImportOnDemand() {
        return this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
    }

    public void setClassCountToUseImportOnDemand(int value) {
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = value;
    }

    public boolean isInsertInnerClassImports() {
        return this.INSERT_INNER_CLASS_IMPORTS;
    }

    public void setInsertInnerClassImports(boolean value) {
        this.INSERT_INNER_CLASS_IMPORTS = value;
    }

    public boolean isInsertInnerClassImportsFor(String className) {
        return this.INSERT_INNER_CLASS_IMPORTS && !this.myDoNotImportInner.contains(className);
    }

    public boolean isUseSingleClassImports() {
        return this.USE_SINGLE_CLASS_IMPORTS;
    }

    public boolean isPreserveModuleImports() {
        return this.PRESERVE_MODULE_IMPORTS;
    }

    public void setPreserveModuleImports(boolean value) {
        this.PRESERVE_MODULE_IMPORTS = value;
    }

    public void setUseSingleClassImports(boolean value) {
        this.USE_SINGLE_CLASS_IMPORTS = value;
    }

    public boolean isUseFqClassNames() {
        return this.USE_FQ_CLASS_NAMES;
    }

    public void setUseFqClassNames(boolean value) {
        this.USE_FQ_CLASS_NAMES = value;
    }

    public PackageEntryTable getImportLayoutTable() {
        return this.IMPORT_LAYOUT_TABLE;
    }

    public PackageEntryTable getPackagesToUseImportOnDemand() {
        return this.PACKAGES_TO_USE_IMPORT_ON_DEMAND;
    }

    private void initImportsByDefault() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "java.awt", false));
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.addEntry(new PackageEntry(false, "javax.swing", false));
        this.initImportLayout();
    }

    private void initImportLayout() {
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_MODULE_IMPORTS);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "javax", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(new PackageEntry(false, "java", true));
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.BLANK_LINE_ENTRY);
        this.IMPORT_LAYOUT_TABLE.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
    }

    public boolean isGenerateFinalLocals() {
        return this.GENERATE_FINAL_LOCALS;
    }

    public boolean isGenerateFinalParameters() {
        return this.GENERATE_FINAL_PARAMETERS;
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(1);
        }
        this.USE_EXTERNAL_ANNOTATIONS = rootSettings.USE_EXTERNAL_ANNOTATIONS;
        this.INSERT_OVERRIDE_ANNOTATION = rootSettings.INSERT_OVERRIDE_ANNOTATION;
        this.REPEAT_SYNCHRONIZED = rootSettings.REPEAT_SYNCHRONIZED;
        this.setRepeatAnnotations(rootSettings.getRepeatAnnotations());
        this.LAYOUT_STATIC_IMPORTS_SEPARATELY = rootSettings.LAYOUT_STATIC_IMPORTS_SEPARATELY;
        this.USE_FQ_CLASS_NAMES = rootSettings.USE_FQ_CLASS_NAMES;
        this.USE_SINGLE_CLASS_IMPORTS = rootSettings.USE_SINGLE_CLASS_IMPORTS;
        this.INSERT_INNER_CLASS_IMPORTS = rootSettings.INSERT_INNER_CLASS_IMPORTS;
        this.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = rootSettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND;
        this.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = rootSettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND;
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(rootSettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.IMPORT_LAYOUT_TABLE.copyFrom(rootSettings.IMPORT_LAYOUT_TABLE);
        this.FIELD_NAME_PREFIX = rootSettings.FIELD_NAME_PREFIX;
        this.STATIC_FIELD_NAME_PREFIX = rootSettings.STATIC_FIELD_NAME_PREFIX;
        this.PARAMETER_NAME_PREFIX = rootSettings.PARAMETER_NAME_PREFIX;
        this.LOCAL_VARIABLE_NAME_PREFIX = rootSettings.LOCAL_VARIABLE_NAME_PREFIX;
        this.FIELD_NAME_SUFFIX = rootSettings.FIELD_NAME_SUFFIX;
        this.STATIC_FIELD_NAME_SUFFIX = rootSettings.STATIC_FIELD_NAME_SUFFIX;
        this.PARAMETER_NAME_SUFFIX = rootSettings.PARAMETER_NAME_SUFFIX;
        this.LOCAL_VARIABLE_NAME_SUFFIX = rootSettings.LOCAL_VARIABLE_NAME_SUFFIX;
        this.PREFER_LONGER_NAMES = rootSettings.PREFER_LONGER_NAMES;
        this.GENERATE_FINAL_LOCALS = rootSettings.GENERATE_FINAL_LOCALS;
        this.GENERATE_FINAL_PARAMETERS = rootSettings.GENERATE_FINAL_PARAMETERS;
        this.VISIBILITY = rootSettings.VISIBILITY;
        this.ENABLE_JAVADOC_FORMATTING = rootSettings.ENABLE_JAVADOC_FORMATTING;
        this.JD_LEADING_ASTERISKS_ARE_ENABLED = rootSettings.JD_LEADING_ASTERISKS_ARE_ENABLED;
    }

    public Object clone() {
        JavaCodeStyleSettings cloned = (JavaCodeStyleSettings)((Object)super.clone());
        cloned.myRepeatAnnotations = new ArrayList<String>();
        cloned.setRepeatAnnotations(this.getRepeatAnnotations());
        cloned.PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageEntryTable();
        cloned.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(this.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        cloned.IMPORT_LAYOUT_TABLE = new PackageEntryTable();
        cloned.IMPORT_LAYOUT_TABLE.copyFrom(this.IMPORT_LAYOUT_TABLE);
        cloned.myVersion = this.myVersion;
        cloned.myOldVersion = this.myOldVersion;
        cloned.myIsInitialized = this.myIsInitialized;
        return cloned;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        this.readExternalCollection(parentElement, this.myRepeatAnnotations, REPEAT_ANNOTATIONS, REPEAT_ANNOTATIONS_ITEM);
        this.readExternalCollection(parentElement, this.myDoNotImportInner, DO_NOT_IMPORT_INNER, DO_NOT_IMPORT_INNER_ITEM);
        this.myOldVersion = this.myVersion = CustomCodeStyleSettingsUtils.readVersion((Element)parentElement.getChild(this.getTagName()));
        this.myIsInitialized = true;
        Object[] entries = this.IMPORT_LAYOUT_TABLE.getEntries();
        if (entries.length == 0) {
            this.initImportLayout();
        } else {
            if (this.LAYOUT_STATIC_IMPORTS_SEPARATELY && !ContainerUtil.exists((Object[])entries, entry -> entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY)) {
                if (entries[0] == PackageEntry.ALL_MODULE_IMPORTS) {
                    this.IMPORT_LAYOUT_TABLE.insertEntryAt(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY, 1);
                } else {
                    this.IMPORT_LAYOUT_TABLE.insertEntryAt(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY, 0);
                }
            }
            if (!ContainerUtil.exists((Object[])entries, entry -> entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY)) {
                if (entries[0] == PackageEntry.ALL_MODULE_IMPORTS) {
                    this.IMPORT_LAYOUT_TABLE.insertEntryAt(PackageEntry.ALL_OTHER_IMPORTS_ENTRY, 1);
                } else {
                    this.IMPORT_LAYOUT_TABLE.insertEntryAt(PackageEntry.ALL_OTHER_IMPORTS_ENTRY, 0);
                }
            }
            if (!ContainerUtil.exists((Object[])entries, entry -> entry == PackageEntry.ALL_MODULE_IMPORTS)) {
                this.IMPORT_LAYOUT_TABLE.insertEntryAt(PackageEntry.ALL_MODULE_IMPORTS, 0);
            }
        }
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(2);
        }
        super.writeExternal(parentElement, parentSettings);
        this.writeExternalCollection(parentElement, this.myRepeatAnnotations, REPEAT_ANNOTATIONS, REPEAT_ANNOTATIONS_ITEM);
        this.writeExternalCollection(parentElement, this.myDoNotImportInner, DO_NOT_IMPORT_INNER, DO_NOT_IMPORT_INNER_ITEM);
        this.writeVersion(parentElement);
    }

    private void writeVersion(@NotNull Element parentElement) {
        if (parentElement == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(3);
        }
        if (!this.shouldWriteVersion()) {
            return;
        }
        Element settingsTag = parentElement.getChild(this.getTagName());
        if (settingsTag == null) {
            parentElement.addContent(new Element(this.getTagName()));
            settingsTag = parentElement.getChild(this.getTagName());
        }
        CustomCodeStyleSettingsUtils.writeVersion((Element)settingsTag, (int)this.myVersion);
        this.myOldVersion = this.myVersion;
    }

    private boolean shouldWriteVersion() {
        if (this.myVersion != 1) {
            return false;
        }
        if (this.myOldVersion == this.myVersion) {
            return true;
        }
        return this.myOldVersion == 0 && !this.isFirstMigrationPreserved();
    }

    private boolean isFirstMigrationPreserved() {
        CommonCodeStyleSettings commonSettings = this.getCommonSettings();
        return commonSettings.BLANK_LINES_AROUND_FIELD == this.BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS;
    }

    public static JavaCodeStyleSettings getInstance(@NotNull PsiFile file) {
        if (file == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(4);
        }
        return (JavaCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JavaCodeStyleSettings.class);
    }

    @TestOnly
    public static JavaCodeStyleSettings getInstance(@NotNull Project project) {
        if (project == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(5);
        }
        return (JavaCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class);
    }

    private void readExternalCollection(Element parentElement, Collection<? super String> collection, String collectionName, String itemName) {
        Element child = parentElement.getChild(this.getTagName());
        if (child != null) {
            collection.clear();
            Element item = child.getChild(collectionName);
            if (item != null) {
                for (Element element : item.getChildren(itemName)) {
                    collection.add(element.getAttributeValue(COLLECTION_ITEM_ATTRIBUTE));
                }
            }
        }
    }

    private static JavaCodeStyleSettings getDefaultCustomSettings() {
        return (JavaCodeStyleSettings)CodeStyleSettings.getDefaults().getCustomSettings(JavaCodeStyleSettings.class);
    }

    private CommonCodeStyleSettings getCommonSettings() {
        return this.getContainer().getCommonSettings((Language)JavaLanguage.INSTANCE);
    }

    private void writeExternalCollection(Element parentElement, Collection<String> collection, String collectionName, String itemName) {
        if (!collection.isEmpty()) {
            Element child = parentElement.getChild(this.getTagName());
            if (child == null) {
                child = new Element(this.getTagName());
                parentElement.addContent(child);
            }
            Element element = new Element(collectionName);
            for (String item : collection) {
                element.addContent(new Element(itemName).setAttribute(COLLECTION_ITEM_ATTRIBUTE, item));
            }
            child.addContent(element);
        }
    }

    protected void afterLoaded() {
        this.migrateNonVersionedSettings();
        if (this.myIsInitialized) {
            if (this.myVersion < 1) {
                this.migrateSettingsToVersion1();
            }
            this.myVersion = 1;
        }
    }

    private void migrateSettingsToVersion1() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.getCommonSettings();
        this.BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS = commonCodeStyleSettings.BLANK_LINES_AROUND_FIELD;
    }

    private void migrateNonVersionedSettings() {
        this.REPLACE_INSTANCEOF_AND_CAST |= this.REPLACE_CAST || this.REPLACE_INSTANCEOF;
        this.REPLACE_INSTANCEOF = false;
        this.REPLACE_CAST = false;
    }

    @NotNull
    public List<String> getKnownTagNames() {
        List<String> list = Arrays.asList(this.getTagName(), REPEAT_ANNOTATIONS, DO_NOT_IMPORT_INNER);
        if (list == null) {
            JavaCodeStyleSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        JavaCodeStyleSettings otherSettings = (JavaCodeStyleSettings)((Object)obj);
        if (!this.myRepeatAnnotations.equals(otherSettings.getRepeatAnnotations())) {
            return false;
        }
        return this.myDoNotImportInner.equals(otherSettings.getDoNotImportInner());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/JavaCodeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/JavaCodeStyleSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTagNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importLegacySettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

