/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.xml.impl.dom.AbstractDomChildrenDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementXmlDescriptor
extends AbstractDomChildrenDescriptor
implements XmlHighlightingAwareElementDescriptor {
    private final DomChildrenDescription myChildrenDescription;

    public DomElementXmlDescriptor(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomElementXmlDescriptor.$$$reportNull$$$0(0);
        }
        super(domElement.getManager());
        this.myChildrenDescription = new MyRootDomChildrenDescription(domElement);
    }

    public DomElementXmlDescriptor(@NotNull DomChildrenDescription childrenDescription, DomManager manager) {
        if (childrenDescription == null) {
            DomElementXmlDescriptor.$$$reportNull$$$0(1);
        }
        super(manager);
        this.myChildrenDescription = childrenDescription;
    }

    @Override
    public String getDefaultName() {
        return this.myChildrenDescription.getXmlElementName();
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myChildrenDescription.getDeclaration(this.myManager.getProject());
    }

    @Override
    @NonNls
    public String getName(PsiElement context) {
        String name = this.getDefaultName();
        if (context instanceof XmlTag) {
            XmlTag tag = (XmlTag)context;
            PsiFile file = tag.getContainingFile();
            DomElement element = this.myManager.getDomElement(tag);
            if (element == null && tag.getParentTag() != null) {
                element = this.myManager.getDomElement(tag.getParentTag());
            }
            if (element != null && file instanceof XmlFile && !(this.myChildrenDescription instanceof MyRootDomChildrenDescription)) {
                String s;
                String namespace = DomService.getInstance().getEvaluatedXmlName(element).evaluateChildName(this.myChildrenDescription.getXmlName()).getNamespace(tag, (XmlFile)file);
                if (!tag.getNamespaceByPrefix("").equals(namespace) && StringUtil.isNotEmpty((String)(s = tag.getPrefixByNamespace(namespace)))) {
                    return s + ":" + name;
                }
            }
        }
        return name;
    }

    @Override
    public boolean shouldCheckRequiredAttributes() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "domElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "childrenDescription";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/impl/dom/DomElementXmlDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Presentation(typeName="Root Tag")
    private static class MyRootDomChildrenDescription
    implements DomChildrenDescription {
        private final DomElement myDomElement;

        MyRootDomChildrenDescription(DomElement domElement) {
            this.myDomElement = domElement;
        }

        public String getName() {
            return this.getXmlElementName();
        }

        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public XmlName getXmlName() {
            throw new UnsupportedOperationException("Method getXmlName not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public String getXmlElementName() {
            String string2 = this.myDomElement.getXmlElementName();
            if (string2 == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
            if (strategy == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public String getCommonPresentableName(@NotNull DomElement parent) {
            if (parent == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public List<? extends DomElement> getValues(@NotNull DomElement parent) {
            if (parent == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException("Method getValues not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
            if (parent == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException("Method getStableValues not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public Type getType() {
            throw new UnsupportedOperationException("Method getType not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @NotNull
        public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
            if (parent == null) {
                MyRootDomChildrenDescription.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException("Method getDomNameStrategy not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public <T> T getUserData(Key<T> key2) {
            return null;
        }

        @Override
        public ElementPresentationTemplate getPresentationTemplate() {
            return null;
        }

        @Override
        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            throw new UnsupportedOperationException("Method getAnnotation not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        @Nullable
        public PsiElement getDeclaration(Project project2) {
            return PomService.convertToPsi((Project)project2, (PomTarget)this);
        }

        @Override
        public DomElement getDomDeclaration() {
            return this.myDomElement;
        }

        @Override
        public boolean isStubbed() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getXmlElementName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonPresentableName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getValues";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getStableValues";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDomNameStrategy";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
            };
        }
    }
}

