/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DomImplUtil {
    private static final Logger LOG = Logger.getInstance(DomImplUtil.class);

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement element, String msg) {
        if (element instanceof DomFileElementImpl) {
            String s = ((DomFileElementImpl)element).checkValidity();
            if (s != null) {
                throw new AssertionError((Object)s);
            }
            return;
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element);
        assert (handler2 != null);
        try {
            handler2.assertValid();
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)(msg + ((Throwable)((Object)e)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod method) {
        if (!DomImplUtil.isGetter(method)) {
            return false;
        }
        if (DomImplUtil.hasTagValueAnnotation(method)) {
            return true;
        }
        if ("getValue".equals(method.getName())) {
            if (method.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (method.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (method.getAnnotation(Convert.class) != null || method.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)method.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)method.getReturnType());
        }
        return false;
    }

    private static boolean hasTagValueAnnotation(JavaMethod method) {
        return method.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method) {
        boolean isIs;
        @NonNls String name = method.getName();
        boolean isGet = name.startsWith("get");
        boolean bl = isIs = !isGet && name.startsWith("is");
        if (!isGet && !isIs) {
            return false;
        }
        if (method.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type returnType = method.getGenericReturnType();
        if (isGet) {
            return returnType != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix(returnType);
    }

    public static boolean isTagValueSetter(JavaMethod method) {
        boolean setter = method.getName().startsWith("set") && method.getGenericParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        return setter && (DomImplUtil.hasTagValueAnnotation(method) || "setValue".equals(method.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        Annotation annotation;
        Class<? extends DomNameStrategy> aClass = null;
        if (isAttribute && (annotation = DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass == null && (annotation = DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass != null) {
            if (HyphenNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static @Unmodifiable List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name, XmlFile file) {
        if (tag == null) {
            DomImplUtil.$$$reportNull$$$0(0);
        }
        return DomImplUtil.findSubTags(tag, name, file, false);
    }

    static @Unmodifiable List<XmlTag> findSubTags(@NotNull XmlTag tag, EvaluatedXmlName name, XmlFile file, boolean processIncludes) {
        Object[] tags;
        if (tag == null) {
            DomImplUtil.$$$reportNull$$$0(1);
        }
        if (!tag.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] objectArray = tags = tag instanceof XmlTagImpl ? ((XmlTagImpl)tag).getSubTags(processIncludes) : tag.getSubTags();
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> {
            ProgressManager.checkCanceled();
            try {
                return DomImplUtil.isNameSuitable(name, childTag, file);
            }
            catch (PsiInvalidElementAccessException e) {
                if (!childTag.isValid()) {
                    LOG.error("tag.getSubTags() returned invalid, tag=" + String.valueOf(tag) + ", containing file: " + String.valueOf(tag.getContainingFile()) + "subTag.parent=" + String.valueOf(childTag.getNode().getTreeParent()));
                    return false;
                }
                throw e;
            }
        });
    }

    public static @Unmodifiable List<XmlTag> findSubTags(XmlTag[] tags, EvaluatedXmlName name, XmlFile file) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> DomImplUtil.isNameSuitable(name, childTag, file));
    }

    public static boolean isNameSuitable(XmlName name, XmlTag tag, @NotNull DomInvocationHandler handler2, XmlFile file) {
        if (handler2 == null) {
            DomImplUtil.$$$reportNull$$$0(2);
        }
        return DomImplUtil.isNameSuitable(handler2.createEvaluatedXmlName(name), tag, file);
    }

    private static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, XmlTag tag, XmlFile file) {
        String evaluatedLocalName = evaluatedXmlName.getXmlName().getLocalName();
        boolean qNameMatch = evaluatedLocalName.equals(tag.getName());
        return (qNameMatch || evaluatedLocalName.equals(tag.getLocalName())) && evaluatedXmlName.isNamespaceAllowed(tag.getNamespace(), file, !qNameMatch);
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, Type type, @Nullable JavaMethod javaMethod) {
        Class<?> aClass;
        if (name == null) {
            DomImplUtil.$$$reportNull$$$0(3);
        }
        if ((aClass = DomImplUtil.getErasure(type)) == null) {
            return null;
        }
        String key2 = DomImplUtil.getNamespaceKey(aClass);
        if (key2 == null && javaMethod != null) {
            for (Method method : javaMethod.getHierarchy()) {
                String key1 = DomImplUtil.getNamespaceKey(method.getDeclaringClass());
                if (key1 == null) continue;
                return new XmlName(name, key1);
            }
        }
        return new XmlName(name, key2);
    }

    @Nullable
    private static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.getErasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    private static String getNamespaceKey(@NotNull Class<?> type) {
        Namespace namespace;
        if (type == null) {
            DomImplUtil.$$$reportNull$$$0(4);
        }
        return (namespace = DomReflectionUtil.findAnnotationDFS(type, Namespace.class)) != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, JavaMethod method) {
        if (name == null) {
            DomImplUtil.$$$reportNull$$$0(5);
        }
        return DomImplUtil.createXmlName(name, method.getGenericReturnType(), method);
    }

    public static @Unmodifiable List<XmlTag> getCustomSubTags(DomInvocationHandler handler2, XmlTag[] subTags, XmlFile file) {
        if (subTags.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx info = handler2.getGenericInfo();
        HashSet<XmlName> usedNames = new HashSet<XmlName>();
        List<? extends DomCollectionChildDescription> collectionChildrenDescriptions = info.getCollectionChildrenDescriptions();
        int size = collectionChildrenDescriptions.size();
        for (int i = 0; i < size; ++i) {
            DomCollectionChildDescription description = collectionChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        List<? extends DomFixedChildDescription> fixedChildrenDescriptions = info.getFixedChildrenDescriptions();
        int size2 = fixedChildrenDescriptions.size();
        for (int i = 0; i < size2; ++i) {
            DomFixedChildDescription description = fixedChildrenDescriptions.get(i);
            usedNames.add(description.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, tag -> {
            if (StringUtil.isEmpty((String)tag.getLocalName())) {
                return false;
            }
            for (XmlName name : usedNames) {
                if (!DomImplUtil.isNameSuitable(name, tag, handler2, file)) continue;
                return false;
            }
            return true;
        });
    }

    static XmlFile getFile(DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (handler2 != null) : domElement;
        while (!(handler2 instanceof DomRootInvocationHandler)) {
            XmlTag tag = handler2.getXmlTag();
            if (tag != null) {
                return DomImplUtil.getContainingFile(tag);
            }
            DomInvocationHandler parent = handler2.getParentHandler();
            if (parent == null) {
                throw new AssertionError((Object)("No parent for " + handler2.toStringEx()));
            }
            handler2 = parent;
        }
        return ((DomFileElementImpl)((DomRootInvocationHandler)handler2).getParent()).getFile();
    }

    private static XmlFile getContainingFile(XmlTag tag) {
        PsiElement parentTag;
        while ((parentTag = PhysicalDomParentStrategy.getParentTagCandidate(tag)) instanceof XmlTag) {
            tag = (XmlTag)parentTag;
        }
        return (XmlFile)tag.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/impl/DomImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameSuitable";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createXmlName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamespaceKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

