/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConverterManagerImpl
implements ConverterManager {
    private final Map<Class<?>, Converter<?>> mySimpleConverters = new HashMap();

    protected ConverterManagerImpl() {
        this.mySimpleConverters.put(Byte.TYPE, new NumberValueConverter<Byte>(Byte.TYPE, false));
        this.mySimpleConverters.put(Byte.class, new NumberValueConverter<Byte>(Byte.class, true));
        this.mySimpleConverters.put(Short.TYPE, new NumberValueConverter<Short>(Short.TYPE, false));
        this.mySimpleConverters.put(Short.class, new NumberValueConverter<Short>(Short.class, true));
        this.mySimpleConverters.put(Integer.TYPE, new NumberValueConverter<Integer>(Integer.TYPE, false));
        this.mySimpleConverters.put(Integer.class, new NumberValueConverter<Integer>(Integer.class, false));
        this.mySimpleConverters.put(Long.TYPE, new NumberValueConverter<Long>(Long.TYPE, false));
        this.mySimpleConverters.put(Long.class, new NumberValueConverter<Long>(Long.class, true));
        this.mySimpleConverters.put(Float.TYPE, new NumberValueConverter<Float>(Float.TYPE, false));
        this.mySimpleConverters.put(Float.class, new NumberValueConverter<Float>(Float.class, true));
        this.mySimpleConverters.put(Double.TYPE, new NumberValueConverter<Double>(Double.TYPE, false));
        this.mySimpleConverters.put(Double.class, new NumberValueConverter<Double>(Double.class, true));
        this.mySimpleConverters.put(BigDecimal.class, new NumberValueConverter<BigDecimal>(BigDecimal.class, true));
        this.mySimpleConverters.put(BigInteger.class, new NumberValueConverter<BigInteger>(BigInteger.class, true));
        this.mySimpleConverters.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(String.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(Object.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    protected void addConverter(Class<?> clazz, Converter<?> converter) {
        this.mySimpleConverters.put(clazz, converter);
    }

    @Override
    @NotNull
    public final Converter<?> getConverterInstance(Class<? extends Converter> converterClass) {
        Converter converter = ConverterManagerImpl.getOrCreateConverterInstance(converterClass);
        assert (converter != null) : "Converter not found for " + String.valueOf(converterClass);
        Converter converter2 = converter;
        if (converter2 == null) {
            ConverterManagerImpl.$$$reportNull$$$0(0);
        }
        return converter2;
    }

    static <T> T getOrCreateConverterInstance(Class<T> clazz) {
        return ((MyClassValue)DomImplementationClassEP.CONVERTER_EP_NAME.computeIfAbsent(ConverterManagerImpl.class, () -> new MyClassValue())).get(clazz);
    }

    @Override
    @Nullable
    public final Converter<?> getConverterByClass(Class<?> convertingClass) {
        Converter<?> converter = this.mySimpleConverters.get(convertingClass);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(convertingClass)) {
            return EnumConverter.createEnumConverter(convertingClass);
        }
        if (DomElement.class.isAssignableFrom(convertingClass)) {
            return DomResolveConverter.createConverter(convertingClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ConverterManagerImpl", "getConverterInstance"));
    }

    private static final class MyClassValue
    extends ClassValue<Object> {
        private final ImplementationClassCache implementationClassCache = new ImplementationClassCache(DomImplementationClassEP.CONVERTER_EP_NAME);

        private MyClassValue() {
        }

        @Override
        protected Object computeValue(Class<?> key2) {
            Class<?> implementation = this.implementationClassCache.get(key2);
            Class<?> aClass = implementation == null ? key2 : implementation;
            try {
                Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Couldn't instantiate " + String.valueOf(aClass), e);
            }
        }
    }
}

