/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelimitedListConverter<T>
extends ResolvingConverter<List<T>>
implements CustomReferenceConverter<List<T>> {
    protected static final Object[] EMPTY_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    private final String myDelimiters;

    public DelimitedListConverter(@NonNls @NotNull String delimiters) {
        if (delimiters == null) {
            DelimitedListConverter.$$$reportNull$$$0(0);
        }
        this.myDelimiters = delimiters;
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, @NotNull ConvertContext var2);

    @Nullable
    protected abstract String toString(@Nullable T var1);

    protected abstract Object[] getReferenceVariants(@NotNull ConvertContext var1, GenericDomValue<? extends List<T>> var2);

    @Nullable
    protected abstract PsiElement resolveReference(@Nullable T var1, @NotNull ConvertContext var2);

    @InspectionMessage
    protected abstract String getUnresolvedMessage(String var1);

    @Override
    @NotNull
    public Collection<? extends List<T>> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            DelimitedListConverter.$$$reportNull$$$0(1);
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            DelimitedListConverter.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public static <T> void filterVariants(List<T> variants, GenericDomValue<? extends List<T>> genericDomValue) {
        List list2 = (List)genericDomValue.getValue();
        if (list2 != null) {
            Iterator<T> i = variants.iterator();
            block0: while (i.hasNext()) {
                T variant = i.next();
                for (Object existing : list2) {
                    if (!existing.equals(variant)) continue;
                    i.remove();
                    continue block0;
                }
            }
        }
    }

    protected char getDefaultDelimiter() {
        return this.myDelimiters.charAt(0);
    }

    @Override
    public List<T> fromString(@Nullable String str, @NotNull ConvertContext context) {
        if (context == null) {
            DelimitedListConverter.$$$reportNull$$$0(3);
        }
        if (str == null) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        for (String s : StringUtil.tokenize((String)str, (String)this.myDelimiters)) {
            T t = this.convertString(s.trim(), context);
            if (t == null) continue;
            values.add(t);
        }
        return values;
    }

    @Override
    public String toString(List<T> ts, @NotNull ConvertContext context) {
        if (context == null) {
            DelimitedListConverter.$$$reportNull$$$0(4);
        }
        StringBuilder buffer = new StringBuilder();
        char delimiter = this.getDefaultDelimiter();
        for (T t : ts) {
            String s = this.toString(t);
            if (s == null) continue;
            if (!buffer.isEmpty()) {
                buffer.append(delimiter);
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    @Override
    public PsiReference @NotNull [] createReferences(final GenericDomValue<List<T>> genericDomValue, final PsiElement element, final ConvertContext context) {
        String text2 = genericDomValue.getRawText();
        if (text2 == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DelimitedListConverter.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final ArrayList references = new ArrayList();
        new DelimitedListProcessor(this.myDelimiters){

            protected void processToken(int start2, int end, boolean delimitersOnly) {
                references.add(DelimitedListConverter.this.createPsiReference(element, start2 + 1, end + 1, context, genericDomValue, delimitersOnly));
            }
        }.processText(text2);
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            DelimitedListConverter.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start2, int end, @NotNull ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean delimitersOnly) {
        if (context == null) {
            DelimitedListConverter.$$$reportNull$$$0(7);
        }
        return new MyPsiReference(this, element, this.getTextRange(genericDomValue, start2, end), context, genericDomValue, delimitersOnly);
    }

    protected TextRange getTextRange(GenericDomValue value, int start2, int end) {
        if (value instanceof GenericAttributeValue) {
            return new TextRange(start2, end);
        }
        TextRange tagRange = XmlTagUtil.getTrimmedValueRange(value.getXmlTag());
        return new TextRange(tagRange.getStartOffset() + start2 - 1, tagRange.getStartOffset() + end - 1);
    }

    public String toString() {
        return super.toString() + " delimiters: " + this.myDelimiters;
    }

    protected PsiElement referenceBindToElement(PsiReference psiReference, PsiElement element, Function<? super PsiElement, ? extends PsiElement> superBindToElementFunction, Function<? super String, ? extends PsiElement> superElementRenameFunction) throws IncorrectOperationException {
        return (PsiElement)superBindToElementFunction.fun((Object)element);
    }

    protected PsiElement referenceHandleElementRename(PsiReference psiReference, String newName, Function<? super String, ? extends PsiElement> superHandleElementRename) throws IncorrectOperationException {
        return (PsiElement)superHandleElementRename.fun((Object)newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/DelimitedListConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/DelimitedListConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPsiReference";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 5, 6 -> new IllegalStateException(string2);
        };
    }

    protected class MyPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<List<T>> myGenericDomValue;
        private final boolean myDelimitersOnly;
        final /* synthetic */ DelimitedListConverter this$0;

        public MyPsiReference(DelimitedListConverter this$0, PsiElement element, @NotNull TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean delimitersOnly) {
            if (context == null) {
                MyPsiReference.$$$reportNull$$$0(0);
            }
            this(this$0, element, range, context, genericDomValue, true, delimitersOnly);
        }

        public MyPsiReference(DelimitedListConverter this$0, PsiElement element, @NotNull TextRange range, ConvertContext context, GenericDomValue<List<T>> genericDomValue, boolean soft, boolean delimitersOnly) {
            if (context == null) {
                MyPsiReference.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            super(element, range, soft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
            this.myDelimitersOnly = delimitersOnly;
        }

        @Nullable
        public PsiElement resolve() {
            if (this.myDelimitersOnly) {
                return this.getElement();
            }
            String value = this.getValue();
            return this.this$0.resolveReference(this.this$0.convertString(value, this.myContext), this.myContext);
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = this.this$0.getReferenceVariants(this.myContext, this.myGenericDomValue);
            if (objectArray == null) {
                MyPsiReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyPsiReference.$$$reportNull$$$0(3);
            }
            Ref ref = new Ref();
            PsiElement element = this.this$0.referenceHandleElementRename((PsiReference)this, newElementName, this.getSuperElementRenameFunction((Ref<? super IncorrectOperationException>)ref));
            if (!ref.isNull()) {
                throw (IncorrectOperationException)((Object)ref.get());
            }
            return element;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyPsiReference.$$$reportNull$$$0(4);
            }
            Ref ref = new Ref();
            PsiElement bindElement = this.this$0.referenceBindToElement((PsiReference)this, element, this.getSuperBindToElementFunction((Ref<? super IncorrectOperationException>)ref), this.getSuperElementRenameFunction((Ref<? super IncorrectOperationException>)ref));
            if (!ref.isNull()) {
                throw (IncorrectOperationException)((Object)ref.get());
            }
            return bindElement;
        }

        public String toString() {
            return super.toString() + " converter: " + String.valueOf(this.this$0);
        }

        private Function<PsiElement, PsiElement> getSuperBindToElementFunction(Ref<? super IncorrectOperationException> ref) {
            return s -> {
                try {
                    return super.bindToElement(s);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                    return null;
                }
            };
        }

        private Function<String, PsiElement> getSuperElementRenameFunction(Ref<? super IncorrectOperationException> ref) {
            return s -> {
                try {
                    return super.handleElementRename(s);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                    return null;
                }
            };
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string2 = this.this$0.getUnresolvedMessage(this.getValue());
            if (string2 == null) {
                MyPsiReference.$$$reportNull$$$0(5);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/converters/DelimitedListConverter$MyPsiReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/converters/DelimitedListConverter$MyPsiReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 5 -> new IllegalStateException(string2);
            };
        }
    }
}

