/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SchemaReferencesProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String VALUE_ATTR_NAME = "value";
    @NonNls
    static final String NAME_ATTR_NAME = "name";
    @NonNls
    static final String MEMBER_TYPES_ATTR_NAME = "memberTypes";
    @NonNls
    static final String ITEM_TYPE_ATTR_NAME = "itemType";
    @NonNls
    static final String BASE_ATTR_NAME = "base";
    @NonNls
    public static final String GROUP_TAG_NAME = "group";
    @NonNls
    public static final String ATTRIBUTE_GROUP_TAG_NAME = "attributeGroup";
    @NonNls
    public static final String ATTRIBUTE_TAG_NAME = "attribute";
    @NonNls
    public static final String ELEMENT_TAG_NAME = "element";
    @NonNls
    public static final String SIMPLE_TYPE_TAG_NAME = "simpleType";
    @NonNls
    public static final String COMPLEX_TYPE_TAG_NAME = "complexType";
    @NonNls
    static final String REF_ATTR_NAME = "ref";
    @NonNls
    static final String TYPE_ATTR_NAME = "type";
    @NonNls
    static final String SUBSTITUTION_GROUP_ATTR_NAME = "substitutionGroup";

    public String[] getCandidateAttributeNamesForSchemaReferences() {
        return new String[]{REF_ATTR_NAME, TYPE_ATTR_NAME, BASE_ATTR_NAME, NAME_ATTR_NAME, SUBSTITUTION_GROUP_ATTR_NAME, MEMBER_TYPES_ATTR_NAME, VALUE_ATTR_NAME, ITEM_TYPE_ATTR_NAME};
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        String attrName;
        PsiElement parent;
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(1);
        }
        if (!((parent = element.getParent()) instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SchemaReferencesProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        switch (attrName = ((XmlAttribute)parent).getName()) {
            case "value": {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
                break;
            }
            case "name": {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = new NameReference(element);
                break;
            }
            case "memberTypes": {
                ArrayList<TypeOrElementOrAttributeReference> result2 = new ArrayList<TypeOrElementOrAttributeReference>(1);
                String text2 = element.getText();
                int lastIndex = 1;
                int testLength = text2.length();
                for (int i = 1; i < testLength; ++i) {
                    if (!Character.isWhitespace(text2.charAt(i))) continue;
                    if (lastIndex != i) {
                        result2.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, i)));
                    }
                    lastIndex = i + 1;
                }
                if (lastIndex != testLength - 1) {
                    result2.add(new TypeOrElementOrAttributeReference(element, new TextRange(lastIndex, testLength - 1)));
                }
                psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
                break;
            }
            default: {
                PsiReference prefix = SchemaReferencesProvider.createSchemaPrefixReference(element);
                PsiReference ref = SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, prefix == null ? null : prefix.getCanonicalText());
                if (prefix == null) {
                    PsiReference[] psiReferenceArray3 = new PsiReference[1];
                    psiReferenceArray = psiReferenceArray3;
                    psiReferenceArray3[0] = ref;
                    break;
                }
                PsiReference[] psiReferenceArray4 = new PsiReference[2];
                psiReferenceArray4[0] = ref;
                psiReferenceArray = psiReferenceArray4;
                psiReferenceArray4[1] = prefix;
                break;
            }
        }
        if (psiReferenceArray == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element) {
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(4);
        }
        return SchemaReferencesProvider.createTypeOrElementOrAttributeReference(element, null);
    }

    public static PsiReference createTypeOrElementOrAttributeReference(@NotNull PsiElement element, String ns) {
        int offset;
        if (element == null) {
            SchemaReferencesProvider.$$$reportNull$$$0(5);
        }
        int length = element.getTextLength();
        int n = offset = element instanceof XmlAttributeValue ? XmlUtil.findPrefixByQualifiedName(((XmlAttributeValue)element).getValue()).length() : 0;
        if (offset > 0) {
            ++offset;
        }
        TypeOrElementOrAttributeReference ref = new TypeOrElementOrAttributeReference(element, length >= 2 ? new TextRange(1 + offset, length - 1) : TextRange.EMPTY_RANGE);
        ref.setNamespacePrefix(ns);
        return ref;
    }

    @Nullable
    private static PsiReference createSchemaPrefixReference(PsiElement element) {
        XmlAttributeValue attributeValue;
        String prefix;
        if (element instanceof XmlAttributeValue && !(prefix = XmlUtil.findPrefixByQualifiedName((attributeValue = (XmlAttributeValue)element).getValue())).isEmpty()) {
            return new SchemaPrefixReference(attributeValue, TextRange.from((int)1, (int)prefix.length()), prefix, null);
        }
        return null;
    }

    @Nullable
    public static XmlNSDescriptorImpl findRedefinedDescriptor(XmlTag tag, String text2) {
        String localName = XmlUtil.findLocalNameByQualifiedName(text2);
        for (XmlTag parentTag = tag.getParentTag(); parentTag != null; parentTag = parentTag.getParentTag()) {
            XmlTag grandParent;
            if (!localName.equals(parentTag.getAttributeValue(NAME_ATTR_NAME)) || (grandParent = parentTag.getParentTag()) == null || !"redefine".equals(grandParent.getLocalName())) continue;
            return XmlNSDescriptorImpl.getRedefinedElementDescriptor(grandParent);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_TAG_NAME;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOrElementOrAttributeReference";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }

    public static final class NameReference
    implements PsiReference {
        private final PsiElement myElement;

        public NameReference(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                NameReference.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            if (textRange == null) {
                NameReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myElement.getParent().getParent();
        }

        @NotNull
        public String getCanonicalText() {
            String text2 = this.myElement.getText();
            String string2 = text2.substring(1, text2.length() - 1);
            if (string2 == null) {
                NameReference.$$$reportNull$$$0(2);
            }
            return string2;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                NameReference.$$$reportNull$$$0(3);
            }
            return ElementManipulators.handleContentChange((PsiElement)this.myElement, (TextRange)this.getRangeInElement(), (String)newElementName.substring(newElementName.indexOf(58) + 1));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                NameReference.$$$reportNull$$$0(4);
            }
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                NameReference.$$$reportNull$$$0(5);
            }
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = SchemaReferencesProvider.ELEMENT_TAG_NAME;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/SchemaReferencesProvider$NameReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 3, 4, 5 -> new IllegalArgumentException(string2);
            };
        }
    }
}

