/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyAdapter;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.IXmlTagElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class XmlWhiteSpaceFormattingStrategy
extends WhiteSpaceFormattingStrategyAdapter {
    private static void addWhitespaceToTagBody(ASTNode treePrev, LeafElement whiteSpaceElement) {
        boolean before2;
        XmlText xmlText;
        CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)treePrev);
        ASTNode treeParent = treePrev.getTreeParent();
        if (treePrev.getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getPsi();
            before2 = true;
        } else if (treePrev.getTreePrev().getElementType() == XmlElementType.XML_TEXT) {
            xmlText = (XmlText)treePrev.getTreePrev().getPsi();
            before2 = false;
        } else {
            xmlText = (XmlText)Factory.createCompositeElement((IElementType)XmlElementType.XML_TEXT, (CharTable)charTable, (PsiManager)treeParent.getPsi().getManager());
            CodeEditUtil.setNodeGenerated((ASTNode)xmlText.getNode(), (boolean)true);
            treeParent.addChild(xmlText.getNode(), treePrev);
            before2 = true;
        }
        ASTNode node = xmlText.getNode();
        assert (node != null);
        TreeElement anchorInText = (TreeElement)(before2 ? node.getFirstChildNode() : node.getLastChildNode());
        if (anchorInText == null) {
            node.addChild((ASTNode)whiteSpaceElement);
        } else if (anchorInText.getElementType() != XmlTokenType.XML_WHITE_SPACE) {
            node.addChild((ASTNode)whiteSpaceElement, (ASTNode)(before2 ? anchorInText : null));
        } else {
            String text2 = before2 ? whiteSpaceElement.getText() + anchorInText.getText() : anchorInText.getText() + whiteSpaceElement.getText();
            node.replaceChild((ASTNode)anchorInText, (ASTNode)ASTFactory.whitespace((CharSequence)text2));
        }
    }

    protected boolean isInsideTagBody(@NotNull ASTNode place) {
        ASTNode treeParent;
        if (place == null) {
            XmlWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        if (!((treeParent = place.getTreeParent()).getElementType() instanceof IXmlTagElementType)) {
            return false;
        }
        while (place != null) {
            if (place.getElementType() == XmlTokenType.XML_TAG_END) {
                return true;
            }
            place = place.getTreePrev();
        }
        return false;
    }

    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            XmlWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        if (whiteSpaceElement == null) {
            XmlWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        if (this.isInsideTagBody(treePrev)) {
            XmlWhiteSpaceFormattingStrategy.addWhitespaceToTagBody(treePrev, whiteSpaceElement);
            return true;
        }
        return false;
    }

    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            XmlWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        return node.getElementType() == XmlTokenType.XML_DATA_CHARACTERS && node.getText().trim().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePrev";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/xml/XmlWhiteSpaceFormattingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideTagBody";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addWhitespace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "containsWhitespacesOnly";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

