/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.html.embedding.BasicHtmlRawTextElementFactory;
import com.intellij.html.embedding.HtmlCustomEmbeddedContentTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.html.BasicHtmlElementFactory;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.html.HtmlRawTextImpl;
import com.intellij.psi.impl.source.xml.stub.XmlStubBasedElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.UnsupportedNodeElementTypeException;
import com.intellij.psi.xml.XmlElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/html/BackendHtmlElementFactory;", "Lcom/intellij/lang/html/BasicHtmlElementFactory;", "Lcom/intellij/html/embedding/BasicHtmlRawTextElementFactory;", "<init>", "()V", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createRawTextElement", "intellij.xml.psi.impl"})
public final class BackendHtmlElementFactory
implements BasicHtmlElementFactory,
BasicHtmlRawTextElementFactory {
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return new HtmlFileImpl(viewProvider);
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (elementType instanceof XmlStubBasedElementType) {
            Object PsiT = ((XmlStubBasedElementType)elementType).createPsi(node);
            object = PsiT;
            Intrinsics.checkNotNullExpressionValue(PsiT, (String)"createPsi(...)");
        } else if (elementType instanceof HtmlCustomEmbeddedContentTokenType) {
            object = ((HtmlCustomEmbeddedContentTokenType)elementType).createPsi(node);
        } else if (elementType == XmlElementType.HTML_EMBEDDED_CONTENT) {
            object = new HtmlEmbeddedContentImpl(node);
        } else {
            throw new UnsupportedNodeElementTypeException(node);
        }
        return object;
    }

    @NotNull
    public PsiElement createRawTextElement(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new HtmlRawTextImpl(node);
    }
}

