/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.documentation.mdn;

import com.intellij.documentation.mdn.BaselineData;
import com.intellij.documentation.mdn.BaselineLevel;
import com.intellij.documentation.mdn.MdnApiStatus;
import com.intellij.documentation.mdn.MdnBundle;
import com.intellij.documentation.mdn.MdnDocumentation;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnJavaScriptRuntime;
import com.intellij.documentation.mdn.MdnRawSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolsBundle;
import com.intellij.xml.frontback.impl.icons.XmlFrontbackImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J%\u0010\u001a\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001fH\u0016J\f\u0010!\u001a\u00020\u0003*\u00020\u0003H\u0002J\b\u0010\"\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020\u0003*\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00030\u0015H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter;", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "name", "", "source", "Lcom/intellij/documentation/mdn/MdnDocumentation;", "doc", "Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;", "<init>", "(Ljava/lang/String;Lcom/intellij/documentation/mdn/MdnDocumentation;Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;)V", "getName", "()Ljava/lang/String;", "url", "getUrl", "apiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "description", "getDescription", "sections", "", "getSections", "()Ljava/util/Map;", "footnote", "getFootnote", "getDocumentation", "withDefinition", "", "Lcom/intellij/openapi/util/NlsSafe;", "additionalSectionsContent", "Ljava/util/function/Consumer;", "Ljava/lang/StringBuilder;", "fixUrls", "renderBaseline", "renderList", "Lcom/intellij/documentation/mdn/MdnJavaScriptRuntime;", "intellij.xml.psi.impl"})
@SourceDebugExtension(value={"SMAP\nMdnDocumentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnDocumentation.kt\ncom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,836:1\n1#2:837\n1#2:859\n1863#3,2:838\n774#3:844\n865#3,2:845\n1611#3,9:849\n1863#3:858\n1864#3:860\n1620#3:861\n1557#3:862\n1628#3,3:863\n126#4:840\n153#4,3:841\n216#4,2:847\n413#5,4:866\n648#5,5:870\n*S KotlinDebug\n*F\n+ 1 MdnDocumentation.kt\ncom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter\n*L\n322#1:859\n235#1:838,2\n274#1:844\n274#1:845,2\n322#1:849,9\n322#1:858\n322#1:860\n322#1:861\n325#1:862\n325#1:863,3\n251#1:840\n251#1:841,3\n304#1:847,2\n328#1:866,4\n330#1:870,5\n*E\n"})
public final class MdnSymbolDocumentationAdapter
implements MdnSymbolDocumentation {
    @NotNull
    private final String name;
    @NotNull
    private final MdnDocumentation source;
    @NotNull
    private final MdnRawSymbolDocumentation doc;

    public MdnSymbolDocumentationAdapter(@NotNull String name, @NotNull MdnDocumentation source, @NotNull MdnRawSymbolDocumentation doc) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.name = name;
        this.source = source;
        this.doc = doc;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getUrl() {
        String string2;
        String string3 = this.doc.getUrl();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = MdnDocumentationKt.access$fixMdnUrls(it, this.source.getLang());
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    @NotNull
    public WebSymbolApiStatus getApiStatus() {
        Set<MdnApiStatus> set;
        block4: {
            block3: {
                set = this.doc.getStatus();
                if (set == null) break block3;
                Set<MdnApiStatus> it = set;
                boolean bl = false;
                WebSymbolApiStatus webSymbolApiStatus = it.contains((Object)MdnApiStatus.Obsolete) ? (WebSymbolApiStatus)WebSymbolApiStatus.Obsolete : (it.contains((Object)MdnApiStatus.Deprecated) ? (WebSymbolApiStatus)WebSymbolApiStatus.Deprecated : (it.contains((Object)MdnApiStatus.Experimental) ? (WebSymbolApiStatus)WebSymbolApiStatus.Experimental : null));
                set = webSymbolApiStatus;
                if (webSymbolApiStatus != null) break block4;
            }
            set = WebSymbolApiStatus.Stable;
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getDescription() {
        String string2;
        MdnSymbolDocumentationAdapter mdnSymbolDocumentationAdapter;
        String string3;
        block6: {
            block5: {
                String string4;
                void it;
                string3 = this.renderBaseline();
                mdnSymbolDocumentationAdapter = this;
                string2 = this.doc.getDoc();
                if (string2 == null) break block5;
                String string5 = string2;
                MdnSymbolDocumentationAdapter mdnSymbolDocumentationAdapter2 = mdnSymbolDocumentationAdapter;
                String string6 = string3;
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"```", (boolean)false, (int)2, null)) {
                    Project project2 = DefaultProjectFactory.getInstance().getDefaultProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
                    string4 = DocMarkdownToHtmlConverter.convert$default((Project)project2, (String)it, null, (int)4, null);
                } else {
                    string4 = string5;
                }
                String string7 = string4;
                string3 = string6;
                mdnSymbolDocumentationAdapter = mdnSymbolDocumentationAdapter2;
                String string8 = string7;
                string2 = string8;
                if (string8 != null) break block6;
            }
            string2 = "";
        }
        String string9 = StringUtil.capitalize((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"capitalize(...)");
        return string3 + mdnSymbolDocumentationAdapter.fixUrls(string9);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getSections() {
        void $this$mapTo$iv$iv;
        Sequence $i$f$forEach2;
        Object element$iv;
        Object object;
        Iterable<MdnApiStatus> $this$forEach$iv;
        Map result2 = MapsKt.toMutableMap(this.doc.getSections());
        if (this.doc.getCompatibility() != null && this.doc.getBaseline() == null) {
            Map<String, Map<MdnJavaScriptRuntime, String>> map = this.doc.getCompatibility();
            Intrinsics.checkNotNull(map);
            $this$forEach$iv = map.entrySet();
            boolean $i$f$forEach2 = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                String string2;
                element$iv = object.next();
                Map.Entry entry2 = (Map.Entry)element$iv;
                boolean bl = false;
                String id = (String)entry2.getKey();
                Map map2 = (Map)entry2.getValue();
                String actualId = Intrinsics.areEqual((Object)id, (Object)"default_context") ? "browser_compatibility" : id;
                String bundleKey = "mdn.documentation.section.compat." + actualId;
                if (StringsKt.startsWith$default((String)actualId, (String)"support_of_", (boolean)false, (int)2, null) && !MdnBundle.hasKey(bundleKey)) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)actualId.substring(11), (String)"substring(...)");
                    var13_18 = MdnBundle.message("mdn.documentation.section.compat.support_of", objectArray);
                    Intrinsics.checkNotNull((Object)var13_18);
                    string2 = var13_18;
                } else {
                    var13_18 = MdnBundle.message(bundleKey, new Object[0]);
                    Intrinsics.checkNotNull((Object)var13_18);
                    string2 = var13_18;
                }
                String sectionName = string2;
                result2.put(sectionName, this.renderList(map2));
            }
        }
        if (($this$forEach$iv = this.doc.getStatus()) != null && ($i$f$forEach2 = CollectionsKt.asSequence((Iterable)$this$forEach$iv)) != null && (object = SequencesKt.filter((Sequence)$i$f$forEach2, MdnSymbolDocumentationAdapter::_get_sections_$lambda$4)) != null && (element$iv = SequencesKt.map((Sequence)object, MdnSymbolDocumentationAdapter::_get_sections_$lambda$5)) != null) {
            MapsKt.toMap((Sequence)element$iv, (Map)result2);
        }
        Map $this$map$iv = result2;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key2 = (String)entry3.getKey();
            String value = (String)entry3.getValue();
            collection.add(new Pair((Object)this.fixUrls(key2), (Object)this.fixUrls(value)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public String getFootnote() {
        return this.fixUrls("By <a href='" + this.doc.getUrl() + "/contributors.txt'>Mozilla Contributors</a>, <a href='https://creativecommons.org/licenses/by-sa/2.5/'>CC BY-SA 2.5</a>");
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition) {
        return this.getDocumentation(withDefinition, null);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition, @Nullable Consumer<StringBuilder> additionalSectionsContent) {
        return MdnDocumentationKt.access$buildDoc(this, withDefinition, additionalSectionsContent);
    }

    private final String fixUrls(String $this$fixUrls) {
        CharSequence charSequence = $this$fixUrls;
        Regex regex = new Regex("<a[ \n\t]+href=[ \t]*['\"]#([^'\"]*)['\"]");
        String string2 = this.doc.getUrl();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = "<a href=\"" + Regex.Companion.escapeReplacement(string2) + "#$1\"";
        return MdnDocumentationKt.access$fixMdnUrls(regex.replace(charSequence, string3), this.source.getLang());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String renderBaseline() {
        StringBuilder result2;
        block24: {
            StringBuilder stringBuilder;
            block26: {
                String string2;
                StringBuilder stringBuilder2;
                String string3;
                Object[] objectArray;
                StringBuilder stringBuilder3;
                block20: {
                    int n;
                    void $this$takeWhile$iv;
                    block28: {
                        block27: {
                            String string4;
                            String string5;
                            block19: {
                                BaselineData baseline;
                                block25: {
                                    Collection<String> collection;
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    void $this$mapNotNullTo$iv$iv;
                                    void $this$mapNotNull$iv;
                                    Object id;
                                    Set notSupportedEngines;
                                    Object it;
                                    block22: {
                                        Iterator<Map.Entry<String, Map<MdnJavaScriptRuntime, String>>> $i$f$filter2;
                                        Object destination$iv$iv;
                                        block23: {
                                            block21: {
                                                Set set;
                                                Map<MdnJavaScriptRuntime, String> supportedEngines;
                                                BaselineData baselineData = this.doc.getBaseline();
                                                if (baselineData == null) {
                                                    return "";
                                                }
                                                baseline = baselineData;
                                                Map<String, Map<MdnJavaScriptRuntime, String>> map = this.doc.getCompatibility();
                                                Map<MdnJavaScriptRuntime, String> map2 = supportedEngines = map != null ? map.get("default_context") : null;
                                                if (map2 == null) {
                                                    set = null;
                                                } else {
                                                    void $this$filterTo$iv$iv;
                                                    it = map2;
                                                    boolean bl = false;
                                                    Iterable $this$filter$iv = MdnDocumentationKt.getBASELINE_BROWSERS();
                                                    boolean $i$f$filter2 = false;
                                                    Iterable iterable = $this$filter$iv;
                                                    destination$iv$iv = new ArrayList();
                                                    boolean $i$f$filterTo = false;
                                                    for (Object t : $this$filterTo$iv$iv) {
                                                        MdnJavaScriptRuntime it2 = (MdnJavaScriptRuntime)((Object)t);
                                                        boolean bl2 = false;
                                                        if (!(supportedEngines.get((Object)it2) == null)) continue;
                                                        destination$iv$iv.add(t);
                                                    }
                                                    set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                                                }
                                                notSupportedEngines = set;
                                                result2 = new StringBuilder();
                                                it = this.doc.getCompatibility();
                                                StringBuilder stringBuilder4 = !(it == null || it.isEmpty()) ? result2.append("<details class='mdn-baseline'><summary>\n") : result2.append("<div>\n");
                                                String string6 = XmlFrontbackImplIcons.class.getName();
                                                String string7 = baseline.getLevel().name().toLowerCase(Locale.ROOT);
                                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                                                result2.append("<table class='mdn-baseline'><tr><td width=2 valign=top class='mdn-baseline-icon'><icon src='" + string6 + ".Baseline" + StringsKt.capitalize((String)string7) + "'></icon>\n<td class='mdn-baseline-info'>");
                                                switch (WhenMappings.$EnumSwitchMapping$0[baseline.getLevel().ordinal()]) {
                                                    case 1: {
                                                        StringBuilder stringBuilder5;
                                                        if (notSupportedEngines != null && notSupportedEngines.size() == MdnDocumentationKt.getBASELINE_BROWSERS().size()) {
                                                            stringBuilder5 = result2.append(MdnBundle.message("mdn.documentation.baseline.not-supported", new Object[0]));
                                                            break;
                                                        }
                                                        stringBuilder5 = result2.append(MdnBundle.message("mdn.documentation.baseline.limited-availability", new Object[0]));
                                                        break;
                                                    }
                                                    case 2: {
                                                        StringBuilder stringBuilder5 = result2.append(MdnBundle.message("mdn.documentation.baseline.newly-available", new Object[0]));
                                                        break;
                                                    }
                                                    case 3: {
                                                        StringBuilder stringBuilder5 = result2.append(MdnBundle.message("mdn.documentation.baseline.widely-available", new Object[0]));
                                                        break;
                                                    }
                                                    default: {
                                                        throw new NoWhenBranchMatchedException();
                                                    }
                                                }
                                                result2.append("\n</td></tr></table>");
                                                it = this.doc.getCompatibility();
                                                if (it == null || it.isEmpty()) break block21;
                                                result2.append("</summary>\n");
                                                Map<String, Map<MdnJavaScriptRuntime, String>> map3 = this.doc.getCompatibility();
                                                if (map3 == null) break block22;
                                                Map<String, Map<MdnJavaScriptRuntime, String>> $this$forEach$iv = map3;
                                                boolean $i$f$forEach = false;
                                                $i$f$filter2 = $this$forEach$iv.entrySet().iterator();
                                                break block23;
                                            }
                                            stringBuilder = result2.append("</div>");
                                            break block24;
                                        }
                                        while ($i$f$filter2.hasNext()) {
                                            Map.Entry<String, Map<MdnJavaScriptRuntime, String>> element$iv = $i$f$filter2.next();
                                            destination$iv$iv = element$iv;
                                            boolean bl = false;
                                            id = (String)destination$iv$iv.getKey();
                                            Map map = (Map)destination$iv$iv.getValue();
                                            result2.append("<p>");
                                            if (!Intrinsics.areEqual((Object)id, (Object)"default_context")) {
                                                String string8;
                                                String bundleKey = "mdn.documentation.section.compat." + (String)id;
                                                if (StringsKt.startsWith$default((String)id, (String)"support_of_", (boolean)false, (int)2, null) && !MdnBundle.hasKey(bundleKey)) {
                                                    Object[] bl2 = new Object[1];
                                                    Intrinsics.checkNotNullExpressionValue((Object)((String)id).substring(11), (String)"substring(...)");
                                                    var16_48 = MdnBundle.message("mdn.documentation.section.compat.support_of", bl2);
                                                    Intrinsics.checkNotNull((Object)var16_48);
                                                    string8 = var16_48;
                                                } else {
                                                    var16_48 = MdnBundle.message(bundleKey, new Object[0]);
                                                    Intrinsics.checkNotNull((Object)var16_48);
                                                    string8 = var16_48;
                                                }
                                                String sectionName = string8;
                                                result2.append(StringsKt.removeSuffix((String)sectionName, (CharSequence)":"));
                                                result2.append(": ");
                                            }
                                            result2.append("<span class='grayed'>");
                                            result2.append(this.renderList(map));
                                            result2.append("</span>\n");
                                        }
                                    }
                                    if (notSupportedEngines == null || !(!((Collection)notSupportedEngines).isEmpty())) break block25;
                                    it = notSupportedEngines;
                                    Object object = notSupportedEngines;
                                    boolean $i$f$mapNotNull22 = false;
                                    void $i$f$forEach = $this$mapNotNull$iv;
                                    Collection destination$iv$iv = new ArrayList();
                                    boolean $i$f$mapNotNullTo = false;
                                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                    boolean $i$f$forEach2 = false;
                                    id = $this$forEach$iv$iv$iv.iterator();
                                    while (id.hasNext()) {
                                        MdnJavaScriptRuntime it$iv$iv;
                                        Object e;
                                        Object element$iv$iv = e = id.next();
                                        boolean bl = false;
                                        MdnJavaScriptRuntime it3 = (MdnJavaScriptRuntime)((Object)element$iv$iv);
                                        boolean bl3 = false;
                                        if (it3.getMobileRuntime() == null) continue;
                                        boolean bl4 = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    object.removeAll((List)destination$iv$iv);
                                    result2.append("<p class='grayed'>");
                                    Object[] objectArray2 = new Object[1];
                                    Iterable $i$f$mapNotNull22 = notSupportedEngines;
                                    int n2 = 0;
                                    Object[] objectArray3 = objectArray2;
                                    String string9 = "mdn.documentation.baseline.not-supported-by";
                                    object = result2;
                                    boolean $i$f$map = false;
                                    destination$iv$iv = $this$map$iv;
                                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                        MdnJavaScriptRuntime mdnJavaScriptRuntime = (MdnJavaScriptRuntime)((Object)item$iv$iv);
                                        collection = destination$iv$iv2;
                                        boolean bl = false;
                                        collection.add(mdnJavaScriptRuntime.getDisplayName());
                                    }
                                    collection = (List)destination$iv$iv2;
                                    objectArray3[n2] = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                                    stringBuilder3 = ((StringBuilder)object).append(MdnBundle.message(string9, objectArray2));
                                    break block26;
                                }
                                String string10 = baseline.getHighDate();
                                if (string10 == null) {
                                    string10 = string5 = baseline.getLowDate();
                                }
                                if (string10 == null) break block27;
                                String $this$dropWhile$iv = string5;
                                boolean $i$f$dropWhile = false;
                                int n3 = ((CharSequence)$this$dropWhile$iv).length();
                                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                                    char it = $this$dropWhile$iv.charAt(index$iv);
                                    boolean bl = false;
                                    if (!Character.isDigit(it)) continue;
                                    String string11 = $this$dropWhile$iv.substring(index$iv);
                                    string4 = string11;
                                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                                    break block19;
                                }
                                string4 = string5 = "";
                            }
                            if (string4 == null) break block27;
                            String date = string5;
                            boolean bl = false;
                            result2.append("<p class='grayed'>");
                            objectArray = new Object[1];
                            String it = date;
                            int n4 = 0;
                            Object[] objectArray4 = objectArray;
                            string3 = "mdn.documentation.baseline.since";
                            stringBuilder2 = result2;
                            boolean $i$f$takeWhile = false;
                            n = $this$takeWhile$iv.length();
                            break block28;
                        }
                        stringBuilder3 = null;
                        break block26;
                    }
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (Character.isDigit(it)) continue;
                        void var19_58 = $this$takeWhile$iv;
                        int n5 = 0;
                        String string12 = var19_58.substring(n5, index$iv);
                        string2 = string12;
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"substring(...)");
                        break block20;
                    }
                    string2 = $this$takeWhile$iv;
                }
                void var21_64 = string2;
                objectArray4[n4] = var21_64;
                stringBuilder3 = stringBuilder2.append(MdnBundle.message(string3, objectArray));
            }
            stringBuilder = result2.append("\n</details>");
        }
        result2.append("\n");
        String string13 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toString(...)");
        return string13;
    }

    private final String renderList(Map<MdnJavaScriptRuntime, String> $this$renderList) {
        CharSequence charSequence;
        CharSequence charSequence2 = CollectionsKt.joinToString$default((Iterable)$this$renderList.entrySet(), (CharSequence)", ", null, null, (int)0, null, MdnSymbolDocumentationAdapter::renderList$lambda$15, (int)30, null);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            String string2 = MdnBundle.message("mdn.documentation.section.compat.supported_by.none", new Object[0]);
            charSequence = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final boolean _get_sections_$lambda$4(MdnApiStatus it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it != MdnApiStatus.StandardTrack;
    }

    private static final Pair _get_sections_$lambda$5(MdnApiStatus it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new Pair((Object)WebSymbolsBundle.message("mdn.documentation.section.status." + it.name(), new Object[0]), (Object)"");
    }

    private static final CharSequence renderList$lambda$15(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((MdnJavaScriptRuntime)((Object)it.getKey())).getDisplayName() + (String)(((CharSequence)it.getValue()).length() > 0 ? "&nbsp;" + it.getValue() : "");
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BaselineLevel.values().length];
            try {
                nArray[BaselineLevel.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BaselineLevel.LOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BaselineLevel.HIGH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

