/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagRuleProvider;
import com.intellij.xml.actions.GenerateXmlTagAction;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInsertHandler INSTANCE = new XmlTagInsertHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            XmlTagInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XmlTagInsertHandler.$$$reportNull$$$0(1);
        }
        Project project2 = context.getProject();
        Editor editor = context.getEditor();
        int startOffset = context.getStartOffset();
        Document document = InjectedLanguageUtil.getTopLevelEditor((Editor)editor).getDocument();
        Ref currentElementRef = Ref.create();
        XmlTagNameSynchronizer.runWithoutCancellingSyncTagsEditing(document, () -> {
            int offset = editor.getCaretModel().getOffset();
            editor.getDocument().insertString(offset, (CharSequence)" ");
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            currentElementRef.set((Object)context.getFile().findElementAt(startOffset));
            editor.getDocument().deleteString(offset, offset + 1);
        });
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)((PsiElement)currentElementRef.get()), XmlTag.class, (boolean)true);
        if (tag == null) {
            return;
        }
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        if (XmlUtil.getTokenOfType(tag, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType(tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            XmlTagInsertHandler.insertIncompleteTag(context.getCompletionChar(), editor, tag);
        } else if (context.getCompletionChar() == '\t') {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            int caretOffset = editor.getCaretModel().getOffset();
            XmlTag otherTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType(otherTag, XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null) {
                PsiElement sibling = endTagStart.getNextSibling();
                assert (sibling != null);
                ASTNode node = sibling.getNode();
                assert (node != null);
                if (node.getElementType() == XmlTokenType.XML_NAME) {
                    int sOffset = sibling.getTextRange().getStartOffset();
                    int eOffset = sibling.getTextRange().getEndOffset();
                    editor.getDocument().deleteString(sOffset, eOffset);
                    editor.getDocument().insertString(sOffset, (CharSequence)otherTag.getName());
                }
            }
            editor.getCaretModel().moveToOffset(caretOffset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
        if (context.getCompletionChar() == ' ' && TemplateManager.getInstance((Project)project2).getActiveTemplate(editor) != null) {
            return;
        }
        TailType tailType = LookupItem.handleCompletionChar((Editor)editor, (LookupElement)item, (char)context.getCompletionChar());
        tailType.processTail(editor, editor.getCaretModel().getOffset());
    }

    public static void insertIncompleteTag(char completionChar, final Editor editor, XmlTag tag) {
        XmlElementDescriptor descriptor;
        XmlTag originalElement = (XmlTag)CompletionUtil.getOriginalElement((PsiElement)tag);
        XmlElementDescriptor xmlElementDescriptor = descriptor = originalElement != null ? originalElement.getDescriptor() : tag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        final Project project2 = editor.getProject();
        TemplateManager templateManager = TemplateManager.getInstance((Project)project2);
        Template template = templateManager.createTemplate("", "");
        template.setToIndent(true);
        PsiFile containingFile = tag.getContainingFile();
        boolean fileHasHtml = HtmlUtil.hasHtml(containingFile);
        if (fileHasHtml && !tag.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            return;
        }
        boolean htmlCode = fileHasHtml || HtmlUtil.supportsXmlTypedHandlers(containingFile);
        template.setToReformat(!htmlCode);
        StringBuilder indirectRequiredAttrs = XmlTagInsertHandler.addRequiredAttributes(descriptor, tag, template, containingFile);
        final boolean chooseAttributeName = XmlTagInsertHandler.addTail(completionChar, descriptor, htmlCode, tag, template, indirectRequiredAttrs);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
            private RangeMarker myAttrValueMarker;

            public void waitingForInput(Template template) {
                int offset = editor.getCaretModel().getOffset();
                this.myAttrValueMarker = editor.getDocument().createRangeMarker(offset + 1, offset + 4);
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                char c;
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                int offset = editor.getCaretModel().getOffset();
                if (chooseAttributeName && offset > 0 && ((c = editor.getDocument().getCharsSequence().charAt(offset - 1)) == '/' || c == ' ' && brokenOff)) {
                    WriteCommandAction.writeCommandAction((Project)project2).run(() -> editor.getDocument().replaceString(offset, offset + 3, (CharSequence)">"));
                }
            }

            public void templateCancelled(Template template) {
                if (this.myAttrValueMarker == null) {
                    return;
                }
                if (UndoManager.getInstance((Project)project2).isUndoOrRedoInProgress()) {
                    return;
                }
                if (chooseAttributeName && this.myAttrValueMarker.isValid()) {
                    int startOffset = this.myAttrValueMarker.getStartOffset();
                    int endOffset = this.myAttrValueMarker.getEndOffset();
                    WriteCommandAction.writeCommandAction((Project)project2).run(() -> editor.getDocument().replaceString(startOffset, endOffset, (CharSequence)">"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/completion/XmlTagInsertHandler$1", "templateFinished"));
            }
        });
    }

    @Nullable
    private static StringBuilder addRequiredAttributes(XmlElementDescriptor descriptor, @Nullable XmlTag tag, Template template, PsiFile containingFile) {
        XmlAttributeDescriptor[] attributes;
        InspectionProfileImpl profile;
        XmlEntitiesInspection inspection;
        Set notRequiredAttributes = Collections.emptySet();
        if (tag instanceof HtmlTag && (inspection = (XmlEntitiesInspection)(profile = InspectionProjectProfileManager.getInstance((Project)tag.getProject()).getCurrentProfile()).getUnwrappedTool("RequiredAttributes", (PsiElement)tag)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inspection.getAdditionalEntries());
            notRequiredAttributes = new HashSet();
            while (tokenizer.hasMoreElements()) {
                notRequiredAttributes.add(tokenizer.nextToken());
            }
        }
        if ((attributes = XmlTagInsertHandler.getAttributesDescriptors(descriptor, tag)) == null || attributes.length == 0) {
            return null;
        }
        StringBuilder indirectRequiredAttrs = null;
        if (WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes()) {
            XmlExtension extension = XmlExtension.getExtension(containingFile);
            for (XmlAttributeDescriptor attributeDecl : attributes) {
                boolean htmlCode;
                String attributeName = attributeDecl.getName(tag);
                boolean shouldBeInserted = extension.shouldBeInserted(attributeDecl);
                if (!shouldBeInserted) continue;
                XmlExtension.AttributeValuePresentation presenter = extension.getAttributeValuePresentation(tag, attributeName, XmlEditUtil.getAttributeQuote(containingFile));
                boolean bl = htmlCode = HtmlUtil.hasHtml(containingFile) || HtmlUtil.supportsXmlTypedHandlers(containingFile);
                if (tag == null || tag.getAttributeValue(attributeName) == null) {
                    if (notRequiredAttributes.contains(attributeName)) continue;
                    if (!extension.isIndirectSyntax(attributeDecl)) {
                        template.addTextSegment(" " + attributeName + "=" + presenter.getPrefix());
                        template.addVariable((Expression)(presenter.showAutoPopup() ? new MacroCallNode((Macro)new CompleteMacro()) : new EmptyExpression()), true);
                        template.addTextSegment(presenter.getPostfix());
                        continue;
                    }
                    if (indirectRequiredAttrs == null) {
                        indirectRequiredAttrs = new StringBuilder();
                    }
                    indirectRequiredAttrs.append("\n<jsp:attribute name=\"").append(attributeName).append("\"></jsp:attribute>\n");
                    continue;
                }
                if (!attributeDecl.isFixed() || attributeDecl.getDefaultValue() == null || htmlCode) continue;
                template.addTextSegment(" " + attributeName + "=" + presenter.getPrefix() + attributeDecl.getDefaultValue() + presenter.getPostfix());
            }
        }
        return indirectRequiredAttrs;
    }

    protected static boolean addTail(char completionChar, XmlElementDescriptor descriptor, boolean isHtmlCode, XmlTag tag, Template template, StringBuilder indirectRequiredAttrs) {
        if (completionChar == '>' || completionChar == '/' && indirectRequiredAttrs != null) {
            String name;
            template.addTextSegment(">");
            if (indirectRequiredAttrs != null) {
                template.addTextSegment(indirectRequiredAttrs.toString());
            }
            template.addEndVariable();
            if (!(tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag, true) || tag.getAttributes().length != 0 || !WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() || (name = descriptor.getName(tag)) == null)) {
                template.addTextSegment("</");
                template.addTextSegment(name);
                template.addTextSegment(">");
            }
        } else if (completionChar == '/') {
            template.addTextSegment(XmlTagInsertHandler.closeTag(tag));
        } else if (completionChar == ' ' && template.getSegmentsCount() == 0) {
            if (WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && (XmlTagInsertHandler.getAttributesDescriptors(descriptor, tag).length > 0 || XmlTagInsertHandler.isTagFromHtml(tag) && !HtmlUtil.isTagWithoutAttributes(tag.getName()))) {
                XmlTagInsertHandler.completeAttribute(tag.getContainingFile(), template);
                return true;
            }
        } else if (completionChar == '\u0000' || completionChar == '\n' || completionChar == '\t') {
            if (WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() && isHtmlCode && HtmlUtil.isSingleHtmlTag(tag, true)) {
                if (XmlTagInsertHandler.runWithTimeoutOrNull(() -> XmlTagInsertHandler.hasOwnAttributes(descriptor, tag)) == Boolean.TRUE) {
                    template.addEndVariable();
                }
                template.addTextSegment(HtmlUtil.isHtmlTag(tag) ? ">" : XmlTagInsertHandler.closeTag(tag));
            } else {
                if (XmlTagInsertHandler.needAtLeastOneAttribute(tag) && WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && tag.getAttributes().length == 0 && template.getSegmentsCount() == 0) {
                    XmlTagInsertHandler.completeAttribute(tag.getContainingFile(), template);
                    return true;
                }
                XmlTagInsertHandler.completeTagTail(template, descriptor, tag.getContainingFile(), tag, true);
            }
        }
        return false;
    }

    @NotNull
    private static String closeTag(XmlTag tag) {
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)tag.getContainingFile());
        boolean html = HtmlUtil.isHtmlTag(tag);
        boolean needsSpace = html && ((HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class)).HTML_SPACE_INSIDE_EMPTY_TAG || !html && ((XmlCodeStyleSettings)settings.getCustomSettings(XmlCodeStyleSettings.class)).XML_SPACE_INSIDE_EMPTY_TAG;
        return needsSpace ? " />" : "/>";
    }

    private static void completeAttribute(PsiFile file, Template template) {
        template.addTextSegment(" ");
        template.addVariable((Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
        template.addTextSegment("=" + XmlEditUtil.getAttributeQuote(file));
        template.addEndVariable();
        template.addTextSegment(XmlEditUtil.getAttributeQuote(file));
    }

    private static boolean needAtLeastOneAttribute(XmlTag tag) {
        for (XmlTagRuleProvider ruleProvider : XmlTagRuleProvider.EP_NAME.getExtensionList()) {
            for (XmlTagRuleProvider.Rule rule : ruleProvider.getTagRule(tag)) {
                if (!rule.needAtLeastOneAttribute(tag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean addRequiredSubTags(Template template, XmlElementDescriptor descriptor, PsiFile file, XmlTag context) {
        if (!WebEditorOptions.getInstance().isAutomaticallyInsertRequiredSubTags()) {
            return false;
        }
        List<XmlElementDescriptor> requiredSubTags = GenerateXmlTagAction.getRequiredSubTags(descriptor);
        if (!requiredSubTags.isEmpty()) {
            template.addTextSegment(">");
            template.setToReformat(true);
        }
        for (XmlElementDescriptor subTag : requiredSubTags) {
            String prefixByNamespace;
            if (subTag == null) {
                template.addTextSegment("<");
                template.addVariable((Expression)new MacroCallNode((Macro)new CompleteSmartMacro()), true);
                continue;
            }
            Object qname = subTag.getName();
            if (subTag instanceof XmlElementDescriptorImpl && StringUtil.isNotEmpty((String)(prefixByNamespace = context.getPrefixByNamespace(((XmlElementDescriptorImpl)subTag).getNamespace())))) {
                qname = prefixByNamespace + ":" + subTag.getName();
            }
            template.addTextSegment("<" + (String)qname);
            XmlTagInsertHandler.addRequiredAttributes(subTag, null, template, file);
            XmlTagInsertHandler.completeTagTail(template, subTag, file, context, false);
        }
        if (!requiredSubTags.isEmpty()) {
            XmlTagInsertHandler.addTagEnd(template, descriptor, context);
        }
        return !requiredSubTags.isEmpty();
    }

    private static void completeTagTail(Template template, XmlElementDescriptor descriptor, PsiFile file, XmlTag context, boolean firstLevel) {
        boolean completeIt = !(firstLevel && XmlTagInsertHandler.canHaveAttributes(descriptor, context) || file != null && !XmlExtension.getExtension(file).shouldCompleteTag(context));
        switch (descriptor.getContentType()) {
            case -1: {
                break;
            }
            case 0: {
                if (!completeIt) break;
                template.addTextSegment(XmlTagInsertHandler.closeTag(context));
                break;
            }
            case 3: {
                if (!completeIt) break;
                template.addTextSegment(">");
                if (firstLevel) {
                    template.addEndVariable();
                } else {
                    template.addVariable((Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
                }
                XmlTagInsertHandler.addTagEnd(template, descriptor, context);
                break;
            }
            default: {
                if (XmlTagInsertHandler.addRequiredSubTags(template, descriptor, file, context) || !completeIt) break;
                template.addTextSegment(">");
                template.addEndVariable();
                XmlTagInsertHandler.addTagEnd(template, descriptor, context);
            }
        }
    }

    private static boolean hasOwnAttributes(XmlElementDescriptor descriptor, XmlTag tag) {
        return ContainerUtil.find((Object[])XmlTagInsertHandler.getAttributesDescriptors(descriptor, tag), attr -> attr instanceof HtmlAttributeDescriptorImpl && HtmlUtil.isOwnHtmlAttribute(attr)) != null;
    }

    private static boolean canHaveAttributes(XmlElementDescriptor descriptor, XmlTag context) {
        Object[] attributes = XmlTagInsertHandler.getAttributesDescriptors(descriptor, context);
        int required = WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes() ? ArraysKt.count((Object[])attributes, attribute -> attribute.isRequired() && context.getAttribute(attribute.getName()) == null) : 0;
        return attributes.length - required > 0;
    }

    private static void addTagEnd(Template template, XmlElementDescriptor descriptor, XmlTag context) {
        template.addTextSegment("</" + descriptor.getName(context) + ">");
    }

    private static boolean isTagFromHtml(XmlTag tag) {
        String ns = tag.getNamespace();
        return "http://www.w3.org/1999/xhtml".equals(ns) || "http://www.w3.org/1999/html".equals(ns);
    }

    private static XmlAttributeDescriptor[] getAttributesDescriptors(XmlElementDescriptor descriptor, XmlTag tag) {
        XmlAttributeDescriptor[] result2 = (XmlAttributeDescriptor[])XmlTagInsertHandler.runWithTimeoutOrNull(() -> descriptor.getAttributesDescriptors(tag));
        return result2 != null ? result2 : XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public static <T> T runWithTimeoutOrNull(Computable<@NotNull T> block) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode()) {
            return (T)block.get();
        }
        return (T)ProgressIndicatorUtils.withTimeout((long)250L, block);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlTagInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

