/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns.standard;

import ai.grazie.nlp.patterns.AggregatedPattern;
import ai.grazie.nlp.patterns.LambdaMatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.RegexPattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.nlp.patterns.standard.LikelyPatterns;
import ai.grazie.text.TextRange;
import ai.grazie.utils.mpp.TextRegex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001dX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/grazie/nlp/patterns/standard/LikelyPatterns;", "", "()V", "AcademicCitation", "Lai/grazie/nlp/patterns/Pattern;", "ChainedName", "ChatTextEmoji", "Chemical", "CommandLineOption", "FunctionName", "GeneratedId", "IsAbbreviation", "IsCommitHash", "IsCompositeInflection", "IsEmail", "IsEncodedBinary", "Lai/grazie/nlp/patterns/LambdaMatchPattern;", "IsExcelFormula", "IsFilePath", "IsGermanOrdinal", "IsIBAN", "IsIPv4", "IsMention", "IsRebusAbbreviation", "IsURL", "NameInitials", "PunctuationOperator", "TicketName", "dashLikeChars", "", "deBeforeNumerals", "firstNameInitials", "initial", "lastNameInitial", "onlyInitials", "romanDigits", "russianExtendedInitial", "smileyPattern", "smileyStartChars", "looksLikeNonBullet", "", "text", "", "snakeKebabName", "minSeparatorCount", "", "nlp-patterns"})
public final class LikelyPatterns {
    @NotNull
    public static final LikelyPatterns INSTANCE;
    @JvmField
    @NotNull
    public static final Pattern AcademicCitation;
    @JvmField
    @NotNull
    public static final Pattern IsEmail;
    @JvmField
    @NotNull
    public static final Pattern CommandLineOption;
    @JvmField
    @NotNull
    public static final Pattern ChainedName;
    @JvmField
    @NotNull
    public static final Pattern FunctionName;
    @JvmField
    @NotNull
    public static final Pattern IsMention;
    @JvmField
    @NotNull
    public static final Pattern ChatTextEmoji;
    @JvmField
    @NotNull
    public static final Pattern GeneratedId;
    @JvmField
    @NotNull
    public static final LambdaMatchPattern IsEncodedBinary;
    @JvmField
    @NotNull
    public static final Pattern IsIPv4;
    @JvmField
    @NotNull
    public static final Pattern IsFilePath;
    @JvmField
    @NotNull
    public static final Pattern IsURL;
    @JvmField
    @NotNull
    public static final Pattern IsAbbreviation;
    @NotNull
    public static final String romanDigits = "IVXLMCD";
    @NotNull
    private static final String deBeforeNumerals = "rsmneudt";
    @JvmField
    @NotNull
    public static final Pattern IsGermanOrdinal;
    @JvmField
    @NotNull
    public static final Pattern IsCompositeInflection;
    @NotNull
    private static final String russianExtendedInitial = "\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432";
    @NotNull
    private static final String initial = "(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.";
    @NotNull
    private static final String firstNameInitials = "((\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.\\s?){1,2}([:?!)\u2013\u2014-]|\\p{Lu}\\p{Ll}+)";
    @NotNull
    private static final String onlyInitials = "(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.(\\s?(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.)*";
    @NotNull
    private static final String lastNameInitial = "\\p{Lu}(\\p{Ll})+\\s\\p{Lu}\\.";
    @JvmField
    @NotNull
    public static final Pattern NameInitials;
    @NotNull
    public static final String smileyStartChars = ":;";
    @NotNull
    public static final String smileyPattern = "[:;]-?[()]+";
    @NotNull
    public static final String dashLikeChars = "-\u2013\u2014";
    @JvmField
    @NotNull
    public static final Pattern PunctuationOperator;
    @JvmField
    @NotNull
    public static final Pattern TicketName;
    @JvmField
    @NotNull
    public static final Pattern Chemical;
    @JvmField
    @NotNull
    public static final Pattern IsIBAN;
    @JvmField
    @NotNull
    public static final Pattern IsCommitHash;
    @JvmField
    @NotNull
    public static final Pattern IsRebusAbbreviation;
    @JvmField
    @NotNull
    public static final Pattern IsExcelFormula;

    private LikelyPatterns() {
    }

    @NotNull
    public final Pattern snakeKebabName(int minSeparatorCount) {
        String version = "\\d+(.\\d+)*";
        String part = "[a-z]+\\*?";
        String id = part + "([-_]\\*?" + part + "){" + minSeparatorCount + ",}";
        Regex regex = new Regex(id + "(-?" + version + ")?|" + version + "(-" + part + ")+");
        return new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
    }

    private final boolean looksLikeNonBullet(CharSequence text2) {
        int n;
        int n2;
        CharSequence charSequence;
        return text2.length() >= 3 && (!StringsKt.startsWith$default((CharSequence)text2, (CharSequence)". ", (int)1, (boolean)false, (int)4, null) || StringsKt.contains$default((CharSequence)((Object)(charSequence = text2).subSequence(n2 = 3, n = charSequence.length())).toString(), (CharSequence)". ", (boolean)false, (int)2, null));
    }

    public static final /* synthetic */ boolean access$looksLikeNonBullet(LikelyPatterns $this, CharSequence text2) {
        return $this.looksLikeNonBullet(text2);
    }

    static {
        LikelyPatterns $this$AcademicCitation_u24lambda_u242 = INSTANCE = new LikelyPatterns();
        boolean bl = false;
        String year = "(1[89]|20)\\d\\d";
        LikelyPatterns $this$AcademicCitation_u24lambda_u242_u24lambda_u240 = $this$AcademicCitation_u24lambda_u242;
        boolean bl2 = false;
        String surname = "\\p{Lu}\\p{Ll}+";
        String andWord = "and|und|\u0438|\u0442\u0430";
        String etAlWords = "et\\sal\\.|\u0438\\s\u0434\u0440\\.|\u0442\u0430\\s\u0456\u043d\\.";
        String authors = surname + "((\\s?&\\s?|,\\s|/|\\s(" + andWord + ")\\s)" + surname + ")*(\\s(" + etAlWords + ")|,)?";
        String citationWithInnerParens = authors + "\\s\\(" + year + "\\p{L}?";
        LikelyPatterns $this$AcademicCitation_u24lambda_u242_u24lambda_u241 = $this$AcademicCitation_u24lambda_u242;
        boolean $i$a$-run-LikelyPatterns$AcademicCitation$1$citationInParens$22 = false;
        String cf = "(cf|vgl|\u0441\u0440)\\.\\s";
        String pageOrYear = "[1-9]\\d*";
        String singleRef = authors + "\\s" + pageOrYear + "\\p{L}?";
        String citationInParens = "[(\\[](" + cf + ")?" + singleRef + "([,;]\\s" + singleRef + ")*";
        AcademicCitation = new RegexPattern(new Regex(citationInParens + "|" + citationWithInnerParens)).withWordBoundariesAround();
        LikelyPatterns $this$IsEmail_u24lambda_u243 = INSTANCE;
        boolean bl3 = false;
        String specialPrefixChars = "_.+-";
        citationInParens = new Regex("[a-zA-Z0-9" + specialPrefixChars + "]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)+");
        IsEmail = new RegexPattern(specialPrefixChars, (Regex)citationInParens){
            final /* synthetic */ String $specialPrefixChars;
            {
                this.$specialPrefixChars = $specialPrefixChars;
                super($super_call_param$1);
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int n = text2.length() - 3;
                for (int i = 1; i < n; ++i) {
                    MatchResult it;
                    if (text2.charAt(i) != '@') continue;
                    int start2 = 0;
                    start2 = i;
                    while (start2 - 1 > 0 && (Character.isLetterOrDigit(text2.charAt(start2 - 1)) || StringsKt.contains$default((CharSequence)this.$specialPrefixChars, (char)text2.charAt(start2 - 1), (boolean)false, (int)2, null))) {
                        int n2 = start2;
                        start2 = n2 + -1;
                    }
                    if (start2 >= i) continue;
                    if (this.getRegex().matchAt(text2, start2) == null) continue;
                    boolean bl = false;
                    result2.add(new TextRange(start2, it.getRange().getLast() + 1));
                }
                return result2;
            }
        };
        Regex regex = new Regex("--[a-z0-9][a-z0-9-]+|-[XJD]?[a-z]{1,3}");
        CommandLineOption = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.after(new Regex("^|[\\s\\p{Pi}\\p{Po}(]"));
        LikelyPatterns $this$ChainedName_u24lambda_u244 = INSTANCE;
        boolean bl4 = false;
        String part = "[a-zA-Z_]([a-zA-Z_\\d]*)";
        citationInParens = new Regex(part + "(\\." + part + ")+");
        ChainedName = new RegexPattern((Regex)citationInParens){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        LikelyPatterns $this$FunctionName_u24lambda_u245 = INSTANCE;
        boolean bl5 = false;
        part = new Regex("[a-zA-Z_]([a-zA-Z_\\d]*)\\(\\)");
        FunctionName = new RegexPattern((Regex)part){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        LikelyPatterns $this$IsMention_u24lambda_u246 = INSTANCE;
        boolean bl6 = false;
        String nickname = "[\\w.]+";
        String fullName = "\\p{Lu}\\p{Ll}+([\\s.]\\p{Lu}\\p{Ll}+)+";
        String personMention = "@(" + fullName + "|" + nickname + ")";
        String hashtag = "#[\\p{L}\\d_]([\\p{L}\\d_-]+)?[\\p{L}\\d_]";
        Regex $i$a$-run-LikelyPatterns$AcademicCitation$1$citationInParens$22 = new Regex(personMention + "|" + hashtag);
        IsMention = new RegexPattern($i$a$-run-LikelyPatterns$AcademicCitation$1$citationInParens$22){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.afterWordBoundary();
        regex = new Regex(":\\w+:");
        ChatTextEmoji = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        regex = new Regex("[a-zA-Z_0-9-]{10,}");
        GeneratedId = new RegexPattern(regex){

            /*
             * Unable to fully structure code
             */
            public List<TextRange> find(CharSequence text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                $this$filter$iv = super.find(text);
                $i$f$filter = false;
                var4_4 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    range = (TextRange)element$iv$iv;
                    $i$a$-filter-LikelyPatterns$GeneratedId$1$find$1 = false;
                    found = text.subSequence(range.getStart(), range.getEndExclusive());
                    minCount = 3;
                    $this$count$iv = found;
                    $i$f$count = false;
                    count$iv = 0;
                    for (var16_16 = 0; var16_16 < $this$count$iv.length(); ++var16_16) {
                        it = element$iv = $this$count$iv.charAt(var16_16);
                        $i$a$-count-LikelyPatterns$GeneratedId$1$find$1$1 = false;
                        if (!Character.isUpperCase(it)) continue;
                        ++count$iv;
                    }
                    if (count$iv <= minCount) ** GOTO lbl-1000
                    $this$count$iv = found;
                    $i$f$count = false;
                    count$iv = 0;
                    for (var16_16 = 0; var16_16 < $this$count$iv.length(); ++var16_16) {
                        it = element$iv = $this$count$iv.charAt(var16_16);
                        $i$a$-count-LikelyPatterns$GeneratedId$1$find$1$2 = false;
                        if (!Character.isLowerCase(it)) continue;
                        ++count$iv;
                    }
                    if (count$iv <= minCount) ** GOTO lbl-1000
                    $this$count$iv = found;
                    $i$f$count = false;
                    count$iv = 0;
                    for (var16_16 = 0; var16_16 < $this$count$iv.length(); ++var16_16) {
                        it = element$iv = $this$count$iv.charAt(var16_16);
                        $i$a$-count-LikelyPatterns$GeneratedId$1$find$1$3 = false;
                        if (!Character.isDigit(it)) continue;
                        ++count$iv;
                    }
                    if (count$iv > minCount) {
                        v0 = true;
                    } else lbl-1000:
                    // 3 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.withWordBoundariesAround();
        IsEncodedBinary = new LambdaMatchPattern((Function1<? super CharSequence, Boolean>)((Function1)IsEncodedBinary.1.INSTANCE));
        regex = new Regex("(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4])");
        IsIPv4 = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        LikelyPatterns $this$IsFilePath_u24lambda_u247 = INSTANCE;
        boolean bl7 = false;
        String slash = "([/\\\\]{1,2})";
        String namePart = "(\\.?[\\w~-])";
        String pathPart = "(<(" + namePart + "| ){1,100}>|%(" + namePart + "| ){1,100}%|\\$\\{" + namePart + "{1,100}\\}|" + namePart + "{1,100}|\\*+)";
        String pathWithSlashes = slash + "?" + pathPart + "(" + slash + pathPart + "){1,100}" + slash + "?|" + slash + pathPart;
        String dotName = "\\*?\\.[a-z][a-z0-9]{1,6}";
        String nameWithExtensionAndPunctuation = "[a-zA-Z][\\w\\*]+-[-\\w\u2039\u203a<>{}]*\\*?\\.\\*?[a-z]{1,5}";
        String pathWildcard = "<" + namePart + "{1,100}?_" + namePart + "{1,100}>";
        citationWithInnerParens = new Regex(pathWithSlashes + "|" + nameWithExtensionAndPunctuation + "|" + pathWildcard + "|" + dotName);
        IsFilePath = new RegexPattern((Regex)citationWithInnerParens){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isNamePatternPart(char c) {
                boolean bl;
                boolean bl2;
                if (StringsKt.contains$default((CharSequence)"~_-\u2039\u203a<>{}*", (char)c, (boolean)false, (int)2, null)) return true;
                if ('0' <= c) {
                    if (c < ':') {
                        return true;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) return true;
                if ('a' <= c) {
                    if (c < '{') {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) return true;
                if ('A' > c) return false;
                if (c >= '[') return false;
                return true;
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int minStart = 0;
                block0: for (int i = 0; i < text2.length(); ++i) {
                    int start2;
                    boolean retreat;
                    char c = text2.charAt(i);
                    boolean bl = retreat = c == '/' || c == '\\' || c == '<' || c == '.';
                    if (!retreat && c != '%' && c != '$') continue;
                    if (retreat) {
                        for (start2 = i; start2 > minStart && this.isNamePatternPart(text2.charAt(start2 - 1)); --start2) {
                        }
                    }
                    while (start2 <= i) {
                        MatchResult match2;
                        if (this.isPathStartAllowed(text2, start2) && (match2 = this.getRegex().matchAt(text2, start2)) != null) {
                            minStart = match2.getRange().getLast() + 1;
                            result2.add(TextRange.Companion.invoke(match2.getRange()));
                            i = Math.max(match2.getRange().getLast(), i);
                            continue block0;
                        }
                        ++start2;
                    }
                }
                return result2;
            }

            private final boolean isPathStartAllowed(CharSequence text2, int start2) {
                return Pattern.Companion.isWordBoundaryBefore(text2, start2) && (start2 <= 0 || !Character.isLetterOrDigit(text2.charAt(start2 - 1)));
            }
        }.beforeWordBoundary();
        IsURL = new Pattern(){
            private final Regex optionalPrefixRegex;
            private final Regex mainUrlPartsRegex;
            {
                this.optionalPrefixRegex = new Regex("(?:[-\\w+.]{2,}://)?(?:\\S+(?::\\S+)?@)?");
                this.mainUrlPartsRegex = new Regex("(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4])|(?:(?:[\\p{L}\\d][\\p{L}\\d_-]{0,62})?[\\p{L}\\d]\\.)+(?:\\p{L}\\p{Ll}{1,20}|\\p{Lu}{2,4}))(?::\\d{2,5})?(?:[/?#]\\S*)?");
            }

            private final boolean isMainUrlPart(char c) {
                return c == '_' || c == '-' || Character.isLetterOrDigit(c);
            }

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                ArrayList<TextRange> result2 = new ArrayList<TextRange>();
                int i = 1;
                while (i < text2.length() - 1) {
                    if (text2.charAt(i) == '.' && this.isMainUrlPart(text2.charAt(i - 1)) && this.isMainUrlPart(text2.charAt(i + 1))) {
                        TextRange range;
                        MatchResult mainMatch;
                        int mainStart;
                        for (mainStart = i - 1; mainStart > 0 && this.isMainUrlPart(text2.charAt(mainStart - 1)); --mainStart) {
                        }
                        while (i < text2.length() && !CharsKt.isWhitespace((char)text2.charAt(i))) {
                            ++i;
                        }
                        MatchResult matchResult = this.mainUrlPartsRegex.matchAt(text2, mainStart);
                        if (matchResult == null || (matchResult = matchResult.getRange()) == null || (mainMatch = matchResult).getLast() + 1 < text2.length() && this.isMainUrlPart(text2.charAt(mainMatch.getLast() + 1)) || this.addPrefixes(TextRange.Companion.invoke((IntRange)mainMatch), text2) == null) continue;
                        result2.add(range);
                        continue;
                    }
                    ++i;
                }
                return result2;
            }

            private final TextRange addPrefixes(TextRange range, CharSequence text2) {
                int start2;
                if (range.getStart() > 2 && (text2.charAt(start2 = range.getStart() - 1) == '@' || text2.charAt(start2) == '/')) {
                    while (start2 > 0 && !CharsKt.isWhitespace((char)text2.charAt(start2 - 1))) {
                        --start2;
                    }
                    while (start2 < range.getStart() - 1) {
                        if (Pattern.Companion.isWordBoundaryBefore(text2, start2) && this.optionalPrefixRegex.matches(text2.subSequence(start2, range.getStart()))) {
                            return new TextRange(start2, range.getEndExclusive());
                        }
                        ++start2;
                    }
                    return null;
                }
                return range;
            }

            public boolean matches(CharSequence text2) {
                MatchResult prefix;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                int dot = StringsKt.indexOf$default((CharSequence)text2, (char)'.', (int)1, (boolean)false, (int)4, null);
                if (dot < 0 || dot >= text2.length() - 2 || !this.isMainUrlPart(text2.charAt(dot - 1)) || !this.isMainUrlPart(text2.charAt(dot + 1))) {
                    return false;
                }
                MatchResult matchResult = prefix = this.optionalPrefixRegex.matchAt(text2, 0);
                return this.mainUrlPartsRegex.matchesAt(text2, matchResult == null ? 0 : matchResult.getRange().getLast() + 1);
            }
        }.exclude(IsIPv4).exclude(IsEmail);
        IsAbbreviation = AbbreviationPatterns.All;
        regex = new Regex("(\\d{1,3}|[IVXLMCD]+)\\.");
        RegexPattern regexPattern = new RegexPattern(regex){
            private final Regex definiteContinuation;
            {
                this.definiteContinuation = new Regex(" ((" + CollectionsKt.joinToString$default((Iterable)AbbreviationPatterns.INSTANCE.getGermanMonthsShort(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")\\.|" + CollectionsKt.joinToString$default((Iterable)AbbreviationPatterns.INSTANCE.getGermanMonthsFull(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")");
            }

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange range = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!(range.getStart() > 0 || this.definiteContinuation.matchesAt(text2, range.getEndExclusive()) || this.startsWithLowerCase(StringsKt.trim((CharSequence)text2.subSequence(range.getEndExclusive(), text2.length()))))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            private final boolean startsWithLowerCase(CharSequence text2) {
                return text2.length() > 0 && Character.isLowerCase(text2.charAt(0));
            }
        };
        String string2 = deBeforeNumerals.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        IsGermanOrdinal = regexPattern.after(new Regex("^|([,.rsmneudt" + string2 + "],?|" + TextRegex.INSTANCE.getPunctuation().getPattern() + ")[ \\t]+")).before(new Regex("[ \u00a0]([a-z\u00e4\u00f6\u00fcA-Z\u00c4\u00d6\u00dc]\\p{L}*|bis|zu|an|und|oder|od\\.)"));
        LikelyPatterns $this$IsCompositeInflection_u24lambda_u248 = INSTANCE;
        boolean bl8 = false;
        String russianAdjEndings = "([\u044b\u0438\u043e\u0435]?\u0439|[\u0430\u044c]?\u044f|[\u043e\u044c\u044b]?\u0435|\u044c?\u0438|([\u043e\u0435]?\u0433)?\u043e|([\u044b\u043e\u0435\u0438]?\u043c)?\u0443|[\u044c\u0443]?\u044e|[\u044b\u0438]?\u0445|(\u044b\u0438)?\u043c\u0438?)";
        String ukrainianAdjEndings = "(\u0456([\u0439\u043c\u0445]|\u043c\u0438)|[\u0430\u0443\u0435\u0456\u044f\u0454\u044e]|\u043e?(\u0433\u043e|\u043c\u0443|\u0457)|\u0438?([\u0439\u043c\u0445]|\u043c\u0438)|\u044c\u043e(\u0433\u043e|\u043c\u0443|\u0457))";
        String latinLikeWord = "[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00dfs0-9]+";
        Pattern latinWithCyrillicEnding = new RegexPattern(new Regex("(\u0449\u0438)?[\u0430-\u044f\u0451\u0457\u0456\u0454\u0491]{1,4}")).beforeWordBoundary().after(new Regex(latinLikeWord + "[-']|[A-Z\u00c4\u00d6\u00dc]{2,}"));
        RegexPattern parenthesizedSurnameEnding = new RegexPattern(new Regex("\\p{Lu}\\p{L}+\u0432\\(\u0432(\u0430|\u043e\u0439|\u0443|\u044b|\u044b\u043c\u0438?|\u044b\u0445)\\)"));
        RegexPattern slashEnding = new RegexPattern(new Regex("[\u0430-\u044f\u0451\u0410-\u042f\u0401]+/" + russianAdjEndings));
        RegexPattern wordWithOptionalEnding = new RegexPattern(new Regex("\\p{L}+\\(-?\\p{L}{1,3}\\)"));
        RegexPattern germanGendern = new RegexPattern(new Regex("\\p{Lu}\\p{L}+(I|\\*i|:i)nnen|\\p{L}{2,}\\p{Ll}(e[RN]|E)"));
        RegexPattern russianGender = new RegexPattern(new Regex("\\p{L}{3,}[_:*/]([\u0432\u0440\u0442\u043c]?" + russianAdjEndings + "|((\u043d\u0438)?[\u043a\u0446])?([\u0430\u0438\u044b\u0435\u0443]|\u043e\u0439|\u0435\u0439|\u0430\u043c\u0438?|\u0430\u0445)|\u043e?\u043a|\u0438?\u0446|\\p{L}?([\u0430\u0443\u0435\u044b\u044f\u044e\u0438]|\u043e\u043c|\u0435\u043c|\u0451\u043c|\u0430\u043c\u0438?|\u044f\u043c\u0438?|\u0430\u0445|\u044f\u0445|\u043e\u0432|\u0435\u0432))"));
        Pattern russianNumeralOrEnding = new RegexPattern(new Regex("(\\d+%?|%|-)(\u043e\u0432|\u043e\u043c|[\u0432\u0440\u0442\u043c\u043d]?" + russianAdjEndings + "|\u0430\u043c\u0438?|\u0430\u0445|[\u0430\u0443\u0435\u044b])")).beforeWordBoundary();
        Pattern ukrainianNumeralOrEnding = new RegexPattern(new Regex("(\\d+%?|%)?-[\u0448\u0433\u0442\u043c\u0432\u043d]?" + ukrainianAdjEndings)).beforeWordBoundary();
        RegexPattern englishOrdinal = new RegexPattern(new Regex("\\d+(st|nd|rd|th)"));
        Pattern germanNumeralEnding = new RegexPattern(new Regex("\\d((s?t)?e[rmns]?|%-?ig(e[rmns]?)?)")).beforeWordBoundary();
        Pattern latinSuffix = new RegexPattern(new Regex("[-']itis")).beforeWordBoundary().after(new Regex(latinLikeWord));
        Pattern[] patternArray = new Pattern[6];
        Pattern[] patternArray2 = new Pattern[]{parenthesizedSurnameEnding, slashEnding, wordWithOptionalEnding, germanGendern, russianGender, englishOrdinal};
        patternArray[0] = new AggregatedPattern(patternArray2).withWordBoundariesAround();
        patternArray[1] = russianNumeralOrEnding;
        patternArray[2] = ukrainianNumeralOrEnding;
        patternArray[3] = germanNumeralEnding;
        patternArray[4] = latinWithCyrillicEnding;
        patternArray[5] = latinSuffix;
        Pattern[] patternArray3 = patternArray;
        IsCompositeInflection = new AggregatedPattern(patternArray3){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        regex = new Regex("((\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.\\s?){1,2}([:?!)\u2013\u2014-]|\\p{Lu}\\p{Ll}+)|\\p{Lu}(\\p{Ll})+\\s\\p{Lu}\\.|(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.(\\s?(\\p{Lu}|\u0412\u044f\u0447|\u0412\u0441\u0435\u0432|\u0418\u0432)\\.)*");
        NameInitials = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                TextRange it;
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getStart() > 0 || LikelyPatterns.access$looksLikeNonBullet(LikelyPatterns.INSTANCE, text2.subSequence(0, it.getEndExclusive())))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.afterWordBoundary();
        LikelyPatterns $this$PunctuationOperator_u24lambda_u249 = INSTANCE;
        boolean bl9 = false;
        String operatorSign = "(!{1,2}|\\?)";
        Regex regex2 = new Regex("['\"]" + operatorSign + "['\"]|[\\p{L},:]\\s{1,4}" + operatorSign + "(\\s{1,4}[\\p{Ll},])");
        PunctuationOperator = new RegexPattern(regex2){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        };
        regex = new Regex("[A-Z]+-([A-Z]+-)?[0-9]+");
        TicketName = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        LikelyPatterns $this$Chemical_u24lambda_u2410 = INSTANCE;
        boolean bl10 = false;
        part = "\\d(,\\d)+-[A-Za-z][a-z]+ne";
        regex2 = new Regex(part + "(-" + part + ")*");
        Chemical = new RegexPattern(regex2){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        LikelyPatterns $this$IsIBAN_u24lambda_u2411 = INSTANCE;
        boolean bl11 = false;
        String separator = "[\\s\u00a0]?";
        regex2 = new Regex("[A-Z]{2}" + separator + "\\d{2}" + separator + "(?:[A-Z0-9]" + separator + "){1,30}");
        IsIBAN = new RegexPattern(regex2){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        regex = new Regex("[0-9a-f]{40}");
        IsCommitHash = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
        regex = new Regex("[A-Za-z]*[24][A-Za-z]+");
        IsRebusAbbreviation = new RegexPattern(regex){

            /*
             * WARNING - void declaration
             */
            public List<TextRange> find(CharSequence text2) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable $this$filter$iv = super.find(text2);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.Companion.isWordBoundaryOrApostrophe$nlp_patterns(text2, it.getEndExclusive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }.afterWordBoundary();
        regex = new Regex("=[A-Z]{3,7}\\(\\S+\\)");
        IsExcelFormula = new RegexPattern(regex){

            public List<TextRange> find(CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return super.find(text2);
            }
        }.withWordBoundariesAround();
    }
}

