/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 47361935150540L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1330753710 + -28478, 1330753710 + (char)-15660, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1330753710 + -28477, 1330753710 + 23576, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 100135317862730L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.O();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1844679180 - 32124, -1844679180 - -6398, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1844679180 - 32123, -1844679180 - -23834, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1844679180 - 32118, 1844679180 - 20641, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 91480412117586L;
                Object object = this.lock;
                String string = SshAgentIpcService.O();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-1903660680 + -14825, 1903660680 + 1428, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1903660680 + -14828, 1903660680 + 24882, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (string == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1903660680 + -14827, -1903660680 + -12853, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1903660680 + -14838, -1903660680 + -4257, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1903660680 + -14837, -1903660680 + -24475, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1903660680 + -14827, -1903660680 + -12853, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1903660680 + -14840, 1903660680 + 10193, (int)l2));
            if (ActionTimestamp.O() != null) {
                SshAgentIpcService.O("F8AAkc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 44694540659119L;
                    string = SshAgentIpcService.O();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 79939654695160L;
                String string2 = SshAgentIpcService.O();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = string2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4495), 1723439430 - (char)-21681, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4494), -1723439430 - -((char)-1854), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4493), -1723439430 - -((char)-7065), (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4495), 1723439430 - (char)-21681, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4492), 1723439430 - (char)-2733, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4495), 1723439430 - (char)-21681, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4491), 1723439430 - (char)-19315, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4490), 1723439430 - (char)-22874, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4493), -1723439430 - -((char)-7065), (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4495), 1723439430 - (char)-21681, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4499), -1723439430 - -((char)-2257), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1723439430 - -((char)-4489), 1723308360 + (char)-5747, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 82730091424541L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(431351370 + (char)-28786, 431351370 + 21824, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 30871275978307L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-948946800 - -10231, -948946800 - -2988, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ddD#F\u0097\u00c1O|FM\u00cd2\u00fd\u0089\u0094\u00f8\u00dd\u0094}\u0014\u00c6\u00cb@\u00b1\u00e0\u00fd\u00dc~\u00b6\u000b\u0016.D\u00f3b<\u00ee\u00ca\u001c\u0082";
                        var4_3 = "\u00ddD#F\u0097\u00c1O|FM\u00cd2\u00fd\u0089\u0094\u00f8\u00dd\u0094}\u0014\u00c6\u00cb@\u00b1\u00e0\u00fd\u00dc~\u00b6\u000b\u0016.D\u00f3b<\u00ee\u00ca\u001c\u0082".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 21;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 116;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 127;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 117;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 22;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 29;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 108;
                                        break;
                                    }
                                    default: {
                                        v11 = 127;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x5EC5) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 226;
                            case 1 -> 192;
                            case 2 -> 188;
                            case 3 -> 195;
                            case 4 -> 221;
                            case 5 -> 190;
                            case 6 -> 193;
                            case 7 -> 168;
                            case 8 -> 15;
                            case 9 -> 99;
                            case 10 -> 111;
                            case 11 -> 89;
                            case 12 -> 213;
                            case 13 -> 36;
                            case 14 -> 114;
                            case 15 -> 76;
                            case 16 -> 93;
                            case 17 -> 4;
                            case 18 -> 180;
                            case 19 -> 235;
                            case 20 -> 1;
                            case 21 -> 255;
                            case 22 -> 21;
                            case 23 -> 254;
                            case 24 -> 11;
                            case 25 -> 146;
                            case 26 -> 71;
                            case 27 -> 151;
                            case 28 -> 32;
                            case 29 -> 248;
                            case 30 -> 228;
                            case 31 -> 45;
                            case 32 -> 66;
                            case 33 -> 18;
                            case 34 -> 227;
                            case 35 -> 211;
                            case 36 -> 109;
                            case 37 -> 79;
                            case 38 -> 96;
                            case 39 -> 65;
                            case 40 -> 73;
                            case 41 -> 236;
                            case 42 -> 208;
                            case 43 -> 19;
                            case 44 -> 203;
                            case 45 -> 252;
                            case 46 -> 150;
                            case 47 -> 131;
                            case 48 -> 2;
                            case 49 -> 134;
                            case 50 -> 207;
                            case 51 -> 200;
                            case 52 -> 184;
                            case 53 -> 112;
                            case 54 -> 28;
                            case 55 -> 100;
                            case 56 -> 52;
                            case 57 -> 30;
                            case 58 -> 251;
                            case 59 -> 107;
                            case 60 -> 68;
                            case 61 -> 132;
                            case 62 -> 220;
                            case 63 -> 106;
                            case 64 -> 250;
                            case 65 -> 127;
                            case 66 -> 77;
                            case 67 -> 10;
                            case 68 -> 149;
                            case 69 -> 237;
                            case 70 -> 88;
                            case 71 -> 103;
                            case 72 -> 247;
                            case 73 -> 57;
                            case 74 -> 243;
                            case 75 -> 214;
                            case 76 -> 202;
                            case 77 -> 217;
                            case 78 -> 162;
                            case 79 -> 50;
                            case 80 -> 40;
                            case 81 -> 123;
                            case 82 -> 176;
                            case 83 -> 129;
                            case 84 -> 215;
                            case 85 -> 39;
                            case 86 -> 12;
                            case 87 -> 75;
                            case 88 -> 46;
                            case 89 -> 234;
                            case 90 -> 154;
                            case 91 -> 232;
                            case 92 -> 118;
                            case 93 -> 24;
                            case 94 -> 62;
                            case 95 -> 97;
                            case 96 -> 49;
                            case 97 -> 92;
                            case 98 -> 152;
                            case 99 -> 128;
                            case 100 -> 181;
                            case 101 -> 90;
                            case 102 -> 178;
                            case 103 -> 242;
                            case 104 -> 161;
                            case 105 -> 48;
                            case 106 -> 5;
                            case 107 -> 101;
                            case 108 -> 78;
                            case 109 -> 42;
                            case 110 -> 108;
                            case 111 -> 34;
                            case 112 -> 140;
                            case 113 -> 230;
                            case 114 -> 164;
                            case 115 -> 60;
                            case 116 -> 7;
                            case 117 -> 175;
                            case 118 -> 80;
                            case 119 -> 167;
                            case 120 -> 157;
                            case 121 -> 245;
                            case 122 -> 233;
                            case 123 -> 240;
                            case 124 -> 166;
                            case 125 -> 160;
                            case 126 -> 191;
                            case 127 -> 16;
                            case 128 -> 31;
                            case 129 -> 6;
                            case 130 -> 218;
                            case 131 -> 244;
                            case 132 -> 74;
                            case 133 -> 105;
                            case 134 -> 126;
                            case 135 -> 209;
                            case 136 -> 67;
                            case 137 -> 239;
                            case 138 -> 249;
                            case 139 -> 204;
                            case 140 -> 33;
                            case 141 -> 136;
                            case 142 -> 231;
                            case 143 -> 241;
                            case 144 -> 53;
                            case 145 -> 25;
                            case 146 -> 35;
                            case 147 -> 117;
                            case 148 -> 205;
                            case 149 -> 212;
                            case 150 -> 116;
                            case 151 -> 135;
                            case 152 -> 142;
                            case 153 -> 115;
                            case 154 -> 145;
                            case 155 -> 173;
                            case 156 -> 23;
                            case 157 -> 199;
                            case 158 -> 3;
                            case 159 -> 95;
                            case 160 -> 156;
                            case 161 -> 20;
                            case 162 -> 110;
                            case 163 -> 98;
                            case 164 -> 59;
                            case 165 -> 14;
                            case 166 -> 124;
                            case 167 -> 182;
                            case 168 -> 121;
                            case 169 -> 133;
                            case 170 -> 141;
                            case 171 -> 185;
                            case 172 -> 84;
                            case 173 -> 29;
                            case 174 -> 223;
                            case 175 -> 153;
                            case 176 -> 26;
                            case 177 -> 206;
                            case 178 -> 198;
                            case 179 -> 58;
                            case 180 -> 81;
                            case 181 -> 55;
                            case 182 -> 113;
                            case 183 -> 119;
                            case 184 -> 70;
                            case 185 -> 61;
                            case 186 -> 8;
                            case 187 -> 170;
                            case 188 -> 197;
                            case 189 -> 47;
                            case 190 -> 94;
                            case 191 -> 163;
                            case 192 -> 246;
                            case 193 -> 9;
                            case 194 -> 165;
                            case 195 -> 13;
                            case 196 -> 187;
                            case 197 -> 147;
                            case 198 -> 216;
                            case 199 -> 183;
                            case 200 -> 159;
                            case 201 -> 222;
                            case 202 -> 253;
                            case 203 -> 189;
                            case 204 -> 104;
                            case 205 -> 143;
                            case 206 -> 172;
                            case 207 -> 229;
                            case 208 -> 122;
                            case 209 -> 196;
                            case 210 -> 22;
                            case 211 -> 17;
                            case 212 -> 125;
                            case 213 -> 148;
                            case 214 -> 41;
                            case 215 -> 174;
                            case 216 -> 144;
                            case 217 -> 201;
                            case 218 -> 72;
                            case 219 -> 87;
                            case 220 -> 169;
                            case 221 -> 43;
                            case 222 -> 91;
                            case 223 -> 56;
                            case 224 -> 219;
                            case 225 -> 38;
                            case 226 -> 225;
                            case 227 -> 83;
                            case 228 -> 37;
                            case 229 -> 137;
                            case 230 -> 85;
                            case 231 -> 194;
                            case 232 -> 186;
                            case 233 -> 51;
                            case 234 -> 102;
                            case 235 -> 86;
                            case 236 -> 82;
                            case 237 -> 224;
                            case 238 -> 238;
                            case 239 -> 64;
                            case 240 -> 177;
                            case 241 -> 54;
                            case 242 -> 158;
                            case 243 -> 138;
                            case 244 -> 27;
                            case 245 -> 210;
                            case 246 -> 139;
                            case 247 -> 120;
                            case 248 -> 155;
                            case 249 -> 0;
                            case 250 -> 63;
                            case 251 -> 69;
                            case 252 -> 179;
                            case 253 -> 171;
                            case 254 -> 44;
                            default -> 130;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string == null) {
                ActionTimestamp.O(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 40895844733579L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.O();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(833867340 - 3828, -833867340 + -10800, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(833867340 - 3832, 833867340 - 5810, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(833867340 - 3851, -833867340 - -13909, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(833867340 - 3828, -833867340 + -10800, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(833867340 - 3832, 833867340 - 5810, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(833867340 - 3852, 833867340 - 7226, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 7733653356862L;
                        String string3 = SshAgentIpcService.O();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1582801320 - (char)-2890, -1582801320 - -((char)-19642), (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1582801320 - (char)-2891, 1582801320 - (char)-5697, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 8628926791953L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.O();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-337505250 - -6308, 337505250 - 22468, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-337505250 - -6320, -337505250 - -4066, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-337505250 - -6337, 337505250 - 2889, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-337505250 - -6320, -337505250 - -4066, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-337505250 - -6310, -337505250 - -7850, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-337505250 - -6308, 337505250 - 22468, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-337505250 - -6320, -337505250 - -4066, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-337505250 - -6336, 337505250 - 9796, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-337505250 - -6308, 337505250 - 22468, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-337505250 - -6320, -337505250 - -4066, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-337505250 - -6323, 337505250 - 11678, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-337505250 - -6308, 337505250 - 22468, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-337505250 - -6320, -337505250 - -4066, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-337505250 - -6322, -337505250 - -21499, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 129432742818092L;
                    Object object = this.lock;
                    string = SshAgentIpcService.O();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(391637160 - 19369, -391637160 - -3275, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(391637160 - 19381, 391637160 - 21611, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(391637160 - 19386, -391637160 - -11072, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(391637160 - 19385, -391637160 - -9085, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(391637160 - 19369, -391637160 - -3275, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(391637160 - 19381, 391637160 - 21611, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(391637160 - 19392, 391637160 - 343, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(391637160 - 19369, -391637160 - -3275, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(391637160 - 19381, 391637160 - 21611, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(391637160 - 19391, 391637160 + 90, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(391637160 - 19369, -391637160 - -3275, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(391637160 - 19381, 391637160 - 21611, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(391637160 - 19390, 391637160 - 12151, (int)l2));
                    if (string == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(391637160 - 19369, -391637160 - -3275, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(391637160 - 19381, 391637160 - 21611, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(391637160 - 19389, -391637160 - -22346, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00ade\u00b7\u0098ul'\u0086\u0014\u0096\u0099\u00e8\u00e0`\u00eb*l\u0084t\u008a\u000eM\u00ef\u001d\u0003Z\u00a5\u00da\u00e3\u0006V\u0085\u00c8\u0084\u00f0\u00ae\u0018\fl\u00dbn\u0084\u00ff\u00b4.\u009fA\u00e6\u00d8\u00a6\u00ca2%\u0016\b}\u00cb\u00b5=m_\t\u00c1\u00a5\u00fc\u00e6\u000bq]\u00b7\u009e\u0005\u00ad\u00b5\u00b7\u0082\u0005\bN\u00e0\u00cbY\u00a8r\u009a\u00a7\u0005\u0096\u00d2\u00d0n\u00e9\u001e\u0097\u00c3\u00e5(\u00d2\u00f3\u00dc\u00d57*\u00b82!\u00b7`\u00ee\u00bd\u00e0\u00da\"\u00ed/j\u00d0\u0000?H\u0013i\u0098\u0010\u0012\u00d5\u00b1/\u000f!\u0091v\u00e3\u00ec\u00af\u0017\u00c5FSO\t\u008e4\u00c3\u00c5\u00bf2\u00ed@f\u0010\u0086C#\u00fd]{\u00db=\u00aa\u0085\u0086:\u00e0\u00e3\u00f7\u00fb?[\u00e5t\u00ec\u00edb\u00be\u008b\n0Z\u008a\u00c2V!\u00ebP%\u001a_{\u00d2\u00c3\t%\u00ec\u00e1\u00ddk\u0017\u00e6\u00a1\u00d3\u00bc\u0095\u00d9e\u00dc\u00ca\u0015\u0001\u00ae\u00c4\u00d5\u00f5\u008c\u00df\u0091\u00fe\u0087\u00dd\u00d2\u00c4\u0088\u00f2\u00e6\u00aa\u0001\tI\u0002\u00d6 \bY\\)\u00ce\u00f4\u0080\u0011\u00f9\f\u008e\u00e5\u00c3\u00e2\u00b4g\u00f7\u0002\u0006*A\u00cbF\u00ee\u00ce\u00cf\u00875\u00cb\u00c7\u0097\u0000\u0094\u008b\u00d8n\u0014\u00ab\u0085\u00fd\u008f\u00af\u00a5\u00df\u00dfT\u009a\u00e1\u00b5\u008a\u00fd\u00b9:\u00868\u00e39QH'\u00a3)>\u00ee\u00de\u00b2 \u00e5\u00b7\u0089\u008b\u00d3<\u001e\u000fS\u00a5\u0016X\u00a9\u00a2\u00ff\u0081\u00ef\u00a6\u00c1\u0010U\u00aa&y9\u00a9\u001f\u00d3\u00fam\u000f\u00c3\u0017\u00feIs\u00b90@0\u00e4I5\u00e3sl\u009a\u00f0\u00b8\u001e\u0089\u00ef\u00c4\u00a2\u00a0)\u001f\u0096\u000b\u0015\u001d\u00b0\u00fd\u00da\u0084:~\u00bf\u00a9|\u0015<\u009f\u0095\u00aey\u0086\u00a2C\u0092\u00ee\u0011a\u00aal\u0007r\u00d1\u000f\u00f7l\u00b5)\u008a\u00d6F\u008a\u00a6\u00a7R_\u00e6{\u0082\u0018b\u00e5\u009d\u0010&_\u000f\u00b8l\u0084K\u0016*~\u00cd\u008f\u00eb\u000eL\u0080D\u008b\u00c3\u0093k\u00c5+[\r\u0007\u00a6\u00f5\u00c9\u00f4s5s\u00074\u0014\u00ff\u00a4R\u00d0A(\u0084U\u00cb\u00db\u00a7\u00e7\u0084pLI\u00fdh\u00aejFbZ\u00bc.\u0087)]\u008c\u00e6B\u00dcv\u00a0\u00ab\u008b\u009f)\u00c5\u00d5m\u00f5\u0004tU\u009e\u000f\u00a55\u00a1\u00fe\u0002/\u0095\u00aa\u001b\u009f\u00b6\u00e3gO\u00e1\"\u001akT=\u00e4Q\u001a\u0081\u00ef\u00a0\u00a3cE\u0086\u001d\u00b2\u00dd\"\u00faU89a\u00f1\u00fc\u00d6\u00daD-E6\u00ee%\u00b5\u000e\u0094n\u0087\u0095\u00c6B\r\u0007\b*\u00d4U'\u0093\u001bP\u00c8\u0018D\u00ce\u00cd\u0099\u00aa\u00cd\u0018\u00e1\u0012\u00d1M\u00a9\u00dd\u00e3e\u0080!L\u0083\u009c\u0000\b\u0085\u0011\n\u008e\u00d5\u0007\u00e09\u00bd\u00b4\u008e\u00c3\u00fe\u0018L\u00ae\u009b\u0085\u00bfI\u0096d2\b\u00dc\u008f\u00cf\u00ad\u0096\u00e0s\u00c3E\u008c\u008c}\u00df\u008c)\u0006\u0087\u00d7\u00a0\u0094\u00e2\u0014\u00f7.n\u009b\u00baE\u00b8\u00e6\u00c070\u00f2\u0090\u00e9\u0091\u00b2\u00b8`9\u0019\u008b\"\u00d2\u00ce\u008a1\u0014\u00b8\u00f4\u00da\r\u001dB\u00cb";
                var4_3 = "\u00ade\u00b7\u0098ul'\u0086\u0014\u0096\u0099\u00e8\u00e0`\u00eb*l\u0084t\u008a\u000eM\u00ef\u001d\u0003Z\u00a5\u00da\u00e3\u0006V\u0085\u00c8\u0084\u00f0\u00ae\u0018\fl\u00dbn\u0084\u00ff\u00b4.\u009fA\u00e6\u00d8\u00a6\u00ca2%\u0016\b}\u00cb\u00b5=m_\t\u00c1\u00a5\u00fc\u00e6\u000bq]\u00b7\u009e\u0005\u00ad\u00b5\u00b7\u0082\u0005\bN\u00e0\u00cbY\u00a8r\u009a\u00a7\u0005\u0096\u00d2\u00d0n\u00e9\u001e\u0097\u00c3\u00e5(\u00d2\u00f3\u00dc\u00d57*\u00b82!\u00b7`\u00ee\u00bd\u00e0\u00da\"\u00ed/j\u00d0\u0000?H\u0013i\u0098\u0010\u0012\u00d5\u00b1/\u000f!\u0091v\u00e3\u00ec\u00af\u0017\u00c5FSO\t\u008e4\u00c3\u00c5\u00bf2\u00ed@f\u0010\u0086C#\u00fd]{\u00db=\u00aa\u0085\u0086:\u00e0\u00e3\u00f7\u00fb?[\u00e5t\u00ec\u00edb\u00be\u008b\n0Z\u008a\u00c2V!\u00ebP%\u001a_{\u00d2\u00c3\t%\u00ec\u00e1\u00ddk\u0017\u00e6\u00a1\u00d3\u00bc\u0095\u00d9e\u00dc\u00ca\u0015\u0001\u00ae\u00c4\u00d5\u00f5\u008c\u00df\u0091\u00fe\u0087\u00dd\u00d2\u00c4\u0088\u00f2\u00e6\u00aa\u0001\tI\u0002\u00d6 \bY\\)\u00ce\u00f4\u0080\u0011\u00f9\f\u008e\u00e5\u00c3\u00e2\u00b4g\u00f7\u0002\u0006*A\u00cbF\u00ee\u00ce\u00cf\u00875\u00cb\u00c7\u0097\u0000\u0094\u008b\u00d8n\u0014\u00ab\u0085\u00fd\u008f\u00af\u00a5\u00df\u00dfT\u009a\u00e1\u00b5\u008a\u00fd\u00b9:\u00868\u00e39QH'\u00a3)>\u00ee\u00de\u00b2 \u00e5\u00b7\u0089\u008b\u00d3<\u001e\u000fS\u00a5\u0016X\u00a9\u00a2\u00ff\u0081\u00ef\u00a6\u00c1\u0010U\u00aa&y9\u00a9\u001f\u00d3\u00fam\u000f\u00c3\u0017\u00feIs\u00b90@0\u00e4I5\u00e3sl\u009a\u00f0\u00b8\u001e\u0089\u00ef\u00c4\u00a2\u00a0)\u001f\u0096\u000b\u0015\u001d\u00b0\u00fd\u00da\u0084:~\u00bf\u00a9|\u0015<\u009f\u0095\u00aey\u0086\u00a2C\u0092\u00ee\u0011a\u00aal\u0007r\u00d1\u000f\u00f7l\u00b5)\u008a\u00d6F\u008a\u00a6\u00a7R_\u00e6{\u0082\u0018b\u00e5\u009d\u0010&_\u000f\u00b8l\u0084K\u0016*~\u00cd\u008f\u00eb\u000eL\u0080D\u008b\u00c3\u0093k\u00c5+[\r\u0007\u00a6\u00f5\u00c9\u00f4s5s\u00074\u0014\u00ff\u00a4R\u00d0A(\u0084U\u00cb\u00db\u00a7\u00e7\u0084pLI\u00fdh\u00aejFbZ\u00bc.\u0087)]\u008c\u00e6B\u00dcv\u00a0\u00ab\u008b\u009f)\u00c5\u00d5m\u00f5\u0004tU\u009e\u000f\u00a55\u00a1\u00fe\u0002/\u0095\u00aa\u001b\u009f\u00b6\u00e3gO\u00e1\"\u001akT=\u00e4Q\u001a\u0081\u00ef\u00a0\u00a3cE\u0086\u001d\u00b2\u00dd\"\u00faU89a\u00f1\u00fc\u00d6\u00daD-E6\u00ee%\u00b5\u000e\u0094n\u0087\u0095\u00c6B\r\u0007\b*\u00d4U'\u0093\u001bP\u00c8\u0018D\u00ce\u00cd\u0099\u00aa\u00cd\u0018\u00e1\u0012\u00d1M\u00a9\u00dd\u00e3e\u0080!L\u0083\u009c\u0000\b\u0085\u0011\n\u008e\u00d5\u0007\u00e09\u00bd\u00b4\u008e\u00c3\u00fe\u0018L\u00ae\u009b\u0085\u00bfI\u0096d2\b\u00dc\u008f\u00cf\u00ad\u0096\u00e0s\u00c3E\u008c\u008c}\u00df\u008c)\u0006\u0087\u00d7\u00a0\u0094\u00e2\u0014\u00f7.n\u009b\u00baE\u00b8\u00e6\u00c070\u00f2\u0090\u00e9\u0091\u00b2\u00b8`9\u0019\u008b\"\u00d2\u00ce\u008a1\u0014\u00b8\u00f4\u00da\r\u001dB\u00cb".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 59;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = ":|\u0003\u0084\u00fb\u0083e{\u009c\u001d%\u00af\u00e5\u00f3\u0084\u00de@&\u00f2\u0002Va\u00aa\u0095M3\u0014\u0014\u0090\u00c6\u00a62\u00feD\u0014\u00ecP\"\u00cd";
                    var4_3 = ":|\u0003\u0084\u00fb\u0083e{\u009c\u001d%\u00af\u00e5\u00f3\u0084\u00de@&\u00f2\u0002Va\u00aa\u0095M3\u0014\u0014\u0090\u00c6\u00a62\u00feD\u0014\u00ecP\"\u00cd".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 59;
                            break;
                        }
                        case 1: {
                            v15 = 58;
                            break;
                        }
                        case 2: {
                            v15 = 55;
                            break;
                        }
                        case 3: {
                            v15 = 14;
                            break;
                        }
                        case 4: {
                            v15 = 23;
                            break;
                        }
                        case 5: {
                            v15 = 74;
                            break;
                        }
                        default: {
                            v15 = 25;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFEDD8) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 204;
                case 1 -> 45;
                case 2 -> 152;
                case 3 -> 194;
                case 4 -> 50;
                case 5 -> 231;
                case 6 -> 242;
                case 7 -> 56;
                case 8 -> 157;
                case 9 -> 129;
                case 10 -> 82;
                case 11 -> 170;
                case 12 -> 24;
                case 13 -> 133;
                case 14 -> 69;
                case 15 -> 220;
                case 16 -> 234;
                case 17 -> 195;
                case 18 -> 26;
                case 19 -> 250;
                case 20 -> 4;
                case 21 -> 254;
                case 22 -> 80;
                case 23 -> 246;
                case 24 -> 226;
                case 25 -> 161;
                case 26 -> 53;
                case 27 -> 17;
                case 28 -> 203;
                case 29 -> 44;
                case 30 -> 54;
                case 31 -> 138;
                case 32 -> 227;
                case 33 -> 115;
                case 34 -> 141;
                case 35 -> 197;
                case 36 -> 1;
                case 37 -> 99;
                case 38 -> 117;
                case 39 -> 200;
                case 40 -> 224;
                case 41 -> 85;
                case 42 -> 110;
                case 43 -> 237;
                case 44 -> 251;
                case 45 -> 189;
                case 46 -> 236;
                case 47 -> 147;
                case 48 -> 230;
                case 49 -> 123;
                case 50 -> 3;
                case 51 -> 174;
                case 52 -> 144;
                case 53 -> 59;
                case 54 -> 165;
                case 55 -> 223;
                case 56 -> 247;
                case 57 -> 136;
                case 58 -> 241;
                case 59 -> 221;
                case 60 -> 124;
                case 61 -> 126;
                case 62 -> 102;
                case 63 -> 41;
                case 64 -> 31;
                case 65 -> 211;
                case 66 -> 15;
                case 67 -> 164;
                case 68 -> 163;
                case 69 -> 132;
                case 70 -> 107;
                case 71 -> 217;
                case 72 -> 48;
                case 73 -> 140;
                case 74 -> 120;
                case 75 -> 235;
                case 76 -> 7;
                case 77 -> 225;
                case 78 -> 116;
                case 79 -> 29;
                case 80 -> 74;
                case 81 -> 114;
                case 82 -> 128;
                case 83 -> 71;
                case 84 -> 248;
                case 85 -> 156;
                case 86 -> 146;
                case 87 -> 219;
                case 88 -> 249;
                case 89 -> 118;
                case 90 -> 206;
                case 91 -> 35;
                case 92 -> 40;
                case 93 -> 130;
                case 94 -> 64;
                case 95 -> 67;
                case 96 -> 168;
                case 97 -> 191;
                case 98 -> 84;
                case 99 -> 151;
                case 100 -> 176;
                case 101 -> 106;
                case 102 -> 244;
                case 103 -> 49;
                case 104 -> 215;
                case 105 -> 11;
                case 106 -> 73;
                case 107 -> 25;
                case 108 -> 94;
                case 109 -> 95;
                case 110 -> 199;
                case 111 -> 245;
                case 112 -> 65;
                case 113 -> 135;
                case 114 -> 218;
                case 115 -> 23;
                case 116 -> 232;
                case 117 -> 169;
                case 118 -> 79;
                case 119 -> 134;
                case 120 -> 34;
                case 121 -> 57;
                case 122 -> 77;
                case 123 -> 60;
                case 124 -> 159;
                case 125 -> 76;
                case 126 -> 10;
                case 127 -> 16;
                case 128 -> 148;
                case 129 -> 229;
                case 130 -> 63;
                case 131 -> 104;
                case 132 -> 228;
                case 133 -> 160;
                case 134 -> 46;
                case 135 -> 88;
                case 136 -> 9;
                case 137 -> 92;
                case 138 -> 233;
                case 139 -> 239;
                case 140 -> 8;
                case 141 -> 139;
                case 142 -> 87;
                case 143 -> 47;
                case 144 -> 96;
                case 145 -> 186;
                case 146 -> 180;
                case 147 -> 177;
                case 148 -> 90;
                case 149 -> 207;
                case 150 -> 43;
                case 151 -> 216;
                case 152 -> 27;
                case 153 -> 119;
                case 154 -> 193;
                case 155 -> 153;
                case 156 -> 222;
                case 157 -> 121;
                case 158 -> 137;
                case 159 -> 210;
                case 160 -> 243;
                case 161 -> 89;
                case 162 -> 18;
                case 163 -> 12;
                case 164 -> 171;
                case 165 -> 240;
                case 166 -> 202;
                case 167 -> 37;
                case 168 -> 181;
                case 169 -> 42;
                case 170 -> 190;
                case 171 -> 185;
                case 172 -> 86;
                case 173 -> 113;
                case 174 -> 70;
                case 175 -> 209;
                case 176 -> 61;
                case 177 -> 214;
                case 178 -> 20;
                case 179 -> 81;
                case 180 -> 122;
                case 181 -> 127;
                case 182 -> 150;
                case 183 -> 55;
                case 184 -> 149;
                case 185 -> 188;
                case 186 -> 21;
                case 187 -> 166;
                case 188 -> 6;
                case 189 -> 182;
                case 190 -> 173;
                case 191 -> 14;
                case 192 -> 108;
                case 193 -> 52;
                case 194 -> 0;
                case 195 -> 98;
                case 196 -> 28;
                case 197 -> 155;
                case 198 -> 93;
                case 199 -> 125;
                case 200 -> 192;
                case 201 -> 205;
                case 202 -> 158;
                case 203 -> 184;
                case 204 -> 91;
                case 205 -> 33;
                case 206 -> 62;
                case 207 -> 72;
                case 208 -> 145;
                case 209 -> 167;
                case 210 -> 30;
                case 211 -> 111;
                case 212 -> 101;
                case 213 -> 252;
                case 214 -> 75;
                case 215 -> 255;
                case 216 -> 196;
                case 217 -> 13;
                case 218 -> 39;
                case 219 -> 143;
                case 220 -> 201;
                case 221 -> 97;
                case 222 -> 2;
                case 223 -> 38;
                case 224 -> 83;
                case 225 -> 112;
                case 226 -> 238;
                case 227 -> 212;
                case 228 -> 198;
                case 229 -> 183;
                case 230 -> 253;
                case 231 -> 36;
                case 232 -> 5;
                case 233 -> 68;
                case 234 -> 105;
                case 235 -> 100;
                case 236 -> 58;
                case 237 -> 32;
                case 238 -> 109;
                case 239 -> 142;
                case 240 -> 66;
                case 241 -> 213;
                case 242 -> 172;
                case 243 -> 103;
                case 244 -> 162;
                case 245 -> 22;
                case 246 -> 78;
                case 247 -> 19;
                case 248 -> 131;
                case 249 -> 178;
                case 250 -> 51;
                case 251 -> 208;
                case 252 -> 175;
                case 253 -> 154;
                case 254 -> 179;
                default -> 187;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 60031037783982L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-279834450 + -((char)-3801), 279834450 + (char)-10396, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 42828924319430L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.O();
                            try {
                                hANDLE2 = hANDLE;
                                if (string == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(489546450 + 29724, -489546450 + -9382, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(489546450 + 29723, -489546450 + -18056, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(489546450 + 29722, 489546450 + 28529, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "g\u00edPh\u00a9D\u00fb\u0083\u0010~\u000e\u0082\u00b5ID\u001e\u00da\u008f\u00c7\u00c3R~\u00a9$/";
                    var4_3 = "g\u00edPh\u00a9D\u00fb\u0083\u0010~\u000e\u0082\u00b5ID\u001e\u00da\u008f\u00c7\u00c3R~\u00a9$/".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 41;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "T\u00bf\"6\u00835\u00db\u0012\u00c4\u00ef\u008d\"\u008a\u00a9~\u0006{\u00be\u008a\u00ca\u00ab\u00dd\u00b5\u00df\u0005\u00b3\u00d7\u00desv\u00a7\u0098\u008c*BP\u00b8\u00fb\u00d0i\u00a26\u00cf\u00a1.\u00e5\u000f\u00cc\u0086\u00f8B7\u00efV\u001f\u009d{\u001e\u00a0";
                        var4_3 = "T\u00bf\"6\u00835\u00db\u0012\u00c4\u00ef\u008d\"\u008a\u00a9~\u0006{\u00be\u008a\u00ca\u00ab\u00dd\u00b5\u00df\u0005\u00b3\u00d7\u00desv\u00a7\u0098\u008c*BP\u00b8\u00fb\u00d0i\u00a26\u00cf\u00a1.\u00e5\u000f\u00cc\u0086\u00f8B7\u00efV\u001f\u009d{\u001e\u00a0".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 82;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 70;
                                break;
                            }
                            case 1: {
                                v15 = 116;
                                break;
                            }
                            case 2: {
                                v15 = 118;
                                break;
                            }
                            case 3: {
                                v15 = 118;
                                break;
                            }
                            case 4: {
                                v15 = 79;
                                break;
                            }
                            case 5: {
                                v15 = 35;
                                break;
                            }
                            default: {
                                v15 = 5;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA029) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 37;
                    case 1 -> 247;
                    case 2 -> 202;
                    case 3 -> 74;
                    case 4 -> 180;
                    case 5 -> 223;
                    case 6 -> 55;
                    case 7 -> 212;
                    case 8 -> 160;
                    case 9 -> 50;
                    case 10 -> 197;
                    case 11 -> 117;
                    case 12 -> 20;
                    case 13 -> 104;
                    case 14 -> 91;
                    case 15 -> 241;
                    case 16 -> 93;
                    case 17 -> 216;
                    case 18 -> 122;
                    case 19 -> 227;
                    case 20 -> 153;
                    case 21 -> 89;
                    case 22 -> 210;
                    case 23 -> 149;
                    case 24 -> 179;
                    case 25 -> 107;
                    case 26 -> 245;
                    case 27 -> 53;
                    case 28 -> 81;
                    case 29 -> 57;
                    case 30 -> 112;
                    case 31 -> 191;
                    case 32 -> 2;
                    case 33 -> 215;
                    case 34 -> 59;
                    case 35 -> 64;
                    case 36 -> 237;
                    case 37 -> 173;
                    case 38 -> 13;
                    case 39 -> 21;
                    case 40 -> 62;
                    case 41 -> 198;
                    case 42 -> 51;
                    case 43 -> 131;
                    case 44 -> 94;
                    case 45 -> 244;
                    case 46 -> 185;
                    case 47 -> 126;
                    case 48 -> 114;
                    case 49 -> 87;
                    case 50 -> 186;
                    case 51 -> 36;
                    case 52 -> 189;
                    case 53 -> 218;
                    case 54 -> 90;
                    case 55 -> 23;
                    case 56 -> 115;
                    case 57 -> 47;
                    case 58 -> 222;
                    case 59 -> 133;
                    case 60 -> 188;
                    case 61 -> 166;
                    case 62 -> 4;
                    case 63 -> 238;
                    case 64 -> 48;
                    case 65 -> 121;
                    case 66 -> 194;
                    case 67 -> 84;
                    case 68 -> 154;
                    case 69 -> 137;
                    case 70 -> 31;
                    case 71 -> 246;
                    case 72 -> 32;
                    case 73 -> 25;
                    case 74 -> 176;
                    case 75 -> 195;
                    case 76 -> 240;
                    case 77 -> 0;
                    case 78 -> 236;
                    case 79 -> 116;
                    case 80 -> 187;
                    case 81 -> 6;
                    case 82 -> 58;
                    case 83 -> 8;
                    case 84 -> 200;
                    case 85 -> 199;
                    case 86 -> 60;
                    case 87 -> 145;
                    case 88 -> 40;
                    case 89 -> 38;
                    case 90 -> 79;
                    case 91 -> 156;
                    case 92 -> 184;
                    case 93 -> 75;
                    case 94 -> 123;
                    case 95 -> 15;
                    case 96 -> 85;
                    case 97 -> 136;
                    case 98 -> 168;
                    case 99 -> 150;
                    case 100 -> 12;
                    case 101 -> 99;
                    case 102 -> 138;
                    case 103 -> 214;
                    case 104 -> 205;
                    case 105 -> 68;
                    case 106 -> 164;
                    case 107 -> 254;
                    case 108 -> 165;
                    case 109 -> 52;
                    case 110 -> 35;
                    case 111 -> 77;
                    case 112 -> 124;
                    case 113 -> 98;
                    case 114 -> 196;
                    case 115 -> 69;
                    case 116 -> 230;
                    case 117 -> 190;
                    case 118 -> 181;
                    case 119 -> 56;
                    case 120 -> 127;
                    case 121 -> 108;
                    case 122 -> 120;
                    case 123 -> 192;
                    case 124 -> 88;
                    case 125 -> 249;
                    case 126 -> 242;
                    case 127 -> 172;
                    case 128 -> 130;
                    case 129 -> 211;
                    case 130 -> 201;
                    case 131 -> 128;
                    case 132 -> 206;
                    case 133 -> 73;
                    case 134 -> 96;
                    case 135 -> 234;
                    case 136 -> 76;
                    case 137 -> 105;
                    case 138 -> 183;
                    case 139 -> 221;
                    case 140 -> 141;
                    case 141 -> 17;
                    case 142 -> 86;
                    case 143 -> 231;
                    case 144 -> 132;
                    case 145 -> 3;
                    case 146 -> 226;
                    case 147 -> 143;
                    case 148 -> 178;
                    case 149 -> 14;
                    case 150 -> 113;
                    case 151 -> 177;
                    case 152 -> 100;
                    case 153 -> 146;
                    case 154 -> 42;
                    case 155 -> 193;
                    case 156 -> 239;
                    case 157 -> 72;
                    case 158 -> 110;
                    case 159 -> 43;
                    case 160 -> 46;
                    case 161 -> 44;
                    case 162 -> 134;
                    case 163 -> 109;
                    case 164 -> 83;
                    case 165 -> 139;
                    case 166 -> 33;
                    case 167 -> 7;
                    case 168 -> 61;
                    case 169 -> 67;
                    case 170 -> 167;
                    case 171 -> 148;
                    case 172 -> 225;
                    case 173 -> 135;
                    case 174 -> 174;
                    case 175 -> 11;
                    case 176 -> 71;
                    case 177 -> 155;
                    case 178 -> 224;
                    case 179 -> 54;
                    case 180 -> 217;
                    case 181 -> 1;
                    case 182 -> 219;
                    case 183 -> 147;
                    case 184 -> 159;
                    case 185 -> 26;
                    case 186 -> 16;
                    case 187 -> 95;
                    case 188 -> 157;
                    case 189 -> 34;
                    case 190 -> 228;
                    case 191 -> 10;
                    case 192 -> 140;
                    case 193 -> 18;
                    case 194 -> 103;
                    case 195 -> 29;
                    case 196 -> 158;
                    case 197 -> 235;
                    case 198 -> 97;
                    case 199 -> 151;
                    case 200 -> 252;
                    case 201 -> 39;
                    case 202 -> 253;
                    case 203 -> 49;
                    case 204 -> 45;
                    case 205 -> 204;
                    case 206 -> 248;
                    case 207 -> 144;
                    case 208 -> 24;
                    case 209 -> 82;
                    case 210 -> 232;
                    case 211 -> 106;
                    case 212 -> 203;
                    case 213 -> 70;
                    case 214 -> 5;
                    case 215 -> 9;
                    case 216 -> 66;
                    case 217 -> 27;
                    case 218 -> 80;
                    case 219 -> 41;
                    case 220 -> 207;
                    case 221 -> 28;
                    case 222 -> 162;
                    case 223 -> 101;
                    case 224 -> 255;
                    case 225 -> 78;
                    case 226 -> 243;
                    case 227 -> 171;
                    case 228 -> 102;
                    case 229 -> 30;
                    case 230 -> 152;
                    case 231 -> 169;
                    case 232 -> 22;
                    case 233 -> 161;
                    case 234 -> 125;
                    case 235 -> 209;
                    case 236 -> 92;
                    case 237 -> 233;
                    case 238 -> 251;
                    case 239 -> 175;
                    case 240 -> 163;
                    case 241 -> 182;
                    case 242 -> 19;
                    case 243 -> 118;
                    case 244 -> 65;
                    case 245 -> 170;
                    case 246 -> 142;
                    case 247 -> 250;
                    case 248 -> 208;
                    case 249 -> 220;
                    case 250 -> 63;
                    case 251 -> 129;
                    case 252 -> 213;
                    case 253 -> 119;
                    case 254 -> 229;
                    default -> 111;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 119130995651552L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0010x\"P=K:I\t\u0017r1Zp\t'U4";
                    var5_4 = "\u0010x\"P=K:I\t\u0017r1Zp\t'U4".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 79;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 52;
                                    break;
                                }
                                case 1: {
                                    v11 = 82;
                                    break;
                                }
                                case 2: {
                                    v11 = 31;
                                    break;
                                }
                                case 3: {
                                    v11 = 113;
                                    break;
                                }
                                case 4: {
                                    v11 = 23;
                                    break;
                                }
                                case 5: {
                                    v11 = 104;
                                    break;
                                }
                                default: {
                                    v11 = 70;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 22522403902001L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "m/WAo,d\u0004k1[[\ng.P[c.|M/Y\tg.P[c.|A%\r`(MVi#fA\"J\\h*";
                    var5_4 = "m/WAo,d\u0004k1[[\ng.P[c.|M/Y\tg.P[c.|A%\r`(MVi#fA\"J\\h*".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "S\u0019er[\u0017[\u0006S\u0019erW\u001d";
                        var5_4 = "S\u0019er[\u0017[\u0006S\u0019erW\u001d".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 118;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 3;
                                break;
                            }
                            case 2: {
                                v15 = 124;
                                break;
                            }
                            case 3: {
                                v15 = 119;
                                break;
                            }
                            case 4: {
                                v15 = 68;
                                break;
                            }
                            case 5: {
                                v15 = 15;
                                break;
                            }
                            default: {
                                v15 = 74;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 19508564173324L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-822726390 - -12762, 822726390 + 12129, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 116043242631292L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00b5\u00e4\u0096\u00d16\u0003h{\u0099\u0005\u0085\u00cd\u00b60\u00d1\rN{\u00f9\u00ac\u00cdEd\u00d2\u0097\u00f8\u007f,\u00b8\u0010`\u00f6\u00fb\u00f6\u00b2\u009b\u00a04\u00c6\u00a0\u00b6jgo\u0012i\u0005\u00c6d\u00de\u0005\u00dc3\u0001\u00d67$\u00fe\u0085\u0019\u00e3\u008c\u00a7t\u00a3\u00f9\u0007\u00ed{\u00e3Xx\u00e0\n\u00b3$\u00fd\u00ce\u00b6\u00ebl\u0011\u00a6C0\u00ae\u0015X\u00d3\u00e0\u00f13%\u0092[%\u00b2\u00e9D4\u00b18P\u00e5";
                    var4_3 = "\u00b5\u00e4\u0096\u00d16\u0003h{\u0099\u0005\u0085\u00cd\u00b60\u00d1\rN{\u00f9\u00ac\u00cdEd\u00d2\u0097\u00f8\u007f,\u00b8\u0010`\u00f6\u00fb\u00f6\u00b2\u009b\u00a04\u00c6\u00a0\u00b6jgo\u0012i\u0005\u00c6d\u00de\u0005\u00dc3\u0001\u00d67$\u00fe\u0085\u0019\u00e3\u008c\u00a7t\u00a3\u00f9\u0007\u00ed{\u00e3Xx\u00e0\n\u00b3$\u00fd\u00ce\u00b6\u00ebl\u0011\u00a6C0\u00ae\u0015X\u00d3\u00e0\u00f13%\u0092[%\u00b2\u00e9D4\u00b18P\u00e5".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 50;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "B\u00e8&\u00ac\u0090I}\u00f7\u00e4Ak\u00cfEB\u00cfUL\u00f9\u00ed\u00a6\u00c6\u00aa\u00ccT)H\tR\u007fl\u00day?\u00ed\u0098\u00df\u0097\u000f\u00a07\u00a4\u0016\u00efL\u0018\u0086\u00f8\u00c7\r\u00b7\u00c5\u0093L2E\u00caL\u0002\u0012a\u007f\u00ed\u00ba\u00e6\u00cf\t2\u00b2H\"o\u00c9\u00f7Em\u00a6\u00d9\u00ae\u00a4\u0002\u00a9\u00c2\u0000\n \r\u00ca\u0003\u00edM\u00fd\u00c6\u00ac";
                        var4_3 = "B\u00e8&\u00ac\u0090I}\u00f7\u00e4Ak\u00cfEB\u00cfUL\u00f9\u00ed\u00a6\u00c6\u00aa\u00ccT)H\tR\u007fl\u00day?\u00ed\u0098\u00df\u0097\u000f\u00a07\u00a4\u0016\u00efL\u0018\u0086\u00f8\u00c7\r\u00b7\u00c5\u0093L2E\u00caL\u0002\u0012a\u007f\u00ed\u00ba\u00e6\u00cf\t2\u00b2H\"o\u00c9\u00f7Em\u00a6\u00d9\u00ae\u00a4\u0002\u00a9\u00c2\u0000\n \r\u00ca\u0003\u00edM\u00fd\u00c6\u00ac".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 69;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 98;
                                break;
                            }
                            case 1: {
                                v15 = 52;
                                break;
                            }
                            case 2: {
                                v15 = 48;
                                break;
                            }
                            case 3: {
                                v15 = 90;
                                break;
                            }
                            case 4: {
                                v15 = 43;
                                break;
                            }
                            case 5: {
                                v15 = 105;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFC0E8) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 118;
                    case 1 -> 236;
                    case 2 -> 245;
                    case 3 -> 92;
                    case 4 -> 14;
                    case 5 -> 103;
                    case 6 -> 24;
                    case 7 -> 117;
                    case 8 -> 199;
                    case 9 -> 166;
                    case 10 -> 145;
                    case 11 -> 98;
                    case 12 -> 164;
                    case 13 -> 11;
                    case 14 -> 4;
                    case 15 -> 54;
                    case 16 -> 209;
                    case 17 -> 170;
                    case 18 -> 86;
                    case 19 -> 163;
                    case 20 -> 200;
                    case 21 -> 246;
                    case 22 -> 76;
                    case 23 -> 77;
                    case 24 -> 254;
                    case 25 -> 3;
                    case 26 -> 130;
                    case 27 -> 139;
                    case 28 -> 22;
                    case 29 -> 42;
                    case 30 -> 144;
                    case 31 -> 51;
                    case 32 -> 181;
                    case 33 -> 131;
                    case 34 -> 216;
                    case 35 -> 40;
                    case 36 -> 38;
                    case 37 -> 115;
                    case 38 -> 235;
                    case 39 -> 204;
                    case 40 -> 17;
                    case 41 -> 21;
                    case 42 -> 238;
                    case 43 -> 111;
                    case 44 -> 149;
                    case 45 -> 49;
                    case 46 -> 174;
                    case 47 -> 68;
                    case 48 -> 64;
                    case 49 -> 13;
                    case 50 -> 132;
                    case 51 -> 101;
                    case 52 -> 34;
                    case 53 -> 43;
                    case 54 -> 240;
                    case 55 -> 123;
                    case 56 -> 225;
                    case 57 -> 19;
                    case 58 -> 171;
                    case 59 -> 197;
                    case 60 -> 97;
                    case 61 -> 161;
                    case 62 -> 193;
                    case 63 -> 178;
                    case 64 -> 47;
                    case 65 -> 126;
                    case 66 -> 31;
                    case 67 -> 194;
                    case 68 -> 74;
                    case 69 -> 220;
                    case 70 -> 90;
                    case 71 -> 99;
                    case 72 -> 175;
                    case 73 -> 229;
                    case 74 -> 172;
                    case 75 -> 55;
                    case 76 -> 222;
                    case 77 -> 169;
                    case 78 -> 241;
                    case 79 -> 110;
                    case 80 -> 33;
                    case 81 -> 210;
                    case 82 -> 62;
                    case 83 -> 190;
                    case 84 -> 228;
                    case 85 -> 39;
                    case 86 -> 212;
                    case 87 -> 9;
                    case 88 -> 203;
                    case 89 -> 230;
                    case 90 -> 15;
                    case 91 -> 179;
                    case 92 -> 26;
                    case 93 -> 83;
                    case 94 -> 37;
                    case 95 -> 156;
                    case 96 -> 45;
                    case 97 -> 195;
                    case 98 -> 142;
                    case 99 -> 44;
                    case 100 -> 87;
                    case 101 -> 70;
                    case 102 -> 120;
                    case 103 -> 157;
                    case 104 -> 167;
                    case 105 -> 109;
                    case 106 -> 35;
                    case 107 -> 244;
                    case 108 -> 2;
                    case 109 -> 239;
                    case 110 -> 221;
                    case 111 -> 234;
                    case 112 -> 53;
                    case 113 -> 183;
                    case 114 -> 105;
                    case 115 -> 100;
                    case 116 -> 124;
                    case 117 -> 89;
                    case 118 -> 243;
                    case 119 -> 107;
                    case 120 -> 147;
                    case 121 -> 102;
                    case 122 -> 248;
                    case 123 -> 114;
                    case 124 -> 188;
                    case 125 -> 186;
                    case 126 -> 233;
                    case 127 -> 207;
                    case 128 -> 206;
                    case 129 -> 182;
                    case 130 -> 56;
                    case 131 -> 16;
                    case 132 -> 59;
                    case 133 -> 128;
                    case 134 -> 214;
                    case 135 -> 95;
                    case 136 -> 223;
                    case 137 -> 122;
                    case 138 -> 202;
                    case 139 -> 57;
                    case 140 -> 219;
                    case 141 -> 153;
                    case 142 -> 253;
                    case 143 -> 25;
                    case 144 -> 129;
                    case 145 -> 72;
                    case 146 -> 71;
                    case 147 -> 6;
                    case 148 -> 106;
                    case 149 -> 88;
                    case 150 -> 12;
                    case 151 -> 58;
                    case 152 -> 65;
                    case 153 -> 211;
                    case 154 -> 168;
                    case 155 -> 208;
                    case 156 -> 159;
                    case 157 -> 184;
                    case 158 -> 10;
                    case 159 -> 0;
                    case 160 -> 191;
                    case 161 -> 143;
                    case 162 -> 46;
                    case 163 -> 155;
                    case 164 -> 94;
                    case 165 -> 250;
                    case 166 -> 79;
                    case 167 -> 63;
                    case 168 -> 162;
                    case 169 -> 73;
                    case 170 -> 5;
                    case 171 -> 134;
                    case 172 -> 75;
                    case 173 -> 121;
                    case 174 -> 84;
                    case 175 -> 8;
                    case 176 -> 247;
                    case 177 -> 81;
                    case 178 -> 78;
                    case 179 -> 205;
                    case 180 -> 48;
                    case 181 -> 189;
                    case 182 -> 218;
                    case 183 -> 1;
                    case 184 -> 18;
                    case 185 -> 177;
                    case 186 -> 96;
                    case 187 -> 231;
                    case 188 -> 180;
                    case 189 -> 36;
                    case 190 -> 104;
                    case 191 -> 146;
                    case 192 -> 52;
                    case 193 -> 173;
                    case 194 -> 85;
                    case 195 -> 29;
                    case 196 -> 237;
                    case 197 -> 154;
                    case 198 -> 224;
                    case 199 -> 61;
                    case 200 -> 138;
                    case 201 -> 32;
                    case 202 -> 192;
                    case 203 -> 116;
                    case 204 -> 249;
                    case 205 -> 82;
                    case 206 -> 160;
                    case 207 -> 20;
                    case 208 -> 242;
                    case 209 -> 252;
                    case 210 -> 67;
                    case 211 -> 217;
                    case 212 -> 148;
                    case 213 -> 151;
                    case 214 -> 41;
                    case 215 -> 251;
                    case 216 -> 135;
                    case 217 -> 66;
                    case 218 -> 140;
                    case 219 -> 141;
                    case 220 -> 30;
                    case 221 -> 112;
                    case 222 -> 80;
                    case 223 -> 127;
                    case 224 -> 165;
                    case 225 -> 119;
                    case 226 -> 69;
                    case 227 -> 150;
                    case 228 -> 28;
                    case 229 -> 215;
                    case 230 -> 137;
                    case 231 -> 125;
                    case 232 -> 158;
                    case 233 -> 213;
                    case 234 -> 60;
                    case 235 -> 196;
                    case 236 -> 108;
                    case 237 -> 227;
                    case 238 -> 23;
                    case 239 -> 185;
                    case 240 -> 255;
                    case 241 -> 232;
                    case 242 -> 50;
                    case 243 -> 7;
                    case 244 -> 91;
                    case 245 -> 152;
                    case 246 -> 187;
                    case 247 -> 113;
                    case 248 -> 133;
                    case 249 -> 198;
                    case 250 -> 201;
                    case 251 -> 93;
                    case 252 -> 27;
                    case 253 -> 226;
                    case 254 -> 136;
                    default -> 176;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 52287319367462L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-387573990 - -((char)-3844), 387573990 - (char)-3588, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 101037692015370L;
                    String string = SshAgentIpcService.O();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1413589950 + 22653, 1413589950 + (char)-12588, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 63685748495605L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00d7<\u00f86\u00d5\u0003?k\u00b3";
                var4_3 = "\u00d7<\u00f86\u00d5\u0003?k\u00b3".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 117;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 126;
                                break;
                            }
                            case 1: {
                                v11 = 52;
                                break;
                            }
                            case 2: {
                                v11 = 62;
                                break;
                            }
                            case 3: {
                                v11 = 9;
                                break;
                            }
                            case 4: {
                                v11 = 107;
                                break;
                            }
                            case 5: {
                                v11 = 115;
                                break;
                            }
                            default: {
                                v11 = 112;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD730) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 117;
                    case 1 -> 93;
                    case 2 -> 158;
                    case 3 -> 178;
                    case 4 -> 244;
                    case 5 -> 180;
                    case 6 -> 13;
                    case 7 -> 238;
                    case 8 -> 35;
                    case 9 -> 97;
                    case 10 -> 101;
                    case 11 -> 112;
                    case 12 -> 143;
                    case 13 -> 128;
                    case 14 -> 44;
                    case 15 -> 62;
                    case 16 -> 105;
                    case 17 -> 83;
                    case 18 -> 109;
                    case 19 -> 115;
                    case 20 -> 140;
                    case 21 -> 251;
                    case 22 -> 118;
                    case 23 -> 187;
                    case 24 -> 167;
                    case 25 -> 80;
                    case 26 -> 235;
                    case 27 -> 133;
                    case 28 -> 172;
                    case 29 -> 203;
                    case 30 -> 38;
                    case 31 -> 194;
                    case 32 -> 116;
                    case 33 -> 23;
                    case 34 -> 113;
                    case 35 -> 40;
                    case 36 -> 17;
                    case 37 -> 215;
                    case 38 -> 50;
                    case 39 -> 61;
                    case 40 -> 77;
                    case 41 -> 100;
                    case 42 -> 42;
                    case 43 -> 152;
                    case 44 -> 24;
                    case 45 -> 198;
                    case 46 -> 67;
                    case 47 -> 74;
                    case 48 -> 189;
                    case 49 -> 131;
                    case 50 -> 212;
                    case 51 -> 88;
                    case 52 -> 81;
                    case 53 -> 205;
                    case 54 -> 2;
                    case 55 -> 248;
                    case 56 -> 99;
                    case 57 -> 11;
                    case 58 -> 165;
                    case 59 -> 148;
                    case 60 -> 68;
                    case 61 -> 5;
                    case 62 -> 4;
                    case 63 -> 137;
                    case 64 -> 207;
                    case 65 -> 110;
                    case 66 -> 91;
                    case 67 -> 32;
                    case 68 -> 54;
                    case 69 -> 153;
                    case 70 -> 226;
                    case 71 -> 164;
                    case 72 -> 220;
                    case 73 -> 197;
                    case 74 -> 49;
                    case 75 -> 39;
                    case 76 -> 232;
                    case 77 -> 162;
                    case 78 -> 182;
                    case 79 -> 166;
                    case 80 -> 96;
                    case 81 -> 181;
                    case 82 -> 90;
                    case 83 -> 202;
                    case 84 -> 107;
                    case 85 -> 126;
                    case 86 -> 7;
                    case 87 -> 225;
                    case 88 -> 66;
                    case 89 -> 243;
                    case 90 -> 89;
                    case 91 -> 71;
                    case 92 -> 154;
                    case 93 -> 46;
                    case 94 -> 216;
                    case 95 -> 16;
                    case 96 -> 147;
                    case 97 -> 175;
                    case 98 -> 237;
                    case 99 -> 240;
                    case 100 -> 60;
                    case 101 -> 213;
                    case 102 -> 58;
                    case 103 -> 75;
                    case 104 -> 132;
                    case 105 -> 9;
                    case 106 -> 34;
                    case 107 -> 146;
                    case 108 -> 155;
                    case 109 -> 224;
                    case 110 -> 219;
                    case 111 -> 76;
                    case 112 -> 28;
                    case 113 -> 69;
                    case 114 -> 209;
                    case 115 -> 51;
                    case 116 -> 246;
                    case 117 -> 239;
                    case 118 -> 48;
                    case 119 -> 249;
                    case 120 -> 136;
                    case 121 -> 151;
                    case 122 -> 121;
                    case 123 -> 161;
                    case 124 -> 3;
                    case 125 -> 78;
                    case 126 -> 227;
                    case 127 -> 211;
                    case 128 -> 41;
                    case 129 -> 186;
                    case 130 -> 33;
                    case 131 -> 18;
                    case 132 -> 55;
                    case 133 -> 145;
                    case 134 -> 120;
                    case 135 -> 31;
                    case 136 -> 149;
                    case 137 -> 191;
                    case 138 -> 254;
                    case 139 -> 176;
                    case 140 -> 245;
                    case 141 -> 92;
                    case 142 -> 130;
                    case 143 -> 221;
                    case 144 -> 98;
                    case 145 -> 135;
                    case 146 -> 200;
                    case 147 -> 57;
                    case 148 -> 19;
                    case 149 -> 142;
                    case 150 -> 144;
                    case 151 -> 29;
                    case 152 -> 193;
                    case 153 -> 1;
                    case 154 -> 85;
                    case 155 -> 56;
                    case 156 -> 234;
                    case 157 -> 163;
                    case 158 -> 156;
                    case 159 -> 247;
                    case 160 -> 63;
                    case 161 -> 184;
                    case 162 -> 27;
                    case 163 -> 192;
                    case 164 -> 134;
                    case 165 -> 94;
                    case 166 -> 12;
                    case 167 -> 253;
                    case 168 -> 141;
                    case 169 -> 150;
                    case 170 -> 59;
                    case 171 -> 185;
                    case 172 -> 26;
                    case 173 -> 20;
                    case 174 -> 111;
                    case 175 -> 171;
                    case 176 -> 223;
                    case 177 -> 138;
                    case 178 -> 183;
                    case 179 -> 188;
                    case 180 -> 45;
                    case 181 -> 228;
                    case 182 -> 252;
                    case 183 -> 53;
                    case 184 -> 65;
                    case 185 -> 229;
                    case 186 -> 73;
                    case 187 -> 102;
                    case 188 -> 47;
                    case 189 -> 6;
                    case 190 -> 190;
                    case 191 -> 79;
                    case 192 -> 201;
                    case 193 -> 123;
                    case 194 -> 122;
                    case 195 -> 114;
                    case 196 -> 177;
                    case 197 -> 230;
                    case 198 -> 8;
                    case 199 -> 37;
                    case 200 -> 204;
                    case 201 -> 139;
                    case 202 -> 241;
                    case 203 -> 127;
                    case 204 -> 217;
                    case 205 -> 157;
                    case 206 -> 233;
                    case 207 -> 82;
                    case 208 -> 21;
                    case 209 -> 195;
                    case 210 -> 95;
                    case 211 -> 170;
                    case 212 -> 86;
                    case 213 -> 159;
                    case 214 -> 30;
                    case 215 -> 108;
                    case 216 -> 250;
                    case 217 -> 236;
                    case 218 -> 106;
                    case 219 -> 103;
                    case 220 -> 15;
                    case 221 -> 206;
                    case 222 -> 169;
                    case 223 -> 173;
                    case 224 -> 124;
                    case 225 -> 14;
                    case 226 -> 231;
                    case 227 -> 196;
                    case 228 -> 52;
                    case 229 -> 199;
                    case 230 -> 218;
                    case 231 -> 87;
                    case 232 -> 179;
                    case 233 -> 168;
                    case 234 -> 214;
                    case 235 -> 43;
                    case 236 -> 25;
                    case 237 -> 84;
                    case 238 -> 174;
                    case 239 -> 125;
                    case 240 -> 0;
                    case 241 -> 10;
                    case 242 -> 64;
                    case 243 -> 210;
                    case 244 -> 160;
                    case 245 -> 208;
                    case 246 -> 70;
                    case 247 -> 104;
                    case 248 -> 72;
                    case 249 -> 222;
                    case 250 -> 242;
                    case 251 -> 36;
                    case 252 -> 22;
                    case 253 -> 129;
                    case 254 -> 255;
                    default -> 119;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

