/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.DataProviderHolder;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.IDataProviderMethod;
import org.testng.IRetryDataProvider;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Factory;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderLoader;
import org.testng.internal.DataProviderMethod;
import org.testng.internal.DataProviderMethodRemovable;
import org.testng.internal.FilteredParameters;
import org.testng.internal.PropertyUtils;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.internal.collections.ArrayIterator;
import org.testng.internal.invokers.MethodInvocationHelper;
import org.testng.internal.invokers.ParameterHolder;
import org.testng.internal.objects.Dispenser;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.internal.reflect.DataProviderMethodMatcher;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherContext;
import org.testng.internal.reflect.ReflectionRecipes;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Parameters {
    @Deprecated
    public static final String NULL_VALUE = "null";
    private static final List<Class<? extends Annotation>> annotationList = Arrays.asList(BeforeSuite.class, AfterSuite.class, BeforeTest.class, AfterTest.class, BeforeClass.class, AfterClass.class, BeforeGroups.class, AfterGroups.class, BeforeMethod.class, AfterMethod.class, Factory.class);
    private static final Map<String, List<Class<?>>> mapping = Maps.newHashMap();
    private static final List<Class<?>> INJECTED_TYPES;

    public static Object[] createInstantiationParameters(Constructor<?> ctor, String methodAnnotation, IAnnotationFinder finder, String[] parameterNames, Map<String, String> params, XmlSuite xmlSuite) {
        return Parameters.createParametersForConstructor(ctor, ctor.getParameterTypes(), finder.findOptionalValues(ctor), methodAnnotation, parameterNames, new MethodParameters(params, Collections.emptyMap()), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method m, Map<String, String> params, Object[] parameterValues, ITestNGMethod currentTestMethod, IAnnotationFinder finder, XmlSuite xmlSuite, ITestContext ctx, ITestResult testResult) {
        Method currentTestMeth = currentTestMethod != null ? currentTestMethod.getConstructorOrMethod().getMethod() : null;
        Map<String, String> methodParams = currentTestMethod != null ? currentTestMethod.findMethodParameters(ctx.getCurrentXmlTest()) : Collections.emptyMap();
        Class<? extends Annotation> annotation = Parameters.retrieveConfigAnnotation(m);
        String name = annotation == null ? "" : annotation.getSimpleName();
        return Parameters.createParameters(new ConstructorOrMethod(m), new MethodParameters(params, methodParams, parameterValues, currentTestMeth, ctx, testResult), finder, xmlSuite, name);
    }

    private static Class<? extends Annotation> retrieveConfigAnnotation(Method m) {
        return annotationList.stream().filter(annotation -> m.getAnnotation(annotation) != null).findAny().orElse(null);
    }

    private static Object[] createParametersForConstructor(Constructor<?> constructor, Class<?>[] parameterTypes, String[] optionalValues, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        Parameter[] paramsArray;
        Object[] inject;
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        Parameters.checkParameterTypes(constructor.getName(), parameterTypes, methodAnnotation, parameterNames);
        List vResult = Lists.newArrayList();
        if (Parameters.canInject(methodAnnotation) && (inject = ReflectionRecipes.inject(paramsArray = ReflectionRecipes.getConstructorParameters(constructor), InjectableParameter.Assistant.ALL_INJECTS, new Object[0], constructor, params.context, params.testResult)) != null) {
            vResult.addAll(Arrays.asList(inject));
        }
        List<Object> consParams = Parameters.createParams(constructor.getName(), "constructor", methodAnnotation, parameterTypes, optionalValues, parameterNames, params, xmlSuite);
        vResult.addAll(consParams);
        return vResult.toArray(new Object[0]);
    }

    private static List<Object> createParams(String name, String prefix, String methodAnnotation, Class<?>[] parameterTypes, String[] optionalValues, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        List<Object> vResult = Lists.newArrayList();
        if (optionalValues.length != parameterNames.length) {
            FilterOutInjectedTypesResult filterOutResult = Parameters.filterOutInjectedTypesFromOptionalValues(parameterTypes, optionalValues);
            optionalValues = filterOutResult.getOptionalValues();
            parameterTypes = filterOutResult.getParameterTypes();
        }
        if (parameterNames.length == 0 && optionalValues.length > 0) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                vResult.add(PropertyUtils.convertType(parameterTypes[i], optionalValues[i], ""));
            }
            return vResult;
        }
        for (int i = 0; i < parameterNames.length; ++i) {
            String p = parameterNames[i];
            String value = System.getProperty(p, params.xmlParameters.get(p));
            if (null == value) {
                if (optionalValues != null) {
                    value = optionalValues[i];
                }
                if (null == value) {
                    throw new TestNGException("Parameter '" + p + "' is required by " + methodAnnotation + " on " + prefix + " " + name + " but has not been marked @Optional or defined\n" + (String)(xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                }
            }
            vResult.add(PropertyUtils.convertType(parameterTypes[i], value, p));
        }
        return vResult;
    }

    static FilterOutInjectedTypesResult filterOutInjectedTypesFromOptionalValues(Class<?>[] parameterTypes, String[] optionalValues) {
        List<Class<?>> typeList = Lists.newArrayList(parameterTypes);
        List<String> optionalValueList = Lists.newArrayList(optionalValues);
        Iterator<Class<?>> typeIterator = typeList.iterator();
        Iterator<String> optionalIterator = optionalValueList.iterator();
        while (typeIterator.hasNext()) {
            Class<?> parameterType = typeIterator.next();
            optionalIterator.next();
            if (!INJECTED_TYPES.contains(parameterType)) continue;
            optionalIterator.remove();
            typeIterator.remove();
        }
        return new FilterOutInjectedTypesResult(typeList.toArray(new Class[0]), optionalValueList.toArray(new String[0]));
    }

    private static boolean areAllOptionalValuesNull(String[] optionalValues) {
        if (optionalValues == null || optionalValues.length == 0) {
            return true;
        }
        boolean isNull = true;
        for (String optionalValue : optionalValues) {
            if (optionalValue == null) continue;
            isNull = false;
            break;
        }
        return isNull;
    }

    private static Object[] createParametersForMethod(ConstructorOrMethod method, Class<?>[] parameterTypes, String[] optionalValues, String methodAnnotation, String[] parameterNames, MethodParameters params, XmlSuite xmlSuite) {
        if (parameterTypes.length == 0) {
            return new Object[0];
        }
        if (Parameters.areAllOptionalValuesNull(optionalValues)) {
            Parameters.checkParameterTypes(method.getName(), parameterTypes, methodAnnotation, parameterNames);
        }
        List vResult = Lists.newArrayList();
        List<Object> consParams = Parameters.createParams(method.getName(), "method", methodAnnotation, parameterTypes, optionalValues, parameterNames, params, xmlSuite);
        if (Parameters.canInject(methodAnnotation)) {
            Parameter[] paramsArray = Parameters.extractParameters(method);
            Object[] inject = ReflectionRecipes.inject(paramsArray, InjectableParameter.Assistant.ALL_INJECTS, consParams.toArray(new Object[0]), params.currentTestMethod, params.context, params.testResult);
            if (inject != null) {
                vResult.addAll(Arrays.asList(inject));
            }
        } else {
            vResult.addAll(consParams);
        }
        return vResult.toArray(new Object[0]);
    }

    private static Parameter[] extractParameters(ConstructorOrMethod method) {
        if (method.getMethod() != null) {
            return ReflectionRecipes.getMethodParameters(method.getMethod());
        }
        return ReflectionRecipes.getConstructorParameters(method.getConstructor());
    }

    private static boolean canInject(String annotation) {
        return !("@" + Test.class.getSimpleName()).equalsIgnoreCase(annotation);
    }

    private static void checkParameterTypes(String methodName, Class<?>[] parameterTypes, String methodAnnotation, String[] parameterNames) {
        int totalLength = parameterTypes.length;
        for (Class<?> parameterType : parameterTypes) {
            if (!INJECTED_TYPES.contains(parameterType)) continue;
            --totalLength;
        }
        if (parameterNames.length == 0) {
            boolean invalid;
            boolean bl = invalid = totalLength != 0 || !Parameters.validParameters(methodAnnotation, parameterTypes);
            if (invalid) {
                Object annotation = methodAnnotation;
                if (!methodAnnotation.startsWith("@")) {
                    annotation = "@" + methodAnnotation;
                }
                String errPrefix = mapping.containsKey(methodAnnotation) ? "Can inject only one of " + Parameters.prettyFormat(mapping.get(methodAnnotation)) + " into a " + (String)annotation + " annotated " + methodName : "Cannot inject " + (String)annotation + " annotated Method [" + methodName + "] with " + Arrays.toString(parameterTypes);
                throw new TestNGException(errPrefix + ".\nFor more information on native dependency injection please refer to https://testng.org/doc/documentation-main.html#native-dependency-injection");
            }
        }
        if (parameterNames.length != totalLength) {
            throw new TestNGException("Method " + methodName + " requires " + parameterTypes.length + " parameters but " + parameterNames.length + " were supplied in the " + methodAnnotation + " annotation.");
        }
    }

    private static boolean validParameters(String methodAnnotation, Class<?>[] parameterTypes) {
        List<Class<?>> localMapping = mapping.get(methodAnnotation.replace("@", ""));
        if (localMapping == null) {
            return false;
        }
        for (Class<?> parameterType : parameterTypes) {
            if (localMapping.contains(parameterType)) continue;
            return false;
        }
        return true;
    }

    private static String prettyFormat(List<Class<?>> classes) {
        StringBuilder builder = new StringBuilder("<");
        if (classes.size() == 1) {
            builder.append(classes.get(0));
        } else {
            int length = classes.size();
            for (int i = 0; i < length - 1; ++i) {
                builder.append(classes.get(i).getSimpleName()).append(", ");
            }
            builder.append(classes.get(length - 1).getSimpleName());
        }
        builder.append(">");
        return builder.toString();
    }

    private static IDataProviderMethod findDataProvider(ITestObjectFactory objectFactory, Object instance, ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder, ITestContext context) {
        IDataProviderMethod result = null;
        IDataProvidable dp = Parameters.findDataProviderInfo(clazz, m, finder);
        if (dp != null) {
            boolean isDynamicDataProvider;
            String dataProviderName = dp.getDataProvider();
            Class dataProviderClass = dp.getDataProviderClass();
            boolean bl = isDynamicDataProvider = dataProviderClass == null && !dp.getDataProviderDynamicClass().isEmpty();
            if (isDynamicDataProvider) {
                try {
                    dataProviderClass = new DataProviderLoader().loadClazz(dp.getDataProviderDynamicClass());
                }
                catch (ClassNotFoundException e) {
                    throw new TestNGException("Dynamic data provider class %s not found", e);
                }
            }
            if (!Utils.isStringEmpty(dataProviderName) && null == (result = Parameters.findDataProvider(objectFactory, instance, clazz, finder, dataProviderName, dataProviderClass, isDynamicDataProvider, context))) {
                throw new TestNGException("Method " + m + " requires a @DataProvider named : " + dataProviderName + (String)(dataProviderClass != null ? " in class " + dataProviderClass.getName() : ""));
            }
        }
        return result;
    }

    private static IDataProvidable findDataProviderInfo(ITestClass clazz, ConstructorOrMethod m, IAnnotationFinder finder) {
        if (m.getMethod() == null) {
            return AnnotationHelper.findFactory(finder, m.getConstructor());
        }
        ITestAnnotation result = AnnotationHelper.findTest(finder, m.getMethod());
        if (result != null) {
            ITestAnnotation classLevel = AnnotationHelper.findTest(finder, clazz.getRealClass());
            if (classLevel == null) {
                return result;
            }
            return Parameters.merge(result, classLevel);
        }
        IFactoryAnnotation factory = AnnotationHelper.findFactory(finder, m.getMethod());
        if (factory != null) {
            return factory;
        }
        return AnnotationHelper.findTest(finder, clazz.getRealClass());
    }

    private static IDataProvidable merge(ITestAnnotation methodLevel, ITestAnnotation classLevel) {
        if (Parameters.isDataProviderClassEmpty(classLevel) && Parameters.isDataProviderNameEmpty(classLevel)) {
            return methodLevel;
        }
        if (Strings.isNullOrEmpty(methodLevel.getDataProvider()) && Strings.isNotNullAndNotEmpty(classLevel.getDataProvider())) {
            methodLevel.setDataProvider(classLevel.getDataProvider());
        }
        if (Parameters.isDataProviderClassEmpty(methodLevel) && !Parameters.isDataProviderClassEmpty(classLevel)) {
            methodLevel.setDataProviderClass(classLevel.getDataProviderClass());
        }
        if (Parameters.isDynamicDataProviderClassEmpty(methodLevel) && !Parameters.isDynamicDataProviderClassEmpty(classLevel)) {
            methodLevel.setDataProviderDynamicClass(classLevel.getDataProviderDynamicClass());
        }
        return methodLevel;
    }

    private static boolean isDataProviderClassEmpty(ITestAnnotation annotation) {
        return annotation.getDataProviderClass() == null || Object.class.equals(annotation.getDataProviderClass());
    }

    private static boolean isDynamicDataProviderClassEmpty(ITestAnnotation annotation) {
        return annotation.getDataProviderDynamicClass().isEmpty();
    }

    private static boolean isDataProviderNameEmpty(ITestAnnotation annotation) {
        return Strings.isNullOrEmpty(annotation.getDataProvider());
    }

    private static IDataProviderMethod findDataProvider(ITestObjectFactory objectFactory, Object instance, ITestClass clazz, IAnnotationFinder finder, String name, Class<?> dataProviderClass, boolean isDynamicDataProvider, ITestContext context) {
        DataProviderMethod result = null;
        Class<?> cls = clazz.getRealClass();
        boolean shouldBeStatic = false;
        boolean isDataProviderClassAbstract = Modifier.isAbstract(cls.getModifiers());
        if (dataProviderClass != null && !isDataProviderClassAbstract) {
            cls = dataProviderClass;
            shouldBeStatic = true;
        }
        for (Method m : ClassHelper.getAvailableMethods(cls)) {
            boolean proceed;
            IDataProviderAnnotation dp = finder.findAnnotation(m, IDataProviderAnnotation.class);
            boolean bl = proceed = null != dp && name.equals(Parameters.getDataProviderName(dp, m));
            if (!proceed) continue;
            Object instanceToUse = instance;
            if (shouldBeStatic && (m.getModifiers() & 8) == 0) {
                IObjectDispenser dispenser = Dispenser.newInstance(objectFactory);
                BasicAttributes basic = new BasicAttributes(clazz, dataProviderClass);
                CreationAttributes attributes = new CreationAttributes(context, basic, null);
                instanceToUse = dispenser.dispense(attributes);
            }
            if ((m.getModifiers() & 8) == 0 && instanceToUse == null) {
                try {
                    instanceToUse = objectFactory.newInstance(cls, new Object[0]);
                }
                catch (TestNGException testNGException) {
                    // empty catch block
                }
            }
            if (result != null) {
                throw new TestNGException("Found two providers called '" + name + "' on " + cls);
            }
            if (isDynamicDataProvider) {
                result = new DataProviderMethodRemovable(instanceToUse, m, dp);
                continue;
            }
            result = new DataProviderMethod(instanceToUse, m, dp);
        }
        return result;
    }

    private static String getDataProviderName(IDataProviderAnnotation dp, Method m) {
        return Strings.isNullOrEmpty(dp.getName()) ? m.getName() : dp.getName();
    }

    private static String[] extractOptionalValues(IAnnotationFinder finder, ConstructorOrMethod consMethod) {
        if (consMethod.getMethod() != null) {
            return finder.findOptionalValues(consMethod.getMethod());
        }
        return finder.findOptionalValues(consMethod.getConstructor());
    }

    private static Object[] createParameters(ConstructorOrMethod m, MethodParameters params, IAnnotationFinder finder, XmlSuite xmlSuite, String atName) {
        Object[] extraParameters;
        List result = Lists.newArrayList();
        String[] extraOptionalValues = Parameters.extractOptionalValues(finder, m);
        IParametersAnnotation annotation = finder.findAnnotation(m, IParametersAnnotation.class);
        Class<?>[] types = m.getParameterTypes();
        if (null != annotation) {
            String[] parameterNames = annotation.getValue();
            extraParameters = Parameters.createParametersForMethod(m, types, extraOptionalValues, atName, parameterNames, params, xmlSuite);
        } else {
            extraParameters = Parameters.createParametersForMethod(m, types, extraOptionalValues, atName, new String[0], params, xmlSuite);
        }
        Collections.addAll(result, extraParameters);
        for (int i = 0; i < types.length; ++i) {
            if (!Object[].class.equals(types[i])) continue;
            result.add(i, params.parameterValues);
        }
        return result.toArray(new Object[0]);
    }

    public static ParameterHolder handleParameters(ITestObjectFactory objectFactory, ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance, DataProviderHolder holder) {
        return Parameters.handleParameters(objectFactory, testMethod, allParameterNames, instance, methodParams, xmlSuite, annotationFinder, fedInstance, holder, "@Test");
    }

    /*
     * WARNING - void declaration
     */
    public static ParameterHolder handleParameters(ITestObjectFactory objectFactory, ITestNGMethod testMethod, Map<String, String> allParameterNames, Object instance, MethodParameters methodParams, XmlSuite xmlSuite, IAnnotationFinder annotationFinder, Object fedInstance, DataProviderHolder holder, String annotationName) {
        IDataProviderMethod dataProviderMethod = Parameters.findDataProvider(objectFactory, instance, testMethod.getTestClass(), testMethod.getConstructorOrMethod(), annotationFinder, methodParams.context);
        if (null != dataProviderMethod) {
            void var19_29;
            RuntimeException thrownException;
            if (testMethod instanceof TestNGMethod) {
                ((TestNGMethod)testMethod).setDataProviderMethod(dataProviderMethod);
            }
            int parameterCount = testMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int i = 0; i < parameterCount; ++i) {
                String n = "param" + i;
                allParameterNames.put(n, n);
            }
            Class<? extends IRetryDataProvider> retryClass = dataProviderMethod.retryUsing();
            boolean shouldRetry = !retryClass.equals(IRetryDataProvider.DisableDataProviderRetries.class);
            IRetryDataProvider retry = null;
            if (shouldRetry) {
                IObjectDispenser dispenser = Dispenser.newInstance(objectFactory);
                BasicAttributes basic = new BasicAttributes(testMethod.getTestClass(), retryClass);
                CreationAttributes attributes = new CreationAttributes(methodParams.context, basic, null);
                retry = (IRetryDataProvider)dispenser.dispense(attributes);
            }
            Iterator<Object[]> initParams = null;
            do {
                for (IDataProviderListener iDataProviderListener : holder.getListeners()) {
                    iDataProviderListener.beforeDataProviderExecution(dataProviderMethod, testMethod, methodParams.context);
                }
                try {
                    initParams = MethodInvocationHelper.invokeDataProvider(dataProviderMethod.getInstance(), dataProviderMethod.getMethod(), testMethod, methodParams.context, fedInstance, annotationFinder);
                    shouldRetry = false;
                    thrownException = null;
                }
                catch (RuntimeException e) {
                    for (IDataProviderListener each : holder.getListeners()) {
                        each.onDataProviderFailure(testMethod, methodParams.context, e);
                    }
                    if (shouldRetry) {
                        shouldRetry = retry.retry(dataProviderMethod);
                        thrownException = e;
                        continue;
                    }
                    throw e;
                }
            } while (shouldRetry);
            if (thrownException != null) {
                throw thrownException;
            }
            for (IDataProviderListener iDataProviderListener : holder.getListeners()) {
                iDataProviderListener.afterDataProviderExecution(dataProviderMethod, testMethod, methodParams.context);
            }
            ArrayList<Integer> allIndices = new ArrayList<Integer>();
            allIndices.addAll(testMethod.getInvocationNumbers());
            allIndices.addAll(dataProviderMethod.getIndices());
            FilteredParameters filteredParameters = new FilteredParameters(initParams, testMethod, dataProviderMethod.getName(), allIndices);
            testMethod.setMoreInvocationChecker(filteredParameters::hasNext);
            for (IDataProviderInterceptor interceptor : holder.getInterceptors()) {
                Iterator<Object[]> iterator = interceptor.intercept((Iterator<Object[]>)var19_29, dataProviderMethod, testMethod, methodParams.context);
            }
            if (dataProviderMethod instanceof DataProviderMethodRemovable) {
                ((DataProviderMethodRemovable)dataProviderMethod).setMethod(null);
                ((DataProviderMethodRemovable)dataProviderMethod).setInstance(null);
                if (testMethod instanceof TestNGMethod) {
                    ((TestNGMethod)testMethod).setDataProviderMethod(null);
                }
            }
            return new ParameterHolder((Iterator<Object[]>)var19_29, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, dataProviderMethod);
        }
        ParameterHolder.ParameterOrigin origin = methodParams.xmlParameters.isEmpty() ? ParameterHolder.ParameterOrigin.NATIVE : ParameterHolder.ParameterOrigin.ORIGIN_XML;
        allParameterNames.putAll(methodParams.xmlParameters);
        Object[][] allParameterValuesArray = new Object[][]{Parameters.createParameters(testMethod.getConstructorOrMethod(), methodParams, annotationFinder, xmlSuite, annotationName)};
        testMethod.setParameterInvocationCount(allParameterValuesArray.length);
        ArrayIterator parameters = new ArrayIterator(allParameterValuesArray);
        return new ParameterHolder(parameters, origin, null);
    }

    public static Object[] injectParameters(Object[] parameterValues, Method method, ITestContext context) throws TestNGException {
        MethodMatcherContext matcherContext = new MethodMatcherContext(method, parameterValues, context, null);
        DataProviderMethodMatcher matcher = new DataProviderMethodMatcher(matcherContext);
        return matcher.getConformingArguments();
    }

    static {
        List<Class> ctxTest = Arrays.asList(ITestContext.class, XmlTest.class);
        List<Class> beforeAfterMethod = Arrays.asList(ITestContext.class, XmlTest.class, Method.class, Object[].class, ITestResult.class);
        mapping.put(BeforeSuite.class.getSimpleName(), ctxTest);
        mapping.put(AfterSuite.class.getSimpleName(), ctxTest);
        mapping.put(BeforeTest.class.getSimpleName(), ctxTest);
        mapping.put(AfterTest.class.getSimpleName(), ctxTest);
        mapping.put(BeforeGroups.class.getSimpleName(), ctxTest);
        mapping.put(AfterGroups.class.getSimpleName(), ctxTest);
        mapping.put(BeforeClass.class.getSimpleName(), ctxTest);
        mapping.put(AfterClass.class.getSimpleName(), ctxTest);
        mapping.put(BeforeMethod.class.getSimpleName(), beforeAfterMethod);
        mapping.put(AfterMethod.class.getSimpleName(), beforeAfterMethod);
        mapping.put(Test.class.getSimpleName(), Arrays.asList(ITestContext.class, XmlTest.class, Method.class));
        mapping.put(Factory.class.getSimpleName(), ctxTest);
        INJECTED_TYPES = Arrays.asList(ITestContext.class, ITestResult.class, XmlTest.class, Method.class, Object[].class);
    }

    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private final Object[] parameterValues;
        private final ITestResult testResult;

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams) {
            this(params, methodParams, null, null, null, null);
        }

        public static MethodParameters newInstance(Map<String, String> params, ITestNGMethod testNGMethod, ITestContext context) {
            Map<String, String> methodParams = testNGMethod.findMethodParameters(context.getCurrentXmlTest());
            Method method = testNGMethod.getConstructorOrMethod().getMethod();
            return new MethodParameters(params, methodParams, null, method, context, null);
        }

        public MethodParameters(Map<String, String> params, Map<String, String> methodParams, Object[] pv, Method m, ITestContext ctx, ITestResult tr) {
            Map<String, String> allParams = Maps.newHashMap();
            allParams.putAll(params);
            allParams.putAll(methodParams);
            this.xmlParameters = allParams;
            this.currentTestMethod = m;
            this.context = ctx;
            this.parameterValues = pv;
            this.testResult = tr;
        }
    }

    static final class FilterOutInjectedTypesResult {
        private final Class<?>[] parameterTypes;
        private final String[] optionalValues;

        private FilterOutInjectedTypesResult(Class<?>[] parameterTypes, String[] optionalValues) {
            this.parameterTypes = parameterTypes;
            this.optionalValues = optionalValues;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        String[] getOptionalValues() {
            return this.optionalValues;
        }
    }
}

