/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.org.eclipse.sisu.Description;
import org.jetbrains.kotlin.org.eclipse.sisu.Hidden;
import org.jetbrains.kotlin.org.eclipse.sisu.Priority;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.AnnotatedSource;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DescriptionSource;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Guice4;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.HiddenSource;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Implementations;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.PrioritySource;

public final class Sources {
    private Sources() {
    }

    public static Hidden hide() {
        return Sources.hide(null);
    }

    public static Hidden hide(Object source) {
        return new HiddenSource(source);
    }

    public static Description describe(String value) {
        return Sources.describe(null, value);
    }

    public static Description describe(Object source, String value) {
        return new DescriptionSource(source, value);
    }

    public static Priority prioritize(int value) {
        return Sources.prioritize(null, value);
    }

    public static Priority prioritize(Object source, int value) {
        return new PrioritySource(source, value);
    }

    public static <T extends Annotation> T getAnnotation(Binding<?> binding, Class<T> annotationType) {
        T annotation = null;
        Object source = Guice4.getDeclaringSource(binding);
        if (source instanceof AnnotatedSource) {
            annotation = ((AnnotatedSource)source).getAnnotation(binding, annotationType);
        }
        if (null == annotation) {
            annotation = Implementations.getAnnotation(binding, annotationType);
        }
        return annotation;
    }
}

