/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.gui.layer.geoimage.ImageMetadata;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage applyExifRotation(BufferedImage img, Integer exifOrientation) {
        if (exifOrientation == null || !ExifReader.orientationNeedsCorrection(exifOrientation)) {
            return img;
        }
        boolean switchesDimensions = ExifReader.orientationSwitchesDimensions(exifOrientation);
        int width = switchesDimensions ? img.getHeight() : img.getWidth();
        int height = switchesDimensions ? img.getWidth() : img.getHeight();
        BufferedImage rotated = new BufferedImage(width, height, 1);
        AffineTransform transform = ExifReader.getRestoreOrientationTransform(exifOrientation, img.getWidth(), img.getHeight());
        Graphics2D g = rotated.createGraphics();
        g.drawImage(img, transform, null);
        g.dispose();
        return rotated;
    }

    public static ImageReadParam withSubsampling(ImageReader reader, Dimension target) {
        try {
            ImageReadParam param = reader.getDefaultReadParam();
            Dimension source = new Dimension(reader.getWidth(0), reader.getHeight(0));
            if (source.getWidth() > target.getWidth() || source.getHeight() > target.getHeight()) {
                int subsampling = (int)Math.floor(Math.max(source.getWidth() / target.getWidth(), source.getHeight() / target.getHeight()));
                param.setSourceSubsampling(subsampling, subsampling, 0, 0);
            }
            return param;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void applyExif(ImageMetadata image, InputStream inputStream) {
        if (image == null || inputStream == null) {
            return;
        }
        Metadata metadata = ImageUtils.getMetadata(image.getImageURI(), inputStream);
        if (metadata == null) {
            image.setExifTime(image.getLastModified());
            image.setExifCoor(null);
            image.setPos(null);
            return;
        }
        String fn = image.getImageURI().toString();
        IptcDirectory dirIptc = metadata.getFirstDirectoryOfType(IptcDirectory.class);
        if (dirIptc != null) {
            ImageUtils.ifNotNull(ExifReader.readCaption(dirIptc), image::setIptcCaption);
            ImageUtils.ifNotNull(ExifReader.readHeadline(dirIptc), image::setIptcHeadline);
            ImageUtils.ifNotNull(ExifReader.readKeywords(dirIptc), image::setIptcKeywords);
            ImageUtils.ifNotNull(ExifReader.readObjectName(dirIptc), image::setIptcObjectName);
        }
        for (XmpDirectory xmpDirectory : metadata.getDirectoriesOfType(XmpDirectory.class)) {
            Map<String, String> properties = xmpDirectory.getXmpProperties();
            String projectionType = "GPano:ProjectionType";
            if (!properties.containsKey("GPano:ProjectionType")) continue;
            Stream.of(Projections.values()).filter(p -> p.name().equalsIgnoreCase((String)properties.get("GPano:ProjectionType"))).findFirst().ifPresent(image::setProjectionType);
            break;
        }
        Instant time = null;
        try {
            time = ExifReader.readInstant(metadata);
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException ex) {
            Logging.warn(ex);
        }
        if (time == null) {
            Logging.info(I18n.tr("No EXIF time in file \"{0}\". Using last modified date as timestamp.", fn));
            time = image.getLastModified();
        }
        image.setExifTime(time);
        JpegDirectory dir = metadata.getFirstDirectoryOfType(JpegDirectory.class);
        ExifIFD0Directory dirExif = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
        try {
            if (dirExif != null && dirExif.containsTag(274)) {
                image.setExifOrientation(dirExif.getInt(274));
            }
        }
        catch (MetadataException ex) {
            Logging.debug(ex);
        }
        try {
            if (dir != null && dir.containsTag(3) && dir.containsTag(1)) {
                image.setWidth(dir.getInt(3));
                image.setHeight(dir.getInt(1));
            }
        }
        catch (MetadataException ex) {
            Logging.debug(ex);
        }
        if (dirGps == null || dirGps.getTagCount() <= 1) {
            image.setExifCoor(null);
            image.setPos(null);
            return;
        }
        ImageUtils.ifNotNull(ExifReader.readSpeed(dirGps), image::setSpeed);
        ImageUtils.ifNotNull(ExifReader.readElevation(dirGps), image::setElevation);
        try {
            image.setExifCoor(ExifReader.readLatLon(dirGps));
            image.setPos(image.getExifCoor());
        }
        catch (MetadataException | IndexOutOfBoundsException ex) {
            Logging.error("Error reading EXIF from file: " + ex);
            image.setExifCoor(null);
            image.setPos(null);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readDirection(dirGps), image::setExifImgDir);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsTrackDirection(dirGps), image::setExifGpsTrack);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readHpositioningError(dirGps), image::setExifHPosErr);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsDiffMode(dirGps), image::setGpsDiffMode);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsMeasureMode(dirGps), image::setGps2d3dMode);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsDop(dirGps), image::setExifGpsDop);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsDatum(dirGps), image::setExifGpsDatum);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        try {
            ImageUtils.ifNotNull(ExifReader.readGpsProcessingMethod(dirGps), image::setExifGpsProcMethod);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        ImageUtils.ifNotNull(dirGps.getGpsDate(), d -> image.setExifGpsTime(d.toInstant()));
    }

    private static Metadata getMetadata(URI uri, InputStream inputStream) {
        inputStream.mark(32);
        String fn = uri.toString();
        try {
            String ext;
            switch (ext = fn.substring(fn.lastIndexOf(46) + 1).toLowerCase(Locale.US)) {
                case "jpg": 
                case "jpeg": {
                    return JpegMetadataReader.readMetadata(inputStream);
                }
                case "tif": 
                case "tiff": {
                    return TiffMetadataReader.readMetadata(inputStream);
                }
                case "png": {
                    return PngMetadataReader.readMetadata(inputStream);
                }
            }
            throw new NoMetadataReaderWarning(ext);
        }
        catch (JpegProcessingException | PngProcessingException | TiffProcessingException | IOException | NoMetadataReaderWarning exception) {
            Exception topException = exception;
            try {
                return JpegMetadataReader.readMetadata(inputStream);
            }
            catch (JpegProcessingException | IOException ex1) {
                Logging.trace(ex1);
                try {
                    return TiffMetadataReader.readMetadata(inputStream);
                }
                catch (TiffProcessingException | IOException ex2) {
                    Logging.trace(ex2);
                    try {
                        return PngMetadataReader.readMetadata(inputStream);
                    }
                    catch (PngProcessingException | IOException ex3) {
                        Logging.trace(ex3);
                        Logging.warn(topException);
                        Logging.info(I18n.tr("Can''t parse metadata for file \"{0}\". Using last modified date as timestamp.", fn));
                        return null;
                    }
                }
            }
        }
    }

    private static <T> void ifNotNull(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }

    private static class NoMetadataReaderWarning
    extends Exception {
        NoMetadataReaderWarning(String ext) {
            super("No metadata reader for format *." + ext);
        }
    }
}

