/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils.persistence;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class MlParserUtils {
    private MlParserUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, U> T parse(SearchHit hit, BiFunction<XContentParser, U, T> objectParser) {
        BytesReference source = hit.getSourceRef();
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY.withRegistry(NamedXContentRegistry.EMPTY).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)source, (XContentType)XContentType.JSON);){
            XContentParser t = objectParser.apply(parser, null);
            return (T)t;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to parse " + hit.getId(), (Throwable)e, new Object[0]);
        }
    }
}

