/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;

public abstract class AbstractProcessWorkerExecutorService<T extends Runnable>
extends AbstractExecutorService {
    private static final Logger logger = LogManager.getLogger(AbstractProcessWorkerExecutorService.class);
    protected final ThreadContext contextHolder;
    protected final String processName;
    private final CountDownLatch awaitTermination = new CountDownLatch(1);
    protected final BlockingQueue<T> queue;
    private final AtomicReference<Exception> error = new AtomicReference();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final AtomicBoolean shouldShutdownAfterCompletingWork = new AtomicBoolean(false);

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public AbstractProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity, Function<Integer, BlockingQueue<T>> queueSupplier) {
        this.contextHolder = Objects.requireNonNull(contextHolder);
        this.processName = Objects.requireNonNull(processName);
        this.queue = queueSupplier.apply(queueCapacity);
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void shutdownNowWithError(Exception e) {
        this.error.set(e);
        this.shutdownNow();
    }

    @Override
    public void shutdown() {
        this.shouldShutdownAfterCompletingWork.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.running.set(false);
        return new ArrayList<Runnable>(this.queue);
    }

    @Override
    public boolean isShutdown() {
        return !this.running.get() || this.shouldShutdownAfterCompletingWork.get();
    }

    @Override
    public boolean isTerminated() {
        return this.awaitTermination.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitTermination.await(timeout, unit);
    }

    public void start() {
        try {
            while (this.running.get()) {
                Runnable runnable = (Runnable)this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (runnable != null) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        logger.error(() -> "error handling process [" + this.processName + "] operation", (Throwable)e);
                    }
                    EsExecutors.rethrowErrors((Runnable)ThreadContext.unwrap((Runnable)runnable));
                    continue;
                }
                if (!this.shouldShutdownAfterCompletingWork.get()) continue;
                this.running.set(false);
            }
            this.notifyQueueRunnables();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.awaitTermination.countDown();
        }
    }

    public synchronized void notifyQueueRunnables() {
        assert (this.isShutdown()) : "Queue runnables should only be drained and notified after the worker is shutdown";
        if (!this.queue.isEmpty()) {
            logger.warn(Strings.format((String)"[%s] notifying [%d] queued requests that have not been processed before shutdown", (Object[])new Object[]{this.processName, this.queue.size()}));
            ArrayList notExecuted = new ArrayList();
            this.queue.drainTo(notExecuted);
            String msg = "unable to process as " + this.processName + " worker service has shutdown";
            Exception ex = this.error.get();
            for (Runnable runnable : notExecuted) {
                if (!(runnable instanceof AbstractRunnable)) continue;
                AbstractRunnable ar = (AbstractRunnable)runnable;
                if (ex != null) {
                    ar.onFailure(ex);
                    continue;
                }
                ar.onRejection((Exception)((Object)new EsRejectedExecutionException(msg, true)));
            }
        }
    }
}

