/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.utils.persistence.SearchAfterDocumentsIterator;

public class SearchAfterJobsIterator
extends SearchAfterDocumentsIterator<Job.Builder> {
    private String lastJobId;

    public SearchAfterJobsIterator(OriginSettingClient client) {
        super(client, MlConfigIndex.indexName());
    }

    @Override
    protected QueryBuilder getQuery() {
        return new TermQueryBuilder(Job.JOB_TYPE.getPreferredName(), "anomaly_detector");
    }

    @Override
    protected FieldSortBuilder sortField() {
        return new FieldSortBuilder(Job.ID.getPreferredName());
    }

    @Override
    protected Object[] searchAfterFields() {
        if (this.lastJobId == null) {
            return null;
        }
        return new Object[]{this.lastJobId};
    }

    @Override
    protected void extractSearchAfterFields(SearchHit lastSearchHit) {
        this.lastJobId = Job.extractJobIdFromDocumentId((String)lastSearchHit.getId());
    }

    @Override
    protected Job.Builder map(SearchHit hit) {
        Job.Builder builder;
        block8: {
            XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
            try {
                builder = (Job.Builder)Job.LENIENT_PARSER.apply(parser, null);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse job document [" + hit.getId() + "]", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return builder;
    }
}

