/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;

class BatchedBucketsIterator
extends BatchedResultsIterator<Bucket> {
    BatchedBucketsIterator(OriginSettingClient client, String jobId) {
        super(client, jobId, "bucket");
    }

    @Override
    protected Result<Bucket> map(SearchHit hit) {
        Result result;
        block8: {
            XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
            try {
                Bucket bucket = (Bucket)Bucket.LENIENT_PARSER.apply(parser, null);
                result = new Result(hit.getIndex(), (Object)bucket);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return result;
    }
}

