/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public record CharTrie(Map<Character, CharTrie> children) {
    boolean isLeaf() {
        return this.children.isEmpty();
    }

    private void insert(char[] chars) {
        CharTrie child;
        int currentTokenIndex;
        if (chars.length == 0) {
            return;
        }
        CharTrie currentNode = this;
        for (currentTokenIndex = 0; currentTokenIndex < chars.length && (child = currentNode.children.get(Character.valueOf(chars[currentTokenIndex]))) != null; ++currentTokenIndex) {
            currentNode = child;
        }
        while (currentTokenIndex < chars.length) {
            CharTrie childNode = new CharTrie(new HashMap<Character, CharTrie>());
            currentNode.children.put(Character.valueOf(chars[currentTokenIndex++]), childNode);
            currentNode = childNode;
        }
    }

    public static CharTrie build(Collection<String> tokens) {
        CharTrie root = new CharTrie(new HashMap<Character, CharTrie>());
        for (String token : tokens) {
            char[] chars = token.toCharArray();
            root.insert(chars);
        }
        return root;
    }
}

