/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.deployment;

import java.util.Map;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelInput;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class NlpInferenceInput {
    private final String inputText;
    private final Map<String, Object> doc;

    public static NlpInferenceInput fromText(String inputText) {
        return new NlpInferenceInput(inputText);
    }

    public static NlpInferenceInput fromDoc(Map<String, Object> doc) {
        return new NlpInferenceInput(doc);
    }

    private NlpInferenceInput(String inputText) {
        this.inputText = (String)ExceptionsHelper.requireNonNull((Object)inputText, (String)"input_text");
        this.doc = null;
    }

    private NlpInferenceInput(Map<String, Object> doc) {
        this.doc = (Map)ExceptionsHelper.requireNonNull(doc, (String)"doc");
        this.inputText = null;
    }

    public boolean isTextInput() {
        return this.inputText != null;
    }

    public String getInputText() {
        return this.inputText;
    }

    public String extractInput(TrainedModelInput input) {
        if (this.isTextInput()) {
            return this.getInputText();
        }
        assert (input.getFieldNames().size() == 1);
        String inputField = (String)input.getFieldNames().get(0);
        Object inputValue = XContentMapValues.extractValue((String)inputField, this.doc);
        if (inputValue == null) {
            throw ExceptionsHelper.badRequestException((String)"Input field [{}] does not exist in the source document", (Object[])new Object[]{inputField});
        }
        if (inputValue instanceof String) {
            return (String)inputValue;
        }
        throw ExceptionsHelper.badRequestException((String)"Input value [{}] for field [{}] must be a string", (Object[])new Object[]{inputValue, inputField});
    }
}

