/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.steps.AbstractDataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class AnalysisStep
extends AbstractDataFrameAnalyticsStep {
    private final AnalyticsProcessManager processManager;

    public AnalysisStep(NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config, AnalyticsProcessManager processManager) {
        super(client, task, auditor, config);
        this.processManager = Objects.requireNonNull(processManager);
    }

    @Override
    public DataFrameAnalyticsStep.Name name() {
        return DataFrameAnalyticsStep.Name.ANALYSIS;
    }

    @Override
    public void cancel(String reason, TimeValue timeout) {
        this.processManager.stop(this.task);
    }

    @Override
    public void updateProgress(ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    @Override
    protected void doExecute(ActionListener<StepResponse> listener) {
        this.task.getStatsHolder().getDataCountsTracker().reset();
        ParentTaskAssigningClient parentTaskClient = this.parentTaskClient();
        ActionListener dataExtractorFactoryListener = listener.delegateFailureAndWrap((l, dataExtractorFactory) -> this.processManager.runJob(this.task, this.config, (DataFrameDataExtractorFactory)dataExtractorFactory, (ActionListener<StepResponse>)l));
        ActionListener refreshListener = dataExtractorFactoryListener.delegateFailureAndWrap((l, refreshResponse) -> DataFrameDataExtractorFactory.createForDestinationIndex((Client)parentTaskClient, this.config, (ActionListener<DataFrameDataExtractorFactory>)l));
        this.refreshDestAsync((ActionListener<BroadcastResponse>)refreshListener);
    }
}

