/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.DestinationIndex;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.dataframe.inference.InferenceRunner;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.steps.AnalysisStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.FinalStep;
import org.elasticsearch.xpack.ml.dataframe.steps.InferenceStep;
import org.elasticsearch.xpack.ml.dataframe.steps.ReindexingStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class DataFrameAnalyticsManager {
    private static final Logger LOGGER = LogManager.getLogger(DataFrameAnalyticsManager.class);
    private final Settings settings;
    private final NodeClient client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final AnalyticsProcessManager processManager;
    private final DataFrameAnalyticsAuditor auditor;
    private final IndexNameExpressionResolver expressionResolver;
    private final ResultsPersisterService resultsPersisterService;
    private final ModelLoadingService modelLoadingService;
    private final String[] destIndexAllowedSettings;
    private final AtomicBoolean nodeShuttingDown = new AtomicBoolean();
    private final Map<String, ByteSizeValue> memoryLimitById;

    public DataFrameAnalyticsManager(Settings settings, NodeClient client, ThreadPool threadPool, ClusterService clusterService, DataFrameAnalyticsConfigProvider configProvider, AnalyticsProcessManager processManager, DataFrameAnalyticsAuditor auditor, IndexNameExpressionResolver expressionResolver, ResultsPersisterService resultsPersisterService, ModelLoadingService modelLoadingService, String[] destIndexAllowedSettings) {
        this(settings, client, threadPool, clusterService, configProvider, processManager, auditor, expressionResolver, resultsPersisterService, modelLoadingService, destIndexAllowedSettings, new ConcurrentHashMap<String, ByteSizeValue>());
    }

    public DataFrameAnalyticsManager(Settings settings, NodeClient client, ThreadPool threadPool, ClusterService clusterService, DataFrameAnalyticsConfigProvider configProvider, AnalyticsProcessManager processManager, DataFrameAnalyticsAuditor auditor, IndexNameExpressionResolver expressionResolver, ResultsPersisterService resultsPersisterService, ModelLoadingService modelLoadingService, String[] destIndexAllowedSettings, Map<String, ByteSizeValue> memoryLimitById) {
        this.settings = Objects.requireNonNull(settings);
        this.client = Objects.requireNonNull(client);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.processManager = Objects.requireNonNull(processManager);
        this.auditor = Objects.requireNonNull(auditor);
        this.expressionResolver = Objects.requireNonNull(expressionResolver);
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.modelLoadingService = Objects.requireNonNull(modelLoadingService);
        this.destIndexAllowedSettings = Objects.requireNonNull(destIndexAllowedSettings);
        this.memoryLimitById = Objects.requireNonNull(memoryLimitById);
    }

    public void execute(DataFrameAnalyticsTask task, ClusterState clusterState, TimeValue masterNodeTimeout) {
        ActionListener configListener = ActionListener.wrap(config -> {
            this.memoryLimitById.put(config.getId(), config.getModelMemoryLimit());
            IndexMetadata destIndex = clusterState.getMetadata().index(config.getDest().getIndex());
            if (destIndex != null) {
                MappingMetadata destIndexMapping = clusterState.getMetadata().index(config.getDest().getIndex()).mapping();
                DestinationIndex.Metadata metadata = DestinationIndex.readMetadata(config.getId(), destIndexMapping);
                if (metadata.hasMetadata() && !metadata.isCompatible()) {
                    LOGGER.info("[{}] Destination index was created in version [{}] but minimum supported version is [{}]. Deleting index and starting from scratch.", (Object)config.getId(), (Object)metadata.getVersion(), (Object)DestinationIndex.MIN_COMPATIBLE_VERSION);
                    task.getStatsHolder().resetProgressTracker(config.getAnalysis().getProgressPhases(), config.getAnalysis().supportsInference());
                    this.executeJobInMiddleOfReindexing(task, (DataFrameAnalyticsConfig)config);
                    return;
                }
            }
            task.getStatsHolder().adjustProgressTracker(config.getAnalysis().getProgressPhases(), config.getAnalysis().supportsInference());
            this.determineProgressAndResume(task, (DataFrameAnalyticsConfig)config);
        }, task::setFailed);
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessaryAndWaitForYellow((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), (ClusterState)clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)masterNodeTimeout, (ActionListener)configListener.delegateFailureAndWrap((delegate, aBoolean) -> this.createStatsIndexAndUpdateMappingsIfNecessary((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), clusterState, masterNodeTimeout, (ActionListener<Boolean>)delegate.delegateFailureAndWrap((l, ignored) -> this.configProvider.get(task.getParams().getId(), (ActionListener<DataFrameAnalyticsConfig>)l)))));
    }

    private void createStatsIndexAndUpdateMappingsIfNecessary(Client clientToUse, ClusterState clusterState, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        MlStatsIndex.createStatsIndexAndAliasIfNecessary((Client)clientToUse, (ClusterState)clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)masterNodeTimeout, (ActionListener)listener.delegateFailureAndWrap((l, aBoolean) -> ElasticsearchMappings.addDocMappingIfMissing((String)MlStatsIndex.writeAlias(), MlStatsIndex::wrappedMapping, (Client)clientToUse, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)l, (int)1)));
    }

    private void determineProgressAndResume(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        DataFrameAnalyticsTask.StartingState startingState = task.determineStartingState();
        LOGGER.debug(() -> Strings.format((String)"[%s] Starting job from state [%s]", (Object[])new Object[]{config.getId(), startingState}));
        switch (startingState) {
            case FIRST_TIME: {
                this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config, this.destIndexAllowedSettings));
                break;
            }
            case RESUMING_REINDEXING: {
                this.executeJobInMiddleOfReindexing(task, config);
                break;
            }
            case RESUMING_ANALYZING: {
                this.executeStep(task, config, new AnalysisStep(this.client, task, this.auditor, config, this.processManager));
                break;
            }
            case RESUMING_INFERENCE: {
                this.buildInferenceStep(task, config, (ActionListener<InferenceStep>)ActionListener.wrap(inferenceStep -> this.executeStep(task, config, (DataFrameAnalyticsStep)inferenceStep), task::setFailed));
                break;
            }
            case FINISHED: {
                task.setFailed((Exception)ExceptionsHelper.serverError((String)("Unexpected starting state [" + String.valueOf((Object)startingState) + "]")));
            }
        }
    }

    private void executeStep(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, DataFrameAnalyticsStep step) {
        task.setStep(step);
        ActionListener stepListener = ActionListener.wrap(stepResponse -> {
            if (stepResponse.isTaskComplete()) {
                this.executeStep(task, config, new FinalStep(this.client, task, this.auditor, config));
                return;
            }
            switch (step.name()) {
                case REINDEXING: {
                    this.executeStep(task, config, new AnalysisStep(this.client, task, this.auditor, config, this.processManager));
                    break;
                }
                case ANALYSIS: {
                    this.buildInferenceStep(task, config, (ActionListener<InferenceStep>)ActionListener.wrap(inferenceStep -> this.executeStep(task, config, (DataFrameAnalyticsStep)inferenceStep), task::setFailed));
                    break;
                }
                case INFERENCE: {
                    this.executeStep(task, config, new FinalStep(this.client, task, this.auditor, config));
                    break;
                }
                case FINAL: {
                    LOGGER.info("[{}] Marking task completed", (Object)config.getId());
                    task.markAsCompleted();
                    this.memoryLimitById.remove(config.getId());
                    break;
                }
                default: {
                    task.markAsFailed((Exception)ExceptionsHelper.serverError((String)"Unknown step [{}]", (Object[])new Object[]{step}));
                }
            }
        }, task::setFailed);
        step.execute((ActionListener<StepResponse>)stepListener);
    }

    private void executeJobInMiddleOfReindexing(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        if (task.isStopping()) {
            LOGGER.debug("[{}] task is stopping. Marking as complete before restarting reindexing.", (Object)task.getParams().getId());
            task.markAsCompleted();
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), (String)"ml", (ActionType)TransportDeleteIndexAction.TYPE, (ActionRequest)new DeleteIndexRequest(config.getDest().getIndex()), (ActionListener)ActionListener.wrap(r -> this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config, this.destIndexAllowedSettings)), e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config, this.destIndexAllowedSettings));
            } else {
                task.setFailed((Exception)e);
            }
        }));
    }

    private void buildInferenceStep(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, ActionListener<InferenceStep> listener) {
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId());
        new ExtractedFieldsDetectorFactory((Client)parentTaskClient).createFromDest(config, (ActionListener<ExtractedFieldsDetector>)listener.delegateFailureAndWrap((delegate, extractedFieldsDetector) -> {
            ExtractedFields extractedFields = (ExtractedFields)extractedFieldsDetector.detect().v1();
            InferenceRunner inferenceRunner = InferenceRunner.create(this.settings, (Client)parentTaskClient, this.modelLoadingService, this.resultsPersisterService, task.getParentTaskId(), config, extractedFields, task.getStatsHolder().getProgressTracker(), task.getStatsHolder().getDataCountsTracker(), this.threadPool);
            InferenceStep inferenceStep = new InferenceStep(this.client, task, this.auditor, config, this.threadPool, inferenceRunner);
            delegate.onResponse((Object)inferenceStep);
        }));
    }

    public boolean isNodeShuttingDown() {
        return this.nodeShuttingDown.get();
    }

    public void markNodeAsShuttingDown() {
        this.nodeShuttingDown.set(true);
    }

    public Optional<ByteSizeValue> getMemoryLimitIfKnown(String id) {
        return Optional.ofNullable(this.memoryLimitById.get(id));
    }

    public ByteSizeValue getActiveTaskMemoryUsage(PersistentTasksCustomMetadata tasks) {
        long memoryUsedBytes = 0L;
        for (Map.Entry<String, ByteSizeValue> entry : this.memoryLimitById.entrySet()) {
            DataFrameAnalyticsState state = MlTasks.getDataFrameAnalyticsState((String)entry.getKey(), (PersistentTasksCustomMetadata)tasks);
            if (!state.consumesMemory()) continue;
            memoryUsedBytes += entry.getValue().getBytes() + DataFrameAnalyticsConfig.PROCESS_MEMORY_OVERHEAD.getBytes();
        }
        return ByteSizeValue.ofBytes((long)memoryUsedBytes);
    }
}

