/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.LongsRef;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetBitSet;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;

class ItemSetTraverser {
    private static final int SIZE_INCREMENT = 100;
    private final TransactionStore.TopItemIds topItemIds;
    private final List<TransactionStore.TopItemIds.IdIterator> itemIterators = new ArrayList<TransactionStore.TopItemIds.IdIterator>();
    private LongsRef itemIdStack = new LongsRef(100);
    private final ItemSetBitSet itemPositionsVector;
    private final ItemSetBitSet itemPositionsVectorParent;
    private IntsRef itemPositionsStack = new IntsRef(100);
    private int stackPosition = 0;

    ItemSetTraverser(TransactionStore.TopItemIds topItemIds) {
        this.topItemIds = topItemIds;
        this.itemIterators.add(topItemIds.iterator());
        this.itemPositionsVector = new ItemSetBitSet((int)topItemIds.size());
        this.itemPositionsVectorParent = new ItemSetBitSet((int)topItemIds.size());
    }

    public boolean atLeaf() {
        if (this.stackPosition == -1) {
            return false;
        }
        return !this.itemIterators.get(this.stackPosition).hasNext();
    }

    public boolean next() {
        if (this.stackPosition == -1) {
            return false;
        }
        while (true) {
            if (this.itemIterators.get(this.stackPosition).hasNext()) break;
            --this.stackPosition;
            if (this.stackPosition == -1) {
                return false;
            }
            --this.itemIdStack.length;
            --this.itemPositionsStack.length;
            this.itemPositionsVectorParent.clear(this.itemPositionsStack.ints[this.itemPositionsStack.length]);
            this.itemPositionsVector.clear(this.itemPositionsStack.ints[this.itemPositionsStack.length]);
        }
        long itemId = this.itemIterators.get(this.stackPosition).next();
        int itemPosition = this.itemIterators.get(this.stackPosition).getIndex();
        if (this.itemIterators.size() == this.stackPosition + 1) {
            this.itemIterators.add(this.topItemIds.iterator(itemPosition));
        } else {
            this.itemIterators.get(this.stackPosition + 1).reset(itemPosition);
        }
        this.growStacksIfNecessary();
        this.itemIdStack.longs[this.itemIdStack.length++] = itemId;
        if (this.itemPositionsStack.length > 0) {
            this.itemPositionsVectorParent.set(this.itemPositionsStack.ints[this.itemPositionsStack.length - 1]);
        }
        this.itemPositionsStack.ints[this.itemPositionsStack.length++] = itemPosition;
        this.itemPositionsVector.set(itemPosition);
        ++this.stackPosition;
        return true;
    }

    public long getItemId() {
        return this.itemIdStack.longs[this.itemIdStack.length - 1];
    }

    public LongsRef getItemSet() {
        return this.itemIdStack;
    }

    public ItemSetBitSet getItemSetBitSet() {
        return this.itemPositionsVector;
    }

    public ItemSetBitSet getParentItemSetBitSet() {
        return this.itemPositionsVectorParent;
    }

    public int getNumberOfItems() {
        return this.stackPosition;
    }

    public void prune() {
        if (this.stackPosition == -1) {
            return;
        }
        --this.stackPosition;
        if (this.stackPosition == -1) {
            return;
        }
        --this.itemIdStack.length;
        --this.itemPositionsStack.length;
        this.itemPositionsVectorParent.clear(this.itemPositionsStack.ints[this.itemPositionsStack.length]);
        this.itemPositionsVector.clear(this.itemPositionsStack.ints[this.itemPositionsStack.length]);
    }

    private void growStacksIfNecessary() {
        if (this.itemIdStack.longs.length == this.itemIdStack.length) {
            this.itemIdStack.longs = ArrayUtil.grow((long[])this.itemIdStack.longs, (int)(this.itemIdStack.length + 100));
        }
        if (this.itemPositionsStack.ints.length == this.itemPositionsStack.length) {
            this.itemPositionsStack.ints = ArrayUtil.grow((int[])this.itemPositionsStack.ints, (int)(this.itemPositionsStack.length + 100));
        }
    }
}

