/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeDetector;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangeType;
import org.elasticsearch.xpack.ml.aggs.changepoint.SpikeAndDipDetector;

public class ChangePointDetector {
    private static final Logger logger = LogManager.getLogger(ChangePointDetector.class);
    static final double P_VALUE_THRESHOLD = 0.01;
    static final int MINIMUM_BUCKETS = 10;

    public static ChangeType getChangeType(MlAggsHelper.DoubleBucketValues bucketValues) {
        ChangeType spikeOrDip;
        if (bucketValues.getValues().length < 22) {
            return new ChangeType.Indeterminable("not enough buckets to calculate change_point. Requires at least [22]; found [" + bucketValues.getValues().length + "]");
        }
        try {
            SpikeAndDipDetector detect = new SpikeAndDipDetector(bucketValues);
            spikeOrDip = detect.detect(0.01);
            logger.trace("spike or dip p-value: [{}]", (Object)spikeOrDip.pValue());
        }
        catch (NotStrictlyPositiveException nspe) {
            logger.debug("failure testing for dips and spikes", (Throwable)nspe);
            spikeOrDip = new ChangeType.Indeterminable("failure testing for dips and spikes");
        }
        ChangeType change = new ChangeDetector(bucketValues).detect(0.01);
        logger.trace("change p-value: [{}]", (Object)change.pValue());
        if (spikeOrDip.pValue() < change.pValue()) {
            change = spikeOrDip;
        }
        return change;
    }
}

