/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizationBytesRefHash;
import org.elasticsearch.xpack.ml.aggs.categorization.TokenListCategory;

public class SerializableTokenListCategory
implements Writeable {
    public static final int KEY_BUDGET = 10000;
    private static final String REGEX_NEEDS_ESCAPE_PATTERN = "([\\\\|()\\[\\]{}^$.+*?])";
    final BytesRef[] baseTokens;
    final int[] baseTokenWeights;
    final int baseUnfilteredLength;
    final int maxUnfilteredStringLength;
    final int orderedCommonTokenBeginIndex;
    final int orderedCommonTokenEndIndex;
    final int[] commonUniqueTokenIndexes;
    final int[] commonUniqueTokenWeights;
    final int[] keyTokenIndexes;
    final int origUniqueTokenWeight;
    final long numMatches;

    public SerializableTokenListCategory(TokenListCategory category, CategorizationBytesRefHash bytesRefHash) {
        List<TokenListCategory.TokenAndWeight> baseWeightedTokenIds = category.getBaseWeightedTokenIds();
        this.baseTokens = (BytesRef[])baseWeightedTokenIds.stream().map(tw -> bytesRefHash.getDeep(tw.getTokenId())).toArray(BytesRef[]::new);
        this.baseTokenWeights = category.getBaseWeightedTokenIds().stream().mapToInt(TokenListCategory.TokenAndWeight::getWeight).toArray();
        this.baseUnfilteredLength = category.getBaseUnfilteredLength();
        this.maxUnfilteredStringLength = category.getMaxUnfilteredStringLength();
        this.orderedCommonTokenBeginIndex = category.getOrderedCommonTokenBeginIndex();
        this.orderedCommonTokenEndIndex = category.getOrderedCommonTokenEndIndex();
        HashMap<Integer, Integer> tokenIdToIndex = new HashMap<Integer, Integer>();
        for (int index = 0; index < baseWeightedTokenIds.size(); ++index) {
            tokenIdToIndex.putIfAbsent(baseWeightedTokenIds.get(index).getTokenId(), index);
        }
        List<TokenListCategory.TokenAndWeight> commonUniqueTokenIds = category.getCommonUniqueTokenIds();
        this.commonUniqueTokenIndexes = commonUniqueTokenIds.stream().mapToInt(tw -> (Integer)tokenIdToIndex.get(tw.getTokenId())).toArray();
        this.commonUniqueTokenWeights = commonUniqueTokenIds.stream().mapToInt(TokenListCategory.TokenAndWeight::getWeight).toArray();
        ArrayList<Integer> keyTokenIndexes = new ArrayList<Integer>();
        int budgetRemaining = 10001;
        for (TokenListCategory.TokenAndWeight tokenAndWeight : category.getBaseWeightedTokenIds()) {
            if (!category.isTokenIdCommon(tokenAndWeight)) continue;
            int index = (Integer)tokenIdToIndex.get(tokenAndWeight.getTokenId());
            if (this.baseTokens[index].length > --budgetRemaining) break;
            budgetRemaining -= this.baseTokens[index].length;
            keyTokenIndexes.add(index);
        }
        this.keyTokenIndexes = keyTokenIndexes.stream().mapToInt(Integer::intValue).toArray();
        this.origUniqueTokenWeight = category.getOrigUniqueTokenWeight();
        this.numMatches = category.getNumMatches();
    }

    public SerializableTokenListCategory(StreamInput in) throws IOException {
        this.baseTokens = (BytesRef[])in.readArray(StreamInput::readBytesRef, BytesRef[]::new);
        this.baseTokenWeights = in.readVIntArray();
        this.baseUnfilteredLength = in.readVInt();
        this.maxUnfilteredStringLength = in.readVInt();
        this.orderedCommonTokenBeginIndex = in.readVInt();
        this.orderedCommonTokenEndIndex = in.readVInt();
        this.commonUniqueTokenIndexes = in.readVIntArray();
        this.commonUniqueTokenWeights = in.readVIntArray();
        this.keyTokenIndexes = in.readVIntArray();
        this.origUniqueTokenWeight = in.readVInt();
        this.numMatches = in.readVLong();
    }

    public SerializableTokenListCategory(SerializableTokenListCategory other, long scaledMatches) {
        this.baseTokens = other.baseTokens;
        this.baseTokenWeights = other.baseTokenWeights;
        this.baseUnfilteredLength = other.baseUnfilteredLength;
        this.maxUnfilteredStringLength = other.maxUnfilteredStringLength;
        this.orderedCommonTokenBeginIndex = other.orderedCommonTokenBeginIndex;
        this.orderedCommonTokenEndIndex = other.orderedCommonTokenEndIndex;
        this.commonUniqueTokenIndexes = other.commonUniqueTokenIndexes;
        this.commonUniqueTokenWeights = other.commonUniqueTokenWeights;
        this.keyTokenIndexes = other.keyTokenIndexes;
        this.origUniqueTokenWeight = other.origUniqueTokenWeight;
        this.numMatches = scaledMatches;
    }

    public long getNumMatches() {
        return this.numMatches;
    }

    public int maxMatchingStringLen() {
        return TokenListCategory.maxMatchingStringLen(this.baseUnfilteredLength, this.maxUnfilteredStringLength, this.commonUniqueTokenIndexes.length);
    }

    public BytesRef[] getKeyTokens() {
        return (BytesRef[])Arrays.stream(this.keyTokenIndexes).mapToObj(index -> this.baseTokens[index]).toArray(BytesRef[]::new);
    }

    public String getRegex() {
        if (this.keyTokenIndexes.length == 0 || this.orderedCommonTokenBeginIndex == this.orderedCommonTokenEndIndex) {
            return ".*";
        }
        return Arrays.stream(this.keyTokenIndexes).filter(index -> index >= this.orderedCommonTokenBeginIndex && index < this.orderedCommonTokenEndIndex).mapToObj(index -> this.baseTokens[index].utf8ToString().replaceAll(REGEX_NEEDS_ESCAPE_PATTERN, "\\\\$1")).collect(Collectors.joining(".+?", ".*?", ".*?"));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(StreamOutput::writeBytesRef, (Object[])this.baseTokens);
        out.writeVIntArray(this.baseTokenWeights);
        out.writeVInt(this.baseUnfilteredLength);
        out.writeVInt(this.maxUnfilteredStringLength);
        out.writeVInt(this.orderedCommonTokenBeginIndex);
        out.writeVInt(this.orderedCommonTokenEndIndex);
        out.writeVIntArray(this.commonUniqueTokenIndexes);
        out.writeVIntArray(this.commonUniqueTokenWeights);
        out.writeVIntArray(this.keyTokenIndexes);
        out.writeVInt(this.origUniqueTokenWeight);
        out.writeVLong(this.numMatches);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.baseTokens), Arrays.hashCode(this.baseTokenWeights), this.baseUnfilteredLength, this.maxUnfilteredStringLength, this.orderedCommonTokenBeginIndex, this.orderedCommonTokenEndIndex, Arrays.hashCode(this.commonUniqueTokenIndexes), Arrays.hashCode(this.commonUniqueTokenWeights), Arrays.hashCode(this.keyTokenIndexes), this.origUniqueTokenWeight, this.numMatches);
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SerializableTokenListCategory that = (SerializableTokenListCategory)other;
        return Arrays.deepEquals(this.baseTokens, that.baseTokens) && Arrays.equals(this.baseTokenWeights, that.baseTokenWeights) && this.baseUnfilteredLength == that.baseUnfilteredLength && this.maxUnfilteredStringLength == that.maxUnfilteredStringLength && this.orderedCommonTokenBeginIndex == that.orderedCommonTokenBeginIndex && this.orderedCommonTokenEndIndex == that.orderedCommonTokenEndIndex && Arrays.equals(this.commonUniqueTokenIndexes, that.commonUniqueTokenIndexes) && Arrays.equals(this.commonUniqueTokenWeights, that.commonUniqueTokenWeights) && Arrays.equals(this.keyTokenIndexes, that.keyTokenIndexes) && this.origUniqueTokenWeight == that.origUniqueTokenWeight && this.numMatches == that.numMatches;
    }

    public String toString() {
        return Arrays.stream(this.keyTokenIndexes).mapToObj(index -> this.baseTokens[index].utf8ToString()).collect(Collectors.joining(", ", "Category with key tokens [", "]")) + Arrays.stream(this.baseTokens).map(BytesRef::utf8ToString).collect(Collectors.joining(", ", " and base tokens [", "]"));
    }
}

