/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.function;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class Function
extends Expression {
    private final String functionName = this.getClass().getSimpleName().toUpperCase(Locale.ROOT);

    protected Function(Source source, List<Expression> children) {
        super(source, children);
    }

    public final List<Expression> arguments() {
        return this.children();
    }

    public String functionName() {
        return this.functionName;
    }

    @Override
    public Nullability nullable() {
        return Expressions.nullable(this.children());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.children());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        return Objects.equals(this.children(), other.children());
    }

    @Override
    public String nodeString() {
        StringJoiner sj = new StringJoiner(",", this.functionName() + "(", ")");
        for (Expression ex : this.arguments()) {
            sj.add(ex.nodeString());
        }
        return sj.toString();
    }
}

