/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileBoundedPredicate;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public abstract class GeoTileGridTiler
extends GeoGridTiler {
    protected final int tiles;

    private GeoTileGridTiler(int precision) {
        super(precision);
        this.tiles = 1 << precision;
    }

    public static GeoTileGridTiler makeGridTiler(int precision, GeoBoundingBox geoBoundingBox) {
        return geoBoundingBox == null || geoBoundingBox.isUnbounded() ? new UnboundedGeoTileGridTiler(precision) : new BoundedGeoTileGridTiler(precision, geoBoundingBox);
    }

    protected abstract boolean validTile(int var1, int var2, int var3);

    @Override
    public long encode(double x, double y) {
        return GeoTileUtils.longEncode((double)x, (double)y, (int)this.precision);
    }

    @Override
    public int setValues(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        int maxYTile;
        ShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.bottom > GeoTileUtils.NORMALIZED_LATITUDE_MASK || bounds.top < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK) {
            return 0;
        }
        if (this.precision == 0) {
            return this.setValuesByBruteForceScan(values, geoValue, 0, 0, 0, 0);
        }
        int minXTile = GeoTileUtils.getXTile((double)bounds.minX(), (int)this.tiles);
        int minYTile = GeoTileUtils.getYTile((double)bounds.maxY(), (int)this.tiles);
        int maxXTile = GeoTileUtils.getXTile((double)bounds.maxX(), (int)this.tiles);
        long count = (long)(maxXTile - minXTile + 1) * (long)((maxYTile = GeoTileUtils.getYTile((double)bounds.minY(), (int)this.tiles)) - minYTile + 1);
        if (count == 1L) {
            return this.setValue(values, minXTile, minYTile);
        }
        if (count <= 8L * (long)this.precision) {
            return this.setValuesByBruteForceScan(values, geoValue, minXTile, minYTile, maxXTile, maxYTile);
        }
        return this.setValuesByRasterization(0, 0, 0, values, 0, geoValue);
    }

    private GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) throws IOException {
        if (this.validTile(xTile, yTile, precision)) {
            int tiles = 1 << precision;
            int minX = GeoEncodingUtils.encodeLongitude((double)GeoTileUtils.tileToLon((int)xTile, (int)tiles));
            int maxX = GeoEncodingUtils.encodeLongitude((double)GeoTileUtils.tileToLon((int)(xTile + 1), (int)tiles));
            int minY = GeoEncodingUtils.encodeLatitude((double)GeoTileUtils.tileToLat((int)(yTile + 1), (int)tiles));
            int maxY = GeoEncodingUtils.encodeLatitude((double)GeoTileUtils.tileToLat((int)yTile, (int)tiles));
            return geoValue.relate(minX, maxX == Integer.MAX_VALUE ? maxX : maxX - 1, minY == GeoTileUtils.ENCODED_NEGATIVE_LATITUDE_MASK ? minY : minY + 1, maxY);
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    private int setValue(GeoShapeCellValues docValues, int xTile, int yTile) {
        if (this.validTile(xTile, yTile, this.precision)) {
            docValues.resizeCell(1);
            docValues.add(0, GeoTileUtils.longEncodeTiles((int)this.precision, (int)xTile, (int)yTile));
            return 1;
        }
        return 0;
    }

    int setValuesByBruteForceScan(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, int minXTile, int minYTile, int maxXTile, int maxYTile) throws IOException {
        int idx = 0;
        for (int i = minXTile; i <= maxXTile; ++i) {
            for (int j = minYTile; j <= maxYTile; ++j) {
                GeoRelation relation = this.relateTile(geoValue, i, j, this.precision);
                if (relation == GeoRelation.QUERY_DISJOINT) continue;
                values.resizeCell(idx + 1);
                values.add(idx++, GeoTileUtils.longEncodeTiles((int)this.precision, (int)i, (int)j));
            }
        }
        return idx;
    }

    int setValuesByRasterization(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        ++zTile;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int nextX = 2 * xTile + i;
                int nextY = 2 * yTile + j;
                GeoRelation relation = this.relateTile(geoValue, nextX, nextY, zTile);
                if (GeoRelation.QUERY_INSIDE == relation) {
                    if (zTile == this.precision) {
                        values.resizeCell(this.getNewSize(valuesIndex, 1));
                        values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (int)nextX, (int)nextY));
                        continue;
                    }
                    int numTilesAtPrecision = this.getNumTilesAtPrecision(this.precision, zTile);
                    values.resizeCell(this.getNewSize(valuesIndex, numTilesAtPrecision + 1));
                    valuesIndex = this.setValuesForFullyContainedTile(nextX, nextY, zTile, values, valuesIndex);
                    continue;
                }
                if (GeoRelation.QUERY_DISJOINT == relation) continue;
                if (zTile == this.precision) {
                    values.resizeCell(this.getNewSize(valuesIndex, 1));
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (int)nextX, (int)nextY));
                    continue;
                }
                valuesIndex = this.setValuesByRasterization(nextX, nextY, zTile, values, valuesIndex, geoValue);
            }
        }
        return valuesIndex;
    }

    private int getNewSize(int valuesIndex, int increment) {
        long newSize = (long)valuesIndex + (long)increment;
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)newSize;
    }

    private int getNumTilesAtPrecision(int finalPrecision, int currentPrecision) {
        long numTilesAtPrecision = Math.min(1L << 2 * (finalPrecision - currentPrecision), this.getMaxCells());
        if (numTilesAtPrecision > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)numTilesAtPrecision;
    }

    protected abstract int setValuesForFullyContainedTile(int var1, int var2, int var3, GeoShapeCellValues var4, int var5);

    protected int setValues(GeoShapeCellValues values, int valuesIndex, int minY, int maxY, int minX, int maxX) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                assert (this.validTile(i, j, this.precision));
                values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)this.precision, (int)i, (int)j));
            }
        }
        return valuesIndex;
    }

    private static class UnboundedGeoTileGridTiler
    extends GeoTileGridTiler {
        private final long maxTiles;

        UnboundedGeoTileGridTiler(int precision) {
            super(precision);
            this.maxTiles = (long)this.tiles * (long)this.tiles;
        }

        @Override
        protected boolean validTile(int x, int y, int z) {
            return true;
        }

        @Override
        protected long getMaxCells() {
            return this.maxTiles;
        }

        @Override
        protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex) {
            int splits = 1 << this.precision - zTile;
            int minX = xTile * splits;
            int minY = yTile * splits;
            int maxX = minX + splits;
            int maxY = minY + splits;
            return this.setValues(values, valuesIndex, minY, maxY, minX, maxX);
        }
    }

    private static class BoundedGeoTileGridTiler
    extends GeoTileGridTiler {
        private final GeoTileBoundedPredicate predicate;

        BoundedGeoTileGridTiler(int precision, GeoBoundingBox bbox) {
            super(precision);
            this.predicate = new GeoTileBoundedPredicate(precision, bbox);
        }

        @Override
        protected boolean validTile(int x, int y, int z) {
            return this.predicate.validTile(x, y, z);
        }

        @Override
        protected long getMaxCells() {
            return this.predicate.getMaxTiles();
        }

        @Override
        protected int setValuesForFullyContainedTile(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex) {
            int splits = 1 << this.precision - zTile;
            int minY = Math.max(this.predicate.minY(), yTile * splits);
            int maxY = Math.min(this.predicate.maxY(), yTile * splits + splits);
            if (this.predicate.crossesDateline()) {
                int westMinX = Math.max(this.predicate.leftX(), xTile * splits);
                int westMaxX = xTile * splits + splits;
                valuesIndex = this.setValues(values, valuesIndex, minY, maxY, westMinX, westMaxX);
                int eastMaxX = Math.min(westMinX, Math.min(this.predicate.rightX(), xTile * splits + splits));
                int eastMinX = xTile * splits;
                return this.setValues(values, valuesIndex, minY, maxY, eastMinX, eastMaxX);
            }
            int minX = Math.max(this.predicate.leftX(), xTile * splits);
            int maxX = Math.min(this.predicate.rightX(), xTile * splits + splits);
            return this.setValues(values, valuesIndex, minY, maxY, minX, maxX);
        }
    }
}

