/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;

public abstract class LeafShapeFieldData<T extends ShapeValues<?>>
implements LeafFieldData {
    protected final ToScriptFieldFactory<T> toScriptFieldFactory;

    public LeafShapeFieldData(ToScriptFieldFactory<T> toScriptFieldFactory) {
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    public abstract T getShapeValues();

    public final SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("scripts and term aggs are not supported by geo_shape or shape doc values");
    }

    public final DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        return this.toScriptFieldFactory.getScriptFieldFactory(this.getShapeValues(), name);
    }

    public static class ShapeScriptValues<T extends SpatialPoint, V extends ShapeValues.ShapeValue>
    extends ScriptDocValues.BaseGeometry<T, V> {
        private final ScriptDocValues.GeometrySupplier<T, V> gsSupplier;

        protected ShapeScriptValues(ScriptDocValues.GeometrySupplier<T, V> supplier) {
            super(supplier);
            this.gsSupplier = supplier;
        }

        public int getDimensionalType() {
            return this.gsSupplier.getInternal(0) == null ? -1 : ((ShapeValues.ShapeValue)this.gsSupplier.getInternal(0)).dimensionalShapeType().ordinal();
        }

        public T getCentroid() {
            return (T)(this.gsSupplier.getInternal(0) == null ? null : this.gsSupplier.getInternalCentroid());
        }

        public BoundingBox<T> getBoundingBox() {
            return this.gsSupplier.getInternal(0) == null ? null : this.gsSupplier.getInternalBoundingBox();
        }

        public T getLabelPosition() {
            return (T)(this.gsSupplier.getInternal(0) == null ? null : this.gsSupplier.getInternalLabelPosition());
        }

        public V get(int index) {
            return (V)((ShapeValues.ShapeValue)this.gsSupplier.getInternal(0));
        }

        public V getValue() {
            return (V)((ShapeValues.ShapeValue)this.gsSupplier.getInternal(0));
        }

        public int size() {
            return this.supplier.size();
        }
    }

    public static class Empty<T extends ShapeValues<?>>
    extends LeafShapeFieldData<T> {
        private final T emptyValues;

        public Empty(ToScriptFieldFactory<T> toScriptFieldFactory, T emptyValues) {
            super(toScriptFieldFactory);
            this.emptyValues = emptyValues;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public T getShapeValues() {
            return this.emptyValues;
        }
    }
}

