/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class DestAlias
implements Writeable,
ToXContentObject {
    public static final ParseField ALIAS = new ParseField("alias", new String[0]);
    public static final ParseField MOVE_ON_CREATION = new ParseField("move_on_creation", new String[0]);
    public static final ConstructingObjectParser<DestAlias, Void> STRICT_PARSER = DestAlias.createParser(false);
    public static final ConstructingObjectParser<DestAlias, Void> LENIENT_PARSER = DestAlias.createParser(true);
    private final String alias;
    private final boolean moveOnCreation;

    private static ConstructingObjectParser<DestAlias, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser("data_frame_config_dest_alias", lenient, args -> new DestAlias((String)args[0], (Boolean)args[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), ALIAS);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MOVE_ON_CREATION);
        return parser;
    }

    public DestAlias(String alias, Boolean moveOnCreation) {
        this.alias = ExceptionsHelper.requireNonNull(alias, ALIAS.getPreferredName());
        this.moveOnCreation = moveOnCreation != null ? moveOnCreation : false;
    }

    public DestAlias(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.moveOnCreation = in.readBoolean();
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isMoveOnCreation() {
        return this.moveOnCreation;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.alias.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"dest.aliases.alias must not be empty", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias);
        out.writeBoolean(this.moveOnCreation);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ALIAS.getPreferredName(), this.alias);
        builder.field(MOVE_ON_CREATION.getPreferredName(), this.moveOnCreation);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DestAlias that = (DestAlias)other;
        return Objects.equals(this.alias, that.alias) && this.moveOnCreation == that.moveOnCreation;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.moveOnCreation);
    }

    public static DestAlias fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (DestAlias)LENIENT_PARSER.apply(parser, null) : (DestAlias)STRICT_PARSER.apply(parser, null);
    }
}

