/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

class AggProvider
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(AggProvider.class);
    private Exception parsingException;
    private AggregatorFactories.Builder parsedAggs;
    private Map<String, Object> aggs;
    private boolean rewroteAggs;

    static AggProvider fromXContent(XContentParser parser, boolean lenient) throws IOException {
        Map aggs = parser.mapOrdered();
        boolean rewroteAggs = false;
        if (lenient) {
            rewroteAggs = AggProvider.rewriteDateHistogramInterval(aggs, false);
        }
        AggregatorFactories.Builder parsedAggs = null;
        Exception exception = null;
        try {
            if (aggs.isEmpty()) {
                throw new Exception("aggs cannot be empty");
            }
            parsedAggs = XContentObjectTransformer.aggregatorTransformer(parser.getXContentRegistry()).fromMap(aggs);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                ex = (Exception)ex.getCause();
            }
            exception = ex;
            if (lenient) {
                logger.warn("Datafeed aggregations are not parsable", (Throwable)ex);
            }
            throw ExceptionsHelper.badRequestException("Datafeed aggregations are not parsable", ex, new Object[0]);
        }
        return new AggProvider(aggs, parsedAggs, exception, rewroteAggs);
    }

    static boolean rewriteDateHistogramInterval(Map<String, Object> aggs, boolean inDateHistogram) {
        boolean didRewrite = false;
        if (aggs.containsKey(Histogram.INTERVAL_FIELD.getPreferredName()) && inDateHistogram) {
            Object currentInterval = aggs.remove(Histogram.INTERVAL_FIELD.getPreferredName());
            if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(currentInterval.toString()) != null) {
                aggs.put("calendar_interval", currentInterval.toString());
                didRewrite = true;
            } else if (currentInterval instanceof Number) {
                Number number = (Number)currentInterval;
                aggs.put("fixed_interval", number.longValue() + "ms");
                didRewrite = true;
            } else if (currentInterval instanceof String) {
                String str = (String)currentInterval;
                aggs.put("fixed_interval", str);
                didRewrite = true;
            } else {
                throw ExceptionsHelper.badRequestException("Datafeed aggregations are not parsable", new IllegalArgumentException("unable to parse date_histogram interval parameter"), new Object[0]);
            }
        }
        for (Map.Entry<String, Object> entry : aggs.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            boolean rewrite = AggProvider.rewriteDateHistogramInterval((Map)entry.getValue(), entry.getKey().equals("date_histogram"));
            didRewrite = didRewrite || rewrite;
        }
        return didRewrite;
    }

    static AggProvider fromParsedAggs(AggregatorFactories.Builder parsedAggs) throws IOException {
        return parsedAggs == null ? null : new AggProvider(XContentObjectTransformer.aggregatorTransformer(NamedXContentRegistry.EMPTY).toMap(parsedAggs), parsedAggs, null, false);
    }

    static AggProvider fromStream(StreamInput in) throws IOException {
        return new AggProvider(in.readGenericMap(), (AggregatorFactories.Builder)in.readOptionalWriteable(AggregatorFactories.Builder::new), in.readException(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0) ? in.readBoolean() : false);
    }

    AggProvider(Map<String, Object> aggs, AggregatorFactories.Builder parsedAggs, Exception parsingException, boolean rewroteAggs) {
        this.aggs = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(Objects.requireNonNull(aggs, "[aggs] must not be null")));
        this.parsedAggs = parsedAggs;
        this.parsingException = parsingException;
        this.rewroteAggs = rewroteAggs;
    }

    AggProvider(AggProvider other) {
        this.aggs = new LinkedHashMap<String, Object>(other.aggs);
        this.parsedAggs = other.parsedAggs;
        this.parsingException = other.parsingException;
        this.rewroteAggs = other.rewroteAggs;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericMap(this.aggs);
        out.writeOptionalWriteable((Writeable)this.parsedAggs);
        out.writeException((Throwable)this.parsingException);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0)) {
            out.writeBoolean(this.rewroteAggs);
        }
    }

    public Exception getParsingException() {
        return this.parsingException;
    }

    AggregatorFactories.Builder getParsedAggs() {
        return this.parsedAggs;
    }

    public Map<String, Object> getAggs() {
        return this.aggs;
    }

    public boolean isRewroteAggs() {
        return this.rewroteAggs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AggProvider that = (AggProvider)other;
        return Objects.equals(this.aggs, that.aggs) && Objects.equals(this.parsedAggs, that.parsedAggs) && AggProvider.equalExceptionMessages(this.parsingException, that.parsingException) && Objects.equals(this.rewroteAggs, that.rewroteAggs);
    }

    private static boolean equalExceptionMessages(Exception lft, Exception rgt) {
        if (lft == rgt) {
            return true;
        }
        if (lft == null || rgt == null) {
            return false;
        }
        return Objects.equals(lft.getMessage(), rgt.getMessage());
    }

    public int hashCode() {
        return Objects.hash(this.aggs, this.parsedAggs, this.parsingException == null ? null : this.parsingException.getMessage(), this.rewroteAggs);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.map(this.aggs);
        return builder;
    }

    public String toString() {
        return "AggProvider{parsingException=" + String.valueOf(this.parsingException) + ", parsedAggs=" + String.valueOf(this.parsedAggs) + ", aggs=" + String.valueOf(this.aggs) + ", rewroteAggs=" + this.rewroteAggs + "}";
    }
}

