/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class MlStatsIndex {
    public static final String TEMPLATE_NAME = ".ml-stats";
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    public static final int STATS_INDEX_MAPPINGS_VERSION = 1;

    private MlStatsIndex() {
    }

    public static String wrappedMapping() {
        return String.format(Locale.ROOT, "{\n\"_doc\" : %s\n}", MlStatsIndex.mapping());
    }

    public static String mapping() {
        return TemplateUtils.loadTemplate("/ml/stats_index_mappings.json", "8.11.0", MAPPINGS_VERSION_VARIABLE, Map.of("xpack.ml.managed.index.version", Integer.toString(1)));
    }

    public static String indexPattern() {
        return ".ml-stats-*";
    }

    public static String writeAlias() {
        return ".ml-stats-write";
    }

    public static void createStatsIndexAndAliasIfNecessary(Client client, ClusterState state, IndexNameExpressionResolver resolver, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, state, resolver, TEMPLATE_NAME, MlStatsIndex.writeAlias(), masterNodeTimeout, listener);
    }
}

