/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.inference.results.EmbeddingInt;

public class TextEmbeddingUtils {
    public static int getFirstEmbeddingSize(List<EmbeddingInt> embeddings) throws IllegalStateException {
        if (embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return embeddings.get(0).getSize();
    }

    public static void validateInputSizeAgainstEmbeddings(List<String> inputs, int embeddingSize) {
        if (inputs.size() != embeddingSize) {
            throw new IllegalArgumentException(Strings.format((String)"The number of inputs [%s] does not match the embeddings [%s]", (Object[])new Object[]{inputs.size(), embeddingSize}));
        }
    }

    private TextEmbeddingUtils() {
    }
}

