/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionStateUtils;
import org.elasticsearch.xpack.core.ilm.Step;

public class GenerateSnapshotNameStep
extends ClusterStateActionStep {
    public static final String NAME = "generate-snapshot-name";
    private static final Logger logger = LogManager.getLogger(GenerateSnapshotNameStep.class);
    private final String snapshotRepository;

    public GenerateSnapshotNameStep(Step.StepKey key, Step.StepKey nextStepKey, String snapshotRepository) {
        super(key, nextStepKey);
        this.snapshotRepository = snapshotRepository;
    }

    public String getSnapshotRepository() {
        return this.snapshotRepository;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return clusterState;
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (RepositoriesMetadata.get((ClusterState)clusterState).repository(this.snapshotRepository) == null) {
            throw new IllegalStateException("repository [" + this.snapshotRepository + "] is missing. [" + policyName + "] policy for index [" + index.getName() + "] cannot continue until the repository is created or the policy is changed");
        }
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState);
        newLifecycleState.setSnapshotIndexName(index.getName());
        newLifecycleState.setSnapshotRepository(this.snapshotRepository);
        if (lifecycleState.snapshotName() == null) {
            String snapshotName;
            String snapshotNamePrefix = ("<{now/d}-" + index.getName() + "-" + Strings.stripDisallowedChars((String)policyName) + ">").toLowerCase(Locale.ROOT);
            ActionRequestValidationException validationException = GenerateSnapshotNameStep.validateGeneratedSnapshotName(snapshotNamePrefix, snapshotName = GenerateSnapshotNameStep.generateSnapshotName(snapshotNamePrefix));
            if (validationException != null) {
                logger.warn("unable to generate a snapshot name as part of policy [{}] for index [{}] due to [{}]", (Object)policyName, (Object)index.getName(), (Object)validationException.getMessage());
                throw validationException;
            }
            newLifecycleState.setSnapshotName(snapshotName);
        }
        return LifecycleExecutionStateUtils.newClusterStateWithLifecycleState(clusterState, indexMetadata.getIndex(), newLifecycleState.build());
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.snapshotRepository);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenerateSnapshotNameStep other = (GenerateSnapshotNameStep)obj;
        return super.equals(obj) && Objects.equals(this.snapshotRepository, other.snapshotRepository);
    }

    public static String generateSnapshotName(String name) {
        return GenerateSnapshotNameStep.generateSnapshotName(name, System.currentTimeMillis());
    }

    public static String generateSnapshotName(String name, long now) {
        String candidate = IndexNameExpressionResolver.resolveDateMathExpression((String)name, (long)now);
        return candidate + "-" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static ActionRequestValidationException validateGeneratedSnapshotName(String snapshotPrefix, String snapshotName) {
        ActionRequestValidationException err = new ActionRequestValidationException();
        if (!Strings.hasText((String)snapshotPrefix)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: cannot be empty");
        }
        if (snapshotName.contains("#")) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not contain '#'");
        }
        if (snapshotName.charAt(0) == '_') {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not start with '_'");
        }
        if (!snapshotName.toLowerCase(Locale.ROOT).equals(snapshotName)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must be lowercase");
        }
        if (!Strings.validFileName((String)snapshotName)) {
            err.addValidationError("invalid snapshot name [" + snapshotPrefix + "]: must not contain contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (err.validationErrors().size() > 0) {
            return err;
        }
        return null;
    }
}

